/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.application.ViewHandlerWrapper;
import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.context.ViewResources;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.webapp.FilterServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.RenderPhaseComponentListener;

public class AjaxViewHandler
extends ViewHandlerWrapper {
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    public static final String STATE_MARKER_KEY = "org.ajax4jsf.view.state";
    public static final String SERIALIZED_STATE_KEY = "org.ajax4jsf.view.serializedstate";
    private static final Log _log = LogFactory.getLog(AjaxViewHandler.class);
    public static final String VIEW_EXPIRED = "org.ajax4jsf.view.EXPIRED";
    public static final String VIEW_ID_KEY = "org.ajax4jsf.VIEW_ID";

    public AjaxViewHandler(ViewHandler parent) {
        super(parent);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Create instance of Ajax ViewHandler");
        }
    }

    @Override
    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot riRoot;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(facesContext);
        ViewIdHolder viewIdHolder = ajaxContext.getViewIdHolder();
        if (null != viewIdHolder && viewIdHolder.skipNavigation(viewId)) {
            viewIdHolder.setViewId(viewId);
            riRoot = facesContext.getViewRoot();
        } else {
            riRoot = super.createView(facesContext, viewId);
            riRoot.addPhaseListener((PhaseListener)new RenderPhaseComponentListener());
            if (null != facesContext.getViewRoot()) {
                ajaxContext.setAjaxRequest(false);
            }
        }
        return riRoot;
    }

    @Override
    public void writeState(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (ajaxContext.isAjaxRequest() && ajaxContext.isSelfRender()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("name", (Object)STATE_MARKER_KEY, null);
            writer.endElement("span");
        } else {
            super.writeState(context);
        }
    }

    @Override
    public String getResourceURL(FacesContext context, String url) {
        String resourceURL;
        if (url.startsWith("resource://")) {
            InternetResource resource = InternetResourceBuilder.getInstance().createResource(null, url.substring(InternetResource.RESOURCE_URI_PREFIX_LENGTH));
            resourceURL = resource.getUri(context, null);
        } else {
            resourceURL = super.getResourceURL(context, url);
        }
        return resourceURL;
    }

    @Override
    public void renderView(FacesContext context, UIViewRoot root) throws IOException, FacesException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (root instanceof AjaxViewRoot) {
            AjaxViewRoot ajaxRoot = (AjaxViewRoot)root;
            if (ajaxContext.isAjaxRequest()) {
                this.processAjaxEvents(context, ajaxRoot);
                if (ajaxContext.isSelfRender()) {
                    ajaxContext.renderAjax(context);
                }
            }
            if (!context.getResponseComplete()) {
                super.renderView(context, root);
            }
        } else {
            super.renderView(context, root);
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        FilterServletResponseWrapper filterServletResponseWrapper = (FilterServletResponseWrapper)((Object)requestMap.get("com.exade.vcp.Filter.ResponseWrapper"));
        if (null != filterServletResponseWrapper) {
            if (!filterServletResponseWrapper.isError() && !Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED))) {
                ViewResources viewResources = new ViewResources();
                viewResources.initialize(context);
                viewResources.processHeadResources(context);
                requestMap.put("org.ajax4jsf.framework.HEAD_EVENTS_LIST", viewResources.getHeadEvents());
                requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
            }
            requestMap.put(VIEW_ID_KEY, context.getViewRoot().getViewId());
        }
    }

    private void processAjaxEvents(FacesContext context, AjaxViewRoot ajaxRoot) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)Messages.getMessage("PROCESS_AJAX_EVENTS_INFO"));
        }
        ajaxRoot.broadcastAjaxEvents(context);
    }
}

