/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.GestoreConsistenzaDati;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserPassword;
import org.slf4j.Logger;

public final class UtentePasswordChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            UtentiHelper utentiHelper = new UtentiHelper(request, pd, session);
            String newpw = utentiHelper.getParameter("newpw");
            String first = utentiHelper.getParameter("first");
            PageData oldPD = (PageData)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, PageData.class, (String)"PageData");
            UtentiCore utentiCore = new UtentiCore();
            String userToUpdate = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"changePwdScaduta");
            User user = utentiCore.getUser(userToUpdate);
            if (utentiHelper.isEditModeInProgress()) {
                pd.setIncludiMenuLateraleSx(false);
                if (first == null && oldPD != null) {
                    pd.setMessage(oldPD.getMessage(), MessageType.fromValue((String)oldPD.getMessageType()));
                }
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                utentiHelper.addUtenteChangePasswordScadutaToDati(dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utentePassword", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = utentiHelper.changePwScadutaCheckData();
            if (!isOk) {
                pd.setIncludiMenuLateraleSx(false);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                utentiHelper.addUtenteChangePasswordScadutaToDati(dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"utentePassword", (ForwardParams)ForwardParams.CHANGE());
            }
            User myS = null;
            newpw = utentiCore.getUtenzePasswordManager().crypt(newpw);
            myS = utentiCore.getUser(userToUpdate);
            PasswordVerifier passwordVerifier = utentiCore.getUtenzePasswordVerifier();
            if (passwordVerifier.isHistory()) {
                List precedentiPassword = myS.getPrecedentiPassword();
                UserPassword userPassword = new UserPassword();
                userPassword.setDatePassword(user.getLastUpdatePassword());
                userPassword.setPassword(user.getPassword());
                precedentiPassword.add(userPassword);
            }
            myS.setLastUpdatePassword(new Date());
            myS.setPassword(newpw);
            utentiCore.performUpdateOperation(userToUpdate, utentiHelper.smista(), myS);
            ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"changePwdScaduta");
            LoginSessionUtilities.setLoginParametersSession(request, session, (ControlStationCore)utentiCore, userToUpdate);
            utentiCore.performAuditLogin(userToUpdate);
            utentiHelper.makeMenu();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            utentiHelper.initializeFilter(ricerca);
            StringBuilder verificaConfigurazioneProtocolli = new StringBuilder();
            boolean configurazioneCorretta = utentiCore.verificaConfigurazioneProtocolliRispettoSoggettiDefault(verificaConfigurazioneProtocolli);
            if (!configurazioneCorretta) {
                pd.setMessage("Login effettuato con successo<br/><br/><b>Attenzione</b>: il controllo di consistenza tra Profili di Interoperabilit\u00e0 attivati e la configurazione sul Gateway ha rilevato inconsistenze: \n" + verificaConfigurazioneProtocolli.toString(), Costanti.MESSAGE_TYPE_ERROR);
            } else if (GestoreConsistenzaDati.gestoreConsistenzaDatiEseguitoConErrore) {
                pd.setMessage("Login effettuato con successo<br/><br/><b>Attenzione</b>: il controllo sulla consistenza dei dati \u00e8 terminato con errore; esaminare i log per maggiori dettagli", Costanti.MESSAGE_TYPE_INFO);
            } else {
                pd.setMessage("Password aggiornata con successo", Costanti.MESSAGE_TYPE_INFO_SINTETICO);
            }
            gd = generalHelper.initGeneralData(request);
            utentiHelper.makeMenu();
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"utentePassword", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"utentePassword", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

