/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiUtilities;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class SoggettiProprietaChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            soggettiHelper.makeMenu();
            String id = soggettiHelper.getParametroLong("id");
            long idSogg = Long.parseLong(id);
            String nomeprov = null;
            String tipoprov = null;
            String protocollo = soggettiHelper.getParameter("protocollo");
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            String nome = soggettiHelper.getParameter("propNome");
            String valore = soggettiHelper.getLockedParameter("propValore", false);
            valore = soggettiHelper.wrapValoreProprieta("propValore", valore);
            SoggettiCore soggettiCore = new SoggettiCore();
            Soggetto soggettoRegistry = null;
            org.openspcoop2.core.config.Soggetto soggettoConfig = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
            }
            soggettoConfig = soggettiCore.getSoggetto(idSogg);
            if (soggettiCore.isRegistroServiziLocale()) {
                nomeprov = soggettoRegistry.getNome();
                tipoprov = soggettoRegistry.getTipo();
            } else {
                nomeprov = soggettoConfig.getNome();
                tipoprov = soggettoConfig.getTipo();
            }
            if (protocollo == null || StringUtils.isEmpty((CharSequence)protocollo)) {
                protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoprov);
            }
            ArrayList<Parameter> parametersServletSoggettoChange = new ArrayList<Parameter>();
            Parameter pIdSoggetto = new Parameter("id", id);
            parametersServletSoggettoChange.add(pIdSoggetto);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
            if (soggettoRegistry != null) {
                lstParam.add(new Parameter(soggettiHelper.getLabelNomeSoggetto(protocollo, soggettoRegistry.getTipo(), soggettoRegistry.getNome()), "soggettiChange.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()])));
            }
            if (soggettoRegistry != null && soggettoRegistry.sizeProprietaList() > 1) {
                lstParam.add(new Parameter("Propriet&agrave;", "soggettiProprietaList.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()])));
            }
            lstParam.add(new Parameter(nome, null));
            if (soggettiHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                if (valore == null) {
                    for (int i = 0; i < soggettoRegistry.sizeProprietaList(); ++i) {
                        Proprieta ssp = soggettoRegistry.getProprieta(i);
                        if (!nome.equals(ssp.getNome())) continue;
                        if (ssp.getValore() == null) break;
                        valore = ssp.getValore();
                        break;
                    }
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = soggettiHelper.addSoggettoHiddenToDati(dati, id, nomeprov, tipoprov);
                dati = soggettiHelper.addProprietaToDati(TipoOperazione.CHANGE, soggettiHelper.getSize(), nome, valore, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"soggettiProprieta", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = soggettiHelper.soggettiProprietaCheckData(TipoOperazione.CHANGE);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = soggettiHelper.addSoggettoHiddenToDati(dati, id, nomeprov, tipoprov);
                dati = soggettiHelper.addProprietaToDati(TipoOperazione.CHANGE, soggettiHelper.getSize(), nome, valore, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"soggettiProprieta", (ForwardParams)ForwardParams.CHANGE());
            }
            for (int i = 0; i < soggettoRegistry.sizeProprietaList(); ++i) {
                Proprieta ssp = soggettoRegistry.getProprieta(i);
                if (!nome.equals(ssp.getNome())) continue;
                soggettoRegistry.removeProprieta(i);
                break;
            }
            Proprieta ssp = new Proprieta();
            ssp.setNome(nome);
            ssp.setValore(valore);
            soggettoRegistry.addProprieta(ssp);
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistry, soggettoConfig);
            sog.setOldNomeForUpdate(nomeprov);
            sog.setOldTipoForUpdate(tipoprov);
            List<Object> listOggettiDaAggiornare = SoggettiUtilities.getOggettiDaAggiornare(soggettiCore, nomeprov, nomeprov, tipoprov, tipoprov, sog);
            soggettiCore.performUpdateOperation(userLogin, soggettiHelper.smista(), listOggettiDaAggiornare.toArray());
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SOGGETTI_PROP;
            ricerca = soggettiHelper.checkSearchParameters(idLista, ricerca);
            List<Proprieta> lista = soggettiCore.soggettiProprietaList(Integer.parseInt(id), (ISearch)ricerca);
            soggettiHelper.prepareSoggettiProprietaList(soggettoRegistry, id, ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggettiProprieta", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggettiProprieta", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

