/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class SoggettiList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            soggettiHelper.makeMenu();
            String filterDominioInterno = soggettiHelper.getParameter("internalDomain");
            boolean forceFilterDominioInterno = false;
            if ("true".equalsIgnoreCase(filterDominioInterno)) {
                forceFilterDominioInterno = true;
            }
            SoggettiCore soggettiCore = new SoggettiCore();
            boolean multiTenant = soggettiCore.isMultitenant();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SOGGETTI;
            List<Soggetto> lista = null;
            if (soggettiCore.isRegistroServiziLocale() && !ServletUtils.isSearchDone((IConsoleHelper)soggettiHelper)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Soggetto.class);
            }
            ricerca = soggettiHelper.checkSearchParameters(idLista, ricerca);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            if (forceFilterDominioInterno) {
                ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
            } else if (!multiTenant && !soggettiHelper.isModalitaCompleta()) {
                ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                if (lista == null) {
                    lista = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)ricerca) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)ricerca);
                }
                if (!soggettiHelper.isPostBackFilterElement()) {
                    ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                }
                soggettiHelper.prepareSoggettiList(lista, (ISearch)ricerca);
            } else {
                List<org.openspcoop2.core.config.Soggetto> listaConfig = null;
                listaConfig = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)ricerca) : soggettiCore.soggettiList(userLogin, (ISearch)ricerca);
                soggettiHelper.prepareSoggettiConfigList(listaConfig, (ISearch)ricerca);
            }
            String msg = soggettiHelper.getParameter("errorExport");
            if (msg != null && !"".equals(msg)) {
                pd.setMessage("Errore durante esportazione: " + msg);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.LIST());
        }
    }
}

