/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiUtilities;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class SoggettiCredenzialiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            soggettiHelper.makeMenu();
            String id = soggettiHelper.getParametroLong("id");
            int idSogg = Integer.parseInt(id);
            String nomeprov = null;
            String tipoprov = null;
            String objToRemove = soggettiHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            SoggettiCore soggettiCore = new SoggettiCore();
            Soggetto soggettoRegistry = null;
            org.openspcoop2.core.config.Soggetto soggettoConfig = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
            }
            soggettoConfig = soggettiCore.getSoggetto(idSogg);
            if (soggettiCore.isRegistroServiziLocale()) {
                if (soggettoRegistry == null) {
                    throw new CoreException("Soggetto con id '" + idSogg + "' non trovato");
                }
                nomeprov = soggettoRegistry.getNome();
                tipoprov = soggettoRegistry.getTipo();
            } else {
                nomeprov = soggettoConfig.getNome();
                tipoprov = soggettoConfig.getTipo();
            }
            boolean isPrincipale = false;
            for (int i = idsToRemove.size() - 1; i >= 0; --i) {
                int idEliminare = Integer.parseInt(idsToRemove.get(i));
                if (idEliminare != 0) {
                    if (soggettoRegistry == null) continue;
                    soggettoRegistry.removeCredenziali(Integer.parseInt(idsToRemove.get(i)));
                    continue;
                }
                isPrincipale = true;
            }
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistry, soggettoConfig);
            sog.setOldNomeForUpdate(nomeprov);
            sog.setOldTipoForUpdate(tipoprov);
            List<Object> listOggettiDaAggiornare = SoggettiUtilities.getOggettiDaAggiornare(soggettiCore, nomeprov, nomeprov, tipoprov, tipoprov, sog);
            soggettiCore.performUpdateOperation(userLogin, soggettiHelper.smista(), listOggettiDaAggiornare.toArray());
            soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
            soggettiHelper.prepareSoggettiCredenzialiList(soggettoRegistry, id);
            if (isPrincipale) {
                pd.setMessage("Certificato Principale non eliminabile");
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"soggettiCredenziali", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggettiCredenziali", (ForwardParams)ForwardParams.DEL());
        }
    }
}

