/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativoRuoli;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ServiziApplicativiRuoliAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(request, pd, session);
            saHelper.makeMenu();
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentSA == null) {
                parentSA = 0;
            }
            boolean useIdSogg = parentSA != null && parentSA == 1;
            String idsil = saHelper.getParametroLong("idsil");
            int idSilInt = Integer.parseInt(idsil);
            String nome = saHelper.getParameter("ruolo");
            String provider = saHelper.getParametroLong("provider");
            String accessDaChangeTmp = saHelper.getParametroBoolean("accessoDaChange");
            boolean accessDaChange = ServletUtils.isCheckBoxEnabled((String)accessDaChangeTmp);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore();
            SoggettiCore soggettiCore = new SoggettiCore(saCore);
            ServizioApplicativo sa = saCore.getServizioApplicativo(idSilInt);
            String nomeservizioApplicativo = sa.getNome();
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.QUALSIASI);
            filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            ArrayList<String> ruoli = new ArrayList<String>();
            if (sa.getInvocazionePorta().getRuoli() != null && sa.getInvocazionePorta().getRuoli().getRuoloList() != null && !sa.getInvocazionePorta().getRuoli().getRuoloList().isEmpty()) {
                for (Ruolo ruolo : sa.getInvocazionePorta().getRuoli().getRuoloList()) {
                    ruoli.add(ruolo.getNome());
                }
            }
            String tipoENomeSoggetto = "";
            String nomeProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
            if (provider == null) {
                provider = "-1";
            } else {
                Soggetto soggetto = soggettiCore.getSoggetto(Long.parseLong(provider));
                tipoENomeSoggetto = saHelper.getLabelNomeSoggetto(nomeProtocollo, soggetto.getTipo(), soggetto.getNome());
            }
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!saHelper.isModalitaCompleta()) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            if (saHelper.isEditModeInProgress()) {
                if (accessDaChange) {
                    ServletUtils.setPageDataTitleServletFirst((PageData)pd, (String)labelApplicativi, (String)"serviziApplicativiList.do");
                    ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter(nomeservizioApplicativo, "serviziApplicativiChange.do", new Parameter[]{new Parameter("id", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())})});
                    ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Ruoli", "serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("accessoDaChange", accessDaChangeTmp)})});
                    ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{ServletUtils.getParameterAggiungi()});
                } else {
                    ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
                    if (useIdSogg) {
                        lstParm.add(new Parameter("Soggetti", "soggettiList.do"));
                        lstParm.add(new Parameter(labelApplicativiDi + tipoENomeSoggetto, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", provider)}));
                    } else {
                        lstParm.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
                    }
                    if (useIdSogg) {
                        lstParm.add(new Parameter("Ruoli di " + nomeservizioApplicativo, null));
                    } else {
                        lstParm.add(new Parameter("Ruoli di " + nomeservizioApplicativo, "serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("accessoDaChange", accessDaChangeTmp)}));
                    }
                    lstParm.add(ServletUtils.getParameterAggiungi());
                    ServletUtils.setPageDataTitle((PageData)pd, lstParm);
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                DataElement de = new DataElement();
                de.setName("idsil");
                de.setValue(idsil);
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (useIdSogg) {
                    de = new DataElement();
                    de.setName("provider");
                    de.setValue(provider);
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                }
                dati = saHelper.addRuoliToDati(TipoOperazione.ADD, dati, false, filtroRuoli, nome, ruoli, false, true, true, accessDaChangeTmp, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"serviziApplicativiRuoli", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = saHelper.ruoloCheckData(TipoOperazione.ADD, nome, ruoli);
            if (!isOk) {
                ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
                if (useIdSogg) {
                    lstParm.add(new Parameter("Soggetti", "soggettiList.do"));
                    lstParm.add(new Parameter(labelApplicativiDi + tipoENomeSoggetto, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", provider)}));
                } else {
                    lstParm.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
                }
                lstParm.add(new Parameter("Ruoli di " + nomeservizioApplicativo, null));
                lstParm.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParm);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                DataElement de = new DataElement();
                de.setName("idsil");
                de.setValue(idsil);
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (useIdSogg) {
                    de = new DataElement();
                    de.setName("provider");
                    de.setValue(provider);
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                }
                dati = saHelper.addRuoliToDati(TipoOperazione.ADD, dati, false, filtroRuoli, nome, ruoli, false, true, true, accessDaChangeTmp, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"serviziApplicativiRuoli", (ForwardParams)ForwardParams.ADD());
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(nome);
            if (sa.getInvocazionePorta().getRuoli() == null) {
                sa.getInvocazionePorta().setRuoli(new ServizioApplicativoRuoli());
            }
            sa.getInvocazionePorta().getRuoli().addRuolo(ruolo);
            saCore.performUpdateOperation(userLogin, saHelper.smista(), sa);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<String> lista = saCore.servizioApplicativoRuoliList(idSilInt, (ISearch)ricerca);
            saHelper.prepareRuoliList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"serviziApplicativiRuoli", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"serviziApplicativiRuoli", (ForwardParams)ForwardParams.ADD());
        }
    }
}

