/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ruoli;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliUtilities;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class RuoliDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            RuoliHelper ruoliHelper = new RuoliHelper(request, pd, session);
            ruoliHelper.makeMenu();
            String objToRemove = ruoliHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            RuoliCore ruoliCore = new RuoliCore();
            StringBuilder inUsoMessage = new StringBuilder();
            boolean deleteAlmostOneRole = false;
            for (int i = 0; i < idsToRemove.size(); ++i) {
                Ruolo ruolo = ruoliCore.getRuolo(idsToRemove.get(i));
                boolean deleted = RuoliUtilities.deleteRuolo(ruolo, userLogin, ruoliCore, ruoliHelper, inUsoMessage, "<br/>");
                if (!deleted) continue;
                deleteAlmostOneRole = true;
            }
            if (deleteAlmostOneRole) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.RUOLI);
            }
            if (inUsoMessage.length() > 0) {
                pd.setMessage(inUsoMessage.toString());
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Ruolo> lista = null;
            lista = ruoliCore.isVisioneOggettiGlobale(userLogin) ? ruoliCore.ruoliList(null, (ISearch)ricerca) : ruoliCore.ruoliList(userLogin, (ISearch)ricerca);
            ruoliHelper.prepareRuoliList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.DEL());
        }
    }
}

