/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class PddHelper
extends ConsoleHelper {
    public PddHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public PddHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public boolean isPdDEsterna(PdDControlStation pdd) {
        return PddTipologia.ESTERNO.toString().equals(pdd.getTipo());
    }

    public boolean isPdDOperativa(PdDControlStation pdd) {
        return PddTipologia.OPERATIVO.equals(pdd.getTipo());
    }

    public boolean isPdDNonOperativa(PdDControlStation pdd) {
        return PddTipologia.NONOPERATIVO.equals(pdd.getTipo());
    }

    public List<DataElement> addPddToDati(List<DataElement> dati, String nome, String id, String ip, String subject, String password, String confpw, PddTipologia tipo, TipoOperazione tipoOp, String[] protocolli, String protocollo, String protocolloGestione, int porta, String descrizione, String ipGestione, int portaGestione, String implementazione, String clientAuth) {
        DataElement de = new DataElement();
        de.setLabel("Porta di Dominio");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            de = new DataElement();
            de.setLabel("Id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        if (tipoOp.equals((Object)TipoOperazione.ADD) || this.core.isSinglePdD()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setValue(nome);
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("descrizione");
        de.setValue(descrizione);
        de.setSize(this.getSize());
        dati.add(de);
        if (!TipoOperazione.ADD.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.TEXT);
            de.setName("tipo");
            de.setValue(tipo.toString());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Implementazione");
        if (this.isModalitaAvanzata()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("implementazione");
        de.setValue(implementazione);
        de.setSize(this.getSize());
        dati.add(de);
        String[] tipiAuth = new String[]{CostantiConfigurazione.DISABILITATO.toString(), CostantiConfigurazione.ABILITATO.toString()};
        de = new DataElement();
        de.setLabel("Client Auth");
        de.setType(DataElementType.SELECT);
        de.setName("client_auth");
        de.setSelected(clientAuth);
        de.setValues(tipiAuth);
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Subject");
        de.setType(DataElementType.TEXT_EDIT);
        de.setValue(StringEscapeUtils.escapeHtml4((String)subject));
        if (clientAuth != null && clientAuth.equals(CostantiRegistroServizi.ABILITATO.getValue())) {
            de.setRequired(true);
        }
        de.setName("subject");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    boolean pddCheckData(TipoOperazione tipoOp) throws ControlStationCoreException {
        try {
            String nome = this.getParameter("nome");
            String tipoParam = this.getParameter("tipo");
            PddTipologia tipo = PddTipologia.toPddTipologia((String)tipoParam);
            String implementazione = this.getParameter("implementazione");
            String clientAuth = this.getParameter("client_auth");
            String subject = this.getParameter("subject");
            if (implementazione == null || "".equals(implementazione)) {
                this.pd.setMessage("Il campo Implementazione deve essere specificato.");
                return false;
            }
            if (subject != null && !"".equals(subject)) {
                try {
                    CertificateUtils.validaPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il subject fornito non \u00e8 valido: " + e.getMessage());
                    return false;
                }
            }
            if (CostantiConfigurazione.ABILITATO.toString().equals(clientAuth) && (subject == null || "".equals(subject))) {
                this.pd.setMessage("&Egrave; necessario specificare il subject in caso di Client Auth abilitato.");
                return false;
            }
            if (tipo.equals((Object)PddTipologia.ESTERNO)) {
                if (nome == null || nome.equals("")) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Nome.");
                    return false;
                }
                if (nome.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!this.checkNCName(nome, "Nome")) {
                    return false;
                }
            } else {
                if (nome.equals("")) {
                    String tmpElenco = "";
                    if (nome.equals("")) {
                        tmpElenco = "Nome";
                    }
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                    return false;
                }
                if (nome.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!this.checkSimpleName(nome, "Nome")) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoPdd;
                boolean bl = trovatoPdd = this.pddCore.existPdd(nome) > 0L;
                if (trovatoPdd) {
                    this.pd.setMessage("Esiste gi&agrave; una Porta di Dominio con nome " + nome);
                    return false;
                }
            }
            if (subject != null && !"".equals(subject)) {
                List<PortaDominio> pddList = this.pddCore.porteDominioWithSubject(subject);
                for (int i = 0; i < pddList.size(); ++i) {
                    PortaDominio pdd = pddList.get(i);
                    if (tipoOp.equals((Object)TipoOperazione.CHANGE) && nome.equals(pdd.getNome())) continue;
                    this.pd.setMessage("La Porta di Dominio " + pdd.getNome() + " possiede gia' le credenziali ssl indicate.");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new ControlStationCoreException(e.getMessage(), e);
        }
    }

    public void preparePddSinglePddList(List<PdDControlStation> lista, ISearch ricerca) throws ControlStationCoreException {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"pddSinglePdD", (Parameter[])new Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.PDD;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddSinglePdDList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddSinglePdDList.do"), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Porte di Dominio", (String)search);
            }
            String[] labels = new String[]{"Nome", "Tipo", "Implementazione", "Soggetti"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            Iterator<PdDControlStation> it = lista.iterator();
            PdDControlStation pdd = null;
            while (it.hasNext()) {
                pdd = it.next();
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setUrl("pddSinglePdDChange.do", new Parameter[]{new Parameter("id", pdd.getId().toString()), new Parameter("nome", pdd.getNome())});
                de.setValue(pdd.getNome());
                de.setIdToRemove(pdd.getNome());
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getTipo());
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getImplementazione());
                e.add(de);
                de = new DataElement();
                de.setUrl("pddSoggettiList.do", new Parameter[]{new Parameter("id", pdd.getId().toString())});
                if (contaListe != null && contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.pddCore.pddSoggettiList(pdd.getId().intValue(), (ISearch)searchForCount);
                    int numSog = 0;
                    numSog = searchForCount.getNumEntries(Liste.PDD_SOGGETTI);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSog));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new ControlStationCoreException(e.getMessage(), e);
        }
    }

    public void preparePddSoggettiList(String nomePdd, int id, List<Soggetto> lista, ISearch ricerca) throws ControlStationCoreException {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"pddSoggetti", (Parameter[])new Parameter[]{new Parameter("id", "" + id)});
            int idLista = Liste.PDD_SOGGETTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String t2URL = "pddSinglePdDList.do";
            String t3Label = "Soggetti associati alla Porta di Dominio " + nomePdd;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", t2URL), new Parameter(t3Label, null)});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", t2URL), new Parameter(t3Label, "pddSoggettiList.do?id=" + id), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Soggetti", (String)search);
            }
            String[] labels = new String[]{"Soggetti"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Soggetto sog : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", sog.getId().toString()), new Parameter("nomeprov", sog.getNome()), new Parameter("tipoprov", sog.getTipo())});
                    de.setValue(sog.getTipo() + "/" + sog.getNome());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            this.pd.setSelect(false);
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new ControlStationCoreException(e.getMessage(), e);
        }
    }
}

