/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;

public class PddCore
extends ControlStationCore {
    public PddCore() throws DriverControlStationException {
    }

    public PddCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public List<PortaDominio> porteDominioWithSubject(String subject) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "porteDominioWithSubject";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.porteDominioWithSubject(subject);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] DriverRegistroServiziException :" + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAllIdPorteDominio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getAllIdPorteDominio(filtroRicerca);
            return list;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long existPdd(String nomePdd) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "existPdd";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.existPdd(nomePdd);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PdDControlStation getPdDControlStation(String pdd) throws DriverControlStationException, DriverControlStationNotFound {
        Connection con = null;
        String nomeMetodo = "getPdd";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PdDControlStation pdDControlStation = driver.getPdDControlStation(pdd);
            return pdDControlStation;
        }
        catch (DriverControlStationNotFound e) {
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PdDControlStation getPdDControlStation(long idPdd) throws DriverControlStationException, DriverControlStationNotFound {
        Connection con = null;
        String nomeMetodo = "getPdd";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PdDControlStation pdDControlStation = driver.getPdDControlStation(idPdd);
            return pdDControlStation;
        }
        catch (DriverControlStationNotFound e) {
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getPortaDominio(" + nomePdD + ")";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaDominio portaDominio = driver.getDriverRegistroServiziDB().getPortaDominio(nomePdD);
            return portaDominio;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDominio> pddListSinglePdd(String userLogin, ISearch ricerca) throws DriverRegistroServiziException {
        return this.pddListSinglePdd(userLogin, null, ricerca);
    }

    public List<PortaDominio> pddListSinglePdd(String userLogin, String tipo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "pddListSinglePdd";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().porteDominioList(userLogin, tipo, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PdDControlStation> pddList(String userLogin, ISearch ricerca) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "pddList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<PdDControlStation> list = driver.pddList(userLogin, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDominio> porteDominioList(String userLogin, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioList()";
        try {
            ArrayList<PortaDominio> list = new ArrayList<PortaDominio>();
            List<PdDControlStation> listControlStation = this.pddList(userLogin, ricerca);
            while (!listControlStation.isEmpty()) {
                list.add(listControlStation.remove(0));
            }
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public List<Soggetto> pddSoggettiList(long idPDD, ISearch ricerca) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "pddSoggettiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<Soggetto> list = driver.pddSoggettiList(idPDD, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isPddInUsoSinglePdd(PortaDominio pdd, List<String> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isPddInUsoSinglePdd";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().isPddInUso(pdd, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isPddInUso(PdDControlStation pdd, List<String> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "isPddInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isPddInUso(pdd, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<SoggettoCtrlStat> soggettiWithServer(String nomePdD) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "soggettiWithServer";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<SoggettoCtrlStat> list = driver.soggettiWithServer(nomePdD);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPddOperativa() throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsPddOperativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            FiltroRicerca filtro = new FiltroRicerca();
            filtro.setTipo(PddTipologia.OPERATIVO.toString());
            try {
                List nomi = driver.getDriverRegistroServiziDB().getAllIdPorteDominio(filtro);
                if (nomi != null && !nomi.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * Loose catch block
     */
    public String getNomePddOperativa() throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getNomePddOperativa";
        DriverControlStationDB driver = null;
        try {
            block8: {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                FiltroRicerca filtro = new FiltroRicerca();
                filtro.setTipo(PddTipologia.OPERATIVO.toString());
                List nomi = driver.getDriverRegistroServiziDB().getAllIdPorteDominio(filtro);
                if (nomi == null || nomi.isEmpty()) break block8;
                String string = (String)nomi.get(0);
                return string;
            }
            try {
                block9: {
                    break block9;
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                }
                throw new DriverRegistroServiziException("Non e' stata trovata una porta di dominio con tipo '" + PddTipologia.OPERATIVO.toString() + "'");
            }
            catch (Exception e) {
                ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
            }
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isPddEsterna(String nomePdD) throws DriverControlStationException, DriverControlStationNotFound {
        PdDControlStation pdd = null;
        if (nomePdD != null && !nomePdD.equals("") && !nomePdD.equals("-")) {
            pdd = this.getPdDControlStation(nomePdD);
        }
        boolean pddEsterna = false;
        if (pdd == null || PddTipologia.ESTERNO.toString().equals(pdd.getTipo())) {
            pddEsterna = true;
        }
        return pddEsterna;
    }
}

