/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pd;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.openspcoop2.web.ctrlstat.core.UrlParameters;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class PorteDelegateExtendedUtilities {
    private PorteDelegateExtendedUtilities() {
    }

    public static void addToHiddenDati(TipoOperazione tipoOperazione, List<DataElement> dati, ConsoleHelper consoleHelper) throws ExtendedException {
        try {
            String id = consoleHelper.getParametroLong("id");
            String idsogg = consoleHelper.getParametroLong("idsogg");
            PorteDelegateHelper porteDelegateHelper = (PorteDelegateHelper)consoleHelper;
            porteDelegateHelper.addHiddenFieldsToDati(tipoOperazione, id, idsogg, null, dati);
        }
        catch (Exception e) {
            throw new ExtendedException(e.getMessage(), e);
        }
    }

    public static Object getObject(ConsoleHelper consoleHelper) throws Exception {
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(consoleHelper.getCore());
        String id = consoleHelper.getParametroLong("id");
        int idInt = Integer.parseInt(id);
        return porteDelegateCore.getPortaDelegata(idInt);
    }

    public static List<Parameter> getTitle(ConsoleHelper consoleHelper) throws Exception {
        String idFruizione;
        String idSoggettoFruitore = consoleHelper.getParametroLong("idsogg");
        String idAsps = consoleHelper.getParametroLong("idAsps");
        if (idAsps == null) {
            idAsps = "";
        }
        if ((idFruizione = consoleHelper.getParametroLong("myId")) == null) {
            idFruizione = "";
        }
        PorteDelegateHelper pdHelper = new PorteDelegateHelper(consoleHelper.getCore(), consoleHelper.getRequest(), consoleHelper.getPd(), consoleHelper.getSession());
        Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)consoleHelper.getSession(), (HttpServletRequest)consoleHelper.getRequest());
        if (parentPD == null) {
            parentPD = 0;
        }
        return pdHelper.getTitoloPD(parentPD, idSoggettoFruitore, idAsps, idFruizione);
    }

    public static Parameter[] getParameterList(ConsoleHelper consoleHelper) throws Exception {
        String id = consoleHelper.getParametroLong("id");
        String idsogg = consoleHelper.getParametroLong("idsogg");
        Parameter[] par = new Parameter[]{new Parameter("id", id), new Parameter("idsogg", idsogg)};
        return par;
    }

    public static UrlParameters getUrlExtendedChange(ConsoleHelper consoleHelper) throws Exception {
        String id = consoleHelper.getParametroLong("id");
        String idsogg = consoleHelper.getParametroLong("idsogg");
        UrlParameters urlExtended = new UrlParameters();
        urlExtended.addParameter(new Parameter("id", id));
        urlExtended.addParameter(new Parameter("idsogg", idsogg));
        urlExtended.setUrl("porteDelegateExtendedChange.do");
        return urlExtended;
    }

    public static UrlParameters getUrlExtendedList(ConsoleHelper consoleHelper) throws Exception {
        String id = consoleHelper.getParametroLong("id");
        String idsogg = consoleHelper.getParametroLong("idsogg");
        UrlParameters urlExtended = new UrlParameters();
        urlExtended.addParameter(new Parameter("id", id));
        urlExtended.addParameter(new Parameter("idsogg", idsogg));
        urlExtended.setUrl("porteDelegateExtendedList.do");
        return urlExtended;
    }
}

