/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pd;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaParametro;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.web.ctrlstat.core.AutorizzazioneUtilities;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class PorteDelegateCore
extends ControlStationCore {
    private static boolean showGroup = true;

    public PorteDelegateCore() throws DriverControlStationException {
    }

    public PorteDelegateCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public void configureControlloAccessiPortaDelegata(PortaDelegata portaDelegata, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, String fruizioneServizioApplicativo, String fruizioneRuolo, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String fruizioneAutorizzazioneTokenOptions, String fruizioneAutorizzazioneScope, String fruizioneScope, String fruizioneAutorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) {
        ScopeTipoMatch scopeTipoMatch;
        RuoloTipoMatch tipoRuoloMatch;
        portaDelegata.setAutenticazione(fruizioneAutenticazione);
        if (fruizioneAutenticazioneOpzionale != null) {
            if (ServletUtils.isCheckBoxEnabled((String)fruizioneAutenticazioneOpzionale)) {
                portaDelegata.setAutenticazioneOpzionale(StatoFunzionalita.ABILITATO);
            } else {
                portaDelegata.setAutenticazioneOpzionale(StatoFunzionalita.DISABILITATO);
            }
        } else {
            portaDelegata.setAutenticazioneOpzionale(null);
        }
        portaDelegata.getProprietaAutenticazioneList().clear();
        List<Proprieta> proprietaAutenticazione = this.convertToAutenticazioneProprieta(fruizioneAutenticazione, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList);
        if (proprietaAutenticazione != null && !proprietaAutenticazione.isEmpty()) {
            portaDelegata.getProprietaAutenticazioneList().addAll(proprietaAutenticazione);
        }
        portaDelegata.setAutorizzazione(AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString(fruizioneAutorizzazione, ServletUtils.isCheckBoxEnabled((String)fruizioneAutorizzazioneAutenticati), ServletUtils.isCheckBoxEnabled((String)fruizioneAutorizzazioneRuoli), ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken), ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken), ServletUtils.isCheckBoxEnabled((String)fruizioneAutorizzazioneScope), fruizioneAutorizzazioneTokenOptions, org.openspcoop2.core.registry.constants.RuoloTipologia.toEnumConstant((String)fruizioneAutorizzazioneRuoliTipologia)));
        if (fruizioneAutorizzazione != null && fruizioneAutorizzazione.equals("xacml-Policy") && allegatoXacmlPolicy.getValue() != null) {
            portaDelegata.setXacmlPolicy(new String(allegatoXacmlPolicy.getValue()));
        } else {
            portaDelegata.setXacmlPolicy(null);
        }
        if (fruizioneAutorizzazioneRuoliMatch != null && !"".equals(fruizioneAutorizzazioneRuoliMatch) && (tipoRuoloMatch = RuoloTipoMatch.toEnumConstant((String)fruizioneAutorizzazioneRuoliMatch)) != null) {
            if (portaDelegata.getRuoli() == null) {
                portaDelegata.setRuoli(new AutorizzazioneRuoli());
            }
            portaDelegata.getRuoli().setMatch(tipoRuoloMatch);
        }
        if (fruizioneServizioApplicativo != null && !"".equals(fruizioneServizioApplicativo) && !"-".equals(fruizioneServizioApplicativo)) {
            PortaDelegataServizioApplicativo sa = new PortaDelegataServizioApplicativo();
            sa.setNome(fruizioneServizioApplicativo);
            portaDelegata.addServizioApplicativo(sa);
        }
        if (fruizioneRuolo != null && !"".equals(fruizioneRuolo) && !"-".equals(fruizioneRuolo)) {
            if (portaDelegata.getRuoli() == null) {
                portaDelegata.setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(fruizioneRuolo);
            portaDelegata.getRuoli().addRuolo(ruolo);
        }
        if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken)) {
            if (portaDelegata.getAutorizzazioneToken() == null) {
                portaDelegata.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            portaDelegata.getAutorizzazioneToken().setAutorizzazioneApplicativi(StatoFunzionalita.ABILITATO);
        } else if (portaDelegata.getAutorizzazioneToken() != null) {
            portaDelegata.getAutorizzazioneToken().setAutorizzazioneApplicativi(null);
            portaDelegata.getAutorizzazioneToken().setServiziApplicativi(null);
        }
        if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken)) {
            if (portaDelegata.getAutorizzazioneToken() == null) {
                portaDelegata.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            portaDelegata.getAutorizzazioneToken().setAutorizzazioneRuoli(StatoFunzionalita.ABILITATO);
            if (autorizzazioneRuoliTipologiaToken != null && !"".equals(autorizzazioneRuoliTipologiaToken)) {
                RuoloTipologia ruoloTipologia = RuoloTipologia.toEnumConstant((String)autorizzazioneRuoliTipologiaToken);
                portaDelegata.getAutorizzazioneToken().setTipologiaRuoli(ruoloTipologia);
            } else {
                portaDelegata.getAutorizzazioneToken().setTipologiaRuoli(null);
            }
            if (autorizzazioneRuoliMatchToken != null && !"".equals(autorizzazioneRuoliMatchToken)) {
                RuoloTipoMatch ruoloTipoMatch = RuoloTipoMatch.toEnumConstant((String)autorizzazioneRuoliMatchToken);
                if (ruoloTipoMatch != null) {
                    if (portaDelegata.getAutorizzazioneToken().getRuoli() == null) {
                        portaDelegata.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                    }
                    portaDelegata.getAutorizzazioneToken().getRuoli().setMatch(ruoloTipoMatch);
                } else if (portaDelegata.getAutorizzazioneToken().getRuoli() != null) {
                    portaDelegata.getAutorizzazioneToken().getRuoli().setMatch(null);
                }
            } else if (portaDelegata.getAutorizzazioneToken().getRuoli() != null) {
                portaDelegata.getAutorizzazioneToken().getRuoli().setMatch(null);
            }
        } else if (portaDelegata.getAutorizzazioneToken() != null) {
            portaDelegata.getAutorizzazioneToken().setAutorizzazioneRuoli(null);
            portaDelegata.getAutorizzazioneToken().setTipologiaRuoli(null);
            portaDelegata.getAutorizzazioneToken().setRuoli(null);
        }
        if (ServletUtils.isCheckBoxEnabled((String)fruizioneAutorizzazioneScope)) {
            if (portaDelegata.getScope() == null) {
                portaDelegata.setScope(new AutorizzazioneScope());
            }
            portaDelegata.getScope().setStato(StatoFunzionalita.ABILITATO);
        } else {
            portaDelegata.setScope(null);
        }
        if (fruizioneScope != null && !"".equals(fruizioneScope) && !"-".equals(fruizioneScope)) {
            if (portaDelegata.getScope() == null) {
                portaDelegata.setScope(new AutorizzazioneScope());
            }
            Scope scope = new Scope();
            scope.setNome(fruizioneScope);
            portaDelegata.getScope().addScope(scope);
        }
        if (fruizioneAutorizzazioneScopeMatch != null && !"".equals(fruizioneAutorizzazioneScopeMatch) && (scopeTipoMatch = ScopeTipoMatch.toEnumConstant((String)fruizioneAutorizzazioneScopeMatch)) != null) {
            if (portaDelegata.getScope() == null) {
                portaDelegata.setScope(new AutorizzazioneScope());
            }
            portaDelegata.getScope().setMatch(scopeTipoMatch);
        }
        while (portaDelegata.sizeAttributeAuthorityList() > 0) {
            portaDelegata.removeAttributeAuthority(0);
        }
        if (StatoFunzionalita.ABILITATO.getValue().equals(identificazioneAttributiStato) && attributeAuthoritySelezionate != null && attributeAuthoritySelezionate.length > 0) {
            for (String aaName : attributeAuthoritySelezionate) {
                portaDelegata.addAttributeAuthority(this.buildAttributeAuthority(attributeAuthoritySelezionate.length, aaName, attributeAuthorityAttributi));
            }
        }
    }

    public void configureControlloAccessiGestioneToken(PortaDelegata portaDelegata, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneTokenOptions) {
        if (portaDelegata.getGestioneToken() == null) {
            portaDelegata.setGestioneToken(new GestioneToken());
        }
        if (gestioneToken != null && gestioneToken.equals(StatoFunzionalita.ABILITATO.getValue())) {
            portaDelegata.getGestioneToken().setPolicy(gestioneTokenPolicy);
            if (ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale)) {
                portaDelegata.getGestioneToken().setTokenOpzionale(StatoFunzionalita.ABILITATO);
            } else {
                portaDelegata.getGestioneToken().setTokenOpzionale(StatoFunzionalita.DISABILITATO);
            }
            portaDelegata.getGestioneToken().setValidazione(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenValidazioneInput));
            portaDelegata.getGestioneToken().setIntrospection(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenIntrospection));
            portaDelegata.getGestioneToken().setUserInfo(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenUserInfo));
            portaDelegata.getGestioneToken().setForward(StatoFunzionalita.toEnumConstant((String)gestioneTokenForward));
            portaDelegata.getGestioneToken().setOptions(autorizzazioneTokenOptions);
            if (portaDelegata.getGestioneToken().getAutenticazione() == null) {
                portaDelegata.getGestioneToken().setAutenticazione(new GestioneTokenAutenticazione());
            }
            portaDelegata.getGestioneToken().getAutenticazione().setIssuer(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenIssuer) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenIssuer));
            portaDelegata.getGestioneToken().getAutenticazione().setClientId(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenClientId) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenClientId));
            portaDelegata.getGestioneToken().getAutenticazione().setSubject(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenSubject) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenSubject));
            portaDelegata.getGestioneToken().getAutenticazione().setUsername(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenUsername) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenUsername));
            portaDelegata.getGestioneToken().getAutenticazione().setEmail(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenEMail) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenEMail));
        } else {
            portaDelegata.getGestioneToken().setPolicy(null);
            portaDelegata.getGestioneToken().setTokenOpzionale(StatoFunzionalita.DISABILITATO);
            portaDelegata.getGestioneToken().setValidazione(StatoFunzionalitaConWarning.DISABILITATO);
            portaDelegata.getGestioneToken().setIntrospection(StatoFunzionalitaConWarning.DISABILITATO);
            portaDelegata.getGestioneToken().setUserInfo(StatoFunzionalitaConWarning.DISABILITATO);
            portaDelegata.getGestioneToken().setForward(StatoFunzionalita.DISABILITATO);
            portaDelegata.getGestioneToken().setOptions(null);
            if (portaDelegata.getGestioneToken().getAutenticazione() != null) {
                portaDelegata.getGestioneToken().setAutenticazione(null);
            }
        }
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPorteDelegateWithServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteDelegateWithServizio(idServizio);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> porteDelegateWithSoggettoErogatoreList(long idSoggettoErogatore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateWithSoggettoErogatoreList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateWithSoggettoErogatoreList(idSoggettoErogatore);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> porteDelegateWithTipoNomeErogatoreList(String tipoSoggettoErogatore, String nomeSoggettoErogatore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateWithTipoNomeErogatoreList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateWithTipoNomeErogatoreList(tipoSoggettoErogatore, nomeSoggettoErogatore);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Integer versioneServizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPorteDelegateWithServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteDelegateWithServizio(idServizio, tiposervizio, nomeservizio, versioneServizio, idSoggetto, tiposoggetto, nomesoggetto);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaDelegataAzione(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaDelegataAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataAzione(nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaDelegata";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegata(idPD);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateMessageSecurityRequestList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateMessageSecurityRequestList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateMessageSecurityResponseList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateMessageSecurityResponseList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        String nomeMetodo = "getPortaDelegata(id)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaDelegata portaDelegata = driver.getDriverConfigurazioneDB().getPortaDelegata(idPD);
            return portaDelegata;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] Exception :" + de.getMessage(), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaDelegata getPortaDelegata(long idPortaDelegata) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPortaDelegata(long)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaDelegata portaDelegata = driver.getDriverConfigurazioneDB().getPortaDelegata(idPortaDelegata);
            return portaDelegata;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] Exception :" + de.getMessage(), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ProprietaOggetto getProprietaOggetto(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        String nomeMetodo = "getProprietaOggetto(id)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ProprietaOggetto proprietaOggetto = driver.getDriverConfigurazioneDB().getProprietaOggetto(idPD);
            return proprietaOggetto;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] Exception :" + de.getMessage(), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void updateProprietaOggetto(IDPortaDelegata idPD, String user) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            driver.getDriverConfigurazioneDB().updateProprietaOggetto(idPD, user);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean azioneUsataInTrasformazioniPortaDelegata(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "azioneUsataInTrasformazioniPortaDelegata";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().azioneUsataInTrasformazioniPortaDelegata(nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingFruizionePortaDelegata> getMappingConGruppiPerAzione(String nomeAzione, List<IDServizio> list) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMappingConGruppiPerAzione";
        try {
            con = ControlStationCore.dbM.getConnection();
            ArrayList<MappingFruizionePortaDelegata> listInUtilizzo = new ArrayList<MappingFruizionePortaDelegata>();
            if (list != null && !list.isEmpty()) {
                for (IDServizio idServizio : list) {
                    AccordiServizioParteSpecificaCore aspsCore = new AccordiServizioParteSpecificaCore(this);
                    Long idS = aspsCore.getIdAccordoServizioParteSpecifica(con, idServizio);
                    ConsoleSearch s = new ConsoleSearch(true);
                    List<Fruitore> listFruitori = aspsCore.serviziFruitoriList(con, idS, (ISearch)s);
                    if (listFruitori == null || listFruitori.isEmpty()) continue;
                    for (Fruitore fruitore : listFruitori) {
                        IDSoggetto idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                        List lPD = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)this.tipoDB, (IDSoggetto)idSoggettoFruitore, (IDServizio)idServizio, (boolean)false);
                        if (lPD == null || lPD.isEmpty()) continue;
                        for (MappingFruizionePortaDelegata mapping : lPD) {
                            this.fill(nomeAzione, mapping, listInUtilizzo);
                        }
                    }
                }
            }
            ArrayList<MappingFruizionePortaDelegata> arrayList = listInUtilizzo;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    private void fill(String nomeAzione, MappingFruizionePortaDelegata mapping, List<MappingFruizionePortaDelegata> listInUtilizzo) throws DriverConfigurazioneException {
        try {
            PortaDelegata pd = this.getPortaDelegata(mapping.getIdPortaDelegata());
            if (pd != null && pd.getAzione() != null && pd.getAzione().getAzioneDelegataList() != null && pd.getAzione().getAzioneDelegataList().contains(nomeAzione)) {
                listInUtilizzo.add(mapping);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
    }

    public List<MappingFruizionePortaDelegata> getMapping(List<IDServizio> list, boolean addDefault, boolean addNotDefault) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMapping";
        try {
            con = ControlStationCore.dbM.getConnection();
            ArrayList<MappingFruizionePortaDelegata> listMappingDefault = new ArrayList<MappingFruizionePortaDelegata>();
            if (list != null && !list.isEmpty()) {
                for (IDServizio idServizio : list) {
                    AccordiServizioParteSpecificaCore aspsCore = new AccordiServizioParteSpecificaCore(this);
                    Long idS = aspsCore.getIdAccordoServizioParteSpecifica(con, idServizio);
                    ConsoleSearch s = new ConsoleSearch(true);
                    List<Fruitore> listFruitori = aspsCore.serviziFruitoriList(con, idS, (ISearch)s);
                    if (listFruitori == null || listFruitori.isEmpty()) continue;
                    for (Fruitore fruitore : listFruitori) {
                        IDSoggetto idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                        List lPD = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)this.tipoDB, (IDSoggetto)idSoggettoFruitore, (IDServizio)idServizio, (boolean)false);
                        if (lPD == null || lPD.isEmpty()) continue;
                        for (MappingFruizionePortaDelegata mapping : lPD) {
                            if (mapping.isDefault()) {
                                if (!addDefault) continue;
                                listMappingDefault.add(mapping);
                                continue;
                            }
                            if (!addNotDefault) continue;
                            listMappingDefault.add(mapping);
                        }
                    }
                }
            }
            ArrayList<MappingFruizionePortaDelegata> arrayList = listMappingDefault;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaDelegata> getPortaDelegataAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        String nomeMetodo = "getPortaDelegataAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPortaDelegataAzione(nome);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getIdPortaDelegata(String nomePorta) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPortaDelegata";
        try {
            con = ControlStationCore.dbM.getConnection();
            long l = DBUtils.getIdPortaDelegata((String)nomePorta, (Connection)con, (String)this.getTipoDatabase());
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getAllIdPorteDelegate";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getAllIdPorteDelegate(filtroRicerca);
            return list;
        }
        catch (DriverConfigurazioneNotFound notFound) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)notFound)), notFound);
            ArrayList<IDPortaDelegata> arrayList = new ArrayList<IDPortaDelegata>();
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> porteDelegateList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> porteDelegateList(String superUser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateList(superUser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> porteDelegateServizioApplicativoList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateServizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateServizioApplicativoList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> porteDelegateServizioApplicativoTokenList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateServizioApplicativoTokenList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateServizioApplicativoTokenList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<CorrelazioneApplicativaElemento> porteDelegateCorrelazioneApplicativaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateCorrelazioneApplicativaList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteDelegateCorrelazioneApplicativaRispostaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateCorrelazioneApplicativaRispostaList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MtomProcessorFlowParameter> porteDelegateMTOMRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateMTOMRequestList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateMTOMRequestList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MtomProcessorFlowParameter> porteDelegateMTOMResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateMTOMResponseList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateMTOMResponseList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto fruitore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPortaDelegataAssociataDefault";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDPortaDelegata iDPortaDelegata = driver.getIDPortaDelegataAssociataDefault(idServizio, fruitore);
            return iDPortaDelegata;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto fruitore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPortaDelegataAssociataAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDPortaDelegata iDPortaDelegata = driver.getIDPortaDelegataAssociataAzione(idServizio, fruitore);
            return iDPortaDelegata;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaDelegata> getIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto fruitore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPorteDelegateAssociate";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDPortaDelegata> list = driver.getIDPorteDelegateAssociate(idServizio, fruitore);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsMappingFruizionePortaDelegata";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.existsMappingFruizionePortaDelegata(mapping);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaDelegataRuoliList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaDelegataRuoliList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaDelegataRuoliList(idPD, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaDelegataRuoliTokenList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaDelegataRuoliTokenList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaDelegataRuoliTokenList(idPD, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaDelegataScopeList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaDelegataScopeList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaDelegataScopeList(idPD, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void aggiornaDescrizioneMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping, String user) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "aggiornaDescrizioneMappingFruizionePortaDelegata";
        try {
            con = ControlStationCore.dbM.getConnection();
            DBMappingUtils.updateMappingFruizione((long)mapping.getTableId(), (String)mapping.getDescrizione(), (Connection)con, (String)this.tipoDB);
            if (mapping.getIdPortaDelegata() != null) {
                this.updateProprietaOggetto(mapping.getIdPortaDelegata(), user);
            }
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public MappingFruizionePortaDelegata getMappingFruizionePortaDelegata(PortaDelegata pd) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMappingFruizionePortaDelegata";
        try {
            con = ControlStationCore.dbM.getConnection();
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setNome(pd.getNome());
            IDSoggetto idFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
            MappingFruizionePortaDelegata mappingFruizionePortaDelegata = DBMappingUtils.getMappingFruizione((IDServizio)idServizio, (IDSoggetto)idFruitore, (IDPortaDelegata)idPD, (Connection)con, (String)this.tipoDB);
            return mappingFruizionePortaDelegata;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingFruizionePortaDelegata> countMappingFruizionePortaDelegata(IDSoggetto idFruitore, IDServizio idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "countMappingFruizionePortaDelegata";
        try {
            con = ControlStationCore.dbM.getConnection();
            List list = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)this.tipoDB, (IDSoggetto)idFruitore, (IDServizio)idServizio, (boolean)false);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public static boolean isShowGroup() {
        return showGroup;
    }

    public static void setShowGroup(boolean showGroup) {
        PorteDelegateCore.showGroup = showGroup;
    }

    public String getLabelRegolaMappingFruizionePortaDelegata(String functionDi, String function, PortaDelegata pd) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingFruizionePortaDelegata(functionDi, function, pd, 50);
    }

    public String getLabelRegolaMappingFruizionePortaDelegata(String functionDi, String function, PortaDelegata pd, boolean forceGroupName) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingFruizionePortaDelegata(functionDi, function, pd, 50, forceGroupName);
    }

    public String getLabelRegolaMappingFruizionePortaDelegata(String functionDi, String function, PortaDelegata pd, int sizeSubstring) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingFruizionePortaDelegata(functionDi, function, pd, sizeSubstring, false);
    }

    public String getLabelRegolaMappingFruizionePortaDelegata(String functionDi, String function, PortaDelegata pd, int sizeSubstring, boolean forceGroupName) throws DriverConfigurazioneException {
        List listaAzioni;
        MappingFruizionePortaDelegata mapping;
        String prefix = "";
        if (functionDi != null) {
            prefix = functionDi;
            if (showGroup) {
                prefix = this.convertPrefixConfigDelGruppo(prefix);
            }
        }
        if ((mapping = this.getMappingFruizionePortaDelegata(pd)).isDefault()) {
            if (this.countMappingFruizionePortaDelegata(mapping.getIdFruitore(), mapping.getIdServizio()).size() > 1 || forceGroupName) {
                if (showGroup) {
                    return prefix + this.getLabelGroup(mapping.getDescrizione());
                }
                return prefix + "Default";
            }
            return function != null ? function : "Default";
        }
        if (showGroup) {
            StringBuilder sb = new StringBuilder(mapping.getDescrizione());
            if (sb.length() > sizeSubstring) {
                return prefix + this.getLabelGroup(sb.toString().substring(0, sizeSubstring - 3) + "...");
            }
            return prefix + this.getLabelGroup(sb.toString());
        }
        List list = listaAzioni = pd.getAzione() != null ? pd.getAzione().getAzioneDelegataList() : new ArrayList();
        if (!listaAzioni.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : listaAzioni) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(string);
            }
            if (sb.length() > sizeSubstring) {
                return prefix + sb.toString().substring(0, sizeSubstring - 3) + "...";
            }
            return prefix + sb.toString();
        }
        return prefix + "???";
    }

    public List<Proprieta> porteDelPropList(long idPortaDelegata, ConsoleSearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegatePropList(idPortaDelegata, (ISearch)ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> nomiProprietaPD(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoServiziProtocollo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "nomiProprietaPD";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().nomiProprietaPD(filterSoggettoTipo, filterSoggettoNome, tipoServiziProtocollo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Map<String, Properties> readMessageSecurityRequestPropertiesConfiguration(long idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "readMessageSecurityRequestPropertiesConfiguration";
        try {
            con = ControlStationCore.dbM.getConnection();
            Map readProperties = DBPropertiesUtils.readProperties((Connection)con, (String)this.tipoDB, (String)"pd_security_request", (String)"nome", (String)"valore", (String)"enc_value", (String)"id_porta", (Long)idPortaDelegata, (IDriverBYOK)this.getDriverBYOKUtilities().getDriverBYOKManagerNode(false, true));
            Map map = DBPropertiesUtils.toMultiMap((Map)readProperties);
            return map;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Map<String, Properties> readMessageSecurityResponsePropertiesConfiguration(long idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "readMessageSecurityResponsePropertiesConfiguration";
        try {
            con = ControlStationCore.dbM.getConnection();
            Map readProperties = DBPropertiesUtils.readProperties((Connection)con, (String)this.tipoDB, (String)"pd_security_response", (String)"nome", (String)"valore", (String)"enc_value", (String)"id_porta", (Long)idPortaDelegata, (IDriverBYOK)this.getDriverBYOKUtilities().getDriverBYOKManagerNode(false, true));
            Map map = DBPropertiesUtils.toMultiMap((Map)readProperties);
            return map;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ResponseCachingConfigurazioneRegola> getResponseCachingConfigurazioneRegolaList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getResponseCachingConfigurazioneRegolaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaDelegataResponseCachingConfigurazioneRegolaList(idPA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsResponseCachingConfigurazioneRegola(Long idPorta, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsResponseCachingConfigurazioneRegola";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataResponseCachingConfigurazioneRegola(idPorta.longValue(), statusMin, statusMax, fault);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegola> porteDelegateTrasformazioniList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniList(idPortaDelegata, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazione(idPorta, azioni, pattern, contentType, connettori);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazione(idPorta, nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegola getTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegola trasformazioneRegola = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazione(idPorta, azioni, pattern, contentType, connettori, applicativi);
            return trasformazioneRegola;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegola getTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegola trasformazioneRegola = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazione(idPorta, nome);
            return trasformazioneRegola;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaRisposta> porteDelegateTrasformazioniRispostaList(long idPortaDelegata, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniRispostaList(idPortaDelegata, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaRisposta getTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaRisposta trasformazioneRegolaRisposta = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
            return trasformazioneRegolaRisposta;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaRisposta getTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaRisposta trasformazioneRegolaRisposta = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, nome);
            return trasformazioneRegolaRisposta;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRispostaHeaderList(long idPortaDelegata, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniRispostaHeaderList(idPortaDelegata, idTrasformazione, idTrasformazioneRisposta, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRispostaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRispostaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaHeaderList(long idPortaDelegata, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniRichiestaHeaderList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniRichiestaHeaderList(idPortaDelegata, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaUrlParameterList(long idPortaDelegata, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniRichiestaUrlParameterList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniRichiestaUrlParameterList(idPortaDelegata, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRichiestaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRichiestaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRichiestaUrlParameter";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaDelegataTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRichiestaUrlParameter";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaDelegataTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteDelegateTrasformazioniServiziApplicativiAutorizzatiList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateTrasformazioniServiziApplicativiAutorizzatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateTrasformazioniServiziApplicativiList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteDelegateAutenticazioneCustomPropList(long idPortaDelegata, ConsoleSearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateAutenticazioneCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateAutenticazioneCustomPropList(idPortaDelegata, (ISearch)ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteDelegateAutorizzazioneCustomPropList(long idPortaDelegata, ConsoleSearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateAutorizzazioneCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateAutorizzazioneCustomPropList(idPortaDelegata, (ISearch)ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteDelegateAutorizzazioneContenutoCustomPropList(long idPortaDelegata, ConsoleSearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteDelegateAutorizzazioneContenutoCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteDelegateAutorizzazioneContenutoCustomPropList(idPortaDelegata, (ISearch)ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

