/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class PorteApplicativeConnettoriMultipliDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            PortaApplicativaServizioApplicativo paSA;
            String idConnTab;
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            String idPorta = porteApplicativeHelper.getParametroLong("id");
            int idInt = Integer.parseInt(idPorta);
            String objToRemove = porteApplicativeHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            String idAsps = porteApplicativeHelper.getParameter("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            if (StringUtils.isNotEmpty((CharSequence)(idConnTab = porteApplicativeHelper.getParametroInteger("idConnTab")))) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idConnTab, (String)"idConnTab");
            }
            String nome = "";
            String actionConferma = porteApplicativeHelper.getParameter("actionConfirm");
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            ServiziApplicativiCore saCore = new ServiziApplicativiCore(porteApplicativeCore);
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteApplicativeCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteApplicativeCore);
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(idInt);
            long idAspsLong = Long.parseLong(idAsps);
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idAspsLong);
            AccordoServizioParteComuneSintetico apc = apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(apc.getServiceBinding());
            ArrayList<ServizioApplicativo> listaOggettiDaEliminare = new ArrayList<ServizioApplicativo>();
            boolean eseguiOperazione = true;
            boolean connettoreUtilizzatiConfig = false;
            ArrayList<String> messaggiSezioniConnettore = new ArrayList<String>();
            int numeroElementiDaControllare = idsToRemove.size();
            for (int i = 0; i < idsToRemove.size(); ++i) {
                nome = idsToRemove.get(i);
                connettoreUtilizzatiConfig = porteApplicativeHelper.isConnettoreMultiploInUso(numeroElementiDaControllare, nome, pa, asps, apc, serviceBinding, messaggiSezioniConnettore);
            }
            StringBuilder sbErrore = new StringBuilder();
            if (connettoreUtilizzatiConfig) {
                if (idsToRemove.size() > 1) {
                    sbErrore.append("Impossibile eliminare i connettori selezionati.<br/>Sono utilizzati all'interno della sezione 'Configurazione Connettori Multipli'");
                } else {
                    sbErrore.append("Impossibile eliminare il connettore selezionato.<br/>&Egrave; utilizzato all'interno della sezione 'Configurazione Connettori Multipli'");
                }
                sbErrore.append(":").append("<br/>");
                for (String s : messaggiSezioniConnettore) {
                    sbErrore.append(s);
                }
                eseguiOperazione = false;
            } else {
                connettoreUtilizzatiConfig = porteApplicativeHelper.isConnettoreMultiploInUsoCriteriApplicabilitaTrasformazioni(numeroElementiDaControllare, nome, pa, serviceBinding, messaggiSezioniConnettore);
                if (connettoreUtilizzatiConfig) {
                    if (idsToRemove.size() > 1) {
                        sbErrore.append("Impossibile eliminare i connettori selezionati.<br/>Sono utilizzati in");
                    } else {
                        sbErrore.append("Impossibile eliminare il connettore selezionato.<br/>&Egrave; utilizzato in");
                    }
                    sbErrore.append(":").append("<br/>");
                    for (String s : messaggiSezioniConnettore) {
                        sbErrore.append(s);
                    }
                    eseguiOperazione = false;
                }
            }
            if (!connettoreUtilizzatiConfig) {
                int numeroAbilitati = 0;
                for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                    boolean abilitato;
                    paSA = pa.getServizioApplicativo(j);
                    boolean toDel = false;
                    for (int i = 0; i < idsToRemove.size(); ++i) {
                        nome = idsToRemove.get(i);
                        if (!nome.equals(paSA.getNome())) continue;
                        toDel = true;
                        break;
                    }
                    if (toDel) continue;
                    boolean bl = abilitato = paSA.getDatiConnettore() != null ? paSA.getDatiConnettore().getStato().equals((Object)StatoFunzionalita.ABILITATO) : true;
                    if (!abilitato) continue;
                    ++numeroAbilitati;
                }
                if (numeroAbilitati < 1) {
                    eseguiOperazione = false;
                    if (idsToRemove.size() > 1) {
                        sbErrore.append("Impossibile eliminare i connettori selezionati.<br/>Deve rimanare almento un connettore abilitato");
                    } else {
                        sbErrore.append("Impossibile eliminare il connettore selezionato.<br/>Deve rimanare almento un connettore abilitato");
                    }
                }
            }
            if (!eseguiOperazione && actionConferma == null) {
                String messaggio = sbErrore.toString();
                String title = "Attenzione";
                String[][] bottoni = new String[][]{{"Chiudi", "AnnullaConferma()"}};
                pd.setBottoni(bottoni);
                pd.setMessage(messaggio, title, MessageType.CONFIRM);
            }
            if (eseguiOperazione) {
                block7: for (int i = 0; i < idsToRemove.size(); ++i) {
                    nome = idsToRemove.get(i);
                    for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                        paSA = pa.getServizioApplicativo(j);
                        if (!nome.equals(paSA.getNome()) || porteApplicativeHelper.isConnettoreDefault(paSA)) continue;
                        pa.removeServizioApplicativo(j);
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setNome(paSA.getNome());
                        IDSoggetto idSoggettoProprietario = new IDSoggetto();
                        idSoggettoProprietario.setTipo(pa.getTipoSoggettoProprietario());
                        idSoggettoProprietario.setNome(pa.getNomeSoggettoProprietario());
                        idSA.setIdSoggettoProprietario(idSoggettoProprietario);
                        ServizioApplicativo sa = saCore.getServizioApplicativo(idSA);
                        if ("server".equals(sa.getTipo())) continue block7;
                        listaOggettiDaEliminare.add(sa);
                        continue block7;
                    }
                }
                String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
                if (!listaOggettiDaEliminare.isEmpty()) {
                    porteApplicativeCore.performDeleteOperation(userLogin, porteApplicativeHelper.smista(), listaOggettiDaEliminare.toArray(new Object[listaOggettiDaEliminare.size()]));
                }
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI;
            ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
            pa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
            IDSoggetto idSoggettoProprietario = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
            List<PortaApplicativaServizioApplicativo> listaFiltrata = porteApplicativeHelper.applicaFiltriRicercaConnettoriMultipli((ISearch)ricerca, idLista, pa.getServizioApplicativoList(), idSoggettoProprietario);
            porteApplicativeHelper.preparePorteAppConnettoriMultipliList_fromDeleteConnettore(ricerca, listaFiltrata, pa);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"porteApplicativeConnettoriMultipli", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeConnettoriMultipli", (ForwardParams)ForwardParams.DEL());
        }
    }
}

