/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderFactory;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderType;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.GestoreConsistenzaDati;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginTipologia;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class OAuth2UserServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = ControlStationLogger.getPddConsoleCoreLogger();

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.engineDoGet(httpServletRequest, httpServletResponse);
    }

    private void engineDoGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        IPrincipalReader principalReader = null;
        String loginUtenteNonAutorizzatoRedirectUrl = null;
        String loginUtenteNonValidoRedirectUrl = null;
        String loginErroreInternoRedirectUrl = null;
        String oauth2LogoutUrl = null;
        GeneralHelper generalHelper = null;
        HttpSession session = httpServletRequest.getSession();
        log.debug("[OAuth2User] Session ID: {}, Session creation time: {}, Last accessed time: {}", new Object[]{session.getId(), new Date(session.getCreationTime()), new Date(session.getLastAccessedTime())});
        try {
            String loginTipo = ConsoleProperties.getInstance().getLoginTipo();
            loginTipo = this.getTipoLogin(loginTipo);
            Properties prop = ConsoleProperties.getInstance().getLoginProperties();
            principalReader = this.caricaPrincipalReader(loginTipo, prop);
            loginUtenteNonAutorizzatoRedirectUrl = ConsoleProperties.getInstance().getLoginUtenteNonAutorizzatoRedirectUrl();
            loginUtenteNonValidoRedirectUrl = ConsoleProperties.getInstance().getLoginUtenteNonValidoRedirectUrl();
            loginErroreInternoRedirectUrl = ConsoleProperties.getInstance().getLoginErroreInternoRedirectUrl();
            oauth2LogoutUrl = prop.getProperty("oauth2.logout.endpoint");
            generalHelper = new GeneralHelper(session);
            ControlStationCore core = generalHelper.getCore();
            LoginHelper loginHelper = new LoginHelper(generalHelper.getCore(), httpServletRequest, new PageData(), session);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            if (userLogin == null) {
                String username = this.getPrincipal(httpServletRequest, principalReader);
                if (username != null) {
                    ControlStationCore.clearAuditManager();
                    if (GestoreConsistenzaDati.gestoreConsistenzaDatiInEsecuzione) {
                        log.debug("Controllo di valida non valido: {}", (Object)loginHelper.getPd().getMessage());
                        ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)"<b>Attenzione</b>: \u00e8 in esecuzione un controllo sulla consistenza dei dati; attendere il completamento dell'operazione", (String)"principalErrorMsg");
                        ServletUtils.removeUserLoginFromSession((HttpSession)session);
                        this.redirectToPagina(log, httpServletRequest, httpServletResponse, session, null, "login.do", oauth2LogoutUrl);
                        return;
                    }
                    UtentiCore utentiCore = new UtentiCore(core);
                    User user = utentiCore.getUser(username);
                    this.gestioneUtenteTrovato(httpServletRequest, httpServletResponse, loginUtenteNonAutorizzatoRedirectUrl, loginUtenteNonValidoRedirectUrl, oauth2LogoutUrl, loginHelper, user);
                } else {
                    ServletUtils.removeUserLoginFromSession((HttpSession)session);
                    ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)"Impossibile leggere le informazioni dell'utenza. Principal assente.", (String)"principalErrorMsg");
                    this.redirectToPagina(log, httpServletRequest, httpServletResponse, session, loginUtenteNonAutorizzatoRedirectUrl, "login.do", oauth2LogoutUrl);
                }
            } else {
                UtentiCore utentiCore = new UtentiCore(core);
                User user = utentiCore.getUser(userLogin);
                log.debug("Utente Loggato sessione valida.");
                ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)core.isSinglePdD(), (String)"singlePdD");
                ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)core.getTipoDatabase(), (String)"tipoDB");
                this.resetRicerche(httpServletRequest, session, loginHelper);
                this.utenteLoggatoCorrettamente(httpServletRequest, httpServletResponse, userLogin, session, core, user);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | OpenSPCoop2ConfigurationException | UtilsException | PrincipalReaderException | DriverControlStationException | DriverUsersDBException e) {
            ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)"Il sistema non riesce ad autenticare l'utente.", (String)"principalErrorMsg");
            try {
                this.redirectToPagina(log, httpServletRequest, httpServletResponse, session, loginErroreInternoRedirectUrl, "login.do", oauth2LogoutUrl);
            }
            catch (IOException e2) {
                log.error("Errore durante esecuzione redirect: " + e2.getMessage(), (Throwable)e2);
                httpServletResponse.setStatus(503);
                try {
                    httpServletResponse.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore: " + ((Throwable)e).getMessage());
                }
                catch (IOException e1) {
                    log.error("Errore durante esecuzione redirect: " + e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    private String getTipoLogin(String loginTipo) {
        if (StringUtils.isEmpty((CharSequence)loginTipo)) {
            loginTipo = PrincipalReaderType.OAUTH2.getValue();
        }
        return loginTipo;
    }

    private void resetRicerche(HttpServletRequest httpServletRequest, HttpSession session, LoginHelper loginHelper) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, DriverControlStationException {
        String resetSearch = httpServletRequest.getParameter("resetSearch");
        String postBackElement = httpServletRequest.getParameter("postBackElementName");
        if (ServletUtils.isCheckBoxEnabled((String)resetSearch) && (postBackElement == null || "".equals(postBackElement))) {
            for (int i = 0; i < Liste.getTotaleListe(); ++i) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (int)i);
            }
            boolean existsRicerca = ServletUtils.existsSearchObjectFromSession((HttpServletRequest)httpServletRequest, (HttpSession)session);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)httpServletRequest, (HttpSession)session, ConsoleSearch.class);
            if (ricerca != null) {
                ricerca.reset();
                for (int i = 0; i < Liste.getTotaleListe(); ++i) {
                    loginHelper.initializeFilter(ricerca, i);
                }
                if (!existsRicerca) {
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (ISearch)ricerca);
                }
                ControlStationCore.logDebug("Effettuato reset della ricerca");
            }
        }
    }

    private void gestioneUtenteTrovato(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String loginUtenteNonAutorizzatoRedirectUrl, String loginUtenteNonValidoRedirectUrl, String oauth2LogoutUrl, LoginHelper loginHelper, User user) throws IOException, DriverUsersDBException {
        String username = user.getLogin();
        HttpSession session = httpServletRequest.getSession();
        GeneralHelper generalHelper = new GeneralHelper(session);
        ControlStationCore core = generalHelper.getCore();
        boolean isOk = loginHelper.loginCheckData(LoginTipologia.WITHOUT_PASSWORD, username, null);
        if (isOk) {
            this.utenteLoggatoCorrettamente(httpServletRequest, httpServletResponse, username, session, core, user);
        } else {
            ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)MessageFormat.format("Il sistema non riesce ad autenticare l''utente {0}: {1}.", username, loginHelper.getPd().getMessage()), (String)"principalErrorMsg");
            String debugMsg = "Utente non autorizzato: {}";
            String customRedirectUrl = loginUtenteNonAutorizzatoRedirectUrl;
            if (loginHelper.getPd().getMessage().equals("L'utente non &egrave; abilitato ad utilizzare la console") || loginHelper.getPd().getMessage().equals("L'utente non &egrave; abilitato ad utilizzare la console: configurazione incompleta")) {
                debugMsg = "Utente non valido: {}";
                customRedirectUrl = loginUtenteNonValidoRedirectUrl;
                ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)MessageFormat.format("Il sistema non riesce ad autenticare l''utente {0}: {1}.", username, loginHelper.getPd().getMessage()), (String)"principalErrorMsg");
            }
            log.debug(debugMsg, (Object)loginHelper.getPd().getMessage());
            ServletUtils.removeUserLoginFromSession((HttpSession)session);
            this.redirectToPagina(log, httpServletRequest, httpServletResponse, session, customRedirectUrl, "login.do", oauth2LogoutUrl);
        }
    }

    private void utenteLoggatoCorrettamente(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String username, HttpSession session, ControlStationCore core, User user) throws IOException, DriverUsersDBException {
        ServletUtils.setObjectIntoSession((HttpServletRequest)httpServletRequest, (HttpSession)session, (Object)core.getTipoDatabase(), (String)"tipoDB");
        LoginCore loginCore = new LoginCore(core);
        LoginSessionUtilities.setLoginParametersSession(httpServletRequest, session, loginCore, username, user);
        loginCore.performAuditLogin(username);
        log.debug("Utente autorizzato, effettuo il redirect verso l'applicazione...");
        String redirPageUrl = new Parameter("", httpServletRequest.getContextPath() + "/messagePage.do", new Parameter[]{new Parameter("mpText", "Login effettuato con successo"), new Parameter("mpType", MessageType.INFO_SINTETICO.toString())}).getValue();
        httpServletResponse.sendRedirect(redirPageUrl);
    }

    private void redirectToPagina(Logger log, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession session, String customRedirectUrl, String defaultRedirectUrl, String oauth2LogoutUrl) throws IOException {
        String redirPageUrl = StringUtils.isNotEmpty((CharSequence)customRedirectUrl) ? customRedirectUrl : ServletUtils.buildInternalRedirectUrl((HttpServletRequest)httpServletRequest, (String)("/" + defaultRedirectUrl));
        String idToken = (String)session.getAttribute("oauthIdToken");
        String logoutUrl = OAuth2Utilities.creaUrlLogout((String)idToken, (String)oauth2LogoutUrl, (String)redirPageUrl);
        log.debug("Effettuo redirect logout verso pagina: {}", (Object)logoutUrl);
        httpServletResponse.sendRedirect(logoutUrl);
    }

    private String getPrincipal(HttpServletRequest httpServletRequest, IPrincipalReader principalReader) throws PrincipalReaderException {
        try {
            return principalReader.getPrincipal(httpServletRequest);
        }
        catch (PrincipalReaderException e) {
            ControlStationCore.logError("Errore durante la lettura del principal: " + e.getMessage(), e);
            throw e;
        }
    }

    private IPrincipalReader caricaPrincipalReader(String loginTipo, Properties prop) throws PrincipalReaderException {
        try {
            IPrincipalReader principalReader = PrincipalReaderFactory.getReader((Logger)log, (String)loginTipo);
            principalReader.init(new Object[]{prop});
            return principalReader;
        }
        catch (PrincipalReaderException e) {
            ControlStationCore.logError("Impossibile caricare il principal reader: " + e.getMessage(), e);
            throw e;
        }
    }
}

