/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.costanti.TipologiaConnettori;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.User;

public class LoginSessionUtilities {
    private LoginSessionUtilities() {
    }

    public static void setLoginParametersSession(HttpServletRequest request, HttpSession session, ControlStationCore core, String login) throws DriverUsersDBException {
        UtentiCore utentiCore = new UtentiCore(core);
        User user = utentiCore.getUser(login);
        LoginSessionUtilities.setLoginParametersSession(request, session, utentiCore, login, user);
    }

    public static void setLoginParametersSession(HttpServletRequest request, HttpSession session, ControlStationCore core, String login, User user) {
        Boolean contaListe = core.isShowCountElementInLinkList();
        ServletUtils.setUserLoginIntoSession((HttpSession)session, (String)login);
        ServletUtils.setContaListeIntoSession((HttpSession)session, (Boolean)contaListe);
        ServletUtils.setUserIntoSession((HttpServletRequest)request, (HttpSession)session, (User)user);
        LoginSessionUtilities.setLoginParametersSession(request, session, core, user);
    }

    public static void setLoginParametersSession(HttpServletRequest request, HttpSession session, ControlStationCore core, User user) {
        Boolean showAccordiAzioni = core.isShowAccordiColonnaAzioni();
        Boolean gestioneInfoProtocol = core.isShowAccordiInformazioniProtocollo();
        Boolean soggVirt = core.isShowGestioneSoggettiVirtuali();
        Boolean confPers = core.isShowConfigurazioniPersonalizzate();
        Boolean singlePdD = core.isSinglePdD();
        Boolean sameDBWebUI = core.isTracceSameDBWebUI();
        Boolean showAccordiCooperazione = user.getPermessi().isAccordiCooperazione();
        InterfaceType gui = user.getInterfaceType();
        switch (gui) {
            case AVANZATA: 
            case COMPLETA: {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)gestioneInfoProtocol, (String)"GestioneInfoProtocollo");
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)showAccordiAzioni, (String)"ShowAccordiAzioni");
                Utilities.readTipologiaConnettori(core);
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)soggVirt, (String)"SoggettoVirtuale");
                break;
            }
            case STANDARD: {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)false, (String)"GestioneInfoProtocollo");
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)false, (String)"ShowAccordiAzioni");
                Utilities.setTipologiaConnettori(TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP);
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)false, (String)"SoggettoVirtuale");
            }
        }
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)gui.toString(), (String)"ModalitaInterfaccia");
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)singlePdD, (String)"singlePdD");
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)showAccordiCooperazione, (String)"ShowAccordiCooperazione");
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)confPers, (String)"ConfigurazioniPersonalizzate");
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)sameDBWebUI, (String)"sameDBWebUI");
    }

    public static void cleanLoginParametersSession(HttpServletRequest request, HttpSession session) {
        ServletUtils.removeUserLoginFromSession((HttpSession)session);
        ServletUtils.removeContaListeFromSession((HttpSession)session);
        ServletUtils.removeUserFromSession((HttpServletRequest)request, (HttpSession)session);
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"GestioneInfoProtocollo");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"ShowAccordiAzioni");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"SoggettoVirtuale");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"ModalitaInterfaccia");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"singlePdD");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"ShowAccordiCooperazione");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"ConfigurazioniPersonalizzate");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"sameDBWebUI");
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"tipoDB");
    }
}

