/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginTipologia;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class LoginHelper
extends ConsoleHelper {
    public LoginHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public LoginHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public boolean loginCheckData(LoginTipologia tipoCheck) throws DriverUsersDBException, DriverControlStationException {
        String login = this.getParameter("login");
        String password = this.getParameter("password");
        return this.loginCheckData(tipoCheck, login, password);
    }

    public static User loginCheckData(Logger log, UtentiCore utentiCore, LoginTipologia tipoCheck, String login, String password, StringBuilder denyReason) throws DriverUsersDBException {
        if (login.equals("")) {
            if (denyReason != null) {
                denyReason.append("Dati incompleti. &Egrave; necessario indicare un Username");
            }
            return null;
        }
        if (tipoCheck.equals((Object)LoginTipologia.WITH_PASSWORD) && password.equals("")) {
            if (denyReason != null) {
                denyReason.append("Dati incompleti. &Egrave; necessario indicare una Password");
            }
            return null;
        }
        boolean trovato = utentiCore.existsUser(login);
        User u = null;
        if (trovato && tipoCheck.equals((Object)LoginTipologia.WITH_PASSWORD)) {
            boolean bloccaUtente = FailedAttempts.getInstance().bloccaUtente(log, login);
            if (bloccaUtente) {
                if (denyReason != null) {
                    denyReason.append("Utenza bloccata, superato il numero di tentativi di accesso massimo!");
                }
                return null;
            }
            u = utentiCore.getUser(login);
            String pwcrypt = u.getPassword();
            if (pwcrypt != null && !pwcrypt.equals("") && !(trovato = utentiCore.getUtenzePasswordManager().check(password, pwcrypt)) && utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                trovato = utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(password, pwcrypt);
            }
        }
        if (trovato && tipoCheck.equals((Object)LoginTipologia.WITHOUT_PASSWORD)) {
            u = utentiCore.getUser(login);
        }
        if (!trovato) {
            if (tipoCheck.equals((Object)LoginTipologia.WITHOUT_PASSWORD)) {
                if (denyReason != null) {
                    denyReason.append("Login inesistente!");
                }
            } else {
                FailedAttempts.getInstance().aggiungiTentativoFallitoUtente(log, login);
                if (denyReason != null) {
                    denyReason.append("Login o password errata!");
                }
            }
            return null;
        }
        FailedAttempts.getInstance().resetTentativiUtente(log, login);
        return u;
    }

    public boolean loginCheckData(LoginTipologia tipoCheck, String login, String password) throws DriverUsersDBException {
        try {
            StringBuilder denyReason = new StringBuilder();
            User u = LoginHelper.loginCheckData(this.log, this.utentiCore, tipoCheck, login, password, denyReason);
            if (u == null) {
                this.pd.setMessage(denyReason.toString(), MessageType.ERROR_SINTETICO);
                return false;
            }
            if (this.hasOnlyPermessiDiagnosticaReportistica(this.utentiCore.getUser(login))) {
                this.pd.setMessage("L'utente non &egrave; abilitato ad utilizzare la console", MessageType.ERROR_SINTETICO);
                return false;
            }
            if (!u.isConfigurazioneValidaAbilitazioni()) {
                this.pd.setMessage("L'utente non &egrave; abilitato ad utilizzare la console: configurazione incompleta", MessageType.ERROR_SINTETICO);
                return false;
            }
            ServletUtils.setUserIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (User)u);
            return true;
        }
        catch (DriverUsersDBException e) {
            ControlStationCore.logError("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public boolean loginScadenzaPasswordCheckData() throws DriverUsersDBException, DriverControlStationException {
        String login = this.getParameter("login");
        String password = this.getParameter("password");
        return this.loginScadenzaPasswordCheckData(login, password);
    }

    public boolean loginScadenzaPasswordCheckData(String login, String password) throws DriverUsersDBException {
        try {
            User u;
            ServletUtils.removeObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"changePwdScaduta");
            PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
            if (this.utentiCore.isCheckPasswordExpire(passwordVerifier) && (u = this.utentiCore.getUser(login)).isCheckLastUpdatePassword()) {
                StringBuilder bfMotivazioneErrore = new StringBuilder();
                if (passwordVerifier.isPasswordExpire(u.getLastUpdatePassword(), bfMotivazioneErrore)) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)login, (String)"changePwdScaduta");
                    ServletUtils.removeUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                    this.pd.setMessage(bfMotivazioneErrore.toString(), MessageType.ERROR_SINTETICO);
                    return false;
                }
            }
            return true;
        }
        catch (DriverUsersDBException e) {
            ControlStationCore.logError("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void impostaMessaggioEsitoLoginDaSessione() throws DriverControlStationException {
        this.impostaMessaggioEsitoLoginDaSessione(false);
    }

    public void impostaMessaggioEsitoLoginDaSessione(boolean leggiMessaggioDaParametro) throws DriverControlStationException {
        String messageText = (String)ServletUtils.removeObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"principalErrorMsg");
        if (messageText == null && leggiMessaggioDaParametro) {
            messageText = this.getParameter("mpText");
        }
        if (messageText == null) {
            messageText = "Il sistema &egrave; momentaneamente indisponibile.";
        }
        String messageType = this.getParameter("mpType");
        MessageType mt = MessageType.ERROR;
        if (messageType != null) {
            try {
                mt = MessageType.fromValue((String)messageType);
                if (mt == null) {
                    mt = MessageType.ERROR;
                }
            }
            catch (Exception e) {
                mt = MessageType.ERROR;
            }
        }
        String messageTitle = this.getParameter("mpTitle");
        String messageBreadcrumbs = this.getParameter("mpBC");
        if (messageBreadcrumbs != null) {
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter(messageBreadcrumbs, null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
        }
        this.pd.setMessage(messageText, messageTitle, mt);
    }
}

