/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Safelist;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.AuthorizationFilter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.security.InputSanitizerProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityWrappedHttpServletRequest;
import org.openspcoop2.web.lib.mvc.security.SecurityWrappedHttpServletResponse;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class HeadersFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private ControlStationCore core = null;
    private static Logger log = ControlStationLogger.getPddConsoleCoreLogger();

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        try {
            this.core = new ControlStationCore();
            Properties consoleSecurityConfiguration = this.core.getConsoleSecurityConfiguration();
            SecurityProperties.init((Properties)consoleSecurityConfiguration, (Logger)log);
            Properties consoleInputSanitizerConfiguration = this.core.getConsoleInputSanitizerConfiguration();
            InputSanitizerProperties.init((Properties)consoleInputSanitizerConfiguration, (Logger)log);
            Validatore.init((SecurityProperties)SecurityProperties.getInstance(), (InputSanitizerProperties)InputSanitizerProperties.getInstance(), (Logger)log);
        }
        catch (Exception e) {
            log.error("Errore durante il caricamento iniziale: " + e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            this.dumpRichiesta(request, response);
            SecurityWrappedHttpServletRequest seqReq = new SecurityWrappedHttpServletRequest(request, log);
            SecurityWrappedHttpServletResponse seqRes = new SecurityWrappedHttpServletResponse(response, log);
            this.gestioneContentSecurityPolicy((HttpServletRequest)seqReq, (HttpServletResponse)seqRes);
            this.gestioneXContentTypeOptions((HttpServletRequest)seqReq, (HttpServletResponse)seqRes);
            HeadersFilter.gestioneCacheControl((HttpServletRequest)seqReq, (HttpServletResponse)seqRes, log);
            chain.doFilter((ServletRequest)seqReq, (ServletResponse)seqRes);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore rilevato durante l'headersFilter", e);
            try {
                HttpSession session = request.getSession();
                GeneralHelper generalHelper = null;
                try {
                    generalHelper = new GeneralHelper(session);
                }
                catch (Exception eClose) {
                    ControlStationCore.logError("Errore rilevato durante l'headersFilter (reInit General Helper)", e);
                }
                AuthorizationFilter.setErrorMsg(generalHelper, session, request, response, "/jsplib/info.jsp", "L'ultima operazione effettuata ha provocato un errore che ha reso l'interfaccia non utilizzabile.<BR><BR>Effettuare nuovamente il login", this.filterConfig.getServletContext(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception eClose) {
                ControlStationCore.logError("Errore rilevato durante l'headersFilter (segnalazione errore)", e);
            }
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private void gestioneContentSecurityPolicy(HttpServletRequest request, HttpServletResponse response) {
        String uuId = UUID.randomUUID().toString();
        request.setAttribute("_csp_random_nonce", (Object)uuId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.core.getCspHeaderValue()})) {
            response.setHeader("Content-Security-Policy", MessageFormat.format(this.core.getCspHeaderValue(), uuId, uuId));
        }
    }

    private void gestioneXContentTypeOptions(HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            // empty if block
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.core.getXFrameOptionsHeaderValue()})) {
            response.setHeader("X-Frame-Options", this.core.getXFrameOptionsHeaderValue());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.core.getXXssProtectionHeaderValue()})) {
            response.setHeader("X-XSS-Protection", this.core.getXXssProtectionHeaderValue());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.core.getXContentTypeOptionsHeaderValue()})) {
            response.setHeader("X-Content-Type-Options", this.core.getXContentTypeOptionsHeaderValue());
        }
    }

    private void dumpRichiesta(HttpServletRequest request, HttpServletResponse response) {
        if (response != null) {
            // empty if block
        }
        Safelist customSafelist = InputSanitizerProperties.getInstance().getSafelist();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            Object[] paramValues = request.getParameterValues(paramName);
            ArrayList<String> parametriCorretti = new ArrayList<String>();
            if (paramValues != null && paramValues.length > 0) {
                for (int i = 0; i < paramValues.length; ++i) {
                    parametriCorretti.add(Entities.unescape((String)Jsoup.parse((String)Jsoup.clean((String)paramValues[i], (Safelist)customSafelist)).body().html()));
                }
            }
            log.debug("Parameter [{}] Valori Originali [{}]", (Object)paramName, paramValues != null && paramValues.length > 0 ? StringUtils.join((Object[])paramValues, (String)"|") : null);
            log.debug("Parameter [{}] Valori Corretti [{}]", (Object)paramName, !parametriCorretti.isEmpty() ? StringUtils.join(parametriCorretti, (String)"|") : null);
        }
    }

    private static void gestioneCacheControl(HttpServletRequest request, HttpServletResponse response, Logger log) {
        String[] staticResourceDirs;
        String requestUri = request.getRequestURI();
        if (requestUri != null && ServletUtils.isStaticResource((String)requestUri, (String[])(staticResourceDirs = new String[]{"images", "css", "fonts", "js"}))) {
            log.debug("Impostazione header Cache-Control per risorsa statica: {}", (Object)requestUri);
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }
}

