/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public class ConfigurazionePolicyGestioneTokenDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            String infoType = confHelper.getParametroInfoType("_tabKey_infoType");
            if (infoType == null) {
                infoType = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_infoType");
            }
            boolean attributeAuthority = ConfigurazioneCostanti.isConfigurazioneAttributeAuthority(infoType);
            String objToRemove = confHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            StringBuilder inUsoMessage = new StringBuilder();
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            boolean normalizeObjectIds = !confHelper.isModalitaCompleta();
            for (int i = 0; i < idsToRemove.size(); ++i) {
                long idGenericProperties = Long.parseLong(idsToRemove.get(i));
                GenericProperties policy = confCore.getGenericProperties(idGenericProperties);
                IDGenericProperties idGP = new IDGenericProperties();
                idGP.setNome(policy.getNome());
                idGP.setTipologia(policy.getTipologia());
                boolean gpInUso = confCore.isGenericPropertiesInUso(idGP, whereIsInUso, normalizeObjectIds);
                if (gpInUso) {
                    inUsoMessage.append(DBOggettiInUsoUtils.toString((IDGenericProperties)idGP, whereIsInUso, (boolean)true, (String)"<br/>"));
                    inUsoMessage.append("<br/>");
                    continue;
                }
                if ("gestionePolicyToken".equals(policy.getTipologia()) && confCore.isPolicyGestioneTokenPDND(policy.getNome())) {
                    String object = "Token Policy";
                    String intestazione = " non eliminabile perch&egrave; :";
                    String separator = "<br/>";
                    String msg = object + " '" + idGP.getNome() + "'" + intestazione + separator;
                    inUsoMessage.append(msg + " definisce la policy di validazione dei token ottenuti dalla PDND");
                    inUsoMessage.append("<br/>");
                    continue;
                }
                confCore.performDeleteOperation(userLogin, confHelper.smista(), policy);
            }
            if (inUsoMessage.length() > 0) {
                pd.setMessage(inUsoMessage.toString());
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = attributeAuthority ? Liste.CONFIGURAZIONE_GESTIONE_ATTRIBUTE_AUTHORITY : Liste.CONFIGURAZIONE_GESTIONE_POLICY_TOKEN;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            ArrayList<String> tipologie = new ArrayList<String>();
            if (attributeAuthority) {
                tipologie.add("attributeAuthority");
            } else {
                tipologie.add("gestionePolicyToken");
                tipologie.add("retrievePolicyToken");
            }
            List<GenericProperties> lista = confCore.gestorePolicyTokenList((Integer)idLista, tipologie, (ISearch)ricerca);
            confHelper.prepareGestorePolicyTokenList(ricerca, lista, idLista);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazionePolicyGestioneToken", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePolicyGestioneToken", (ForwardParams)ForwardParams.DEL());
        }
    }
}

