/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.constants.PluginCostanti;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.pdd.core.autenticazione.pa.IAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pd.IAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazioneContenutoPortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazioneContenutoPortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.controllo_traffico.plugins.IRateLimiting;
import org.openspcoop2.pdd.core.handlers.ExitHandler;
import org.openspcoop2.pdd.core.handlers.InRequestHandler;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolHandler;
import org.openspcoop2.pdd.core.handlers.InResponseHandler;
import org.openspcoop2.pdd.core.handlers.InitHandler;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerRequestHandler;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerResponseHandler;
import org.openspcoop2.pdd.core.handlers.OutRequestHandler;
import org.openspcoop2.pdd.core.handlers.OutResponseHandler;
import org.openspcoop2.pdd.core.handlers.PostOutRequestHandler;
import org.openspcoop2.pdd.core.handlers.PostOutResponseHandler;
import org.openspcoop2.pdd.core.handlers.PreInRequestHandler;
import org.openspcoop2.pdd.core.handlers.PreInResponseHandler;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.slf4j.Logger;

public class ConfigurazionePluginsTipoPluginUtils {
    public static final boolean ADD_TRANSAZIONI = false;
    public static final boolean ADD_RICERCHE = false;
    public static final boolean ADD_STATISTICHE = false;

    private ConfigurazionePluginsTipoPluginUtils() {
    }

    public static List<String> getValuesTipoPlugin(boolean addAllarmi) {
        ArrayList<String> valori = new ArrayList<String>();
        valori.add(TipoPlugin.AUTENTICAZIONE.toString());
        valori.add(TipoPlugin.AUTORIZZAZIONE.toString());
        valori.add(TipoPlugin.AUTORIZZAZIONE_CONTENUTI.toString());
        valori.add(TipoPlugin.RATE_LIMITING.toString());
        if (addAllarmi) {
            valori.add(TipoPlugin.ALLARME.toString());
        }
        valori.add(TipoPlugin.INTEGRAZIONE.toString());
        valori.add(TipoPlugin.CONNETTORE.toString());
        valori.add(TipoPlugin.BEHAVIOUR.toString());
        valori.add(TipoPlugin.MESSAGE_HANDLER.toString());
        valori.add(TipoPlugin.SERVICE_HANDLER.toString());
        valori.add(TipoPlugin.TOKEN_DYNAMIC_DISCOVERY.toString());
        valori.add(TipoPlugin.TOKEN_VALIDAZIONE.toString());
        valori.add(TipoPlugin.TOKEN_NEGOZIAZIONE.toString());
        valori.add(TipoPlugin.ATTRIBUTE_AUTHORITY.toString());
        return valori;
    }

    public static List<String> getLabelsTipoPlugin(boolean addAllarmi) {
        ArrayList<String> labels = new ArrayList<String>();
        List<String> values = ConfigurazionePluginsTipoPluginUtils.getValuesTipoPlugin(addAllarmi);
        for (String value : values) {
            String label = ConfigurazionePluginsTipoPluginUtils.tipoPluginToLabel(TipoPlugin.toEnumConstant((String)value));
            if (label == null) continue;
            labels.add(label);
        }
        return labels;
    }

    public static String tipoPluginToLabel(TipoPlugin value) {
        switch (value) {
            case ALLARME: {
                return "Allarme";
            }
            case AUTENTICAZIONE: {
                return "Autenticazione";
            }
            case AUTORIZZAZIONE: {
                return "Autorizzazione";
            }
            case AUTORIZZAZIONE_CONTENUTI: {
                return "Autorizzazione Contenuti";
            }
            case BEHAVIOUR: {
                return "Behaviour";
            }
            case CONNETTORE: {
                return "Connettore";
            }
            case INTEGRAZIONE: {
                return "Integrazione";
            }
            case MESSAGE_HANDLER: {
                return "Message Handler";
            }
            case RATE_LIMITING: {
                return "Rate Limiting";
            }
            case RICERCA: {
                return "Ricerca";
            }
            case SERVICE_HANDLER: {
                return "Service Handler";
            }
            case STATISTICA: {
                return "Statistica";
            }
            case TRANSAZIONE: {
                return "Transazione";
            }
            case TOKEN_DYNAMIC_DISCOVERY: {
                return "Token Dynamic Discovery";
            }
            case TOKEN_VALIDAZIONE: {
                return "Token Validazione";
            }
            case TOKEN_NEGOZIAZIONE: {
                return "Token Negoziazione";
            }
            case ATTRIBUTE_AUTHORITY: {
                return "Attribute Authority";
            }
        }
        return null;
    }

    public static String getApplicabilitaClassePlugin(Plugin plugin) {
        if (plugin.sizePluginProprietaCompatibilitaList() > 0) {
            TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant((String)plugin.getTipoPlugin());
            StringBuilder sb = new StringBuilder();
            switch (tipoPlugin) {
                case AUTENTICAZIONE: 
                case AUTORIZZAZIONE: 
                case AUTORIZZAZIONE_CONTENUTI: 
                case INTEGRAZIONE: {
                    for (PluginProprietaCompatibilita prop : plugin.getPluginProprietaCompatibilitaList()) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        if ("Qualsiasi".equals(prop.getValore())) {
                            sb.append("Erogazione/Fruizione");
                            continue;
                        }
                        sb.append(prop.getValore());
                    }
                    return sb.toString();
                }
                case SERVICE_HANDLER: {
                    for (PluginProprietaCompatibilita prop : plugin.getPluginProprietaCompatibilitaList()) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INIT.equalsIgnoreCase(prop.getValore())) {
                            sb.append("Startup Gateway");
                            continue;
                        }
                        if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_EXIT.equalsIgnoreCase(prop.getValore())) {
                            sb.append("Shutdown Gateway");
                            continue;
                        }
                        if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INTEGRATION_MANAGER_REQUEST.equalsIgnoreCase(prop.getValore())) {
                            sb.append("Richiesta al servizio IntegrationManager/MessageBox");
                            continue;
                        }
                        if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INTEGRATION_MANAGER_RESPONSE.equalsIgnoreCase(prop.getValore())) {
                            sb.append("Risposta dal servizio IntegrationManager/MessageBox");
                            continue;
                        }
                        sb.append(prop.getValore());
                    }
                    return sb.toString();
                }
                case MESSAGE_HANDLER: {
                    String tipoMessaggio = null;
                    String faseProcessamento = null;
                    for (PluginProprietaCompatibilita prop : plugin.getPluginProprietaCompatibilitaList()) {
                        if ("FaseMessageHandler".equalsIgnoreCase(prop.getNome())) {
                            if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_PRE_IN.equalsIgnoreCase(prop.getValore())) {
                                faseProcessamento = "Pre-In";
                                continue;
                            }
                            if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_IN.equalsIgnoreCase(prop.getValore())) {
                                faseProcessamento = "In";
                                continue;
                            }
                            if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_IN_PROTOCOL_INFO.equalsIgnoreCase(prop.getValore())) {
                                faseProcessamento = "InProfileInfo";
                                continue;
                            }
                            if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_OUT.equalsIgnoreCase(prop.getValore())) {
                                faseProcessamento = "Out";
                                continue;
                            }
                            if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_POST_OUT.equalsIgnoreCase(prop.getValore())) {
                                faseProcessamento = "Post-Out";
                                continue;
                            }
                            faseProcessamento = prop.getValore();
                            continue;
                        }
                        if (PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RICHIESTA.equals(prop.getValore())) {
                            tipoMessaggio = "Richiesta";
                            continue;
                        }
                        tipoMessaggio = "Risposta";
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(tipoMessaggio).append(" (").append(faseProcessamento).append(")");
                    return sb.toString();
                }
                case ALLARME: {
                    for (PluginProprietaCompatibilita prop : plugin.getPluginProprietaCompatibilitaList()) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        if ("ImplementazioneApi".equals(prop.getValore())) {
                            sb.append("Erogazione/Fruizione");
                            continue;
                        }
                        sb.append(prop.getValore());
                    }
                    return sb.toString();
                }
                case BEHAVIOUR: 
                case CONNETTORE: 
                case RATE_LIMITING: 
                case RICERCA: 
                case STATISTICA: 
                case TRANSAZIONE: 
                case TOKEN_DYNAMIC_DISCOVERY: 
                case TOKEN_VALIDAZIONE: 
                case TOKEN_NEGOZIAZIONE: 
                case ATTRIBUTE_AUTHORITY: {
                    return null;
                }
            }
        }
        return null;
    }

    public static TipoPlugin getTipoPluginDefault() {
        return null;
    }

    public static List<PluginProprietaCompatibilita> getApplicabilitaClassePlugin(TipoPlugin tipoPlugin, String ruolo, String shTipo, String mhTipo, String mhRuolo, String applicabilita) {
        ArrayList<PluginProprietaCompatibilita> lista = new ArrayList<PluginProprietaCompatibilita>();
        switch (tipoPlugin) {
            case AUTENTICAZIONE: 
            case AUTORIZZAZIONE: 
            case AUTORIZZAZIONE_CONTENUTI: 
            case INTEGRAZIONE: {
                PluginProprietaCompatibilita propRuolo = new PluginProprietaCompatibilita();
                propRuolo.setNome("Ruolo");
                propRuolo.setValore(ruolo);
                lista.add(propRuolo);
                break;
            }
            case SERVICE_HANDLER: {
                PluginProprietaCompatibilita propShTipo = new PluginProprietaCompatibilita();
                propShTipo.setNome("ServiceHandler");
                propShTipo.setValore(shTipo);
                lista.add(propShTipo);
                break;
            }
            case MESSAGE_HANDLER: {
                PluginProprietaCompatibilita propMhTipo = new PluginProprietaCompatibilita();
                propMhTipo.setNome("FaseMessageHandler");
                propMhTipo.setValore(mhTipo);
                lista.add(propMhTipo);
                PluginProprietaCompatibilita propMhRuolo = new PluginProprietaCompatibilita();
                propMhRuolo.setNome("RuoloMessageHandler");
                propMhRuolo.setValore(mhRuolo);
                lista.add(propMhRuolo);
                break;
            }
            case ALLARME: {
                PluginProprietaCompatibilita propApplicabilita = new PluginProprietaCompatibilita();
                propApplicabilita.setNome("Applicabilita");
                propApplicabilita.setValore(applicabilita);
                lista.add(propApplicabilita);
                break;
            }
        }
        return lista;
    }

    public static void addInfoClassePlugin(DataElement de, TipoPlugin tipoPlugin, String ruolo, String shTipo, String mhTipo, String mhRuolo, boolean integrationManagerEnabled) {
        String titolo = "ClassName";
        DataElementInfo info = new DataElementInfo(titolo);
        String infoSingola = "Il plugin deve implementare l'interfaccia: ";
        String infoMultiplaAnd = "Il plugin deve implementare tutte le seguenti interfacce: ";
        String infoMultiplaOr = "Il plugin deve implementare una delle seguenti interfacce: ";
        ArrayList<Object> listBody = new ArrayList<Object>();
        switch (tipoPlugin) {
            case AUTENTICAZIONE: {
                if (ruolo == null || StringUtils.isEmpty((CharSequence)ruolo) || !PluginCostanti.FILTRO_RUOLO_VALORI.contains(ruolo)) {
                    ruolo = (String)PluginCostanti.FILTRO_RUOLO_VALORI.get(0);
                }
                if ("Erogazione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutenticazionePortaApplicativa.class.getName());
                    break;
                }
                if ("Fruizione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutenticazionePortaDelegata.class.getName());
                    break;
                }
                info.setHeaderBody(infoMultiplaAnd);
                listBody.add(IAutenticazionePortaApplicativa.class.getName());
                listBody.add(IAutenticazionePortaDelegata.class.getName());
                break;
            }
            case AUTORIZZAZIONE: {
                if (ruolo == null || StringUtils.isEmpty((CharSequence)ruolo) || !PluginCostanti.FILTRO_RUOLO_VALORI.contains(ruolo)) {
                    ruolo = (String)PluginCostanti.FILTRO_RUOLO_VALORI.get(0);
                }
                if ("Erogazione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutorizzazionePortaApplicativa.class.getName());
                    break;
                }
                if ("Fruizione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutorizzazionePortaDelegata.class.getName());
                    break;
                }
                info.setHeaderBody(infoMultiplaAnd);
                listBody.add(IAutorizzazionePortaApplicativa.class.getName());
                listBody.add(IAutorizzazionePortaDelegata.class.getName());
                break;
            }
            case AUTORIZZAZIONE_CONTENUTI: {
                if (ruolo == null || StringUtils.isEmpty((CharSequence)ruolo) || !PluginCostanti.FILTRO_RUOLO_VALORI.contains(ruolo)) {
                    ruolo = (String)PluginCostanti.FILTRO_RUOLO_VALORI.get(0);
                }
                if ("Erogazione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutorizzazioneContenutoPortaApplicativa.class.getName());
                    break;
                }
                if ("Fruizione".equals(ruolo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IAutorizzazioneContenutoPortaDelegata.class.getName());
                    break;
                }
                info.setHeaderBody(infoMultiplaAnd);
                listBody.add(IAutorizzazioneContenutoPortaApplicativa.class.getName());
                listBody.add(IAutorizzazioneContenutoPortaDelegata.class.getName());
                break;
            }
            case INTEGRAZIONE: {
                if (ruolo == null || StringUtils.isEmpty((CharSequence)ruolo) || !PluginCostanti.FILTRO_RUOLO_VALORI.contains(ruolo)) {
                    ruolo = (String)PluginCostanti.FILTRO_RUOLO_VALORI.get(0);
                }
                if ("Erogazione".equals(ruolo)) {
                    info.setHeaderBody(infoMultiplaOr);
                    listBody.add(IGestoreIntegrazionePA.class.getName());
                    listBody.add(IGestoreIntegrazionePASoap.class.getName());
                    break;
                }
                if ("Fruizione".equals(ruolo)) {
                    info.setHeaderBody(infoMultiplaOr);
                    listBody.add(IGestoreIntegrazionePD.class.getName());
                    listBody.add(IGestoreIntegrazionePDSoap.class.getName());
                    break;
                }
                info.setHeaderBody(infoMultiplaAnd);
                listBody.add(IGestoreIntegrazionePA.class.getName() + "(o versione Soap)");
                listBody.add(IGestoreIntegrazionePD.class.getName() + "(o versione Soap)");
                break;
            }
            case RATE_LIMITING: {
                info.setHeaderBody(infoSingola);
                listBody.add(IRateLimiting.class.getName());
                break;
            }
            case CONNETTORE: {
                info.setHeaderBody(infoSingola);
                listBody.add(IConnettore.class.getName());
                break;
            }
            case ALLARME: {
                info.setHeaderBody(infoSingola);
                listBody.add(IAlarmProcessing.class.getName());
                break;
            }
            case BEHAVIOUR: {
                info.setHeaderBody(infoSingola);
                listBody.add(IBehaviour.class.getName());
                break;
            }
            case SERVICE_HANDLER: {
                List values;
                List list = values = integrationManagerEnabled ? PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_CON_INTEGRATION_MANAGER : PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_SENZA_INTEGRATION_MANAGER;
                if (shTipo == null || StringUtils.isEmpty((CharSequence)shTipo) || !values.contains(shTipo)) {
                    shTipo = (String)values.get(0);
                }
                if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INIT.equals(shTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(InitHandler.class.getName());
                    break;
                }
                if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_EXIT.equals(shTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(ExitHandler.class.getName());
                    break;
                }
                if (PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INTEGRATION_MANAGER_REQUEST.equals(shTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(IntegrationManagerRequestHandler.class.getName());
                    break;
                }
                if (!PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INTEGRATION_MANAGER_RESPONSE.equals(shTipo)) break;
                info.setHeaderBody(infoSingola);
                listBody.add(IntegrationManagerResponseHandler.class.getName());
                break;
            }
            case MESSAGE_HANDLER: {
                boolean isRisposta;
                List values;
                if (mhRuolo == null || StringUtils.isEmpty((CharSequence)mhRuolo) || !PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORI.contains(mhRuolo)) {
                    mhRuolo = (String)PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORI.get(0);
                }
                List list = values = (isRisposta = PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RISPOSTA.equals(mhRuolo)) ? PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RISPOSTA : PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RICHIESTA;
                if (mhTipo == null || StringUtils.isEmpty((CharSequence)mhTipo) || !values.contains(mhTipo)) {
                    mhTipo = (String)values.get(0);
                }
                if (PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RICHIESTA.equals(mhRuolo)) {
                    if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_PRE_IN.equals(mhTipo)) {
                        info.setHeaderBody(infoSingola);
                        listBody.add(PreInRequestHandler.class.getName());
                        break;
                    }
                    if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_IN.equals(mhTipo)) {
                        info.setHeaderBody(infoSingola);
                        listBody.add(InRequestHandler.class.getName());
                        break;
                    }
                    if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_IN_PROTOCOL_INFO.equals(mhTipo)) {
                        info.setHeaderBody(infoSingola);
                        listBody.add(InRequestProtocolHandler.class.getName());
                        break;
                    }
                    if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_OUT.equals(mhTipo)) {
                        info.setHeaderBody(infoSingola);
                        listBody.add(OutRequestHandler.class.getName());
                        break;
                    }
                    if (!PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_POST_OUT.equals(mhTipo)) break;
                    info.setHeaderBody(infoSingola);
                    listBody.add(PostOutRequestHandler.class.getName());
                    break;
                }
                if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_PRE_IN.equals(mhTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(PreInResponseHandler.class.getName());
                    break;
                }
                if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_IN.equals(mhTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(InResponseHandler.class.getName());
                    break;
                }
                if (PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_OUT.equals(mhTipo)) {
                    info.setHeaderBody(infoSingola);
                    listBody.add(OutResponseHandler.class.getName());
                    break;
                }
                if (!PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_POST_OUT.equals(mhTipo)) break;
                info.setHeaderBody(infoSingola);
                listBody.add(PostOutResponseHandler.class.getName());
                break;
            }
            case RICERCA: 
            case STATISTICA: 
            case TRANSAZIONE: {
                break;
            }
            case TOKEN_DYNAMIC_DISCOVERY: {
                info.setHeaderBody(infoSingola);
                listBody.add(IDynamicDiscoveryParser.class.getName());
                break;
            }
            case TOKEN_VALIDAZIONE: {
                info.setHeaderBody(infoSingola);
                listBody.add(ITokenParser.class.getName());
                break;
            }
            case TOKEN_NEGOZIAZIONE: {
                info.setHeaderBody(infoSingola);
                listBody.add(INegoziazioneTokenParser.class.getName());
                break;
            }
            case ATTRIBUTE_AUTHORITY: {
                info.setHeaderBody(infoSingola);
                listBody.add(IRetrieveAttributeAuthorityResponseParser.class.getName());
            }
        }
        if (!listBody.isEmpty()) {
            info.setListBody(listBody);
            de.setInfo(info);
        }
    }

    public static List<DataElement> getSezioneDinamicaClassePlugin(List<DataElement> dati, TipoPlugin tipoPlugin, String ruolo, String shTipo, String mhTipo, String mhRuolo, String applicabilita, boolean integrationManagerEnabled) {
        switch (tipoPlugin) {
            case AUTENTICAZIONE: 
            case AUTORIZZAZIONE: 
            case AUTORIZZAZIONE_CONTENUTI: 
            case INTEGRAZIONE: {
                DataElement deRuolo = new DataElement();
                deRuolo.setLabel("Tipologia API");
                deRuolo.setLabels(PluginCostanti.FILTRO_RUOLO_LABELS);
                deRuolo.setValues(PluginCostanti.FILTRO_RUOLO_VALORI);
                deRuolo.setType(DataElementType.SELECT);
                deRuolo.setName("pcFRuolo");
                deRuolo.setSelected(ruolo);
                deRuolo.setPostBack(true);
                dati.add(deRuolo);
                break;
            }
            case SERVICE_HANDLER: {
                DataElement deShTipo = new DataElement();
                deShTipo.setLabel("Fase Processamento");
                List values = integrationManagerEnabled ? PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_CON_INTEGRATION_MANAGER : PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_SENZA_INTEGRATION_MANAGER;
                List labels = integrationManagerEnabled ? PluginCostanti.FILTRO_SERVICE_HANDLER_LABEL_CON_INTEGRATION_MANAGER : PluginCostanti.FILTRO_SERVICE_HANDLER_LABEL_SENZA_INTEGRATION_MANAGER;
                deShTipo.setLabels(labels);
                deShTipo.setValues(values);
                deShTipo.setType(DataElementType.SELECT);
                deShTipo.setName("pcFSH");
                deShTipo.setSelected(shTipo);
                deShTipo.setPostBack(true);
                dati.add(deShTipo);
                break;
            }
            case MESSAGE_HANDLER: {
                DataElement deMhRuolo = new DataElement();
                deMhRuolo.setLabel("Ruolo Messaggio");
                deMhRuolo.setLabels(PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_LABELS);
                deMhRuolo.setValues(PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORI);
                deMhRuolo.setType(DataElementType.SELECT);
                deMhRuolo.setName("pcFRMH");
                deMhRuolo.setSelected(mhRuolo);
                deMhRuolo.setPostBack(true);
                dati.add(deMhRuolo);
                DataElement deMhTipo = new DataElement();
                deMhTipo.setLabel("Fase Processamento");
                boolean isRisposta = PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RISPOSTA.equals(mhRuolo);
                List values = isRisposta ? PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RISPOSTA : PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RICHIESTA;
                List labels = isRisposta ? PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_LABEL_RISPOSTA : PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_LABEL_RICHIESTA;
                deMhTipo.setLabels(labels);
                deMhTipo.setValues(values);
                deMhTipo.setType(DataElementType.SELECT);
                deMhTipo.setName("pcFFMH");
                deMhTipo.setSelected(mhTipo);
                deMhTipo.setPostBack(true);
                dati.add(deMhTipo);
                break;
            }
            case ALLARME: {
                DataElement deApplicabilita = new DataElement();
                deApplicabilita.setLabel("Applicabilit\u00e0");
                deApplicabilita.setLabels(PluginCostanti.FILTRO_APPLICABILITA_LABELS);
                deApplicabilita.setValues(PluginCostanti.FILTRO_APPLICABILITA_VALORI);
                deApplicabilita.setType(DataElementType.SELECT);
                deApplicabilita.setName("pcFAppl");
                deApplicabilita.setSelected(applicabilita);
                deApplicabilita.setPostBack(false);
                dati.add(deApplicabilita);
                break;
            }
        }
        return dati;
    }

    public static String getValoreProprieta(Plugin plugin, String nome) {
        if (plugin.sizePluginProprietaCompatibilitaList() > 0) {
            TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant((String)plugin.getTipoPlugin());
            switch (tipoPlugin) {
                case ALLARME: 
                case AUTENTICAZIONE: 
                case AUTORIZZAZIONE: 
                case AUTORIZZAZIONE_CONTENUTI: 
                case INTEGRAZIONE: 
                case MESSAGE_HANDLER: 
                case SERVICE_HANDLER: {
                    for (PluginProprietaCompatibilita prop : plugin.getPluginProprietaCompatibilitaList()) {
                        if (!prop.getNome().equals(nome)) continue;
                        return prop.getValore();
                    }
                    return null;
                }
                case BEHAVIOUR: 
                case CONNETTORE: 
                case RATE_LIMITING: 
                case RICERCA: 
                case STATISTICA: 
                case TRANSAZIONE: 
                case TOKEN_DYNAMIC_DISCOVERY: 
                case TOKEN_VALIDAZIONE: 
                case TOKEN_NEGOZIAZIONE: 
                case ATTRIBUTE_AUTHORITY: {
                    return null;
                }
            }
        }
        return null;
    }

    public static void addFiltriSpecificiTipoPlugin(PageData pd, Logger log, ISearch ricerca, int idLista, String valoreTipoPlugin, int size, boolean integrationManagerEnabled) throws Exception {
        TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant((String)valoreTipoPlugin);
        switch (tipoPlugin) {
            case AUTENTICAZIONE: 
            case AUTORIZZAZIONE: 
            case AUTORIZZAZIONE_CONTENUTI: 
            case INTEGRAZIONE: {
                String filtroRuolo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"Ruolo");
                ConfigurazionePluginsTipoPluginUtils.addFilterTipoPlugin(pd, log, "Ruolo", "Tipologia API", filtroRuolo, PluginCostanti.FILTRO_RUOLO_VALORI_SENZA_ENTRAMBI, PluginCostanti.FILTRO_RUOLO_LABELS_SENZA_ENTRAMBI, false, size);
                break;
            }
            case SERVICE_HANDLER: {
                List values = integrationManagerEnabled ? PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_CON_INTEGRATION_MANAGER : PluginCostanti.FILTRO_SERVICE_HANDLER_VALORI_SENZA_INTEGRATION_MANAGER;
                List labels = integrationManagerEnabled ? PluginCostanti.FILTRO_SERVICE_HANDLER_LABEL_CON_INTEGRATION_MANAGER : PluginCostanti.FILTRO_SERVICE_HANDLER_LABEL_SENZA_INTEGRATION_MANAGER;
                String filtroShTipo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"ServiceHandler");
                ConfigurazionePluginsTipoPluginUtils.addFilterTipoPlugin(pd, log, "ServiceHandler", "Fase Processamento", filtroShTipo, values, labels, false, size);
                break;
            }
            case MESSAGE_HANDLER: {
                String filtroMhRuolo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"RuoloMessageHandler");
                ConfigurazionePluginsTipoPluginUtils.addFilterTipoPlugin(pd, log, "RuoloMessageHandler", "Ruolo Messaggio", filtroMhRuolo, PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORI, PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_LABELS, true, size);
                boolean isRisposta = PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RISPOSTA.equals(filtroMhRuolo);
                List values = isRisposta ? PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RISPOSTA : PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORI_RICHIESTA;
                List labels = isRisposta ? PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_LABEL_RISPOSTA : PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_LABEL_RICHIESTA;
                String filtroMhTipo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"FaseMessageHandler");
                ConfigurazionePluginsTipoPluginUtils.addFilterTipoPlugin(pd, log, "FaseMessageHandler", "Fase Processamento", filtroMhTipo, values, labels, false, size);
                break;
            }
            case ALLARME: {
                String filtroApplicabilita = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"Applicabilita");
                ConfigurazionePluginsTipoPluginUtils.addFilterTipoPlugin(pd, log, "Applicabilita", "Applicabilit\u00e0", filtroApplicabilita, PluginCostanti.FILTRO_APPLICABILITA_VALORI_SENZA_QUALSIASI, PluginCostanti.FILTRO_APPLICABILITA_LABELS_SENZA_QUALSIASI, false, size);
                break;
            }
        }
    }

    public static void addFilterTipoPlugin(PageData pd, Logger log, String nomeFiltro, String labelFiltro, String valoreFiltro, List<String> valuesFiltro, List<String> labelsFiltro, boolean postBack, int size) throws Exception {
        try {
            int length = 1;
            if (valuesFiltro != null && !valuesFiltro.isEmpty()) {
                length += valuesFiltro.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (valuesFiltro != null && valuesFiltro.size() > 0) {
                for (int i = 0; i < valuesFiltro.size(); ++i) {
                    labels[i + 1] = labelsFiltro.get(i);
                    values[i + 1] = valuesFiltro.get(i);
                }
            }
            pd.addFilter(nomeFiltro, labelFiltro, valoreFiltro, values, labels, postBack, size);
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }
}

