/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.id.UUIDUtilsGenerator;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazionePluginsArchiviAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String idArchivioS = confHelper.getParameter("plId");
            String nome = confHelper.getParameter("plNome");
            String descrizione = confHelper.getParameter("plDescr");
            String stato = confHelper.getParameter("plStato");
            String sorgente = confHelper.getParameter("plSorg");
            BinaryParameter jarArchivio = confHelper.getBinaryParameter("plJar");
            String urlArchivio = confHelper.getParameter("plUrl");
            String dirArchivio = confHelper.getParameter("plDir");
            String classiPlugin = confHelper.getParameter("plClassi");
            String[] tipoPlugin = confHelper.getParameterValues("plTipo");
            int numeroArchivi = 0;
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro Archivi", "configurazionePluginsArchiviList.do"));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (nome == null) {
                    nome = "";
                    descrizione = "";
                    stato = StatoFunzionalita.ABILITATO.toString();
                    sorgente = ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE_JAR;
                    classiPlugin = "qualsiasi";
                    tipoPlugin = null;
                    dirArchivio = "";
                    urlArchivio = "";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginToDati(TipoOperazione.ADD, dati, null, idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, tipoPlugin, numeroArchivi);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.registroPluginCheckData(TipoOperazione.ADD, null, idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, tipoPlugin);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginToDati(TipoOperazione.ADD, dati, null, idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, tipoPlugin, numeroArchivi);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.ADD());
            }
            int posizione = confCore.getMaxPosizioneRegistroPlugin() + 1;
            RegistroPlugin registro = new RegistroPlugin();
            registro.setNome(nome);
            if (stato.equals(StatoFunzionalita.ABILITATO.getValue())) {
                registro.setStato(StatoFunzionalita.ABILITATO);
            } else {
                registro.setStato(StatoFunzionalita.DISABILITATO);
            }
            registro.setPosizione(posizione);
            if (descrizione != null && !"".equals(descrizione)) {
                registro.setDescrizione(descrizione);
            }
            registro.setData(new Date());
            registro.getCompatibilitaList().clear();
            if (!classiPlugin.equals("qualsiasi")) {
                for (String tipo : tipoPlugin) {
                    registro.getCompatibilitaList().add(tipo);
                }
            }
            RegistroPluginArchivio registroPluginArchivio = new RegistroPluginArchivio();
            registroPluginArchivio.setNomePlugin(nome);
            registroPluginArchivio.setData(registro.getData());
            registroPluginArchivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio((String)sorgente));
            switch (registroPluginArchivio.getSorgente()) {
                case JAR: {
                    registroPluginArchivio.setNome(jarArchivio.getFilename());
                    registroPluginArchivio.setContenuto(jarArchivio.getValue());
                    break;
                }
                case URL: {
                    registroPluginArchivio.setUrl(urlArchivio);
                    registroPluginArchivio.setNome(UUIDUtilsGenerator.newUUID());
                    break;
                }
                case DIR: {
                    registroPluginArchivio.setDir(dirArchivio);
                    registroPluginArchivio.setNome(UUIDUtilsGenerator.newUUID());
                }
            }
            registro.getArchivioList().add(registroPluginArchivio);
            confCore.performCreateOperation(userLogin, confHelper.smista(), registro);
            confCore.updatePluginClassLoader();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<RegistroPlugin> lista = confCore.pluginsArchiviList((ISearch)ricerca);
            confHelper.preparePluginsArchiviList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.ADD());
        }
    }
}

