/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.govway.struts.upload.FormFile;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizio;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataServizio;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProprietaOggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.AzioneSintetica;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.protocol.basic.config.ImplementationConfiguration;
import org.openspcoop2.protocol.basic.config.SubscriptionConfiguration;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedListServlet;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCostanti;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaPorteApplicativeMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utils.ProprietaOggettoRegistro;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class AccordiServizioParteSpecificaHelper
extends ConnettoriHelper {
    private static boolean documentoUnivocoIndipendentementeTipo = true;
    private static boolean addFruitoreToDati_farVedere = false;

    public AccordiServizioParteSpecificaHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public AccordiServizioParteSpecificaHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    boolean accordiParteSpecificaWSDLCheckData(PageData pd, String tipo, String wsdl, AccordoServizioParteSpecifica aps, AccordoServizioParteComune apc, boolean validazioneDocumenti) throws Exception {
        if (validazioneDocumenti) {
            FormatoSpecifica formato = null;
            if (apc != null) {
                formato = apc.getFormatoSpecifica();
            }
            boolean validazioneParteSpecifica = false;
            if (tipo.equals("wsdlimpler")) {
                tmp = this.apsCore.getInterfaceAsByteArray(formato, wsdl);
                aps.setByteWsdlImplementativoErogatore(tmp);
                validazioneParteSpecifica = true;
            } else if (tipo.equals("wsdlimplfru")) {
                tmp = this.apsCore.getInterfaceAsByteArray(formato, wsdl);
                aps.setByteWsdlImplementativoFruitore(tmp);
                validazioneParteSpecifica = true;
            }
            if (validazioneParteSpecifica) {
                ValidazioneResult result = this.apsCore.validaInterfacciaWsdlParteSpecifica(aps, apc, this.soggettiCore);
                if (!result.isEsito()) {
                    pd.setMessage(result.getMessaggioErrore());
                }
                return result.isEsito();
            }
        }
        return true;
    }

    boolean accordiParteSpecificaFruitoreWSDLCheckData(PageData pd, String tipo, String wsdl, Fruitore fruitore, AccordoServizioParteSpecifica aps, AccordoServizioParteComune apc, boolean validazioneDocumenti) throws Exception {
        if (validazioneDocumenti) {
            FormatoSpecifica formato = null;
            if (apc != null) {
                formato = apc.getFormatoSpecifica();
            }
            boolean validazioneParteSpecifica = false;
            if (tipo.equals("wsdlimpler")) {
                tmp = this.apsCore.getInterfaceAsByteArray(formato, wsdl);
                fruitore.setByteWsdlImplementativoErogatore(tmp);
                validazioneParteSpecifica = true;
            } else if (tipo.equals("wsdlimplfru")) {
                tmp = this.apsCore.getInterfaceAsByteArray(formato, wsdl);
                fruitore.setByteWsdlImplementativoFruitore(tmp);
                validazioneParteSpecifica = true;
            }
            if (validazioneParteSpecifica) {
                ValidazioneResult result = this.apsCore.validaInterfacciaWsdlParteSpecifica(fruitore, (AccordoServizioParteSpecifica)aps.clone(), apc, this.soggettiCore);
                if (!result.isEsito()) {
                    pd.setMessage(result.getMessaggioErrore());
                }
                return result.isEsito();
            }
        }
        return true;
    }

    private boolean existsOperazione(AccordoServizioParteComuneSintetico aspc, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String portType, String azione) {
        block6: {
            block8: {
                block7: {
                    if (!org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding)) break block7;
                    if (aspc.getResource() == null || aspc.getResource().isEmpty()) break block6;
                    for (ResourceSintetica resource : aspc.getResource()) {
                        if (!resource.getNome().equals(azione)) continue;
                        return true;
                    }
                    break block6;
                }
                if (portType == null || "".equals(portType)) break block8;
                if (aspc.getPortType() == null || aspc.getPortType().isEmpty()) break block6;
                for (PortTypeSintetico pt : aspc.getPortType()) {
                    if (!portType.equals(pt.getNome())) continue;
                    if (pt.getAzione() != null && !pt.getAzione().isEmpty()) {
                        for (OperationSintetica az : pt.getAzione()) {
                            if (!az.getNome().equals(azione)) continue;
                            return true;
                        }
                    }
                    break block6;
                }
                break block6;
            }
            if (aspc.getAzione() != null && !aspc.getAzione().isEmpty()) {
                for (AzioneSintetica az : aspc.getAzione()) {
                    if (!az.getNome().equals(azione)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkModificaVersioneApi(AccordoServizioParteSpecifica servizio, long idAccordo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String portType, boolean gestioneFruitori, boolean gestioneErogatori) throws Exception {
        boolean azioniInFruizione;
        List erogazione_listTrasformazioniPredefinito = null;
        ArrayList<String> erogazione_listRateLimitingPredefinito = null;
        ArrayList<Object> erogazione_listAllarmePredefinito = null;
        HashMap erogazione_mapGruppi = new HashMap();
        HashMap<String, List> fruizione_listTrasformazioniPredefinito = null;
        HashMap fruizione_listRateLimitingPredefinito = null;
        HashMap fruizione_listAllarmePredefinito = null;
        HashMap fruizione_mapGruppi = new HashMap();
        IDServizio idService = this.idServizioFactory.getIDServizioFromAccordo(servizio);
        List<MappingErogazionePortaApplicativa> listaMappingErogazione = null;
        try {
            listaMappingErogazione = this.apsCore.mappingServiziPorteAppList(idService, servizio.getId(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (listaMappingErogazione != null && !listaMappingErogazione.isEmpty()) {
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaMappingErogazione) {
                PortaApplicativa pa = null;
                try {
                    pa = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pa == null) continue;
                if (mappingErogazionePortaApplicativa.isDefault()) {
                    Object ricercaPolicies32;
                    if (pa.getTrasformazioni() != null && pa.getTrasformazioni().sizeRegolaList() > 0) {
                        for (TrasformazioneRegola regola : pa.getTrasformazioni().getRegolaList()) {
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeAzioneList() <= 0) continue;
                            if (erogazione_listTrasformazioniPredefinito == null) {
                                erogazione_listTrasformazioniPredefinito = regola.getApplicabilita().getAzioneList();
                                continue;
                            }
                            for (String string : regola.getApplicabilita().getAzioneList()) {
                                if (erogazione_listTrasformazioniPredefinito.contains(string)) continue;
                                erogazione_listTrasformazioniPredefinito.add(string);
                            }
                        }
                    }
                    List<AttivazionePolicy> listaPolicies = null;
                    try {
                        ConsoleSearch ricercaPolicies2 = new ConsoleSearch(true);
                        listaPolicies = this.confCore.attivazionePolicyList(ricercaPolicies2, RuoloPolicy.APPLICATIVA, pa.getNome());
                    }
                    catch (Exception ricercaPolicies2) {
                        // empty catch block
                    }
                    if (listaPolicies != null && !listaPolicies.isEmpty()) {
                        for (AttivazionePolicy ap : listaPolicies) {
                            String[] stringArray;
                            if (ap.getFiltro() == null || ap.getFiltro().getAzione() == null || (stringArray = ap.getFiltro().getAzione().split(",")) == null || stringArray.length <= 0) continue;
                            if (erogazione_listRateLimitingPredefinito == null) {
                                erogazione_listRateLimitingPredefinito = new ArrayList<String>();
                            }
                            for (String az : stringArray) {
                                if (erogazione_listRateLimitingPredefinito.contains(az)) continue;
                                erogazione_listRateLimitingPredefinito.add(az);
                            }
                        }
                    }
                    if (!this.confCore.isConfigurazioneAllarmiEnabled()) continue;
                    Object listaAllarmi = null;
                    try {
                        ricercaPolicies32 = new ConsoleSearch(true);
                        listaAllarmi = this.confCore.allarmiList((ConsoleSearch)ricercaPolicies32, RuoloPorta.APPLICATIVA, pa.getNome());
                    }
                    catch (Exception ricercaPolicies32) {
                        // empty catch block
                    }
                    if (listaAllarmi == null || listaAllarmi.isEmpty()) continue;
                    ricercaPolicies32 = listaAllarmi.iterator();
                    while (ricercaPolicies32.hasNext()) {
                        String[] tmp;
                        ConfigurazioneAllarmeBean configurazioneAllarmeBean = (ConfigurazioneAllarmeBean)ricercaPolicies32.next();
                        if (configurazioneAllarmeBean.getFiltro() == null || configurazioneAllarmeBean.getFiltro().getAzione() == null || (tmp = configurazioneAllarmeBean.getFiltro().getAzione().split(",")) == null || tmp.length <= 0) continue;
                        if (erogazione_listAllarmePredefinito == null) {
                            erogazione_listAllarmePredefinito = new ArrayList<Object>();
                        }
                        for (String az : tmp) {
                            if (erogazione_listAllarmePredefinito.contains(az)) continue;
                            erogazione_listAllarmePredefinito.add(az);
                        }
                    }
                    continue;
                }
                if (pa.getAzione() == null || pa.getAzione().sizeAzioneDelegataList() <= 0) continue;
                ArrayList<Object> l = new ArrayList<Object>();
                for (Object az22 : pa.getAzione().getAzioneDelegataList()) {
                    l.add(az22);
                }
                erogazione_mapGruppi.put(mappingErogazionePortaApplicativa.getDescrizione(), l);
            }
        }
        if (servizio.sizeFruitoreList() > 0) {
            for (Fruitore fruitore : servizio.getFruitoreList()) {
                Object az22;
                IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                String labelFruitore = ConsoleHelper._getLabelNomeSoggetto(idFruitore);
                Object listaMappingFruizione = null;
                try {
                    listaMappingFruizione = this.apsCore.serviziFruitoriMappingList(idFruitore, idService, null);
                }
                catch (Exception az22) {
                    // empty catch block
                }
                if (listaMappingFruizione == null || listaMappingFruizione.isEmpty()) continue;
                az22 = listaMappingFruizione.iterator();
                while (az22.hasNext()) {
                    MappingFruizionePortaDelegata mappingFruizionePortaDelegata = (MappingFruizionePortaDelegata)az22.next();
                    PortaDelegata pd = null;
                    try {
                        pd = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (pd == null) continue;
                    if (mappingFruizionePortaDelegata.isDefault()) {
                        if (pd.getTrasformazioni() != null && pd.getTrasformazioni().sizeRegolaList() > 0) {
                            List list = null;
                            for (TrasformazioneRegola regola : pd.getTrasformazioni().getRegolaList()) {
                                if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeAzioneList() <= 0) continue;
                                if (list == null) {
                                    list = regola.getApplicabilita().getAzioneList();
                                    continue;
                                }
                                for (String az : regola.getApplicabilita().getAzioneList()) {
                                    if (list.contains(az)) continue;
                                    list.add(az);
                                }
                            }
                            if (list != null) {
                                if (fruizione_listTrasformazioniPredefinito == null) {
                                    fruizione_listTrasformazioniPredefinito = new HashMap<String, List>();
                                }
                                fruizione_listTrasformazioniPredefinito.put(labelFruitore, list);
                            }
                        }
                        List<AttivazionePolicy> listaPolicies = null;
                        try {
                            ConsoleSearch ricercaPolicies = new ConsoleSearch(true);
                            listaPolicies = this.confCore.attivazionePolicyList(ricercaPolicies, RuoloPolicy.DELEGATA, pd.getNome());
                        }
                        catch (Exception ricercaPolicies) {
                            // empty catch block
                        }
                        if (listaPolicies != null && !listaPolicies.isEmpty()) {
                            TrasformazioneRegola regola;
                            ArrayList<String> list = null;
                            regola = listaPolicies.iterator();
                            while (regola.hasNext()) {
                                String[] tmp;
                                AttivazionePolicy ap = (AttivazionePolicy)regola.next();
                                if (ap.getFiltro() == null || ap.getFiltro().getAzione() == null || (tmp = ap.getFiltro().getAzione().split(",")) == null || tmp.length <= 0) continue;
                                if (list == null) {
                                    list = new ArrayList<String>();
                                }
                                for (String az4 : tmp) {
                                    if (list.contains(az4)) continue;
                                    list.add(az4);
                                }
                            }
                            if (list != null) {
                                if (fruizione_listRateLimitingPredefinito == null) {
                                    fruizione_listRateLimitingPredefinito = new HashMap();
                                }
                                fruizione_listRateLimitingPredefinito.put(labelFruitore, list);
                            }
                        }
                        if (!this.confCore.isConfigurazioneAllarmiEnabled()) continue;
                        Object listaAllarmi = null;
                        try {
                            ConsoleSearch ricercaPolicies = new ConsoleSearch(true);
                            listaAllarmi = this.confCore.allarmiList(ricercaPolicies, RuoloPorta.DELEGATA, pd.getNome());
                        }
                        catch (Exception ricercaPolicies) {
                            // empty catch block
                        }
                        if (listaAllarmi == null || listaAllarmi.isEmpty()) continue;
                        ArrayList<String> list = null;
                        Iterator iterator = listaAllarmi.iterator();
                        while (iterator.hasNext()) {
                            String[] tmp;
                            ConfigurazioneAllarmeBean allarme = (ConfigurazioneAllarmeBean)iterator.next();
                            if (allarme.getFiltro() == null || allarme.getFiltro().getAzione() == null || (tmp = allarme.getFiltro().getAzione().split(",")) == null || tmp.length <= 0) continue;
                            if (list == null) {
                                list = new ArrayList<String>();
                            }
                            for (String az5 : tmp) {
                                if (list.contains(az5)) continue;
                                list.add(az5);
                            }
                        }
                        if (list == null) continue;
                        if (fruizione_listAllarmePredefinito == null) {
                            fruizione_listAllarmePredefinito = new HashMap();
                        }
                        fruizione_listAllarmePredefinito.put(labelFruitore, list);
                        continue;
                    }
                    if (pd.getAzione() == null || pd.getAzione().sizeAzioneDelegataList() <= 0) continue;
                    ArrayList<String> l = new ArrayList<String>();
                    for (String az6 : pd.getAzione().getAzioneDelegataList()) {
                        l.add(az6);
                    }
                    HashMap<String, ArrayList<String>> m = new HashMap<String, ArrayList<String>>();
                    m.put(mappingFruizionePortaDelegata.getDescrizione(), l);
                    fruizione_mapGruppi.put(labelFruitore, m);
                }
            }
        }
        StringBuilder sbError = new StringBuilder();
        AccordoServizioParteComuneSintetico asSintetico = null;
        boolean azioniInErogazione = !erogazione_mapGruppi.isEmpty() || erogazione_listRateLimitingPredefinito != null || erogazione_listAllarmePredefinito != null || erogazione_listTrasformazioniPredefinito != null;
        boolean bl = azioniInFruizione = !fruizione_mapGruppi.isEmpty() || fruizione_listRateLimitingPredefinito != null || fruizione_listAllarmePredefinito != null || fruizione_listTrasformazioniPredefinito != null;
        if (azioniInErogazione || azioniInFruizione) {
            ArrayList<String> azioniNonTrovate;
            Iterator azioniNonTrovate2;
            asSintetico = this.apcCore.getAccordoServizioSintetico(idAccordo);
            if (!erogazione_mapGruppi.isEmpty()) {
                for (Iterator gruppo : erogazione_mapGruppi.keySet()) {
                    List list = (List)erogazione_mapGruppi.get(gruppo);
                    ArrayList azioniNonTrovate22 = new ArrayList();
                    if (list != null && !list.isEmpty()) {
                        for (String az : list) {
                            if (this.existsOperazione(asSintetico, serviceBinding, portType, az)) continue;
                            azioniNonTrovate22.add(az);
                        }
                    }
                    if (azioniNonTrovate22.isEmpty()) continue;
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Gruppo '" + gruppo + "' (Erogazione): " + String.valueOf(azioniNonTrovate22));
                }
            }
            if (erogazione_listTrasformazioniPredefinito != null && !erogazione_listTrasformazioniPredefinito.isEmpty()) {
                azioniNonTrovate2 = new ArrayList();
                for (String string : erogazione_listTrasformazioniPredefinito) {
                    if (this.existsOperazione(asSintetico, serviceBinding, portType, string)) continue;
                    azioniNonTrovate2.add((String)string);
                }
                if (!azioniNonTrovate2.isEmpty()) {
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Criteri di Applicabilit\u00e0 nelle Trasformazioni del gruppo 'Predefinito' (Erogazione): " + String.valueOf(azioniNonTrovate2));
                }
            }
            if (erogazione_listRateLimitingPredefinito != null && !erogazione_listRateLimitingPredefinito.isEmpty()) {
                azioniNonTrovate2 = new ArrayList();
                for (String string : erogazione_listRateLimitingPredefinito) {
                    if (this.existsOperazione(asSintetico, serviceBinding, portType, string)) continue;
                    azioniNonTrovate2.add((String)string);
                }
                if (!azioniNonTrovate2.isEmpty()) {
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Policy di RateLimiting del gruppo 'Predefinito' (Erogazione): " + String.valueOf(azioniNonTrovate2));
                }
            }
            if (erogazione_listAllarmePredefinito != null && !erogazione_listAllarmePredefinito.isEmpty()) {
                azioniNonTrovate2 = new ArrayList();
                for (String string : erogazione_listAllarmePredefinito) {
                    if (this.existsOperazione(asSintetico, serviceBinding, portType, string)) continue;
                    azioniNonTrovate2.add((String)string);
                }
                if (!azioniNonTrovate2.isEmpty()) {
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Allarme del gruppo 'Predefinito' (Erogazione): " + String.valueOf(azioniNonTrovate2));
                }
            }
            if (azioniInFruizione && sbError.length() > 0) {
                sbError.append("<br/>");
            }
            if (!fruizione_mapGruppi.isEmpty()) {
                for (String labelFruitore : fruizione_mapGruppi.keySet()) {
                    HashMap hashMap = (HashMap)fruizione_mapGruppi.get(labelFruitore);
                    for (String gruppo : hashMap.keySet()) {
                        List azioni = (List)hashMap.get(gruppo);
                        ArrayList<String> azioniNonTrovate3 = new ArrayList<String>();
                        if (azioni != null && !azioni.isEmpty()) {
                            for (String az3 : azioni) {
                                if (this.existsOperazione(asSintetico, serviceBinding, portType, az3)) continue;
                                azioniNonTrovate3.add(az3);
                            }
                        }
                        if (azioniNonTrovate3.isEmpty()) continue;
                        if (sbError.length() > 0) {
                            sbError.append("<br/>");
                        }
                        sbError.append("Gruppo '" + gruppo + "' (Fruizione '" + labelFruitore + "'): " + String.valueOf(azioniNonTrovate3));
                    }
                }
            }
            if (fruizione_listTrasformazioniPredefinito != null && !fruizione_listTrasformazioniPredefinito.isEmpty()) {
                for (String labelFruitore : fruizione_listTrasformazioniPredefinito.keySet()) {
                    List list = (List)fruizione_listTrasformazioniPredefinito.get(labelFruitore);
                    azioniNonTrovate = new ArrayList<String>();
                    for (String az : list) {
                        if (this.existsOperazione(asSintetico, serviceBinding, portType, az)) continue;
                        azioniNonTrovate.add(az);
                    }
                    if (azioniNonTrovate.isEmpty()) continue;
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Criteri di Applicabilit\u00e0 nelle Trasformazioni del gruppo 'Predefinito' (Fruizione '" + labelFruitore + "'): " + String.valueOf(azioniNonTrovate));
                }
            }
            if (fruizione_listRateLimitingPredefinito != null && !fruizione_listRateLimitingPredefinito.isEmpty()) {
                for (String labelFruitore : fruizione_listRateLimitingPredefinito.keySet()) {
                    List list = (List)fruizione_listRateLimitingPredefinito.get(labelFruitore);
                    azioniNonTrovate = new ArrayList();
                    for (String az : list) {
                        if (this.existsOperazione(asSintetico, serviceBinding, portType, az)) continue;
                        azioniNonTrovate.add(az);
                    }
                    if (azioniNonTrovate.isEmpty()) continue;
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Policy di RateLimiting del gruppo 'Predefinito' (Fruizione '" + labelFruitore + "'): " + String.valueOf(azioniNonTrovate));
                }
            }
            if (fruizione_listAllarmePredefinito != null && !fruizione_listAllarmePredefinito.isEmpty()) {
                for (String labelFruitore : fruizione_listAllarmePredefinito.keySet()) {
                    List list = (List)fruizione_listAllarmePredefinito.get(labelFruitore);
                    azioniNonTrovate = new ArrayList();
                    for (String az : list) {
                        if (this.existsOperazione(asSintetico, serviceBinding, portType, az)) continue;
                        azioniNonTrovate.add(az);
                    }
                    if (azioniNonTrovate.isEmpty()) continue;
                    if (sbError.length() > 0) {
                        sbError.append("<br/>");
                    }
                    sbError.append("Allarme del gruppo 'Predefinito' (Fruizione '" + labelFruitore + "'): " + String.valueOf(azioniNonTrovate));
                }
            }
        }
        if (sbError.length() > 0) {
            String prefix = "";
            if (azioniInErogazione && azioniInFruizione || gestioneFruitori && azioniInErogazione || gestioneErogatori && azioniInFruizione) {
                prefix = "La modifica richiesta impatta su altre configurazioni, oltre a quella selezionata.<BR/><BR/>";
            }
            this.pd.setMessage(prefix + MessageFormat.format("La nuova versione dell''API indicata non \u00e8 utilizzabile poich\u00e8 l''attuale configurazione riferisce operazioni non presenti nella nuova versione. Le operazioni non individuate nella nuova versione dell''API sono riferite: <BR/><BR/>{0}", sbError.toString()));
            return false;
        }
        return true;
    }

    private boolean checkCambioErogatore(AccordoServizioParteSpecifica servizio, boolean gestioneFruitori, boolean gestioneErogatori, String idSoggErogatore, String protocollo) throws Exception {
        ArrayList<String> nomiApplicativiServer = new ArrayList<String>();
        IDServizio idService = this.idServizioFactory.getIDServizioFromAccordo(servizio);
        List<MappingErogazionePortaApplicativa> listaMappingErogazione = null;
        try {
            listaMappingErogazione = this.apsCore.mappingServiziPorteAppList(idService, servizio.getId(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (listaMappingErogazione != null && !listaMappingErogazione.isEmpty()) {
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaMappingErogazione) {
                PortaApplicativa pa = null;
                try {
                    pa = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pa == null || pa.sizeServizioApplicativoList() <= 0) continue;
                for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                    ServizioApplicativo sa = null;
                    try {
                        sa = this.saCore.getServizioApplicativo(pasa.getIdServizioApplicativo());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sa == null || !"server".equals(sa.getTipo()) || nomiApplicativiServer.contains(sa.getNome())) continue;
                    nomiApplicativiServer.add(sa.getNome());
                }
            }
        }
        if (!nomiApplicativiServer.isEmpty()) {
            StringBuilder elenco = new StringBuilder();
            for (String server : nomiApplicativiServer) {
                if (elenco.length() > 0) {
                    elenco.append(", ");
                }
                elenco.append(server);
            }
            if (gestioneFruitori) {
                this.pd.setMessage(MessageFormat.format("Non \u00e8 possibile cambiare l''erogatore poich\u00e8 la modifica impatta su altre configurazioni, oltre a quella selezionata.<BR/><BR/>Nell''erogazione {0} non \u00e8 possibile cambiare l''erogatore poich\u00e8 sono stati associati i seguenti applicativi di tipo server: {1}", this.getLabelIdServizioSenzaErogatore(idService), elenco.toString()));
            } else {
                this.pd.setMessage(MessageFormat.format("Non \u00e8 possibile cambiare l''erogatore poich\u00e8 nell''erogazione sono stati associati i seguenti applicativi di tipo server: {0}", elenco.toString()));
            }
            return false;
        }
        if (idSoggErogatore != null && !"".equals(idSoggErogatore)) {
            long idSoggettoErogatoreLong = Long.parseLong(idSoggErogatore);
            Soggetto soggettoErogatoreSelezionato = this.soggettiCore.getSoggettoRegistro(idSoggettoErogatoreLong);
            if (listaMappingErogazione != null && !listaMappingErogazione.isEmpty()) {
                ConsoleSearch searchSoggetti = new ConsoleSearch(true);
                searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", protocollo);
                searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
                List<Soggetto> list = this.soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti);
                boolean find = false;
                if (list != null && !list.isEmpty()) {
                    for (Soggetto soggetto : list) {
                        if (!soggettoErogatoreSelezionato.getTipo().equals(soggetto.getTipo()) || !soggettoErogatoreSelezionato.getNome().equals(soggetto.getNome())) continue;
                        find = true;
                    }
                }
                if (!find) {
                    this.pd.setMessage(MessageFormat.format("Non \u00e8 possibile cambiare l''erogatore poich\u00e8 la modifica impatta su altre configurazioni, oltre a quella selezionata.<BR/><BR/>Nell''erogazione {0} non \u00e8 possibile assegnare il soggetto selezionato come erogatore dell'API.", this.getLabelIdServizioSenzaErogatore(idService)));
                    return false;
                }
            }
            if (servizio.sizeFruitoreList() > 0) {
                for (Fruitore fruitore : servizio.getFruitoreList()) {
                    IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    List<MappingFruizionePortaDelegata> listaMappingFruizione = null;
                    try {
                        listaMappingFruizione = this.apsCore.serviziFruitoriMappingList(idFruitore, idService, null);
                    }
                    catch (Exception soggetto) {
                        // empty catch block
                    }
                    if (listaMappingFruizione == null || listaMappingFruizione.isEmpty()) continue;
                    ConsoleSearch searchSoggetti = new ConsoleSearch(true);
                    searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", protocollo);
                    boolean gestioneFruitori_soggettiErogatori_escludiSoggettoFruitore = false;
                    boolean filtraSoloEsterni = true;
                    if (this.apsCore.isMultitenant() && this.apsCore.getMultitenantSoggettiFruizioni() != null) {
                        switch (this.apsCore.getMultitenantSoggettiFruizioni()) {
                            case SOLO_SOGGETTI_ESTERNI: {
                                filtraSoloEsterni = true;
                                break;
                            }
                            case ESCLUDI_SOGGETTO_FRUITORE: {
                                filtraSoloEsterni = false;
                                gestioneFruitori_soggettiErogatori_escludiSoggettoFruitore = true;
                                break;
                            }
                            case TUTTI: {
                                filtraSoloEsterni = false;
                            }
                        }
                    }
                    if (filtraSoloEsterni) {
                        searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
                    }
                    List<Soggetto> list = this.soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti);
                    if (gestioneFruitori_soggettiErogatori_escludiSoggettoFruitore && list != null && !list.isEmpty()) {
                        for (int i = 0; i < list.size(); ++i) {
                            Soggetto soggettoCheck = list.get(i);
                            if (!soggettoCheck.getTipo().equals(fruitore.getTipo()) || !soggettoCheck.getNome().equals(fruitore.getNome())) continue;
                            list.remove(i);
                            break;
                        }
                    }
                    boolean find = false;
                    if (list != null && !list.isEmpty()) {
                        for (Soggetto soggetto : list) {
                            if (!soggettoErogatoreSelezionato.getTipo().equals(soggetto.getTipo()) || !soggettoErogatoreSelezionato.getNome().equals(soggetto.getNome())) continue;
                            find = true;
                        }
                    }
                    if (find) continue;
                    String labelFruizione = null;
                    String labelFruitore = this.getLabelNomeSoggetto(protocollo, idFruitore);
                    labelFruizione = labelFruitore + " -> " + this.getLabelIdServizioSenzaErogatore(idService);
                    this.pd.setMessage(MessageFormat.format("Non \u00e8 possibile cambiare l''erogatore poich\u00e8 la modifica impatta su altre configurazioni, oltre a quella selezionata.<BR/><BR/>Nella fruizione {0} non \u00e8 possibile assegnare il soggetto selezionato come erogatore dell'API fruita.", labelFruizione));
                    return false;
                }
            }
        }
        return true;
    }

    private String getServiziCheckDataIdSoggettoErogatoreAsString(long idServizio) {
        try {
            AccordoServizioParteSpecifica servizio = this.apsCore.getAccordoServizioParteSpecifica(idServizio);
            return servizio.getIdSoggetto().toString();
        }
        catch (DriverRegistroServiziException | DriverRegistroServiziNotFound throwable) {
            return null;
        }
    }

    public boolean serviziCheckData(TipoOperazione tipoOp, String[] soggettiList, String[] accordiList, String oldNomeservizio, String oldTiposervizio, int oldVersioneServizio, String nomeservizio, String tiposervizio, String idSoggErogatore, String nomeErogatore, String tipoErogatore, String idAccordo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String servcorr, String endpointtype, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, BinaryParameter wsdlimpler, BinaryParameter wsdlimplfru, String id, String profilo, String portType, String[] ptList, boolean visibilitaAccordoServizio, boolean visibilitaServizio, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String versione, boolean validazioneDocumenti, String backToStato, String autenticazioneHttp, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String httpImpl, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, String erogazioneSoggetto, String erogazioneRuolo, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, String erogazioneAutorizzazione, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, boolean isSupportatoAutenticazione, boolean generaPACheckSoggetto, List<ExtendedConnettore> listExtendedConnettore, String fruizioneServizioApplicativo, String fruizioneRuolo, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, String protocollo, BinaryParameter allegatoXacmlPolicy, String descrizione, String tipoFruitore, String nomeFruitore, boolean autenticazioneToken, String tokenPolicy, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, boolean erogazioneServizioApplicativoServerEnabled, String erogazioneServizioApplicativoServer, String canaleStato, String canale, boolean gestioneCanaliEnabled) throws Exception {
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        try {
            StringBuilder inUsoMessage;
            boolean alreadyExists;
            long idSoggettoErogatore;
            Soggetto tmpSogg;
            if (erogazioneSoggetto != null || erogazioneRuolo != null || fruizioneServizioApplicativo != null || fruizioneRuolo != null || descrizione != null) {
                // empty if block
            }
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            boolean gestioneErogatori = false;
            if (tipologia != null) {
                if ("fruizione".equals(tipologia)) {
                    gestioneFruitori = true;
                } else if ("erogazione".equals(tipologia)) {
                    gestioneErogatori = true;
                }
            }
            if (backToStato != null && tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                return true;
            }
            int idInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            if (idSoggErogatore == null) {
                idSoggErogatore = "";
            }
            if (idAccordo == null) {
                idAccordo = "";
            }
            if (url == null) {
                url = "";
            }
            if (nome == null) {
                nome = "";
            }
            if (tipo == null) {
                tipo = "";
            }
            if (user == null) {
                user = "";
            }
            if (password == null) {
                password = "";
            }
            if (initcont == null) {
                initcont = "";
            }
            if (urlpgk == null) {
                urlpgk = "";
            }
            if (provurl == null) {
                provurl = "";
            }
            if (connfact == null) {
                connfact = "";
            }
            if (sendas == null) {
                sendas = "";
            }
            if (versione == null) {
                versione = "";
            }
            boolean nonVisibile = true;
            boolean visibile = false;
            if (visibilitaServizio == visibile && visibilitaAccordoServizio == nonVisibile) {
                this.pd.setMessage("Non &egrave; possibile utilizzare un accordo di servizio con visibilit&agrave; privata, in un servizio con visibilit&agrave; pubblica.");
                return false;
            }
            Integer versioneInt = 1;
            if (versione != null && !"".equals(versione)) {
                versioneInt = Integer.parseInt(versione);
            } else {
                versione = "1";
                versioneInt = 1;
            }
            String oldTipoSoggettoErogatore = null;
            String oldNomeSoggettoErogatore = null;
            boolean cambiaErogatore = false;
            boolean modificaVersioneApi = false;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                String tmpCambiaSoggettoErogatore;
                String tmpModificaVersioneApi = this.getParameter("modificaAPI");
                if (tmpModificaVersioneApi != null) {
                    modificaVersioneApi = "true".equals(tmpModificaVersioneApi);
                }
                if ((tmpCambiaSoggettoErogatore = this.getParameter("cambiaErogatore")) != null) {
                    cambiaErogatore = "true".equals(tmpCambiaSoggettoErogatore);
                }
                if (modificaVersioneApi) {
                    long idAccordoLong;
                    servizio = this.apsCore.getAccordoServizioParteSpecifica(idInt);
                    boolean isOk = this.checkModificaVersioneApi(servizio, idAccordoLong = Long.parseLong(idAccordo), serviceBinding, portType, gestioneFruitori, gestioneErogatori);
                    if (!isOk) {
                        return false;
                    }
                    idSoggErogatore = servizio.getIdSoggetto().toString();
                } else if (cambiaErogatore) {
                    servizio = this.apsCore.getAccordoServizioParteSpecifica(idInt);
                    oldTipoSoggettoErogatore = servizio.getTipoSoggettoErogatore();
                    oldNomeSoggettoErogatore = servizio.getNomeSoggettoErogatore();
                    boolean isOk = this.checkCambioErogatore(servizio, gestioneFruitori, gestioneErogatori, idSoggErogatore, protocollo);
                    if (!isOk) {
                        return false;
                    }
                } else {
                    IDServizio idService = this.idServizioFactory.getIDServizioFromValues(tiposervizio, nomeservizio, tipoErogatore, nomeErogatore, versioneInt.intValue());
                    idSoggErogatore = this.getServiziCheckDataIdSoggettoErogatoreAsString(idInt);
                }
            }
            if (idAccordo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario selezionare un'API");
                return false;
            }
            if (nomeservizio.equals("") || tiposervizio.equals("") || idSoggErogatore.equals("") || idAccordo.equals("") || versione.equals("")) {
                Object tmpElenco = "";
                if (nomeservizio.equals("")) {
                    tmpElenco = "Nome Servizio";
                }
                if (tiposervizio.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Tipo Servizio" : (String)tmpElenco + ", Tipo Servizio";
                }
                if (idSoggErogatore.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Soggetto" : (String)tmpElenco + ", Soggetto";
                }
                if (idAccordo.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "API" : (String)tmpElenco + ", API";
                }
                if (versione.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Versione Accordo Servizio Parte Specifica" : (String)tmpElenco + ", Versione Accordo Servizio Parte Specifica";
                }
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", tmpElenco));
                return false;
            }
            if (!isModalitaAvanzata || this.apsCore.isPortTypeObbligatorioImplementazioniSOAP()) {
                switch (serviceBinding) {
                    case REST: {
                        break;
                    }
                    default: {
                        if (portType != null && !"".equals(portType) && !"-".equals(portType)) break;
                        if (ptList == null || ptList.length == 0) {
                            this.pd.setMessage("&Egrave; necessario indicare un Servizio, definire almeno un Port-Type per completare l'operazione.");
                            return false;
                        }
                        this.pd.setMessage("&Egrave; necessario indicare un Servizio.");
                        return false;
                    }
                }
            }
            if (nomeservizio.indexOf(" ") != -1 || tiposervizio.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkNCName(nomeservizio, "Nome Servizio")) {
                return false;
            }
            if (!this.checkNCName(tiposervizio, "Tipo Servizio")) {
                return false;
            }
            if (!versione.equals("") && !this.checkNumber(versione, "Versione", false)) {
                return false;
            }
            if (!this.checkLength255(nomeservizio, "Nome Servizio")) {
                return false;
            }
            if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !this.canaleCheckData(canaleStato, canale, gestioneCanaliEnabled)) {
                return false;
            }
            boolean connettoreStatic = false;
            if (gestioneFruitori) {
                connettoreStatic = this.apsCore.isConnettoreStatic(protocollo);
            }
            if (!connettoreStatic && !this.endPointCheckData(serviceBinding, protocollo, gestioneErogatori, endpointtype, url, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, autenticazioneHttp, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, listExtendedConnettore, erogazioneServizioApplicativoServerEnabled, erogazioneServizioApplicativoServer)) {
                return false;
            }
            if (servcorr != null && !servcorr.equals("yes") && !servcorr.equals("no")) {
                this.pd.setMessage("Servizio correlato dev'essere selezionato o deselezionato");
                return false;
            }
            boolean trovatoProv = false;
            for (int i = 0; i < soggettiList.length; ++i) {
                String tmpSogg2 = soggettiList[i];
                if (!tmpSogg2.equals(idSoggErogatore)) continue;
                trovatoProv = true;
            }
            if (!trovatoProv) {
                this.pd.setMessage("Il soggetto indicato non \u00e8 autorizzato ad erogare una API");
                return false;
            }
            boolean trovatoAcc = false;
            for (int i = 0; i < accordiList.length; ++i) {
                String tmpAcc = accordiList[i];
                if (!tmpAcc.equals(idAccordo)) continue;
                trovatoAcc = true;
            }
            if (!trovatoAcc) {
                this.pd.setMessage("L'accordo servizio dev'essere scelto tra quelli definiti nel pannello Accordi servizio");
                return false;
            }
            if (visibilitaServizio == visibile && (tmpSogg = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(tipoErogatore, nomeErogatore))).getPrivato() != null && tmpSogg.getPrivato().booleanValue()) {
                this.pd.setMessage("Non &egrave; possibile utilizzare un soggetto erogatore con visibilit&agrave; privata, in un servizio con visibilit&agrave; pubblica.");
                return false;
            }
            if (!gestioneFruitori && !gestioneErogatori && !connettoreStatic && endpointtype.equals(TipiConnettore.DISABILITATO.getNome())) {
                String eptypeprov = TipiConnettore.DISABILITATO.getNome();
                Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(tipoErogatore, nomeErogatore));
                if (this.pddCore.isPddEsterna(soggetto.getPortaDominio())) {
                    Connettore connettore = soggetto.getConnettore();
                    if (connettore != null && connettore.getTipo() != null) {
                        eptypeprov = connettore.getTipo();
                    }
                    if (eptypeprov.equals(TipiConnettore.DISABILITATO.getNome())) {
                        if (!this.isModalitaCompleta() && tipoOp.equals((Object)TipoOperazione.ADD)) {
                            this.pd.setMessage("Deve essere definito un connettore per l'erogazione");
                        } else {
                            this.pd.setMessage("Il connettore del servizio deve essere specificato se non &egrave; stato definito un connettore per il soggetto erogatore");
                        }
                        return false;
                    }
                } else if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                    boolean escludiSoggettiEsterni = true;
                    boolean trovatoServ = this.apsCore.existFruizioniServizioWithoutConnettore(idInt, escludiSoggettiEsterni);
                    if (trovatoServ) {
                        this.pd.setMessage("Il connettore sul servizio non pu\u00f2 essere disabilitato poich\u00e8 non \u00e8 stato definito un connettore sul soggetto erogatore ed esistono fruizioni del servizio, da parte di soggetti operativi, che non hanno un connettore definito");
                        return false;
                    }
                } else if (!this.isModalitaCompleta() && generaPACheckSoggetto) {
                    this.pd.setMessage("Deve essere definito un connettore per l'erogazione");
                    return false;
                }
            }
            if ((idSoggettoErogatore = Long.parseLong(idSoggErogatore)) < 0L) {
                throw new ControlStationCoreException("id Soggetto erogatore non definito");
            }
            long idAccordoServizio = Long.parseLong(idAccordo);
            if (idAccordoServizio < 0L) {
                throw new ControlStationCoreException("id Accordo Servizio non definito");
            }
            long idSoggettoErogatoreLong = Long.parseLong(idSoggErogatore);
            Soggetto soggettoErogatore = this.soggettiCore.getSoggettoRegistro(idSoggettoErogatoreLong);
            tipoErogatore = soggettoErogatore.getTipo();
            nomeErogatore = soggettoErogatore.getNome();
            long idAccordoServizioParteComuneLong = Long.parseLong(idAccordo);
            AccordoServizioParteComuneSintetico accordoServizioParteComune = this.apcCore.getAccordoServizioSintetico(idAccordoServizioParteComuneLong);
            String uriAccordoServizioParteComune = this.idAccordoFactory.getUriFromAccordo(accordoServizioParteComune);
            IDServizio idAccordoServizioParteSpecifica = this.idServizioFactory.getIDServizioFromValues(tiposervizio, nomeservizio, tipoErogatore, nomeErogatore, versioneInt.intValue());
            if (!(tipoOp.equals((Object)TipoOperazione.CHANGE) && (!tipoOp.equals((Object)TipoOperazione.CHANGE) || oldTiposervizio.equals(tiposervizio) && oldNomeservizio.equals(nomeservizio) && oldVersioneServizio == versioneInt && (!cambiaErogatore || oldTipoSoggettoErogatore.equals(tipoErogatore) && oldNomeSoggettoErogatore.equals(nomeErogatore))) || !(alreadyExists = AccordiServizioParteSpecificaUtilities.alreadyExists(this.apsCore, this, idSoggettoErogatore, idAccordoServizioParteSpecifica, uriAccordoServizioParteComune, tipoFruitore, nomeFruitore, protocollo, profilo, portType, gestioneFruitori, gestioneErogatori, inUsoMessage = new StringBuilder())))) {
                this.pd.setMessage(inUsoMessage.toString());
                return false;
            }
            long idAccordoServizioParteSpecificaLong = idInt;
            boolean servizioCorrelato = false;
            if (servcorr != null && (servcorr.equals("yes") || servcorr.equals(CostantiConfigurazione.ABILITATO.getValue()))) {
                servizioCorrelato = true;
            }
            try {
                this.apsCore.controlloUnicitaImplementazioneAccordoPerSoggetto(portType, new IDSoggetto(soggettoErogatore.getTipo(), soggettoErogatore.getNome()), idSoggettoErogatoreLong, this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizioParteComune), idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, idAccordoServizioParteSpecificaLong, tipoOp, servizioCorrelato);
            }
            catch (Exception e) {
                this.pd.setMessage(e.getMessage());
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (!gestioneFruitori && !gestioneErogatori && this.apsCore.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                    this.pd.setMessage("Esiste gi&agrave; un accordo di servizio parte specifica con tipo, nome, versione e soggetto indicato.");
                    return false;
                }
            } else {
                try {
                    AccordoServizioParteSpecifica servizio = this.apsCore.getServizio(idAccordoServizioParteSpecifica);
                    if (servizio != null && (long)idInt != servizio.getId()) {
                        if (!gestioneFruitori && !gestioneErogatori) {
                            this.pd.setMessage("Esiste gi&agrave; un accordo di servizio parte specifica con tipo, nome, versione e soggetto indicato.");
                            return false;
                        }
                        if (!AccordiServizioParteSpecificaCostanti.isModificaDatiIdentificativiVersoApsEsistente()) {
                            if (gestioneFruitori) {
                                this.pd.setMessage(MessageFormat.format("I dati identificativi forniti indirizzano una API {0} per la quale esiste gi\u00e0 una erogazione; attualmente non \u00e8 supportato questo tipo di aggiornamento.", this.getLabelIdServizio(servizio)));
                            } else {
                                this.pd.setMessage(MessageFormat.format("I dati identificativi forniti indirizzano una API {0} per la quale esiste gi\u00e0 una fruizione; attualmente non \u00e8 supportato questo tipo di aggiornamento.", this.getLabelIdServizio(servizio)));
                            }
                            return false;
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound servizio) {
                    // empty catch block
                }
            }
            AccordoServizioParteComune as = null;
            try {
                as = this.apcCore.getAccordoServizioFull(Long.parseLong(idAccordo));
            }
            catch (Exception e) {
                this.pd.setMessage(MessageFormat.format("API selezionata ({0}) non esistente: {1}", idAccordo, e.getMessage()));
                return false;
            }
            AccordoServizioParteSpecifica aps = new AccordoServizioParteSpecifica();
            aps.setTipo(tiposervizio);
            aps.setNome(nomeservizio);
            if (versione != null) {
                aps.setVersione(Integer.valueOf(Integer.parseInt(versione)));
            }
            if ("yes".equals(servcorr)) {
                aps.setTipologiaServizio(TipologiaServizio.CORRELATO);
            } else {
                aps.setTipologiaServizio(TipologiaServizio.NORMALE);
            }
            aps.setTipoSoggettoErogatore(tipoErogatore);
            aps.setNomeSoggettoErogatore(nomeErogatore);
            ValidazioneResult v = this.apsCore.validazione(aps, this.soggettiCore);
            if (!v.isEsito()) {
                String msg = MessageFormat.format("[validazione-{0}] {1}", protocollo, v.getMessaggioErrore());
                this.pd.setMessage(msg);
                if (v.getException() != null) {
                    this.logError(msg, v.getException());
                } else {
                    this.logError(msg);
                }
                return false;
            }
            if (validazioneDocumenti && tipoOp.equals((Object)TipoOperazione.ADD)) {
                FormatoSpecifica formato = null;
                if (as != null) {
                    formato = as.getFormatoSpecifica();
                }
                String wsdlimplerS = wsdlimpler.getValue() != null ? new String(wsdlimpler.getValue()) : null;
                byte[] wsdlImplementativoErogatore = this.apsCore.getInterfaceAsByteArray(formato, wsdlimplerS);
                String wsdlimplfruS = wsdlimplfru.getValue() != null ? new String(wsdlimplfru.getValue()) : null;
                byte[] wsdlImplementativoFruitore = this.apsCore.getInterfaceAsByteArray(formato, wsdlimplfruS);
                aps.setByteWsdlImplementativoErogatore(wsdlImplementativoErogatore);
                aps.setByteWsdlImplementativoFruitore(wsdlImplementativoFruitore);
                ValidazioneResult result = this.apsCore.validaInterfacciaWsdlParteSpecifica(aps, as, this.soggettiCore);
                if (!result.isEsito()) {
                    this.pd.setMessage(result.getMessaggioErrore());
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                String gestioneToken = this.getParameter("gestioneToken");
                String gestioneTokenPolicy = this.getParameter("gtPolicy");
                String gestioneTokenValidazioneInput = this.getParameter("gtValidazione");
                String gestioneTokenIntrospection = this.getParameter("gtIntrospection");
                String gestioneTokenUserInfo = this.getParameter("gtUserInfo");
                String gestioneTokenTokenForward = this.getParameter("gtTokenForward");
                String autorizzazioneAutenticatiToken = this.getParameter("autorizzazioneAutenticazioneToken");
                String autorizzazioneRuoliToken = this.getParameter("autorizzazioneRuoliToken");
                String autorizzazioneToken = this.getParameter("autorizzazioneToken");
                String autorizzazioneTokenOptions = this.getParameter("autorizzazioneTokenOptions");
                String autorizzazioneScope = this.getParameter("autorizzazioneScope");
                String autorizzazioneScopeMatch = this.getParameter("scopeMatch");
                String autorizzazioneContenutiStato = this.getParameter("authContenutiStato");
                String autorizzazioneContenuti = this.getParameter("autorizzazioneContenuti");
                String autorizzazioneContenutiProperties = this.getParameter("authContenutiProp");
                String identificazioneAttributiStato = this.getParameter("attrStato");
                String[] attributeAuthoritySelezionate = this.getParameterValues("attrAuthority");
                String attributeAuthorityAttributi = this.getParameter("AAttr");
                if (gestioneFruitori ? !this.controlloAccessiCheck(tipoOp, fruizioneAutenticazione, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, fruizioneAutorizzazione, fruizioneAutorizzazioneAutenticati, fruizioneAutorizzazioneRuoli, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, true, true, null, null, gestioneToken, gestioneTokenPolicy, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenTokenForward, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneToken, autorizzazioneTokenOptions, autorizzazioneScope, autorizzazioneScopeMatch, allegatoXacmlPolicy, autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, protocollo, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi) : !this.controlloAccessiCheck(tipoOp, erogazioneAutenticazione, erogazioneAutenticazioneOpzionale, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, erogazioneAutorizzazione, erogazioneAutorizzazioneAutenticati, erogazioneAutorizzazioneRuoli, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, isSupportatoAutenticazione, false, null, null, gestioneToken, gestioneTokenPolicy, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenTokenForward, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneToken, autorizzazioneTokenOptions, autorizzazioneScope, autorizzazioneScopeMatch, allegatoXacmlPolicy, autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, protocollo, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi)) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean serviziFruitoriCheckData(TipoOperazione tipoOp, String[] soggettiList, String id, String nomeservizio, String tiposervizio, Integer versioneservizio, String nomeprov, String tipoprov, String idSoggettoFruitore, String endpointtype, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, BinaryParameter wsdlimpler, BinaryParameter wsdlimplfru, String myId, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, boolean validazioneDocumenti, String backToStato, String autenticazioneHttp, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String httpImpl, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, String fruizioneServizioApplicativo, String fruizioneRuolo, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, BinaryParameter allegatoXacmlPolicy, boolean autenticazioneToken, String tokenPolicy, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, List<ExtendedConnettore> listExtendedConnettore) throws Exception {
        try {
            if (backToStato != null && tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                return true;
            }
            int myIdInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                myIdInt = Integer.parseInt(myId);
            }
            if (idSoggettoFruitore == null) {
                idSoggettoFruitore = "";
            }
            if (url == null) {
                url = "";
            }
            if (nome == null) {
                nome = "";
            }
            if (tipo == null) {
                tipo = "";
            }
            if (user == null) {
                user = "";
            }
            if (password == null) {
                password = "";
            }
            if (initcont == null) {
                initcont = "";
            }
            if (urlpgk == null) {
                urlpgk = "";
            }
            if (provurl == null) {
                provurl = "";
            }
            if (connfact == null) {
                connfact = "";
            }
            if (sendas == null) {
                sendas = "";
            }
            if (idSoggettoFruitore.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Soggetto");
                return false;
            }
            int idInt = 0;
            if (!nomeservizio.equals("")) {
                IDSoggetto ids = new IDSoggetto(tipoprov, nomeprov);
                IDServizio idserv = this.idServizioFactory.getIDServizioFromValues(tiposervizio, nomeservizio, ids, versioneservizio.intValue());
                AccordoServizioParteSpecifica myServ = this.apsCore.getServizio(idserv);
                idInt = myServ.getId().intValue();
            } else {
                idInt = Integer.parseInt(id);
            }
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(idInt);
            String protocollo = ProtocolFactoryManager.getInstance().getProtocolByServiceType(asps.getTipo());
            String tmpModificaProfilo = this.getParameter("modificaProfilo");
            boolean modificaProfilo = false;
            if (tmpModificaProfilo != null) {
                modificaProfilo = "true".equals(tmpModificaProfilo);
            }
            if (!modificaProfilo && (this.isModalitaAvanzata() || TipoOperazione.CHANGE.equals((Object)tipoOp))) {
                String servizioApplicativoServer;
                boolean servizioApplicativoServerEnabled;
                if (endpointtype.equals(TipiConnettore.DISABILITATO.getNome())) {
                    String eptypeprov = TipiConnettore.DISABILITATO.getNome();
                    Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(Long.parseLong(idSoggettoFruitore));
                    if (!this.pddCore.isPddEsterna(soggetto.getPortaDominio())) {
                        Connettore connettore = asps.getConfigurazioneServizio().getConnettore();
                        if (connettore != null && connettore.getTipo() != null) {
                            eptypeprov = connettore.getTipo();
                        }
                        if (eptypeprov.equals(TipiConnettore.DISABILITATO.getNome())) {
                            boolean connettoreStatic;
                            Soggetto soggettoErogatore = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()));
                            connettore = soggettoErogatore.getConnettore();
                            if (connettore != null && connettore.getTipo() != null) {
                                eptypeprov = connettore.getTipo();
                            }
                            if (!(connettoreStatic = this.apsCore.isConnettoreStatic(protocollo)) && eptypeprov.equals(TipiConnettore.DISABILITATO.getNome())) {
                                if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                                    this.pd.setMessage("Per poter disabilitare il connettore deve prima essere definito un connettore sul servizio o sul soggetto erogatore");
                                } else if (this.isModalitaAvanzata()) {
                                    this.pd.setMessage("Per poter aggiungere il fruitore deve essere definito il connettore.<br/>In alternativa \u00e8 possibile configurare un connettore sul servizio o sul soggetto erogatore prima di procedere con la creazione del fruitore.");
                                } else {
                                    this.pd.setMessage("Per poter aggiungere il fruitore deve prima essere definito un connettore sul servizio o sul soggetto erogatore.");
                                }
                                return false;
                            }
                        }
                    }
                }
                if (!this.endPointCheckData(null, protocollo, false, endpointtype, url, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, autenticazioneHttp, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, listExtendedConnettore, servizioApplicativoServerEnabled = false, servizioApplicativoServer = null)) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                Fruitore myFru = this.apsCore.getServizioFruitore(myIdInt);
                String nomeSogg = myFru.getNome();
                String tipoSogg = myFru.getTipo();
                IDSoggetto idfru = new IDSoggetto(tipoSogg, nomeSogg);
                Soggetto mySogg = this.soggettiCore.getSoggettoRegistro(idfru);
                int idProv = mySogg.getId().intValue();
                IDServizio idserv = this.idServizioFactory.getIDServizioFromAccordo(asps);
                long idFru = this.apsCore.getServizioFruitore(idserv, idProv);
                if (idFru != 0L && (tipoOp.equals((Object)TipoOperazione.ADD) || tipoOp.equals((Object)TipoOperazione.CHANGE) && (long)myIdInt != idFru)) {
                    this.pd.setMessage("Esiste gi&agrave; un fruitore del Servizio con lo stesso Soggetto");
                    return false;
                }
            } else {
                String attributeAuthorityAttributi;
                String[] attributeAuthoritySelezionate;
                String identificazioneAttributiStato;
                String autorizzazioneContenutiProperties;
                String autorizzazioneContenuti;
                String autorizzazioneContenutiStato;
                String autorizzazioneScopeMatch;
                String autorizzazioneScope;
                String autorizzazione_tokenOptions;
                String autorizzazione_token;
                String autorizzazioneRuoliToken;
                String autorizzazioneAutenticatiToken;
                String gestioneTokenTokenForward;
                String gestioneTokenUserInfo;
                String gestioneTokenIntrospection;
                String gestioneTokenValidazioneInput;
                String gestioneTokenPolicy;
                String gestioneToken;
                AccordoServizioParteComune as = null;
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                try {
                    as = this.apcCore.getAccordoServizioFull(idAccordo);
                }
                catch (Exception e) {
                    this.pd.setMessage(MessageFormat.format("API selezionata ({0}) non esistente: {1}", idAccordo, e.getMessage()));
                    return false;
                }
                if (validazioneDocumenti && tipoOp.equals((Object)TipoOperazione.ADD) && this.isModalitaAvanzata()) {
                    FormatoSpecifica formato = null;
                    if (as != null) {
                        formato = as.getFormatoSpecifica();
                    }
                    String wsdlimplerS = wsdlimpler.getValue() != null ? new String(wsdlimpler.getValue()) : null;
                    byte[] wsdlImplementativoErogatore = this.apsCore.getInterfaceAsByteArray(formato, wsdlimplerS);
                    String wsdlimplfruS = wsdlimplfru.getValue() != null ? new String(wsdlimplfru.getValue()) : null;
                    byte[] wsdlImplementativoFruitore = this.apsCore.getInterfaceAsByteArray(formato, wsdlimplfruS);
                    Fruitore f = new Fruitore();
                    f.setByteWsdlImplementativoErogatore(wsdlImplementativoErogatore);
                    f.setByteWsdlImplementativoFruitore(wsdlImplementativoFruitore);
                    ValidazioneResult result = this.apsCore.validaInterfacciaWsdlParteSpecifica(f, asps, as, this.soggettiCore);
                    if (!result.isEsito()) {
                        this.pd.setMessage(result.getMessaggioErrore());
                        return false;
                    }
                }
                if (!this.controlloAccessiCheck(tipoOp, fruizioneAutenticazione, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, fruizioneAutorizzazione, fruizioneAutorizzazioneAutenticati, fruizioneAutorizzazioneRuoli, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, true, true, null, null, gestioneToken = this.getParameter("gestioneToken"), gestioneTokenPolicy = this.getParameter("gtPolicy"), gestioneTokenValidazioneInput = this.getParameter("gtValidazione"), gestioneTokenIntrospection = this.getParameter("gtIntrospection"), gestioneTokenUserInfo = this.getParameter("gtUserInfo"), gestioneTokenTokenForward = this.getParameter("gtTokenForward"), autorizzazioneAutenticatiToken = this.getParameter("autorizzazioneAutenticazioneToken"), autorizzazioneRuoliToken = this.getParameter("autorizzazioneRuoliToken"), autorizzazione_token = this.getParameter("autorizzazioneToken"), autorizzazione_tokenOptions = this.getParameter("autorizzazioneTokenOptions"), autorizzazioneScope = this.getParameter("autorizzazioneScope"), autorizzazioneScopeMatch = this.getParameter("scopeMatch"), allegatoXacmlPolicy, autorizzazioneContenutiStato = this.getParameter("authContenutiStato"), autorizzazioneContenuti = this.getParameter("autorizzazioneContenuti"), autorizzazioneContenutiProperties = this.getParameter("authContenutiProp"), protocollo, identificazioneAttributiStato = this.getParameter("attrStato"), attributeAuthoritySelezionate = this.getParameterValues("attrAuthority"), attributeAuthorityAttributi = this.getParameter("AAttr"))) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public static boolean isDocumentoUnivocoIndipendentementeTipo() {
        return documentoUnivocoIndipendentementeTipo;
    }

    public static void setDocumentoUnivocoIndipendentementeTipo(boolean documentoUnivocoIndipendentementeTipo) {
        AccordiServizioParteSpecificaHelper.documentoUnivocoIndipendentementeTipo = documentoUnivocoIndipendentementeTipo;
    }

    public boolean serviziAllegatiCheckData(TipoOperazione tipoOp, FormFile formFile, Documento documento, IProtocolFactory<?> pf) throws Exception {
        try {
            String ruolo = this.getParameter("ruolo");
            if (ruolo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Tipo di documento");
                return false;
            }
            if (formFile == null || formFile.getFileName() != null && "".equals(formFile.getFileName())) {
                this.pd.setMessage("&Egrave; necessario selezionare un documento.");
                return false;
            }
            if (formFile == null || formFile.getFileSize() <= 0) {
                this.pd.setMessage("Il documento selezionato non pu&ograve; essere vuoto.");
                return false;
            }
            if (documento.getTipo() == null || "".equals(documento.getTipo()) || documento.getTipo().length() > 30 || formFile.getFileName().lastIndexOf(".") == -1) {
                if (documento.getTipo() == null || "".equals(documento.getTipo()) || formFile.getFileName().lastIndexOf(".") == -1) {
                    this.pd.setMessage("L'estensione del documento non &egrave; valida.");
                } else {
                    this.pd.setMessage("L'estensione del documento non &egrave; valida. La dimensione dell'estensione &egrave; troppo lunga.");
                }
                return false;
            }
            String labelServizio = this.getLabelServizioMessaggioErroreDocumentoDuplicato();
            if (this.archiviCore.existsDocumento(documento, ProprietariDocumento.servizio, documentoUnivocoIndipendentementeTipo)) {
                Documento existing;
                String tipo = documento.getTipo();
                String ruoloDoc = documento.getRuolo();
                String allegatoMsg = "L''allegato con nome ''{0}'' (tipo: {1}) &egrave; gi&agrave; presente {2}.";
                String specificaMsg = "La {0} con nome ''{1}'' (tipo: {2}) &egrave; gi&agrave; presente {3}.";
                if (documentoUnivocoIndipendentementeTipo) {
                    tipo = null;
                    ruoloDoc = null;
                    allegatoMsg = "L''allegato con nome ''{0}'' &egrave; gi&agrave; presente {1}.";
                    specificaMsg = "La {0} con nome ''{1}'' &egrave; gi&agrave; presente {2}.";
                }
                if ((existing = this.archiviCore.getDocumento(documento.getFile(), tipo, ruoloDoc, documento.getIdProprietarioDocumento(), false, ProprietariDocumento.servizio)).getId().longValue() == documento.getId().longValue()) {
                    return true;
                }
                if (RuoliDocumento.allegato.toString().equals(documento.getRuolo()) || documentoUnivocoIndipendentementeTipo) {
                    if (documentoUnivocoIndipendentementeTipo) {
                        this.pd.setMessage(MessageFormat.format(allegatoMsg, documento.getFile(), labelServizio));
                    } else {
                        this.pd.setMessage(MessageFormat.format(allegatoMsg, documento.getFile(), documento.getTipo(), labelServizio));
                    }
                } else {
                    this.pd.setMessage(MessageFormat.format(specificaMsg, documento.getRuolo(), documento.getFile(), documento.getTipo(), labelServizio));
                }
                return false;
            }
            ValidazioneResult valida = pf.createValidazioneDocumenti().valida(documento);
            if (!valida.isEsito()) {
                this.pd.setMessage(valida.getMessaggioErrore());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    private String getLabelServizioMessaggioErroreDocumentoDuplicato() {
        String labelServizio = "nel servizio";
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        labelServizio = gestioneFruitori ? "nella fruizione" : "nell'erogazione";
        return labelServizio;
    }

    public boolean serviziAllegatiCheckData(TipoOperazione tipoOp, List<BinaryParameter> binaryParameterDocumenti, Long idProprietarioDocumento, IProtocolFactory<?> pf) throws Exception {
        try {
            String ruolo = this.getParameter("ruolo");
            String tipoFile = this.getParameter("tipoFile");
            if (ruolo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Tipo di documento");
                return false;
            }
            boolean almenoUnoSelezionato = false;
            for (int i = 0; i < binaryParameterDocumenti.size(); ++i) {
                BinaryParameter binaryParameter = binaryParameterDocumenti.get(i);
                if (binaryParameter.getValue() == null || binaryParameter.getValue().length <= 0) continue;
                almenoUnoSelezionato = true;
                break;
            }
            if (!almenoUnoSelezionato) {
                this.pd.setMessage("&Egrave; necessario selezionare almeno un documento.");
                return false;
            }
            ArrayList<Object> listaErrori = new ArrayList<Object>();
            String labelServizio = this.getLabelServizioMessaggioErroreDocumentoDuplicato();
            for (int i = 0; i < binaryParameterDocumenti.size(); ++i) {
                ValidazioneResult valida;
                BinaryParameter binaryParameter = binaryParameterDocumenti.get(i);
                if (StringUtils.isBlank((CharSequence)binaryParameter.getFilename())) {
                    listaErrori.add("Il documento selezionato in posizione (" + (i + 1) + ") non ha un nome valido.");
                    continue;
                }
                if (binaryParameter.getValue() == null || binaryParameter.getValue().length <= 0) {
                    listaErrori.add("Il documento '" + binaryParameter.getFilename() + "' &egrave; vuoto.");
                    continue;
                }
                String tipo = null;
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        tipo = binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length());
                        break;
                    }
                    case specificaSemiformale: {
                        tipo = TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome();
                        break;
                    }
                    case specificaSicurezza: {
                        tipo = TipiDocumentoSicurezza.valueOf((String)tipoFile).getNome();
                        break;
                    }
                    case specificaLivelloServizio: {
                        tipo = TipiDocumentoLivelloServizio.valueOf((String)tipoFile).getNome();
                    }
                }
                if (tipo == null || "".equals(tipo) || tipo.length() > 30 || binaryParameter.getFilename().lastIndexOf(".") == -1) {
                    if (tipo == null || "".equals(tipo) || binaryParameter.getFilename().lastIndexOf(".") == -1) {
                        listaErrori.add("L'estensione del documento '" + binaryParameter.getFilename() + "' non &egrave; valida.");
                        continue;
                    }
                    listaErrori.add("L'estensione del documento '" + binaryParameter.getFilename() + "' non &egrave; valida. La dimensione dell'estensione &egrave; troppo lunga.");
                    continue;
                }
                Documento documento = new Documento();
                documento.setRuolo(RuoliDocumento.valueOf((String)ruolo).toString());
                documento.setByteContenuto(binaryParameter.getValue());
                documento.setFile(binaryParameter.getFilename());
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        documento.setTipo(binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length()));
                        break;
                    }
                    case specificaSemiformale: {
                        documento.setTipo(TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome());
                        break;
                    }
                    case specificaSicurezza: {
                        documento.setTipo(TipiDocumentoSicurezza.valueOf((String)tipoFile).getNome());
                        break;
                    }
                    case specificaLivelloServizio: {
                        documento.setTipo(TipiDocumentoLivelloServizio.valueOf((String)tipoFile).getNome());
                    }
                }
                documento.setIdProprietarioDocumento(idProprietarioDocumento);
                boolean documentoUnivocoIndipendentementeTipo = true;
                if (this.archiviCore.existsDocumento(documento, ProprietariDocumento.servizio, documentoUnivocoIndipendentementeTipo)) {
                    Documento existing;
                    tipo = documento.getTipo();
                    String ruoloDoc = documento.getRuolo();
                    String allegatoMsg = "L''allegato con nome ''{0}'' (tipo: {1}) &egrave; gi&agrave; presente {2}.";
                    String specificaMsg = "La {0} con nome ''{1}'' (tipo: {2}) &egrave; gi&agrave; presente {3}.";
                    if (documentoUnivocoIndipendentementeTipo) {
                        tipo = null;
                        ruoloDoc = null;
                        allegatoMsg = "L''allegato con nome ''{0}'' &egrave; gi&agrave; presente {1}.";
                        specificaMsg = "La {0} con nome ''{1}'' &egrave; gi&agrave; presente {2}.";
                    }
                    if ((existing = this.archiviCore.getDocumento(documento.getFile(), tipo, ruoloDoc, documento.getIdProprietarioDocumento(), false, ProprietariDocumento.servizio)).getId().longValue() != documento.getId().longValue()) {
                        if (RuoliDocumento.allegato.toString().equals(documento.getRuolo()) || documentoUnivocoIndipendentementeTipo) {
                            if (documentoUnivocoIndipendentementeTipo) {
                                listaErrori.add(MessageFormat.format(allegatoMsg, documento.getFile(), labelServizio));
                                continue;
                            }
                            listaErrori.add(MessageFormat.format(allegatoMsg, documento.getFile(), documento.getTipo(), labelServizio));
                            continue;
                        }
                        listaErrori.add(MessageFormat.format(specificaMsg, documento.getRuolo(), documento.getFile(), documento.getTipo(), labelServizio));
                        continue;
                    }
                }
                if ((valida = pf.createValidazioneDocumenti().valida(documento)).isEsito()) continue;
                listaErrori.add(valida.getMessaggioErrore());
            }
            if (!listaErrori.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < listaErrori.size(); ++i) {
                    if (i != 0) {
                        sb.append("<br/>");
                    }
                    sb.append((String)listaErrori.get(i));
                }
                this.pd.setMessage(sb.toString());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareServiziAllegatiList(AccordoServizioParteSpecifica asps, ISearch ricerca, List<Documento> lista) throws Exception {
        try {
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            if (tipologia != null && "fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            }
            String id = this.getParameter("id");
            String tipoSoggettoFruitore = null;
            String nomeSoggettoFruitore = null;
            IDSoggetto idSoggettoFruitore = null;
            Parameter pTipoSoggettoFruitore = null;
            Parameter pNomeSoggettoFruitore = null;
            if (gestioneFruitori) {
                tipoSoggettoFruitore = this.getParametroTipoSoggetto("tipoSoggFru");
                nomeSoggettoFruitore = this.getParameter("nomeSoggFru");
                idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                pTipoSoggettoFruitore = new Parameter("tipoSoggFru", tipoSoggettoFruitore);
                pNomeSoggettoFruitore = new Parameter("nomeSoggFru", nomeSoggettoFruitore);
            }
            Parameter pModificaAPI = null;
            String modificaAPI = this.getParameter("modificaAPI");
            if (modificaAPI != null) {
                pModificaAPI = new Parameter("modificaAPI", modificaAPI);
            }
            ArrayList<Parameter> listAllegatiSession = new ArrayList<Parameter>();
            listAllegatiSession.add(new Parameter("id", id));
            if (gestioneFruitori) {
                listAllegatiSession.add(pTipoSoggettoFruitore);
                listAllegatiSession.add(pNomeSoggettoFruitore);
            }
            if (pModificaAPI != null) {
                listAllegatiSession.add(pModificaAPI);
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecificaAllegati", (Parameter[])listAllegatiSession.toArray(new Parameter[1]));
            int idLista = Liste.SERVIZI_ALLEGATI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String tipoProtocollo = this.apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
            String tmpTitle = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, asps, tipoProtocollo);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
            if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
                }
                ArrayList<Parameter> listErogazioniChange = new ArrayList<Parameter>();
                Parameter pIdServizio = new Parameter("id", "" + asps.getId());
                listErogazioniChange.add(pIdServizio);
                if (gestioneFruitori) {
                    listErogazioniChange.add(pNomeSoggettoFruitore);
                    listErogazioniChange.add(pTipoSoggettoFruitore);
                }
                if (pModificaAPI != null) {
                    listErogazioniChange.add(pModificaAPI);
                }
                lstParam.add(new Parameter(tmpTitle, "aspsErogazioniChange.do", listErogazioniChange.toArray(new Parameter[1])));
                lstParam.add(new Parameter("Informazioni Generali", "accordiServizioParteSpecificaChange.do", listErogazioniChange.toArray(new Parameter[1])));
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    lstParam.add(new Parameter("Allegati", null));
                } else {
                    lstParam.add(new Parameter("Allegati", "accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", "" + asps.getId())}));
                    lstParam.add(new Parameter("Risultati ricerca", null));
                }
            } else {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                }
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    lstParam.add(new Parameter("Allegati di " + tmpTitle, null));
                } else {
                    lstParam.add(new Parameter("Allegati di " + tmpTitle, "accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", "" + asps.getId())}));
                    lstParam.add(new Parameter("Risultati ricerca", null));
                }
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Allegati", (String)search);
            }
            String[] labels = new String[]{"Nome", "Ruolo", "Tipo", "Documento"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Documento doc : lista) {
                    Parameter pIdAllegato = new Parameter("idAllegato", "" + doc.getId());
                    Parameter pId = new Parameter("id", "" + asps.getId());
                    Parameter pNomeDoc = new Parameter("nomeDoc", doc.getFile());
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    ArrayList<Parameter> listAllegatiChange = new ArrayList<Parameter>();
                    listAllegatiChange.add(pIdAllegato);
                    listAllegatiChange.add(pId);
                    listAllegatiChange.add(pNomeDoc);
                    if (gestioneFruitori) {
                        listAllegatiChange.add(pTipoSoggettoFruitore);
                        listAllegatiChange.add(pNomeSoggettoFruitore);
                    }
                    if (pModificaAPI != null) {
                        listAllegatiChange.add(pModificaAPI);
                    }
                    de.setUrl("accordiServizioParteSpecificaAllegatiChange.do", listAllegatiChange.toArray(new Parameter[1]));
                    de.setValue(doc.getFile());
                    de.setIdToRemove("" + doc.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getRuolo());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getTipo());
                    e.add(de);
                    de = new DataElement();
                    if (this.core.isShowAllegati()) {
                        de.setUrl("accordiServizioParteSpecificaAllegatiView.do", new Parameter[]{pIdAllegato, pId, pNomeDoc});
                        de.setValue("visualizza");
                    } else {
                        Parameter pIdAccordo = new Parameter("idAccordo", "" + asps.getId());
                        Parameter pTipoDoc = new Parameter("tipoDocumento", "asps");
                        de.setUrl("downloadDocumento", new Parameter[]{pIdAllegato, pId, pNomeDoc, pIdAccordo, pTipoDoc});
                        de.setValue("Download".toLowerCase());
                        de.setDisabilitaAjaxStatus();
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(asps.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareServiziList(ISearch ricerca, List<AccordoServizioParteSpecifica> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            String protocollo;
            IProtocolFactory p;
            List<String> l;
            if (lista == null) {
                throw new Exception("Lista is null");
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecifica", (Parameter[])new Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            Boolean isAccordiCooperazione = user.getPermessi().isAccordiCooperazione();
            Boolean isServizi = user.getPermessi().isServizi();
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            boolean showServiceBinding = true;
            if (!(showProtocolli || (l = this.core.getProtocolli(this.request, this.session)).size() <= 0 || (p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(l.get(0))).getManifest().getBinding().getRest() != null && p.getManifest().getBinding().getSoap() != null)) {
                showServiceBinding = false;
            }
            int idLista = Liste.SERVIZI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.addFilterProtocol(ricerca, idLista);
            if (showServiceBinding) {
                String filterTipoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroServiceBinding");
                this.addFilterServiceBinding(filterTipoAccordo, false, true);
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            boolean showConfigurazionePA = false;
            boolean showConfigurazionePD = false;
            boolean showSoggettoFruitore = false;
            boolean showSoggettoErogatore = false;
            boolean showFruitori = false;
            boolean showConnettorePA = false;
            boolean showConnettorePD = false;
            boolean gestioneFruitori = false;
            if (tipologia == null) {
                String filterDominio = null;
                if (!this.core.isGestionePddAbilitata(this)) {
                    filterDominio = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroDominio");
                    this.addFilterDominio(filterDominio, false);
                }
                PddTipologia pddTipologiaFilter = null;
                if (filterDominio != null && !"".equals(filterDominio)) {
                    pddTipologiaFilter = PddTipologia.toPddTipologia((String)filterDominio);
                }
                boolean bl = showConfigurazionePA = pddTipologiaFilter == null || !PddTipologia.ESTERNO.equals(pddTipologiaFilter);
                if (showConfigurazionePA) {
                    showConnettorePA = true;
                }
                showFruitori = pddTipologiaFilter == null || this.isModalitaCompleta() || PddTipologia.ESTERNO.equals((Object)pddTipologiaFilter);
                showSoggettoErogatore = true;
            } else {
                if ("erogazione".equals(tipologia)) {
                    showConfigurazionePA = true;
                    showSoggettoErogatore = false;
                    showConnettorePA = true;
                }
                if ("fruizione".equals(tipologia)) {
                    gestioneFruitori = true;
                    showConfigurazionePD = true;
                    showSoggettoFruitore = false;
                    showSoggettoErogatore = true;
                    showConnettorePD = true;
                }
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
            if (showConfigurazionePD) {
                lstParm.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
            } else {
                lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
            }
            this.pd.setSearchLabel("Servizio / Soggetto");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            } else {
                lstParm.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Erogazioni", (String)search);
            }
            String[] labels = null;
            String asLabel = "API (ParteComune/Composto)";
            if (isServizi.booleanValue() && !isAccordiCooperazione.booleanValue()) {
                asLabel = "API";
            }
            if (!isServizi.booleanValue() && isAccordiCooperazione.booleanValue()) {
                asLabel = "API (Servizio Composto)";
            }
            if (isServizi.booleanValue() && isAccordiCooperazione.booleanValue()) {
                asLabel = "API (ParteComune/Composto)";
            }
            String correlatoLabel = "Ruolo";
            String fruitoriLabel = "Fruizioni";
            ArrayList<AccordoServizioParteComuneSintetico> listApc = new ArrayList<AccordoServizioParteComuneSintetico>();
            ArrayList<String> protocolli = new ArrayList<String>();
            boolean showRuoli = false;
            for (AccordoServizioParteSpecifica asps : lista) {
                AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
                org.openspcoop2.message.constants.ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(apc.getServiceBinding());
                String tipoSoggetto = asps.getTipoSoggettoErogatore();
                protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoSoggetto);
                showRuoli = showRuoli || this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(protocollo, serviceBinding);
                listApc.add(apc);
                protocolli.add(protocollo);
            }
            ArrayList<String> listaLabelTabella = new ArrayList<String>();
            listaLabelTabella.add("Servizio");
            if (showSoggettoErogatore) {
                listaLabelTabella.add("Soggetto Erogatore");
            }
            if (showSoggettoFruitore) {
                listaLabelTabella.add("Soggetto Fruitore");
            }
            if (showProtocolli) {
                listaLabelTabella.add("Profilo");
            }
            listaLabelTabella.add(asLabel);
            if (showServiceBinding) {
                listaLabelTabella.add("Tipo");
            }
            if (showConfigurazionePA) {
                listaLabelTabella.add("URL Invocazione");
                if (showConnettorePA) {
                    listaLabelTabella.add("Connettore");
                    listaLabelTabella.add("Verifica Connettivit\u00e0 Connettore");
                    listaLabelTabella.add("Configurazione Connettori Multipli");
                    listaLabelTabella.add("Elenco Connettori");
                }
                listaLabelTabella.add("Configurazione");
            }
            if (showConfigurazionePD) {
                listaLabelTabella.add("URL Invocazione");
                if (showConnettorePD) {
                    listaLabelTabella.add("Connettore");
                }
                listaLabelTabella.add("Configurazione");
            }
            if (showRuoli) {
                // empty if block
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                listaLabelTabella.add("Stato");
            }
            if (showFruitori) {
                listaLabelTabella.add(fruitoriLabel);
            }
            if (!this.isModalitaStandard()) {
                listaLabelTabella.add("Allegati");
            }
            labels = listaLabelTabella.toArray(new String[listaLabelTabella.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            for (int i = 0; i < lista.size(); ++i) {
                ConsoleSearch searchForCount;
                IDServizio idServizio;
                AccordoServizioParteSpecifica asps = lista.get(i);
                Fruitore fruitore = null;
                if (showConfigurazionePD) {
                    fruitore = asps.getFruitore(0);
                }
                protocollo = (String)protocolli.get(i);
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                Parameter pIdsoggErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
                String uriASPS = this.idServizioFactory.getUriFromAccordo(asps);
                Soggetto sog = this.soggettiCore.getSoggettoRegistro(asps.getIdSoggetto());
                boolean isPddEsterna = this.pddCore.isPddEsterna(sog.getPortaDominio());
                DataElement de = new DataElement();
                de.setUrl("accordiServizioParteSpecificaChange.do", new Parameter[]{new Parameter("id", "" + asps.getId()), pIdsoggErogatore});
                de.setValue(this.getLabelNomeServizio(protocollo, asps.getTipo(), asps.getNome(), asps.getVersione()));
                de.setIdToRemove(uriASPS);
                e.add(de);
                if (showSoggettoErogatore) {
                    de = new DataElement();
                    de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + asps.getIdSoggetto()), new Parameter("tipoprov", asps.getTipoSoggettoErogatore()), new Parameter("nomeprov", asps.getNomeSoggettoErogatore())});
                    de.setValue(this.getLabelNomeSoggetto(protocollo, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()));
                    e.add(de);
                }
                if (showSoggettoFruitore) {
                    de = new DataElement();
                    de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + fruitore.getIdSoggetto()), new Parameter("tipoprov", fruitore.getTipo()), new Parameter("nomeprov", fruitore.getNome())});
                    de.setValue(this.getLabelNomeSoggetto(protocollo, fruitore.getTipo(), fruitore.getNome()));
                    e.add(de);
                }
                if (showProtocolli) {
                    de = new DataElement();
                    de.setValue(this.getLabelProtocollo(protocollo));
                    e.add(de);
                }
                de = new DataElement();
                AccordoServizioParteComuneSintetico apc = (AccordoServizioParteComuneSintetico)listApc.get(i);
                org.openspcoop2.message.constants.ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(apc.getServiceBinding());
                Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(apc);
                de.setUrl("accordiServizioParteComuneChange.do", new Parameter[]{new Parameter("id", "" + asps.getIdAccordo()), new Parameter("nome", apc.getNome()), pTipoAccordo});
                de.setValue(this.getLabelIdAccordo(apc));
                e.add(de);
                if (showServiceBinding) {
                    de = new DataElement();
                    switch (serviceBinding) {
                        case REST: {
                            de.setValue("Rest");
                            break;
                        }
                        default: {
                            de.setValue("Soap");
                        }
                    }
                    e.add(de);
                }
                if (showConfigurazionePA) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
                    idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
                    Parameter paIdSogg = null;
                    Parameter paNomePorta = null;
                    Parameter paIdPorta = null;
                    Parameter paIdAsps = null;
                    Parameter paConfigurazioneDati = null;
                    Parameter paIdProvider = null;
                    Parameter paIdPortaPerSA = null;
                    Parameter paConnettoreDaListaAPS = null;
                    IDPortaApplicativa idPA = null;
                    PortaApplicativa paDefault = null;
                    PortaApplicativaServizioApplicativo paSADefault = null;
                    boolean connettoreMultiploEnabled = false;
                    boolean checkConnettore = false;
                    boolean visualizzaConnettore = true;
                    long idConnettore = 1L;
                    if (!isPddEsterna) {
                        idPA = this.porteApplicativeCore.getIDPortaApplicativaAssociataDefault(idServizio);
                        if (idPA != null) {
                            paDefault = this.porteApplicativeCore.getPortaApplicativa(idPA);
                        }
                        paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                        paIdAsps = new Parameter("idAsps", "" + asps.getId());
                        paConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
                        paConnettoreDaListaAPS = new Parameter("connettoreDaListaAps", "true");
                        if (paDefault != null) {
                            paSADefault = (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0);
                            paNomePorta = new Parameter("nomePorta", paDefault.getNome());
                            paIdPorta = new Parameter("id", "" + paDefault.getId());
                            paIdProvider = new Parameter("provider", "" + paDefault.getIdSoggetto());
                            paIdPortaPerSA = new Parameter("idPorta", "" + paDefault.getId());
                        }
                        List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
                        ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
                        for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                            listaPorteApplicativeAssociate.add(this.porteApplicativeCore.getPortaApplicativa(mappinErogazione.getIdPortaApplicativa()));
                        }
                        for (int z = 0; z < listaPorteApplicativeAssociate.size(); ++z) {
                            PortaApplicativaServizioApplicativo portaApplicativaAssociataServizioApplicativo;
                            boolean connettoreConfigurazioneRidefinito;
                            PortaApplicativa paAssociata = (PortaApplicativa)listaPorteApplicativeAssociate.get(z);
                            MappingErogazionePortaApplicativa mapping = listaMappingErogazionePortaApplicativa.get(z);
                            if (mapping.isDefault() || !(connettoreConfigurazioneRidefinito = this.isConnettoreRidefinito(paDefault, paSADefault, paAssociata, portaApplicativaAssociataServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0), paAssociata.getServizioApplicativoList()))) continue;
                            visualizzaConnettore = false;
                            break;
                        }
                        if (visualizzaConnettore && paDefault != null) {
                            connettoreMultiploEnabled = paDefault.getBehaviour() != null;
                            PortaApplicativaServizioApplicativo paDefautServizioApplicativo = (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0);
                            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()));
                            idServizioApplicativo.setNome(paDefautServizioApplicativo.getNome());
                            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idServizioApplicativo);
                            org.openspcoop2.core.config.Connettore connettore = sa.getInvocazioneServizio().getConnettore();
                            idConnettore = connettore.getId();
                            checkConnettore = ConnettoreCheck.checkSupported((org.openspcoop2.core.config.Connettore)connettore);
                        }
                    }
                    de = new DataElement();
                    if (isPddEsterna || this.isModalitaCompleta()) {
                        de.setType(DataElementType.TEXT);
                        de.setValue("-");
                    } else {
                        de.setUrl("porteApplicativeChange.do", new Parameter[]{paIdSogg, paNomePorta, paIdPorta, paIdAsps, paConfigurazioneDati});
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    if (showConnettorePA) {
                        de = new DataElement();
                        if (isPddEsterna || this.isModalitaCompleta()) {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        } else {
                            boolean visualizzaLinkConfigurazioneConnettore;
                            boolean bl = visualizzaLinkConfigurazioneConnettore = visualizzaConnettore && (!this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled);
                            if (visualizzaLinkConfigurazioneConnettore) {
                                PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativo = (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0);
                                de.setUrl("serviziApplicativiEndPointInvocazioneServizio.do", new Parameter[]{paIdProvider, paIdPortaPerSA, paIdAsps, new Parameter("nomeservizioApplicativo", portaApplicativaServizioApplicativo.getNome()), new Parameter("idsil", "" + portaApplicativaServizioApplicativo.getIdServizioApplicativo()), paConnettoreDaListaAPS});
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            } else {
                                de.setType(DataElementType.TEXT);
                                de.setValue("-");
                            }
                        }
                        e.add(de);
                        de = new DataElement();
                        Parameter pIdConnettore = new Parameter("connettoreId", "" + idConnettore);
                        Parameter pConnettoreAccessoDaGruppi = new Parameter("connettoreAccessoDaGruppi", "false");
                        Parameter pConnettoreVerificaAccesso = new Parameter("connettoreRegistro", "false");
                        if (isPddEsterna || this.isModalitaCompleta()) {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        } else {
                            boolean visualizzaLinkCheckConnettore;
                            boolean bl = visualizzaLinkCheckConnettore = visualizzaConnettore && checkConnettore && (!this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled);
                            if (visualizzaLinkCheckConnettore) {
                                ArrayList<Parameter> listParametersVerificaConnettore = new ArrayList<Parameter>();
                                paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                                listParametersVerificaConnettore.add(paIdSogg);
                                listParametersVerificaConnettore.add(paIdPorta);
                                listParametersVerificaConnettore.add(paIdAsps);
                                listParametersVerificaConnettore.add(paConnettoreDaListaAPS);
                                listParametersVerificaConnettore.add(pIdConnettore);
                                listParametersVerificaConnettore.add(pConnettoreAccessoDaGruppi);
                                listParametersVerificaConnettore.add(pConnettoreVerificaAccesso);
                                de.setUrl("porteApplicativeVerificaConnettore.do", listParametersVerificaConnettore.toArray(new Parameter[1]));
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            } else {
                                de.setType(DataElementType.TEXT);
                                de.setValue("-");
                            }
                        }
                        e.add(de);
                        de = new DataElement();
                        if (isPddEsterna || this.isModalitaCompleta()) {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        } else if (visualizzaConnettore && this.core.isConnettoriMultipliEnabled()) {
                            ArrayList<Parameter> listParametersConfigutazioneConnettoriMultipli = new ArrayList<Parameter>();
                            paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                            listParametersConfigutazioneConnettoriMultipli.add(paIdSogg);
                            listParametersConfigutazioneConnettoriMultipli.add(paIdPorta);
                            listParametersConfigutazioneConnettoriMultipli.add(paIdAsps);
                            listParametersConfigutazioneConnettoriMultipli.add(paConnettoreDaListaAPS);
                            listParametersConfigutazioneConnettoriMultipli.add(pIdConnettore);
                            listParametersConfigutazioneConnettoriMultipli.add(pConnettoreAccessoDaGruppi);
                            listParametersConfigutazioneConnettoriMultipli.add(pConnettoreVerificaAccesso);
                            de.setUrl("porteApplicativeConnettoriMultipliConfig.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                            de.setValue(this.getStatoConnettoriMultipliPortaApplicativa(paDefault));
                        } else {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        }
                        e.add(de);
                        de = new DataElement();
                        if (isPddEsterna || this.isModalitaCompleta()) {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        } else if (visualizzaConnettore && this.core.isConnettoriMultipliEnabled() && connettoreMultiploEnabled) {
                            ArrayList<Parameter> listParametersConfigutazioneConnettoriMultipli = new ArrayList<Parameter>();
                            paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                            listParametersConfigutazioneConnettoriMultipli.add(paIdSogg);
                            listParametersConfigutazioneConnettoriMultipli.add(paIdPorta);
                            listParametersConfigutazioneConnettoriMultipli.add(paIdAsps);
                            listParametersConfigutazioneConnettoriMultipli.add(paConnettoreDaListaAPS);
                            listParametersConfigutazioneConnettoriMultipli.add(pIdConnettore);
                            listParametersConfigutazioneConnettoriMultipli.add(pConnettoreAccessoDaGruppi);
                            listParametersConfigutazioneConnettoriMultipli.add(pConnettoreVerificaAccesso);
                            listParametersConfigutazioneConnettoriMultipli.add(new Parameter("idConnTab", "0"));
                            de.setUrl("porteApplicativeConnettoriMultipliList.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                            if (contaListe.booleanValue()) {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(paDefault.sizeServizioApplicativoList()));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                        } else {
                            de.setType(DataElementType.TEXT);
                            de.setValue("-");
                        }
                        e.add(de);
                    }
                    de = new DataElement();
                    if (isPddEsterna) {
                        de.setType(DataElementType.TEXT);
                        de.setValue("-");
                    } else {
                        de.setUrl("accordiServizioParteSpecificaPorteApplicativeList.do", new Parameter[]{new Parameter("id", "" + asps.getId()), pIdsoggErogatore, new Parameter("gestioneGruppi", "true"), new Parameter("gestioneConfigurazioni", "true")});
                        if (contaListe.booleanValue()) {
                            ConsoleSearch searchForCount2 = new ConsoleSearch(true, 1);
                            this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), (ISearch)searchForCount2);
                            int numPA = searchForCount2.getNumEntries(Liste.CONFIGURAZIONE_EROGAZIONE);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPA));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                    }
                    e.add(de);
                }
                if (showConfigurazionePD) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
                    idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
                    IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    IDPortaDelegata idPD = this.porteDelegateCore.getIDPortaDelegataAssociataDefault(idServizio, idFruitore);
                    PortaDelegata pdDefault = this.porteDelegateCore.getPortaDelegata(idPD);
                    Parameter pIdPD = new Parameter("id", "" + pdDefault.getId());
                    Parameter pNomePD = new Parameter("nomePorta", pdDefault.getNome());
                    Parameter pIdSoggPD = new Parameter("idsogg", "" + pdDefault.getIdSoggetto());
                    Parameter pIdAsps = new Parameter("idAsps", "" + asps.getId());
                    Parameter pId = new Parameter("id", "" + asps.getId());
                    Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
                    Parameter pIdFruitore = new Parameter("myId", "" + fruitore.getId());
                    Parameter pConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
                    Parameter pConnettoreDaListaAPS = new Parameter("connettoreDaListaAps", "true");
                    Long idSoggettoLong = fruitore.getIdSoggetto();
                    if (idSoggettoLong == null) {
                        idSoggettoLong = this.soggettiCore.getIdSoggetto(fruitore.getNome(), fruitore.getTipo());
                    }
                    Parameter pIdProviderFruitore = new Parameter("providerFruitore", "" + idSoggettoLong);
                    Parameter pIdSogg = new Parameter("idsogg", "" + idSoggettoLong);
                    de = new DataElement();
                    de.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneDati});
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    e.add(de);
                    if (showConnettorePD) {
                        boolean connettoreStatic = false;
                        if (gestioneFruitori) {
                            connettoreStatic = this.apsCore.isConnettoreStatic(protocollo);
                        }
                        de = new DataElement();
                        if (!connettoreStatic) {
                            ArrayList<Parameter> listParameter = new ArrayList<Parameter>();
                            listParameter.add(pId);
                            listParameter.add(pIdFruitore);
                            listParameter.add(pIdSoggettoErogatore);
                            listParameter.add(pIdProviderFruitore);
                            listParameter.add(pConnettoreDaListaAPS);
                            de.setUrl("accordiServizioParteSpecificaFruitoriChange.do", listParameter.toArray(new Parameter[1]));
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        } else {
                            de.setValue("-");
                        }
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setUrl("accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{pId, pIdSogg, pIdFruitore, new Parameter("gestioneGruppi", "true"), new Parameter("gestioneConfigurazioni", "true")});
                    if (contaListe.booleanValue()) {
                        ConsoleSearch searchForCount3 = new ConsoleSearch(true, 1);
                        IDServizio idServizioFromAccordo = this.idServizioFactory.getIDServizioFromAccordo(asps);
                        this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idFruitore, idServizioFromAccordo, (ISearch)searchForCount3);
                        int numPD = searchForCount3.getNumEntries(Liste.CONFIGURAZIONE_FRUIZIONE);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPD));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                }
                if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                    de = new DataElement();
                    de.setValue(StatiAccordo.upper((String)asps.getStatoPackage()));
                    e.add(de);
                }
                if (showFruitori) {
                    de = new DataElement();
                    if (!isPddEsterna) {
                        de.setValue("-");
                    } else {
                        de.setUrl("accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", "" + asps.getId()), pIdsoggErogatore});
                        if (contaListe.booleanValue()) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.apsCore.serviziFruitoriList(asps.getId().intValue(), (ISearch)searchForCount);
                            int numFru = searchForCount.getNumEntries(Liste.SERVIZI_FRUITORI);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numFru));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                    }
                    e.add(de);
                }
                if (!this.isModalitaStandard()) {
                    de = new DataElement();
                    de.setUrl("accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", "" + asps.getId())});
                    if (contaListe.booleanValue()) {
                        searchForCount = new ConsoleSearch(true, 1);
                        this.apsCore.serviziAllegatiList(asps.getId().intValue(), (ISearch)searchForCount);
                        int numAllegati = searchForCount.getNumEntries(Liste.SERVIZI_ALLEGATI);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numAllegati));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                }
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(AccordiServizioParteSpecificaCostanti.LABEL_APS_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareServiziFruitoriList(List<Fruitore> lista, String id, ISearch ricerca) throws Exception {
        try {
            PageData oldPD;
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecificaFruitori", (Parameter[])new Parameter[]{new Parameter("id", id)});
            int idLista = Liste.SERVIZI_FRUITORI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Object idSoggettoErogatoreDelServizio = this.getParametroLong("idSoggErogatore");
            if ((idSoggettoErogatoreDelServizio == null || ((String)idSoggettoErogatoreDelServizio).equals("")) && ((idSoggettoErogatoreDelServizio = (oldPD = ServletUtils.getPageDataFromSession((HttpServletRequest)this.request, (HttpSession)this.session)).getHidden("idSoggErogatore")) == null || ((String)idSoggettoErogatoreDelServizio).equals(""))) {
                AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(id));
                String tipoSoggettoErogatore = asps.getTipoSoggettoErogatore();
                String nomesoggettoErogatore = asps.getNomeSoggettoErogatore();
                IDSoggetto idSE = new IDSoggetto(tipoSoggettoErogatore, nomesoggettoErogatore);
                Soggetto SE = this.soggettiCore.getSoggettoRegistro(idSE);
                idSoggettoErogatoreDelServizio = "" + SE.getId();
            }
            this.pd.addHidden("idSoggErogatore", (String)idSoggettoErogatoreDelServizio);
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(id));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
            String tmpTitle = this.getLabelIdServizio(asps);
            ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
            lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParm.add(new Parameter("Fruizioni di " + tmpTitle, null));
            } else {
                lstParm.add(new Parameter("Fruizioni di " + tmpTitle, "accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", id)}));
                lstParm.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
            this.pd.setSearchLabel("Soggetto");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Fruizioni", (String)search);
            }
            String labelFruitore = "Soggetto";
            boolean showPoliticheSLA = false;
            ArrayList<String> listaLabelTabella = new ArrayList<String>();
            listaLabelTabella.add(labelFruitore);
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                listaLabelTabella.add("Stato");
            }
            listaLabelTabella.add("URL Invocazione");
            listaLabelTabella.add("Configurazione");
            this.pd.setLabels(listaLabelTabella.toArray(new String[1]));
            Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", (String)idSoggettoErogatoreDelServizio);
            Parameter pId = new Parameter("id", id);
            Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
            Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
            ArrayList dati = new ArrayList();
            Iterator<Fruitore> it = lista.iterator();
            Fruitore fru = null;
            while (it.hasNext()) {
                fru = it.next();
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                Parameter pMyId = new Parameter("myId", "" + fru.getId());
                DataElement de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("idFruitore");
                de.setValue("" + fru.getId());
                e.add(de);
                de = new DataElement();
                de.setUrl("accordiServizioParteSpecificaFruitoriChange.do", new Parameter[]{pId, pMyId, pIdSoggettoErogatore, new Parameter("providerFruitore", "" + fru.getIdSoggetto())});
                de.setValue(this.getLabelNomeSoggetto(protocollo, fru.getTipo(), fru.getNome()));
                de.setIdToRemove(fru.getId().toString());
                e.add(de);
                if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                    de = new DataElement();
                    de.setValue(StatiAccordo.upper((String)fru.getStatoPackage()));
                    e.add(de);
                }
                Parameter pIdSogg = new Parameter("idsogg", "" + fru.getIdSoggetto());
                IDSoggetto fruitore = new IDSoggetto(fru.getTipo(), fru.getNome());
                Soggetto fruitoreSogg = this.soggettiCore.getSoggettoRegistro(fruitore);
                boolean esterno = this.pddCore.isPddEsterna(fruitoreSogg.getPortaDominio());
                ServletUtils.removeObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"_tabKey_portaPar");
                IDServizio idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
                Parameter pIdPD = null;
                Parameter pNomePD = null;
                Parameter pIdSoggPD = null;
                Parameter pIdAsps = null;
                Parameter pIdFruitore = null;
                Parameter pConfigurazioneDati = null;
                if (!esterno) {
                    IDPortaDelegata idPD = this.porteDelegateCore.getIDPortaDelegataAssociataDefault(idServizio, fruitore);
                    PortaDelegata pdDefault = this.porteDelegateCore.getPortaDelegata(idPD);
                    pIdPD = new Parameter("id", "" + pdDefault.getId());
                    pNomePD = new Parameter("nomePorta", pdDefault.getNome());
                    pIdSoggPD = new Parameter("idsogg", "" + pdDefault.getIdSoggetto());
                    pIdAsps = new Parameter("idAsps", "" + asps.getId());
                    pIdFruitore = new Parameter("myId", "" + fru.getId());
                    pConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
                }
                de = new DataElement();
                if (esterno) {
                    de.setType(DataElementType.TEXT);
                    de.setValue("-");
                } else {
                    de.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneDati});
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                de = new DataElement();
                if (esterno) {
                    de.setValue("-");
                } else {
                    de.setUrl("accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{pId, pIdSogg, pNomeServizio, pTipoServizio, pMyId, new Parameter("gestioneGruppi", "true"), new Parameter("gestioneConfigurazioni", "true")});
                    if (contaListe.booleanValue()) {
                        ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                        IDServizio idServizioFromAccordo = this.idServizioFactory.getIDServizioFromAccordo(asps);
                        IDSoggetto idSoggettoFruitore = new IDSoggetto(fru.getNome(), fru.getTipo());
                        this.apsCore.serviziFruitoriMappingList(fru.getId(), idSoggettoFruitore, idServizioFromAccordo, (ISearch)searchForCount);
                        int numPD = searchForCount.getNumEntries(Liste.CONFIGURAZIONE_FRUIZIONE);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPD));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                }
                e.add(de);
                if (showPoliticheSLA) {
                    de = new DataElement();
                    de.setValue("non disp.");
                    e.add(de);
                }
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareServiziConfigurazioneList(List<MappingErogazionePortaApplicativa> listaParam, String id, String idSoggettoErogatoreDelServizio, ISearch ricerca) throws Exception {
        try {
            boolean chooseTabWithFilter;
            boolean showBottoneAggiungiNuovaConfigurazione;
            boolean visualizzazioneTabs;
            Boolean contaListeObject = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            boolean contaListe = contaListeObject != null ? contaListeObject : false;
            IExtendedListServlet extendedServletList = this.core.getExtendedServletPortaApplicativa();
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecificaPorteApplicative", (Parameter[])new Parameter[]{new Parameter("id", id), new Parameter("idSoggErogatore", idSoggettoErogatoreDelServizio)});
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneErogatori = false;
            if (tipologia != null && "erogazione".equals(tipologia)) {
                gestioneErogatori = true;
            }
            boolean gestioneGruppi = true;
            String paramGestioneGruppi = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"gestioneGruppi");
            if (paramGestioneGruppi != null && !"".equals(paramGestioneGruppi)) {
                gestioneGruppi = Boolean.valueOf(paramGestioneGruppi);
            }
            boolean gestioneConfigurazioni = true;
            String paramGestioneConfigurazioni = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"gestioneConfigurazioni");
            if (paramGestioneConfigurazioni != null && !"".equals(paramGestioneConfigurazioni)) {
                gestioneConfigurazioni = Boolean.valueOf(paramGestioneConfigurazioni);
            }
            boolean bl = visualizzazioneTabs = !this.isModalitaCompleta();
            if (visualizzazioneTabs) {
                gestioneGruppi = false;
                this.pd.setCustomListViewName("configurazione");
            }
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(id));
            AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
            ServiceBinding serviceBinding = apc.getServiceBinding();
            org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage = this.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
            int idLista = Liste.CONFIGURAZIONE_EROGAZIONE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            Map<String, String> azioni = this.porteApplicativeCore.getAzioniConLabel(asps, apc, false, true, new ArrayList<String>());
            String filtroAzione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroAzione");
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setSearch("");
            List<MappingErogazionePortaApplicativa> listaSenzaFiltro = this.impostaFiltroAzioneMappingErogazione(null, listaParam, ricerca, idLista);
            boolean bl2 = showBottoneAggiungiNuovaConfigurazione = azioni != null && azioni.size() > 1 || listaSenzaFiltro.size() > 1;
            if (showBottoneAggiungiNuovaConfigurazione) {
                for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaParam) {
                    if (!mappingErogazionePortaApplicativa.isDefault()) continue;
                    PortaApplicativa paDefaullt = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                    if (paDefaullt.getAzione() == null || !PortaApplicativaAzioneIdentificazione.STATIC.equals((Object)paDefaullt.getAzione().getIdentificazione())) break;
                    showBottoneAggiungiNuovaConfigurazione = false;
                    break;
                }
            }
            List<MappingErogazionePortaApplicativa> lista = null;
            boolean bl3 = chooseTabWithFilter = !this.isModalitaCompleta();
            if (chooseTabWithFilter) {
                lista = listaSenzaFiltro;
                if (lista.size() > 1) {
                    MappingErogazionePortaApplicativa mappingContenenteAzione = this.getFiltroAzioneMappingErogazione(filtroAzione, listaParam);
                    if (mappingContenenteAzione != null) {
                        int tab = -1;
                        for (int i = 0; i < lista.size(); ++i) {
                            if (!lista.get(i).getNome().equals(mappingContenenteAzione.getNome())) continue;
                            tab = i;
                            break;
                        }
                        if (tab >= 0) {
                            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)("" + tab), (String)"idTab");
                        }
                    }
                    this.pd.setLabelBottoneFiltra("Individua Gruppo");
                }
            } else {
                lista = this.impostaFiltroAzioneMappingErogazione(filtroAzione, listaParam, ricerca, idLista);
            }
            boolean allActionRedefined = false;
            List<String> actionNonRidefinite = null;
            if (listaSenzaFiltro != null && listaSenzaFiltro.size() > 1) {
                ArrayList<String> azioniL = new ArrayList<String>();
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                if (!(allActionRedefined = this.allActionsRedefinedMappingErogazione(azioniL, listaSenzaFiltro))) {
                    actionNonRidefinite = this.getAllActionsNotRedefinedMappingErogazione(azioniL, listaSenzaFiltro);
                }
            }
            if (!gestioneGruppi && listaParam.size() <= 1) {
                ServletUtils.disabledPageDataSearch((PageData)this.pd);
            } else {
                this.addFilterAzione(azioni, filtroAzione, serviceBindingMessage);
            }
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
            if (idSoggettoErogatoreDelServizio == null || idSoggettoErogatoreDelServizio.equals("")) {
                idSoggettoErogatoreDelServizio = this.getParametroLong("idSoggErogatore");
            }
            if (idSoggettoErogatoreDelServizio == null || idSoggettoErogatoreDelServizio.equals("")) {
                PageData oldPD = ServletUtils.getPageDataFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                idSoggettoErogatoreDelServizio = oldPD.getHidden("idSoggErogatore");
            }
            this.pd.addHidden("idSoggErogatore", idSoggettoErogatoreDelServizio);
            String servizioTmpTile = this.getLabelIdServizio(asps);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            Parameter pIdServizio = new Parameter("id", "" + asps.getId());
            Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
            Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
            Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
            Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
            String labelAzioni = this.getLabelAzioni(serviceBindingMessage);
            if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                lstParam.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
                lstParam.add(new Parameter(servizioTmpTile, "aspsErogazioniChange.do", new Parameter[]{pIdServizio, pNomeServizio, pTipoServizio}));
                String labelConfigurazione = gestioneConfigurazioni ? "Configurazione" : (gestioneGruppi ? MessageFormat.format("Gruppi", labelAzioni) : "Configurazione");
                lstParam.add(new Parameter(labelConfigurazione, null));
            } else {
                lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                lstParam.add(new Parameter(servizioTmpTile, null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            boolean visualizzaAllarmi = this.confCore.isVisualizzaConfigurazioneAllarmiEnabled();
            boolean visualizzaMTOM = true;
            boolean visualizzaSicurezza = true;
            boolean visualizzaCorrelazione = true;
            switch (serviceBinding) {
                case REST: {
                    visualizzaMTOM = false;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                    break;
                }
                default: {
                    visualizzaMTOM = true;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                }
            }
            boolean showConnettoreLink = true;
            if (gestioneConfigurazioni && this.isModalitaStandard()) {
                showConnettoreLink = false;
                Iterator<MappingErogazionePortaApplicativa> it = lista.iterator();
                MappingErogazionePortaApplicativa mapping = null;
                while (it.hasNext()) {
                    mapping = it.next();
                    if (mapping.isDefault()) continue;
                    PortaApplicativa paAssociata = this.porteApplicativeCore.getPortaApplicativa(mapping.getIdPortaApplicativa());
                    PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0);
                    if (portaApplicativaServizioApplicativo.getNome().equals(paAssociata.getNome())) {
                        showConnettoreLink = true;
                    } else {
                        if (!this.saCore.isApplicativiServerEnabled(this)) continue;
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(new IDSoggetto(paAssociata.getTipoSoggettoProprietario(), paAssociata.getNomeSoggettoProprietario()));
                        idSA.setNome(portaApplicativaServizioApplicativo.getNome());
                        ServizioApplicativo sa = this.saCore.getServizioApplicativo(idSA);
                        if (!"server".equals(sa.getTipo())) continue;
                        showConnettoreLink = true;
                    }
                    break;
                }
            } else {
                showConnettoreLink = lista != null && lista.size() > 1;
            }
            PortaApplicativa paAssociataDefault = null;
            PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativoDefault = null;
            if (lista != null) {
                Iterator<MappingErogazionePortaApplicativa> itDef = lista.iterator();
                MappingErogazionePortaApplicativa mappingDefault = null;
                while (itDef.hasNext()) {
                    mappingDefault = itDef.next();
                    if (!mappingDefault.isDefault()) continue;
                    paAssociataDefault = this.porteApplicativeCore.getPortaApplicativa(mappingDefault.getIdPortaApplicativa());
                    portaApplicativaServizioApplicativoDefault = (PortaApplicativaServizioApplicativo)paAssociataDefault.getServizioApplicativoList().get(0);
                    break;
                }
            }
            ArrayList<Object> listaLabel = new ArrayList<Object>();
            if (visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                listaLabel.add("Nome Gruppo");
            }
            if (gestioneConfigurazioni) {
                listaLabel.add("");
            }
            if (!visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                listaLabel.add("Nome Gruppo");
            }
            if (gestioneGruppi || visualizzazioneTabs) {
                if (this.isModalitaCompleta()) {
                    listaLabel.add(labelAzioni);
                } else {
                    listaLabel.add("Elenco " + labelAzioni);
                }
            }
            if (gestioneConfigurazioni) {
                if (showConnettoreLink) {
                    listaLabel.add("Connettore");
                    listaLabel.add("Verifica Connettivit\u00e0 Connettore");
                    listaLabel.add("Configurazione Connettori Multipli");
                    listaLabel.add("Elenco Connettori");
                }
                listaLabel.add("Controllo Accessi");
                listaLabel.add("Rate Limiting");
                listaLabel.add("Validazione");
                listaLabel.add("Caching Risposta");
                if (visualizzaSicurezza) {
                    listaLabel.add("Sicurezza Messaggio");
                }
                if (visualizzaMTOM) {
                    listaLabel.add("MTOM");
                }
                listaLabel.add("Trasformazioni");
                if (visualizzaCorrelazione) {
                    listaLabel.add("Tracciamento");
                }
                listaLabel.add("Registrazione Messaggi");
                if (visualizzaAllarmi) {
                    listaLabel.add("Allarmi");
                }
                if (this.isModalitaAvanzata() || this.apsCore.isProprietaErogazioniShowModalitaStandard()) {
                    listaLabel.add("Propriet&agrave;");
                }
                if (this.isModalitaAvanzata()) {
                    listaLabel.add("Opzioni Avanzate");
                }
                if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                    listaLabel.add(extendedServletList.getListTitle(this));
                }
            }
            String[] labels = listaLabel.toArray(new String[listaLabel.size()]);
            this.pd.setLabels(labels);
            PropertiesSourceConfiguration propertiesSourceConfiguration = null;
            ConfigManager configManager = null;
            Configurazione configurazioneGenerale = null;
            if (visualizzazioneTabs) {
                propertiesSourceConfiguration = this.apsCore.getMessageSecurityPropertiesSourceConfiguration();
                configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
                configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
                configurazioneGenerale = this.confCore.getConfigurazioneGenerale();
            }
            this.impostaComandiMenuContestualePA(asps, protocollo, pNomeServizio, pTipoServizio, pIdSoggettoErogatore);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                Iterator<MappingErogazionePortaApplicativa> it = lista.iterator();
                MappingErogazionePortaApplicativa mapping = null;
                int idTab = 0;
                while (it.hasNext()) {
                    DataElementImage image;
                    DataElementImage image2;
                    Parameter pAbilita;
                    DataElement de;
                    boolean descrizioneEmpty;
                    mapping = it.next();
                    PortaApplicativa paAssociata = this.porteApplicativeCore.getPortaApplicativa(mapping.getIdPortaApplicativa());
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pNomePorta = new Parameter("nomePorta", paAssociata.getNome());
                    Parameter pIdSogg = new Parameter("idsogg", "" + paAssociata.getIdSoggetto());
                    Parameter pIdPorta = new Parameter("id", "" + paAssociata.getId());
                    Parameter pIdAsps = new Parameter("idAsps", "" + asps.getId());
                    Parameter pIdProvider = new Parameter("provider", "" + paAssociata.getIdSoggetto());
                    Parameter pIdPortaPerSA = new Parameter("idPorta", "" + paAssociata.getId());
                    Parameter pIdTAb = new Parameter("idTab", "" + idTab);
                    Parameter pConfigurazioneAltroPorta = new Parameter("configurazioneAltroPorta", "true");
                    Parameter pConfigurazioneDescrizione = new Parameter("configurazioneDescrizione", "true");
                    if (gestioneConfigurazioni && mapping.isDefault() && allActionRedefined && !showConnettoreLink) {
                        int numEntries = ricerca.getNumEntries(idLista);
                        ricerca.setNumEntries(idLista, numEntries - 1);
                        this.pd.setNumEntries(numEntries - 1);
                        continue;
                    }
                    boolean statoPA = paAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    String statoPAallRedefined = null;
                    String statoMapping = statoPA ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                    boolean urlCambiaStato = true;
                    if (mapping.isDefault() && allActionRedefined) {
                        statoPA = false;
                        statoPAallRedefined = "off";
                        statoMapping = this.getLabelAllAzioniRidefiniteTooltip(serviceBindingMessage);
                        urlCambiaStato = false;
                    }
                    boolean bl4 = descrizioneEmpty = paAssociata.getDescrizione() == null || StringUtils.isEmpty((CharSequence)paAssociata.getDescrizione()) || ImplementationConfiguration.isDescriptionDefault((String)paAssociata.getDescrizione());
                    if (visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                        DataElementImage image3;
                        de = new DataElement();
                        de.setWidthPx(10);
                        de.setType(DataElementType.CHECKBOX);
                        de.setStatusToolTip(statoPA ? "Configurazione abilitata" : "Configurazione disabilitata");
                        if (statoPAallRedefined != null) {
                            de.setStatusType(statoPAallRedefined);
                        } else {
                            de.setStatusType(statoPA ? CheckboxStatusType.ABILITATO : CheckboxStatusType.DISABILITATO);
                        }
                        de.setLabel("Nome Gruppo");
                        de.setValue(mapping.getDescrizione());
                        de.setStatusValue(mapping.getDescrizione());
                        if (!mapping.isDefault()) {
                            image3 = new DataElementImage();
                            image3.setUrl("porteApplicativeConfigurazioneChange.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image3.setToolTip(MessageFormat.format("Modifica {0}", "Nome Gruppo"));
                            image3.setImage("&#xE3C9;");
                            de.addImage(image3);
                        }
                        if (!mapping.isDefault()) {
                            de.setIdToRemove(paAssociata.getNome());
                        }
                        if (descrizioneEmpty) {
                            image3 = new DataElementImage();
                            image3.setUrl("porteApplicativeChange.do", new Parameter[]{pIdSogg, pNomePorta, pIdPorta, pIdAsps, pConfigurazioneDescrizione, pIdTAb});
                            image3.setToolTip(MessageFormat.format("Aggiungi {0}", "Descrizione"));
                            image3.setImage("&#xE873;");
                            de.addImage(image3);
                        }
                        if (urlCambiaStato) {
                            pAbilita = new Parameter("abilita", statoPA ? "no" : "true");
                            de.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pAbilita});
                            image2 = new DataElementImage();
                            image2.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pAbilita, pIdTAb});
                            image2.setToolTip(statoMapping);
                            image2.setImage(statoPA ? "&#xE9F6;" : "&#xE9F5;");
                            de.addImage(image2);
                        }
                        e.add(de);
                    }
                    if (gestioneConfigurazioni && !visualizzazioneTabs) {
                        de = new DataElement();
                        de.setWidthPx(10);
                        de.setType(DataElementType.CHECKBOX);
                        de.setToolTip(statoMapping);
                        if (statoPAallRedefined != null) {
                            de.setSelected(statoPAallRedefined);
                        } else {
                            de.setSelected(statoPA);
                        }
                        if (urlCambiaStato) {
                            pAbilita = new Parameter("abilita", statoPA ? "no" : "true");
                            de.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pAbilita});
                            image2 = new DataElementImage();
                            image2.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pAbilita, pIdTAb});
                            image2.setToolTip(statoMapping);
                            image2.setImage(statoPA ? "&#xE9F6;" : "&#xE9F5;");
                            de.setImage(image2);
                        }
                        e.add(de);
                    }
                    if (!visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                        de = new DataElement();
                        de.setValue(mapping.getDescrizione());
                        if (gestioneGruppi && !mapping.isDefault()) {
                            de.setUrl("porteApplicativeConfigurazioneChange.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        }
                        e.add(de);
                    }
                    if (gestioneGruppi || visualizzazioneTabs && (listaParam.size() > 1 || !mapping.isDefault())) {
                        List listaAzioni = null;
                        String nomiAzioni = null;
                        long countAzioni = 0L;
                        if (!mapping.isDefault()) {
                            List list = listaAzioni = paAssociata.getAzione() != null ? paAssociata.getAzione().getAzioneDelegataList() : new ArrayList();
                            if (!listaAzioni.isEmpty() && azioni.size() > 0) {
                                StringBuilder sb = new StringBuilder();
                                for (String idAzione : azioni.keySet()) {
                                    if (!listaAzioni.contains(idAzione)) continue;
                                    if (sb.length() > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(azioni.get(idAzione));
                                    ++countAzioni;
                                }
                                nomiAzioni = sb.toString();
                            }
                        }
                        DataElement de2 = new DataElement();
                        de2.setSize(200);
                        de2.setIdToRemove(paAssociata.getNome());
                        if (visualizzazioneTabs) {
                            de2.setLabel("Elenco " + labelAzioni);
                        }
                        if (listaSenzaFiltro.size() > 1) {
                            DataElementImage image4 = new DataElementImage();
                            if (!mapping.isDefault()) {
                                de2.setUrl("porteApplicativeAzioneList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                                if (this.isModalitaCompleta()) {
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de2, (Long)countAzioni);
                                } else {
                                    de2.setValue(nomiAzioni);
                                }
                                de2.setToolTip(nomiAzioni);
                                image4.setUrl("porteApplicativeAzioneList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                image4.setToolTip(MessageFormat.format("Modifica {0}", "Elenco " + labelAzioni));
                                image4.setImage("&#xE3C9;");
                                de2.setImage(image4);
                            } else if (actionNonRidefinite != null && !actionNonRidefinite.isEmpty() && azioni.size() > 0) {
                                long countAzioniRidefinite = 0L;
                                StringBuilder sb = new StringBuilder();
                                for (String idAzione : azioni.keySet()) {
                                    if (!actionNonRidefinite.contains(idAzione)) continue;
                                    if (sb.length() > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(azioni.get(idAzione));
                                    ++countAzioniRidefinite;
                                }
                                String nomiAzioniNonRidefinite = sb.toString();
                                de2.setUrl("porteApplicativeAzioneList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                                if (this.isModalitaCompleta()) {
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de2, (Long)countAzioniRidefinite);
                                } else {
                                    de2.setValue(nomiAzioniNonRidefinite);
                                }
                                de2.setToolTip(nomiAzioniNonRidefinite);
                                image4.setUrl("porteApplicativeAzioneList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                image4.setToolTip(MessageFormat.format("Modifica {0}", "Elenco " + labelAzioni));
                                image4.setImage("&#xE3C9;");
                                de2.setImage(image4);
                            } else if (allActionRedefined) {
                                de2.setValue(this.getLabelAllAzioniRidefiniteTooltip(serviceBindingMessage));
                            } else {
                                de2.setValue("-");
                            }
                        } else if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                            de2.setValue("Tutte le azioni dell'API");
                        } else {
                            de2.setValue("Tutte le risorse dell'API");
                        }
                        e.add(de2);
                    }
                    if (!descrizioneEmpty) {
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Descrizione");
                        }
                        de.setUrl("porteApplicativeChange.do", new Parameter[]{pIdSogg, pNomePorta, pIdPorta, pIdAsps, pConfigurazioneDescrizione});
                        int length = 150;
                        Object descrizione = paAssociata.getDescrizione();
                        if (descrizione != null && ((String)descrizione).length() > length) {
                            descrizione = ((String)descrizione).substring(0, length - 4) + " ...";
                        }
                        de.setValue(descrizione != null ? StringEscapeUtils.escapeHtml4((String)descrizione) : null);
                        de.setToolTip(paAssociata.getDescrizione());
                        de.setCopyToClipboard(paAssociata.getDescrizione());
                        if (visualizzazioneTabs) {
                            image = new DataElementImage();
                            image.setUrl("porteApplicativeChange.do", new Parameter[]{pIdSogg, pNomePorta, pIdPorta, pIdAsps, pConfigurazioneDescrizione, pIdTAb});
                            image.setToolTip(MessageFormat.format("Modifica {0}", "Descrizione"));
                            image.setImage("&#xE3C9;");
                            de.setImage(image);
                        }
                        e.add(de);
                    }
                    if (gestioneConfigurazioni) {
                        if (showConnettoreLink) {
                            DataElementImage image5;
                            ArrayList<Parameter> listParametersConfigutazioneConnettoriMultipli;
                            boolean checkConnettore;
                            boolean visualizzaLinkConfigurazioneConnettore;
                            boolean connettoreMultiploEnabled;
                            Parameter paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                            DataElement de3 = new DataElement();
                            String servletConnettore = "serviziApplicativiEndPointInvocazioneServizio.do";
                            PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0);
                            boolean bl5 = connettoreMultiploEnabled = paAssociata.getBehaviour() != null;
                            if (visualizzazioneTabs) {
                                if (!connettoreMultiploEnabled) {
                                    de3.setLabel("Connettore");
                                } else {
                                    de3.setLabel("Connettori");
                                }
                            }
                            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paAssociata.getTipoSoggettoProprietario(), paAssociata.getNomeSoggettoProprietario()));
                            idServizioApplicativo.setNome(portaApplicativaServizioApplicativo.getNome());
                            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idServizioApplicativo);
                            InvocazioneServizio is = sa.getInvocazioneServizio();
                            org.openspcoop2.core.config.Connettore connettore = is.getConnettore();
                            boolean connettoreMultiploEnabledDefault = false;
                            if (!mapping.isDefault()) {
                                connettoreMultiploEnabledDefault = paAssociataDefault != null && paAssociataDefault.getBehaviour() != null;
                            }
                            boolean ridefinito = false;
                            boolean connettoreRidefinito = false;
                            boolean bl6 = visualizzaLinkConfigurazioneConnettore = !this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled;
                            if (mapping.isDefault()) {
                                if (visualizzazioneTabs) {
                                    if (!connettoreMultiploEnabled) {
                                        de3.setValue(this.getLabelConnettore(sa, is, true));
                                        String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                                        de3.setToolTip(tooltipConnettore);
                                        de3.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                                    } else {
                                        de3.setValue(this.getNomiConnettoriMultipliPortaApplicativa(paAssociata));
                                        de3.setToolTip(this.getToolTipConnettoriMultipliPortaApplicativa(paAssociata));
                                    }
                                } else if (visualizzaLinkConfigurazioneConnettore) {
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de3);
                                } else {
                                    de3.setType(DataElementType.TEXT);
                                    de3.setValue("-");
                                }
                                if (visualizzaLinkConfigurazioneConnettore) {
                                    de3.setUrl(servletConnettore, new Parameter[]{pIdProvider, pIdPortaPerSA, pIdAsps, new Parameter("nomeservizioApplicativo", portaApplicativaServizioApplicativo.getNome()), new Parameter("idsil", "" + portaApplicativaServizioApplicativo.getIdServizioApplicativo())});
                                }
                                if (visualizzazioneTabs && visualizzaLinkConfigurazioneConnettore) {
                                    DataElementImage image6 = new DataElementImage();
                                    image6.setUrl(servletConnettore, new Parameter[]{pIdProvider, pIdPortaPerSA, pIdAsps, pIdTAb, new Parameter("nomeservizioApplicativo", portaApplicativaServizioApplicativo.getNome()), new Parameter("idsil", "" + portaApplicativaServizioApplicativo.getIdServizioApplicativo())});
                                    image6.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                                    image6.setImage("&#xE3C9;");
                                    de3.addImage(image6);
                                }
                            } else {
                                connettoreRidefinito = this.isConnettoreRidefinito(paAssociataDefault, portaApplicativaServizioApplicativoDefault, paAssociata, portaApplicativaServizioApplicativo, paAssociata.getServizioApplicativoList());
                                if (!connettoreRidefinito) {
                                    servletConnettore = "porteApplicativeConnettoreDefault.do";
                                    if (visualizzazioneTabs) {
                                        if (!connettoreMultiploEnabled && !connettoreMultiploEnabledDefault) {
                                            de3.setValue("[Predefinito] " + this.getLabelConnettore(sa, is, true));
                                            String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                                            de3.setToolTip("Utilizza connettore del gruppo 'Predefinito'&#10;" + tooltipConnettore);
                                            de3.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                                        } else if (connettoreMultiploEnabledDefault) {
                                            de3.setValue(this.getNomiConnettoriMultipliPortaApplicativa(paAssociataDefault));
                                            de3.setToolTip(this.getToolTipConnettoriMultipliPortaApplicativa(paAssociataDefault));
                                        } else {
                                            de3.setValue(this.getNomiConnettoriMultipliPortaApplicativa(paAssociata));
                                            de3.setToolTip(this.getToolTipConnettoriMultipliPortaApplicativa(paAssociata));
                                        }
                                    } else if (visualizzaLinkConfigurazioneConnettore) {
                                        de3.setValue("Utilizza connettore del gruppo 'Predefinito'");
                                        String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                                        de3.setToolTip("Utilizza connettore del gruppo 'Predefinito'&#10;" + tooltipConnettore);
                                        de3.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                                    } else {
                                        de3.setType(DataElementType.TEXT);
                                        de3.setValue("-");
                                    }
                                } else {
                                    ridefinito = true;
                                    servletConnettore = "porteApplicativeConnettoreRidefinito.do";
                                    if (visualizzazioneTabs) {
                                        if (!connettoreMultiploEnabled) {
                                            de3.setValue(this.getLabelConnettore(sa, is, true));
                                            String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                                            de3.setToolTip("Connettore ridefinito per il gruppo&#10;" + tooltipConnettore);
                                            de3.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                                        } else {
                                            de3.setValue(this.getNomiConnettoriMultipliPortaApplicativa(paAssociata));
                                            de3.setToolTip(this.getToolTipConnettoriMultipliPortaApplicativa(paAssociata));
                                        }
                                    } else if (visualizzaLinkConfigurazioneConnettore) {
                                        de3.setValue("Connettore ridefinito per il gruppo");
                                        String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                                        de3.setToolTip("Connettore ridefinito per il gruppo&#10;" + tooltipConnettore);
                                        de3.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                                    } else {
                                        de3.setType(DataElementType.TEXT);
                                        de3.setValue("-");
                                    }
                                }
                                if (visualizzaLinkConfigurazioneConnettore) {
                                    de3.setUrl(servletConnettore, new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                                }
                                if (visualizzazioneTabs && visualizzaLinkConfigurazioneConnettore) {
                                    DataElementImage image7 = new DataElementImage();
                                    image7.setUrl(servletConnettore, new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                    image7.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                                    image7.setImage("&#xE3C9;");
                                    de3.addImage(image7);
                                }
                            }
                            if ((checkConnettore = ConnettoreCheck.checkSupported((org.openspcoop2.core.config.Connettore)connettore)) && !mapping.isDefault() && !ridefinito) {
                                checkConnettore = false;
                            }
                            long idConnettore = connettore.getId();
                            boolean visualizzaLinkCheckConnettore = checkConnettore && (!this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled);
                            Parameter pIdConnettore = new Parameter("connettoreId", "" + idConnettore);
                            Parameter pConnettoreAccessoDaGruppi = new Parameter("connettoreAccessoDaGruppi", "true");
                            Parameter pConnettoreVerificaRegistro = new Parameter("connettoreRegistro", "false");
                            if (visualizzazioneTabs && visualizzaLinkCheckConnettore) {
                                DataElementImage image8 = new DataElementImage();
                                image8.setUrl("porteApplicativeVerificaConnettore.do", new Parameter[]{paIdSogg, pIdPorta, pIdAsps, pIdTAb, pIdConnettore, pConnettoreAccessoDaGruppi, pConnettoreVerificaRegistro});
                                image8.setToolTip(MessageFormat.format("Verifica {0}", "Connettore"));
                                image8.setImage("&#xE8BE;");
                                de3.addImage(image8);
                            }
                            de3.allineaTdAlCentro();
                            e.add(de3);
                            if (!visualizzazioneTabs) {
                                DataElement deVerificaConnettore = new DataElement();
                                if (visualizzaLinkCheckConnettore) {
                                    deVerificaConnettore.setValue("verifica");
                                    deVerificaConnettore.setUrl("porteApplicativeVerificaConnettore.do", new Parameter[]{paIdSogg, pIdPorta, pIdAsps, pIdConnettore, pConnettoreAccessoDaGruppi, pConnettoreVerificaRegistro});
                                } else {
                                    deVerificaConnettore.setValue("-");
                                }
                                deVerificaConnettore.allineaTdAlCentro();
                                e.add(deVerificaConnettore);
                            }
                            if (visualizzazioneTabs) {
                                if (this.core.isConnettoriMultipliEnabled() && (connettoreRidefinito || mapping.isDefault())) {
                                    listParametersConfigutazioneConnettoriMultipli = new ArrayList<Parameter>();
                                    listParametersConfigutazioneConnettoriMultipli.add(paIdSogg);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdPorta);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdAsps);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdTAb);
                                    listParametersConfigutazioneConnettoriMultipli.add(pConnettoreAccessoDaGruppi);
                                    listParametersConfigutazioneConnettoriMultipli.add(pConnettoreVerificaRegistro);
                                    listParametersConfigutazioneConnettoriMultipli.add(new Parameter("idConnTab", "0"));
                                    image5 = new DataElementImage();
                                    image5.setToolTip("Configurazione Connettori Multipli");
                                    image5.setImage("&#xE8B8;");
                                    image5.setUrl("porteApplicativeConnettoriMultipliConfig.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                                    de3.addImage(image5);
                                }
                            } else {
                                DataElement deConfiguraConnettoriMultipli = new DataElement();
                                if (this.core.isConnettoriMultipliEnabled() && (connettoreRidefinito || mapping.isDefault())) {
                                    deConfiguraConnettoriMultipli.setValue(this.getStatoConnettoriMultipliPortaApplicativa(paAssociata));
                                    deConfiguraConnettoriMultipli.setUrl("porteApplicativeConnettoriMultipliConfig.do", new Parameter[]{paIdSogg, pIdPorta, pIdAsps, pConnettoreAccessoDaGruppi, pConnettoreVerificaRegistro, new Parameter("idConnTab", "0")});
                                } else {
                                    deConfiguraConnettoriMultipli.setValue("-");
                                }
                                deConfiguraConnettoriMultipli.allineaTdAlCentro();
                                e.add(deConfiguraConnettoriMultipli);
                            }
                            if (visualizzazioneTabs) {
                                if (this.core.isConnettoriMultipliEnabled() && connettoreMultiploEnabled) {
                                    listParametersConfigutazioneConnettoriMultipli = new ArrayList();
                                    listParametersConfigutazioneConnettoriMultipli.add(paIdSogg);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdPorta);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdAsps);
                                    listParametersConfigutazioneConnettoriMultipli.add(pIdTAb);
                                    listParametersConfigutazioneConnettoriMultipli.add(pConnettoreAccessoDaGruppi);
                                    listParametersConfigutazioneConnettoriMultipli.add(pConnettoreVerificaRegistro);
                                    image5 = new DataElementImage();
                                    image5.setToolTip("Elenco Connettori");
                                    image5.setImage("&#xE0EE;");
                                    image5.setUrl("porteApplicativeConnettoriMultipliList.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                                    de3.addImage(image5);
                                }
                            } else {
                                DataElement deListaConnettoriMultipli = new DataElement();
                                if (this.core.isConnettoriMultipliEnabled() && connettoreMultiploEnabled) {
                                    if (contaListe) {
                                        ServletUtils.setDataElementVisualizzaLabel((DataElement)deListaConnettoriMultipli, (Long)Long.valueOf(paAssociata.sizeServizioApplicativoList()));
                                    } else {
                                        ServletUtils.setDataElementVisualizzaLabel((DataElement)deListaConnettoriMultipli);
                                    }
                                    deListaConnettoriMultipli.setUrl("porteApplicativeConnettoriMultipliList.do", new Parameter[]{paIdSogg, pIdPorta, pIdAsps, pConnettoreAccessoDaGruppi, pConnettoreVerificaRegistro});
                                } else {
                                    deListaConnettoriMultipli.setValue("-");
                                }
                                deListaConnettoriMultipli.allineaTdAlCentro();
                                e.add(deListaConnettoriMultipli);
                            }
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Controllo Accessi");
                        }
                        de.setUrl("porteApplicativeControlloAccessi.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        if (visualizzazioneTabs) {
                            this.setStatoControlloAccessiPortaApplicativa(protocollo, paAssociata, de);
                        } else {
                            String statoControlloAccessi = this.getStatoControlloAccessiPortaApplicativa(protocollo, paAssociata);
                            de.setValue(statoControlloAccessi);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image9 = new DataElementImage();
                            image9.setUrl("porteApplicativeControlloAccessi.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image9.setToolTip(MessageFormat.format("Modifica {0}", "Controllo Accessi"));
                            image9.setImage("&#xE3C9;");
                            de.setImage(image9);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Rate Limiting");
                        }
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do?CTPolicyRuoloPorta=" + RuoloPolicy.APPLICATIVA.getValue() + "&CTPolicyNomePorta=" + paAssociata.getNome() + "&CTPolicyServiceBinding=" + serviceBindingMessage.name());
                        List<AttivazionePolicy> listaPolicy = null;
                        if (contaListe || visualizzazioneTabs) {
                            ConsoleSearch searchPolicy = new ConsoleSearch(true);
                            listaPolicy = this.confCore.attivazionePolicyList(searchPolicy, RuoloPolicy.APPLICATIVA, paAssociata.getNome());
                        }
                        if (visualizzazioneTabs) {
                            this.setStatoRateLimiting(de, listaPolicy);
                        } else if (contaListe) {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(listaPolicy.size()));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image10 = new DataElementImage();
                            image10.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do", new Parameter[]{new Parameter("CTPolicyRuoloPorta", RuoloPolicy.APPLICATIVA.getValue()), new Parameter("CTPolicyNomePorta", paAssociata.getNome()), new Parameter("CTPolicyServiceBinding", serviceBindingMessage.name()), pIdTAb});
                            image10.setToolTip(MessageFormat.format("Modifica {0}", "Rate Limiting"));
                            image10.setImage("&#xE3C9;");
                            de.setImage(image10);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Validazione");
                        }
                        de.setUrl("porteApplicativeValidazioneContenuti.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        if (visualizzazioneTabs) {
                            this.setStatoValidazioneContenuti(de, paAssociata.getValidazioneContenutiApplicativi(), apc.getFormatoSpecifica());
                        } else {
                            String statoValidazione = this.getStatoValidazionePortaApplicativa(paAssociata);
                            de.setValue(statoValidazione);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image11 = new DataElementImage();
                            image11.setUrl("porteApplicativeValidazioneContenuti.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image11.setToolTip(MessageFormat.format("Modifica {0}", "Validazione"));
                            image11.setImage("&#xE3C9;");
                            de.setImage(image11);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Caching Risposta");
                        }
                        de.setUrl("porteApplicativeResponseCaching.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        if (visualizzazioneTabs) {
                            this.setStatoCachingRisposta(de, paAssociata.getResponseCaching(), configurazioneGenerale);
                        } else {
                            String statoResponseCaching = this.getStatoResponseCachingPortaApplicativa(paAssociata, false);
                            de.setValue(statoResponseCaching);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image12 = new DataElementImage();
                            image12.setUrl("porteApplicativeResponseCaching.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image12.setToolTip(MessageFormat.format("Modifica {0}", "Caching Risposta"));
                            image12.setImage("&#xE3C9;");
                            de.setImage(image12);
                        }
                        e.add(de);
                        if (visualizzaSicurezza) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Sicurezza Messaggio");
                            }
                            de.setUrl("porteApplicativeWS.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                            if (visualizzazioneTabs) {
                                this.setStatoSicurezzaMessaggio(de, paAssociata.getMessageSecurity(), configManager, propertiesSourceConfiguration);
                            } else {
                                String statoMessageSecurity = this.getStatoMessageSecurityPortaApplicativa(paAssociata);
                                de.setValue(statoMessageSecurity);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image13 = new DataElementImage();
                                image13.setUrl("porteApplicativeWS.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                image13.setToolTip(MessageFormat.format("Modifica {0}", "Sicurezza Messaggio"));
                                image13.setImage("&#xE3C9;");
                                de.setImage(image13);
                            }
                            e.add(de);
                        }
                        if (visualizzaMTOM) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("MTOM");
                            }
                            de.setUrl("porteApplicativeMTOM.do", new Parameter[]{pIdPorta, pIdSogg, pIdAsps});
                            if (visualizzazioneTabs) {
                                this.setStatoMTOM(de, paAssociata.getMtomProcessor());
                            } else {
                                String statoMTOM = this.getStatoMTOMPortaApplicativa(paAssociata);
                                de.setValue(statoMTOM);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image14 = new DataElementImage();
                                image14.setUrl("porteApplicativeMTOM.do", new Parameter[]{pIdPorta, pIdSogg, pIdAsps, pIdTAb});
                                image14.setToolTip(MessageFormat.format("Modifica {0}", "MTOM"));
                                image14.setImage("&#xE3C9;");
                                de.setImage(image14);
                            }
                            e.add(de);
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Trasformazioni");
                        }
                        de.setUrl("porteApplicativeTrasformazioniList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        if (visualizzazioneTabs) {
                            this.setStatoTrasformazioni(de, paAssociata.getTrasformazioni(), serviceBindingMessage);
                        } else if (contaListe) {
                            long size = 0L;
                            if (paAssociata.getTrasformazioni() != null) {
                                size = paAssociata.getTrasformazioni().sizeRegolaList();
                            }
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)size);
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image15 = new DataElementImage();
                            image15.setUrl("porteApplicativeTrasformazioniList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image15.setToolTip(MessageFormat.format("Modifica {0}", "Trasformazioni"));
                            image15.setImage("&#xE3C9;");
                            de.setImage(image15);
                        }
                        e.add(de);
                        if (visualizzaCorrelazione) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Tracciamento");
                            }
                            de.setUrl("porteApplicativeCorrelazioneApplicativa.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                            if (visualizzazioneTabs) {
                                this.setStatoTracciamento(de, paAssociata.getCorrelazioneApplicativa(), paAssociata.getCorrelazioneApplicativaRisposta(), paAssociata.getTracciamento(), configurazioneGenerale != null && configurazioneGenerale.getTracciamento() != null ? configurazioneGenerale.getTracciamento().getPortaApplicativa() : null, paAssociata.getProprieta(), configurazioneGenerale);
                            } else {
                                String statoTracciamento = this.getStatoTracciamentoPortaApplicativa(paAssociata);
                                de.setValue(statoTracciamento);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image16 = new DataElementImage();
                                image16.setUrl("porteApplicativeCorrelazioneApplicativa.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                image16.setToolTip(MessageFormat.format("Modifica {0}", "Tracciamento"));
                                image16.setImage("&#xE3C9;");
                                de.setImage(image16);
                            }
                            e.add(de);
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Registrazione Messaggi");
                        }
                        de.setUrl("porteApplicativeDumpConfigurazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                        if (visualizzazioneTabs) {
                            this.setStatoDump(de, paAssociata.getDump(), configurazioneGenerale, true);
                        } else {
                            String statoDump = this.getStatoDumpPortaApplicativa(paAssociata, false);
                            de.setValue(statoDump);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image17 = new DataElementImage();
                            image17.setUrl("porteApplicativeDumpConfigurazione.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                            image17.setToolTip(MessageFormat.format("Modifica {0}", "Registrazione Messaggi"));
                            image17.setImage("&#xE3C9;");
                            de.setImage(image17);
                        }
                        e.add(de);
                        if (visualizzaAllarmi) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Allarmi");
                            }
                            de.setUrl("configurazioneAllarmiList.do?allRuoloPorta=" + RuoloPorta.APPLICATIVA.getValue() + "&allNomePorta=" + paAssociata.getNome() + "&allServiceBinding=" + serviceBindingMessage.name());
                            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                            if (contaListe || visualizzazioneTabs) {
                                ConsoleSearch searchPolicy = new ConsoleSearch(true);
                                listaAllarmi = this.confCore.allarmiList(searchPolicy, RuoloPorta.APPLICATIVA, paAssociata.getNome());
                            }
                            if (visualizzazioneTabs) {
                                this.setStatoAllarmi(de, listaAllarmi);
                            } else if (contaListe) {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(listaAllarmi.size()));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                image = new DataElementImage();
                                image.setUrl("configurazioneAllarmiList.do", new Parameter[]{new Parameter("allRuoloPorta", RuoloPorta.APPLICATIVA.getValue()), new Parameter("allNomePorta", paAssociata.getNome()), new Parameter("allServiceBinding", serviceBindingMessage.name()), pIdTAb});
                                image.setToolTip(MessageFormat.format("Modifica {0}", "Allarmi"));
                                image.setImage("&#xE3C9;");
                                de.setImage(image);
                            }
                            e.add(de);
                        }
                        if (this.isModalitaAvanzata() || this.apsCore.isProprietaErogazioniShowModalitaStandard()) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Propriet&agrave;");
                            }
                            de.setUrl("porteApplicativeProprietaProtocolloList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps});
                            if (visualizzazioneTabs) {
                                this.setStatoProprieta(de, paAssociata.sizeProprietaList());
                            } else if (contaListe) {
                                int numProp = paAssociata.sizeProprietaList();
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numProp));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image18 = new DataElementImage();
                                image18.setUrl("porteApplicativeProprietaProtocolloList.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pIdTAb});
                                image18.setToolTip(MessageFormat.format("Modifica {0}", "Propriet&agrave;"));
                                image18.setImage("&#xE3C9;");
                                de.setImage(image18);
                            }
                            e.add(de);
                        }
                        if (this.isModalitaAvanzata()) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Opzioni Avanzate");
                            }
                            de.setUrl("porteApplicativeChange.do", new Parameter[]{pIdSogg, pNomePorta, pIdPorta, pIdAsps, pConfigurazioneAltroPorta});
                            if (visualizzazioneTabs) {
                                String behaviour = !this.core.isConnettoriMultipliEnabled() && paAssociata.getBehaviour() != null ? paAssociata.getBehaviour().getNome() : null;
                                this.setStatoOpzioniAvanzate(de, protocollo, serviceBindingMessage, paAssociata.getAllegaBody(), paAssociata.getScartaBody(), paAssociata.getIntegrazione(), behaviour, paAssociata.getProprietaRateLimitingList(), paAssociata.getStateless(), null, paAssociata.getRicevutaAsincronaSimmetrica(), paAssociata.getRicevutaAsincronaAsimmetrica(), paAssociata.getGestioneManifest(), paAssociata.getConfigurazioneHandler());
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image19 = new DataElementImage();
                                image19.setUrl("porteApplicativeChange.do", new Parameter[]{pIdSogg, pIdPorta, pIdAsps, pConfigurazioneAltroPorta, pIdTAb});
                                image19.setToolTip(MessageFormat.format("Modifica {0}", "Opzioni Avanzate"));
                                image19.setImage("&#xE3C9;");
                                de.setImage(image19);
                            }
                            e.add(de);
                        }
                        if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel(extendedServletList.getListTitle(this));
                            }
                            de.setUrl("porteApplicativeExtendedList.do", new Parameter[]{pIdPorta, pIdSogg, pNomePorta, pIdAsps, pConfigurazioneAltroPorta});
                            if (visualizzazioneTabs) {
                                int numExtended = extendedServletList.sizeList(paAssociata);
                                String stato = extendedServletList.getStatoTab(this, paAssociata, mapping.isDefault());
                                String statoTooltip = extendedServletList.getStatoTab(this, paAssociata, mapping.isDefault());
                                this.setStatoExtendedList(de, numExtended, stato, statoTooltip);
                            } else if (contaListe) {
                                int numExtended = extendedServletList.sizeList(paAssociata);
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numExtended));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image20 = new DataElementImage();
                                image20.setUrl("porteApplicativeExtendedList.do", new Parameter[]{pIdPorta, pIdSogg, pNomePorta, pIdAsps, pConfigurazioneAltroPorta, pIdTAb});
                                image20.setToolTip(MessageFormat.format("Modifica {0}", extendedServletList.getListTitle(this)));
                                image20.setImage("&#xE3C9;");
                                de.setImage(image20);
                            }
                            e.add(de);
                        }
                        if (visualizzazioneTabs) {
                            this.addProprietaOggetto(e, paAssociata.getProprietaOggetto());
                        }
                    }
                    dati.add(e);
                    ++idTab;
                }
            }
            this.pd.setDati(dati);
            if (visualizzazioneTabs) {
                this.pd.setSelect(true);
                if (showBottoneAggiungiNuovaConfigurazione) {
                    this.pd.setAddButton(true);
                } else {
                    this.pd.setAddButton(false);
                }
                if (lista.size() > 1) {
                    this.pd.setRemoveButton(true);
                } else {
                    this.pd.setRemoveButton(false);
                }
            } else if (gestioneGruppi) {
                if (listaSenzaFiltro != null && listaSenzaFiltro.size() > 1) {
                    this.pd.setRemoveButton(true);
                    this.pd.setSelect(true);
                } else {
                    this.pd.setRemoveButton(false);
                    this.pd.setSelect(false);
                }
                this.pd.setAddButton(true);
            } else {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    private MappingErogazionePortaApplicativa getFiltroAzioneMappingErogazione(String filtroAzione, List<MappingErogazionePortaApplicativa> lista) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (StringUtils.isNotEmpty((CharSequence)filtroAzione) && !filtroAzione.equals("")) {
            MappingErogazionePortaApplicativa mappingTmp = null;
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : lista) {
                PortaApplicativa paAssociata = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                if (paAssociata.getAzione() == null || !paAssociata.getAzione().getAzioneDelegataList().contains(filtroAzione)) continue;
                mappingTmp = mappingErogazionePortaApplicativa;
                break;
            }
            if (mappingTmp == null) {
                for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : lista) {
                    if (!mappingErogazionePortaApplicativa.isDefault()) continue;
                    mappingTmp = mappingErogazionePortaApplicativa;
                    break;
                }
            }
            return mappingTmp;
        }
        return null;
    }

    private List<MappingErogazionePortaApplicativa> impostaFiltroAzioneMappingErogazione(String filtroAzione, List<MappingErogazionePortaApplicativa> lista, ISearch ricerca, int idLista) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        MappingErogazionePortaApplicativa mapping = this.getFiltroAzioneMappingErogazione(filtroAzione, lista);
        if (mapping != null) {
            ArrayList<MappingErogazionePortaApplicativa> newList = new ArrayList<MappingErogazionePortaApplicativa>();
            newList.add(mapping);
            this.pd.setNumEntries(1);
            return newList;
        }
        this.pd.setNumEntries(ricerca.getNumEntries(idLista));
        return lista;
    }

    public boolean allActionsRedefinedMappingErogazionePaAssociate(List<String> azioni, List<PortaApplicativa> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean all = true;
        if (azioni != null && azioni.size() > 0) {
            for (String azione : azioni) {
                if (lista == null || lista.size() <= 0) {
                    all = false;
                    break;
                }
                boolean found = false;
                for (PortaApplicativa paAssociata : lista) {
                    if (paAssociata.getAzione() == null || !paAssociata.getAzione().getAzioneDelegataList().contains(azione)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                all = false;
                break;
            }
        }
        return all;
    }

    private MappingFruizionePortaDelegata getFiltroAzioneMappingFruizione(String filtroAzione, List<MappingFruizionePortaDelegata> lista) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (StringUtils.isNotEmpty((CharSequence)filtroAzione) && !filtroAzione.equals("")) {
            MappingFruizionePortaDelegata mappingTmp = null;
            for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : lista) {
                PortaDelegata pdAssociata = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                if (pdAssociata.getAzione() == null || !pdAssociata.getAzione().getAzioneDelegataList().contains(filtroAzione)) continue;
                mappingTmp = mappingFruizionePortaDelegata;
                break;
            }
            if (mappingTmp == null) {
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : lista) {
                    if (!mappingFruizionePortaDelegata.isDefault()) continue;
                    mappingTmp = mappingFruizionePortaDelegata;
                    break;
                }
            }
            return mappingTmp;
        }
        return null;
    }

    private List<MappingFruizionePortaDelegata> impostaFiltroAzioneMappingFruizione(String filtroAzione, List<MappingFruizionePortaDelegata> lista, ISearch ricerca, int idLista) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        MappingFruizionePortaDelegata mappingTmp = this.getFiltroAzioneMappingFruizione(filtroAzione, lista);
        if (mappingTmp != null) {
            ArrayList<MappingFruizionePortaDelegata> newList = new ArrayList<MappingFruizionePortaDelegata>();
            newList.add(mappingTmp);
            this.pd.setNumEntries(1);
            return newList;
        }
        this.pd.setNumEntries(ricerca.getNumEntries(idLista));
        return lista;
    }

    public List<String> getAllActionsNotRedefinedMappingFruizione(List<String> azioni, List<MappingFruizionePortaDelegata> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<String> l = new ArrayList<String>();
        if (lista == null || lista.size() <= 0) {
            return azioni;
        }
        l.addAll(azioni);
        for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : lista) {
            PortaDelegata pdAssociata = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
            if (pdAssociata.getAzione() == null || pdAssociata.getAzione().getAzioneDelegataList().isEmpty()) continue;
            for (String azPA : pdAssociata.getAzione().getAzioneDelegataList()) {
                l.remove(azPA);
            }
        }
        return l;
    }

    public boolean allActionsRedefinedMappingFruizione(List<String> azioni, List<MappingFruizionePortaDelegata> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean all = true;
        if (azioni != null && azioni.size() > 0) {
            for (String azione : azioni) {
                if (lista == null || lista.size() <= 0) {
                    all = false;
                    break;
                }
                boolean found = false;
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : lista) {
                    PortaDelegata pdAssociata = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                    if (pdAssociata.getAzione() == null || !pdAssociata.getAzione().getAzioneDelegataList().contains(azione)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                all = false;
                break;
            }
        }
        return all;
    }

    public boolean allActionsRedefinedMappingFruizionePdAssociate(List<String> azioni, List<PortaDelegata> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean all = true;
        if (azioni != null && azioni.size() > 0) {
            for (String azione : azioni) {
                if (lista == null || lista.size() <= 0) {
                    all = false;
                    break;
                }
                boolean found = false;
                for (PortaDelegata pdAssociata : lista) {
                    if (pdAssociata.getAzione() == null || !pdAssociata.getAzione().getAzioneDelegataList().contains(azione)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                all = false;
                break;
            }
        }
        return all;
    }

    public void serviziFruitoriPorteDelegateList(List<PortaDelegata> lista, String idServizio, String idSoggettoFruitore, String idFruzione, ISearch ricerca) throws Exception {
        try {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecificaFruitoriPorteDelegate", (Parameter[])new Parameter[]{new Parameter("id", idServizio), new Parameter("idsogg", idSoggettoFruitore), new Parameter("myId", idFruzione)});
            IExtendedListServlet extendedServletList = this.core.getExtendedServletPortaDelegata();
            int idLista = Liste.SERVIZI_FRUITORI_PORTE_DELEGATE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idServizio));
            Soggetto soggFruitore = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idSoggettoFruitore));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggFruitore.getTipo());
            String servizioTmpTile = asps.getTipoSoggettoErogatore() + "/" + asps.getNomeSoggettoErogatore() + "-" + asps.getTipo() + "/" + asps.getNome();
            Parameter pIdServizio = new Parameter("id", idServizio);
            Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
            Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
            String fruitoreTmpTile = "Fruitore " + soggFruitore.getTipo() + "/" + soggFruitore.getNome();
            Parameter pIdFruitore = new Parameter("myId", idFruzione);
            ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
            lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
            lstParm.add(new Parameter(servizioTmpTile, "accordiServizioParteSpecificaChange.do", new Parameter[]{pIdServizio, pNomeServizio, pTipoServizio}));
            lstParm.add(new Parameter(fruitoreTmpTile, "accordiServizioParteSpecificaFruitoriChange.do", new Parameter[]{pIdServizio, pIdFruitore}));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParm.add(new Parameter("Configurazione", null));
            } else {
                lstParm.add(new Parameter("Configurazione", "accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{new Parameter("id", idServizio), new Parameter("idsogg", idSoggettoFruitore)}));
                lstParm.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Configurazioni", (String)search);
            }
            ArrayList<String> listaLabel = new ArrayList<String>();
            listaLabel.add("Nome");
            listaLabel.add("Servizi Applicativi");
            listaLabel.add("Ruoli");
            listaLabel.add("Sicurezza Messaggio");
            listaLabel.add("MTOM");
            listaLabel.add("Correlazione applicativa<BR/>Richiesta");
            listaLabel.add("Correlazione applicativa<BR/>Risposta");
            if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                listaLabel.add(extendedServletList.getListTitle(this));
            }
            String[] labels = listaLabel.toArray(new String[listaLabel.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            Iterator<PortaDelegata> it = lista.iterator();
            PortaDelegata pd = null;
            while (it.hasNext()) {
                int numSA;
                pd = it.next();
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setValue("" + pd.getId());
                e.add(de);
                de = new DataElement();
                de.setUrl("porteDelegateChange.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("nomePorta", pd.getNome()), new Parameter("id", "" + pd.getId())});
                de.setValue(pd.getNome());
                de.setIdToRemove(pd.getId().toString());
                de.setToolTip(pd.getDescrizione());
                e.add(de);
                de = new DataElement();
                if (TipoAutorizzazione.isAuthenticationRequired((String)pd.getAutorizzazione()) || !TipoAutorizzazione.getAllValues().contains(pd.getAutorizzazione())) {
                    de.setUrl("porteDelegateServizioApplicativoList.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                    if (contaListe.booleanValue()) {
                        numSA = pd.sizeServizioApplicativoList();
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSA));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                } else {
                    de.setValue("-");
                }
                e.add(de);
                de = new DataElement();
                if (TipoAutorizzazione.isRolesRequired((String)pd.getAutorizzazione()) || !TipoAutorizzazione.getAllValues().contains(pd.getAutorizzazione())) {
                    de.setUrl("porteDelegateRuoliList.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                    if (contaListe.booleanValue()) {
                        numSA = 0;
                        if (pd.getRuoli() != null) {
                            numSA = pd.getRuoli().sizeRuoloList();
                        }
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSA));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                } else {
                    de.setValue("-");
                }
                e.add(de);
                de = new DataElement();
                de.setUrl("porteDelegateWS.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                de.setValue(pd.getStatoMessageSecurity());
                e.add(de);
                de = new DataElement();
                de.setUrl("porteDelegateMTOM.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                boolean isMTOMAbilitatoReq = false;
                boolean isMTOMAbilitatoRes = false;
                if (pd.getMtomProcessor() != null) {
                    MTOMProcessorType mode;
                    if (pd.getMtomProcessor().getRequestFlow() != null && pd.getMtomProcessor().getRequestFlow().getMode() != null && !(mode = pd.getMtomProcessor().getRequestFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                        isMTOMAbilitatoReq = true;
                    }
                    if (pd.getMtomProcessor().getResponseFlow() != null && pd.getMtomProcessor().getResponseFlow().getMode() != null && !(mode = pd.getMtomProcessor().getResponseFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                        isMTOMAbilitatoRes = true;
                    }
                }
                if (isMTOMAbilitatoReq || isMTOMAbilitatoRes) {
                    de.setValue("abilitato");
                } else {
                    de.setValue("disabilitato");
                }
                e.add(de);
                de = new DataElement();
                de.setUrl("porteDelegateCorrelazioneApplicativaRequestList.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                if (contaListe.booleanValue()) {
                    int numCorrelazione = 0;
                    if (pd.getCorrelazioneApplicativa() != null) {
                        numCorrelazione = pd.getCorrelazioneApplicativa().sizeElementoList();
                    }
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numCorrelazione));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                de = new DataElement();
                de.setUrl("porteDelegateCorrelazioneApplicativaResponseList.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                if (contaListe.booleanValue()) {
                    int numCorrelazione = 0;
                    if (pd.getCorrelazioneApplicativaRisposta() != null) {
                        numCorrelazione = pd.getCorrelazioneApplicativaRisposta().sizeElementoList();
                    }
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numCorrelazione));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                    de = new DataElement();
                    de.setUrl("porteDelegateExtendedList.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("id", "" + pd.getId())});
                    if (contaListe.booleanValue()) {
                        int numExtended = extendedServletList.sizeList(pd);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numExtended));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                }
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void serviziFruitoriMappingList(List<MappingFruizionePortaDelegata> listaParam, String idServizio, String idSoggFruitoreDelServizio, IDSoggetto idSoggettoFruitore, String idFruzione, ISearch ricerca) throws Exception {
        try {
            boolean chooseTabWithFilter;
            boolean showBottoneAggiungiNuovaConfigurazione;
            boolean visualizzazioneTabs;
            Boolean contaListeObject = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            boolean contaListe = contaListeObject != null ? contaListeObject : false;
            Parameter parametroTipoSoggettoFruitore = new Parameter("tipoSoggFru", idSoggettoFruitore.getTipo());
            Parameter parametroNomeSoggettoFruitore = new Parameter("nomeSoggFru", idSoggettoFruitore.getNome());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteSpecificaFruitoriPorteDelegate", (Parameter[])new Parameter[]{new Parameter("id", idServizio), new Parameter("idsogg", idSoggFruitoreDelServizio), new Parameter("myId", idFruzione)});
            IExtendedListServlet extendedServletList = this.core.getExtendedServletPortaDelegata();
            int idLista = Liste.CONFIGURAZIONE_FRUIZIONE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            if (tipologia != null && "fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            }
            boolean gestioneGruppi = true;
            String paramGestioneGruppi = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"gestioneGruppi");
            if (paramGestioneGruppi != null && !"".equals(paramGestioneGruppi)) {
                gestioneGruppi = Boolean.valueOf(paramGestioneGruppi);
            }
            boolean gestioneConfigurazioni = true;
            String paramGestioneConfigurazioni = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"gestioneConfigurazioni");
            if (paramGestioneConfigurazioni != null && !"".equals(paramGestioneConfigurazioni)) {
                gestioneConfigurazioni = Boolean.valueOf(paramGestioneConfigurazioni);
            }
            boolean bl = visualizzazioneTabs = !this.isModalitaCompleta();
            if (visualizzazioneTabs) {
                gestioneGruppi = false;
                this.pd.setCustomListViewName("configurazione");
            }
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idServizio));
            AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
            ServiceBinding serviceBinding = apc.getServiceBinding();
            org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage = this.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            Map<String, String> azioni = this.porteApplicativeCore.getAzioniConLabel(asps, apc, false, true, new ArrayList<String>());
            String filtroAzione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroAzione");
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setSearch("");
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
            List<MappingFruizionePortaDelegata> listaSenzaFiltro = this.impostaFiltroAzioneMappingFruizione(null, listaParam, ricerca, idLista);
            boolean bl2 = showBottoneAggiungiNuovaConfigurazione = azioni != null && azioni.size() > 1 || listaSenzaFiltro.size() > 1;
            if (showBottoneAggiungiNuovaConfigurazione) {
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : listaParam) {
                    if (!mappingFruizionePortaDelegata.isDefault()) continue;
                    PortaDelegata pdDefaullt = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                    if (pdDefaullt.getAzione() == null || !PortaDelegataAzioneIdentificazione.STATIC.equals((Object)pdDefaullt.getAzione().getIdentificazione())) break;
                    showBottoneAggiungiNuovaConfigurazione = false;
                    break;
                }
            }
            List<MappingFruizionePortaDelegata> lista = null;
            boolean bl3 = chooseTabWithFilter = !this.isModalitaCompleta();
            if (chooseTabWithFilter) {
                lista = listaSenzaFiltro;
                if (lista.size() > 1) {
                    MappingFruizionePortaDelegata mappingContenenteAzione = this.getFiltroAzioneMappingFruizione(filtroAzione, listaParam);
                    if (mappingContenenteAzione != null) {
                        int tab = -1;
                        for (int i = 0; i < lista.size(); ++i) {
                            if (!lista.get(i).getNome().equals(mappingContenenteAzione.getNome())) continue;
                            tab = i;
                            break;
                        }
                        if (tab >= 0) {
                            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)("" + tab), (String)"idTab");
                        }
                    }
                    this.pd.setLabelBottoneFiltra("Individua Gruppo");
                }
            } else {
                lista = this.impostaFiltroAzioneMappingFruizione(filtroAzione, listaParam, ricerca, idLista);
            }
            boolean allActionRedefined = false;
            List<String> actionNonRidefinite = null;
            if (listaSenzaFiltro != null && listaSenzaFiltro.size() > 1) {
                ArrayList<String> azioniL = new ArrayList<String>();
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                if (!(allActionRedefined = this.allActionsRedefinedMappingFruizione(azioniL, listaSenzaFiltro))) {
                    actionNonRidefinite = this.getAllActionsNotRedefinedMappingFruizione(azioniL, listaSenzaFiltro);
                }
            }
            if (!gestioneGruppi && listaParam.size() <= 1) {
                ServletUtils.disabledPageDataSearch((PageData)this.pd);
            } else {
                this.addFilterAzione(azioni, filtroAzione, serviceBindingMessage);
            }
            boolean visualizzaAllarmi = this.confCore.isVisualizzaConfigurazioneAllarmiEnabled();
            boolean visualizzaMTOM = true;
            boolean visualizzaSicurezza = true;
            boolean visualizzaCorrelazione = true;
            switch (serviceBinding) {
                case REST: {
                    visualizzaMTOM = false;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                    break;
                }
                default: {
                    visualizzaMTOM = true;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                }
            }
            Soggetto soggFruitore = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idSoggFruitoreDelServizio));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggFruitore.getTipo());
            String servizioTmpTile = this.getLabelIdServizio(asps);
            if (gestioneFruitori) {
                servizioTmpTile = this.getLabelServizioFruizione(protocollo, idSoggettoFruitore, asps);
            }
            Parameter pIdServizio = new Parameter("id", idServizio);
            Parameter pIdAsps = new Parameter("idAsps", idServizio);
            Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
            String fruitoreTmpTile = this.getLabelNomeSoggetto(protocollo, soggFruitore.getTipo(), soggFruitore.getNome());
            Fruitore fru = null;
            if (gestioneFruitori) {
                for (Fruitore fruCheck : asps.getFruitoreList()) {
                    if (!fruCheck.getTipo().equals(idSoggettoFruitore.getTipo()) || !fruCheck.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    fru = fruCheck;
                    break;
                }
            } else {
                for (Fruitore fruCheck : asps.getFruitoreList()) {
                    if (!fruCheck.getTipo().equals(soggFruitore.getTipo()) || !fruCheck.getNome().equals(soggFruitore.getNome())) continue;
                    fru = fruCheck;
                    break;
                }
            }
            Parameter pIdFruitore = new Parameter("myId", idFruzione);
            boolean showConnettoreLink = true;
            if (gestioneConfigurazioni && this.isModalitaStandard()) {
                showConnettoreLink = false;
                Iterator<MappingFruizionePortaDelegata> it = lista.iterator();
                MappingFruizionePortaDelegata mapping = null;
                while (it.hasNext()) {
                    mapping = it.next();
                    if (mapping.isDefault()) continue;
                    PortaDelegata pdAssociata = this.porteDelegateCore.getPortaDelegata(mapping.getIdPortaDelegata());
                    List listaAzioniPDAssociataMappingNonDefault = pdAssociata.getAzione().getAzioneDelegataList();
                    String azioneConnettore = null;
                    if (listaAzioniPDAssociataMappingNonDefault != null && !listaAzioniPDAssociataMappingNonDefault.isEmpty()) {
                        azioneConnettore = (String)listaAzioniPDAssociataMappingNonDefault.get(0);
                    }
                    boolean ridefinito = false;
                    if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                        for (ConfigurazioneServizioAzione check : fru.getConfigurazioneAzioneList()) {
                            if (!check.getAzioneList().contains(azioneConnettore)) continue;
                            ridefinito = true;
                            break;
                        }
                    }
                    if (!ridefinito) continue;
                    showConnettoreLink = true;
                    break;
                }
            } else {
                showConnettoreLink = lista != null && lista.size() > 1;
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
            Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
            Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
            String labelAzioni = this.getLabelAzioni(serviceBindingMessage);
            if (gestioneFruitori) {
                if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                    lstParam.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
                    lstParam.add(new Parameter(servizioTmpTile, "aspsErogazioniChange.do", new Parameter[]{pIdServizio, pNomeServizio, pTipoServizio, parametroTipoSoggettoFruitore, parametroNomeSoggettoFruitore}));
                    String labelConfigurazione = gestioneConfigurazioni ? "Configurazione" : (gestioneGruppi ? MessageFormat.format("Gruppi", labelAzioni) : "Configurazione");
                    lstParam.add(new Parameter(labelConfigurazione, null));
                } else {
                    lstParam.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
                    lstParam.add(new Parameter(servizioTmpTile, null));
                }
            } else {
                lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                lstParam.add(new Parameter("Fruizioni di " + servizioTmpTile, "accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{pIdServizio, pIdSoggettoErogatore}));
                lstParam.add(new Parameter(fruitoreTmpTile, null));
            }
            this.pd.setSearchLabel("Nome");
            this.pd.setSearchDescription("");
            boolean connettoreStatic = false;
            if (gestioneFruitori) {
                connettoreStatic = this.apsCore.isConnettoreStatic(protocollo);
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            ArrayList<Object> listaLabel = new ArrayList<Object>();
            if (visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                listaLabel.add("Nome Gruppo");
            }
            if (gestioneConfigurazioni) {
                listaLabel.add("");
            }
            if (!visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                listaLabel.add("Nome Gruppo");
            }
            if (gestioneGruppi || visualizzazioneTabs) {
                if (this.isModalitaCompleta()) {
                    listaLabel.add(labelAzioni);
                } else {
                    listaLabel.add("Elenco " + labelAzioni);
                }
            }
            if (gestioneConfigurazioni) {
                if (showConnettoreLink && !connettoreStatic) {
                    listaLabel.add("Connettore");
                    listaLabel.add("Verifica Connettivit\u00e0 Connettore");
                }
                listaLabel.add("Controllo Accessi");
                listaLabel.add("Rate Limiting");
                listaLabel.add("Validazione");
                listaLabel.add("Caching Risposta");
                if (visualizzaSicurezza) {
                    listaLabel.add("Sicurezza Messaggio");
                }
                if (visualizzaMTOM) {
                    listaLabel.add("MTOM");
                }
                listaLabel.add("Trasformazioni");
                if (visualizzaCorrelazione) {
                    listaLabel.add("Tracciamento");
                }
                listaLabel.add("Registrazione Messaggi");
                if (this.isModalitaAvanzata() || this.porteDelegateCore.isProprietaFruizioniShowModalitaStandard()) {
                    listaLabel.add("Propriet&agrave;");
                }
                if (this.isModalitaAvanzata()) {
                    listaLabel.add("Opzioni Avanzate");
                }
                if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                    listaLabel.add(extendedServletList.getListTitle(this));
                }
            }
            String[] labels = listaLabel.toArray(new String[listaLabel.size()]);
            this.pd.setLabels(labels);
            PropertiesSourceConfiguration propertiesSourceConfiguration = null;
            ConfigManager configManager = null;
            Configurazione configurazioneGenerale = null;
            if (visualizzazioneTabs) {
                propertiesSourceConfiguration = this.apsCore.getMessageSecurityPropertiesSourceConfiguration();
                configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
                configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
                configurazioneGenerale = this.confCore.getConfigurazioneGenerale();
            }
            this.impostaComandiMenuContestualePD(idSoggFruitoreDelServizio, parametroTipoSoggettoFruitore, parametroNomeSoggettoFruitore, asps, protocollo, pIdSoggettoErogatore, fru, pIdFruitore, pNomeServizio, pTipoServizio);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                Iterator<MappingFruizionePortaDelegata> it = lista.iterator();
                MappingFruizionePortaDelegata mapping = null;
                int idTab = 0;
                while (it.hasNext()) {
                    DataElementImage image;
                    Parameter pAbilita;
                    DataElement de;
                    boolean descrizioneEmpty;
                    mapping = it.next();
                    PortaDelegata pdAssociata = this.porteDelegateCore.getPortaDelegata(mapping.getIdPortaDelegata());
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pIdPD = new Parameter("id", "" + pdAssociata.getId());
                    Parameter pNomePD = new Parameter("nomePorta", pdAssociata.getNome());
                    Parameter pIdSoggPD = new Parameter("idsogg", "" + pdAssociata.getIdSoggetto());
                    Parameter pIdTAb = new Parameter("idTab", "" + idTab);
                    Parameter pConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
                    Parameter pConfigurazioneAltroPorta = new Parameter("configurazioneAltroPorta", "true");
                    Parameter pConfigurazioneDescrizione = new Parameter("configurazioneDescrizione", "true");
                    List listaAzioniPDAssociataMappingNonDefault = null;
                    if (!mapping.isDefault()) {
                        listaAzioniPDAssociataMappingNonDefault = pdAssociata.getAzione().getAzioneDelegataList();
                    }
                    if (gestioneConfigurazioni && mapping.isDefault() && allActionRedefined && !showConnettoreLink) {
                        int numEntries = ricerca.getNumEntries(idLista);
                        ricerca.setNumEntries(idLista, numEntries - 1);
                        this.pd.setNumEntries(numEntries - 1);
                        continue;
                    }
                    boolean statoPD = pdAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    String statoPDallRedefined = null;
                    String statoMapping = statoPD ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                    boolean urlCambiaStato = true;
                    if (mapping.isDefault() && allActionRedefined) {
                        statoPD = false;
                        statoPDallRedefined = "off";
                        statoMapping = this.getLabelAllAzioniRidefiniteTooltip(serviceBindingMessage);
                        urlCambiaStato = false;
                    }
                    boolean bl4 = descrizioneEmpty = pdAssociata.getDescrizione() == null || StringUtils.isEmpty((CharSequence)pdAssociata.getDescrizione()) || SubscriptionConfiguration.isDescriptionDefault((String)pdAssociata.getDescrizione());
                    if (visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                        DataElementImage image2;
                        de = new DataElement();
                        de.setWidthPx(10);
                        de.setType(DataElementType.CHECKBOX);
                        de.setStatusToolTip(statoPD ? "Configurazione abilitata" : "Configurazione disabilitata");
                        if (statoPDallRedefined != null) {
                            de.setStatusType(statoPDallRedefined);
                        } else {
                            de.setStatusType(statoPD ? CheckboxStatusType.ABILITATO : CheckboxStatusType.DISABILITATO);
                        }
                        de.setLabel("Nome Gruppo");
                        de.setValue(mapping.getDescrizione());
                        de.setStatusValue(mapping.getDescrizione());
                        if (!mapping.isDefault()) {
                            image2 = new DataElementImage();
                            image2.setUrl("porteDelegateConfigurazioneChange.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image2.setToolTip(MessageFormat.format("Modifica {0}", "Nome Gruppo"));
                            image2.setImage("&#xE3C9;");
                            de.addImage(image2);
                        }
                        if (!mapping.isDefault()) {
                            de.setIdToRemove(pdAssociata.getNome());
                        }
                        if (descrizioneEmpty) {
                            image2 = new DataElementImage();
                            image2.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneDescrizione, pIdTAb});
                            image2.setToolTip(MessageFormat.format("Aggiungi {0}", "Descrizione"));
                            image2.setImage("&#xE873;");
                            de.addImage(image2);
                        }
                        if (urlCambiaStato) {
                            pAbilita = new Parameter("abilita", statoPD ? "no" : "true");
                            de.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita});
                            image = new DataElementImage();
                            image.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita, pIdTAb});
                            image.setToolTip(statoMapping);
                            image.setImage(statoPD ? "&#xE9F6;" : "&#xE9F5;");
                            de.addImage(image);
                        }
                        e.add(de);
                    }
                    if (gestioneConfigurazioni && !visualizzazioneTabs) {
                        de = new DataElement();
                        de.setWidthPx(10);
                        de.setType(DataElementType.CHECKBOX);
                        de.setToolTip(statoMapping);
                        if (statoPDallRedefined != null) {
                            de.setSelected(statoPDallRedefined);
                        } else {
                            de.setSelected(statoPD);
                        }
                        if (urlCambiaStato) {
                            pAbilita = new Parameter("abilita", statoPD ? "no" : "true");
                            de.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita});
                            image = new DataElementImage();
                            image.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita, pIdTAb});
                            image.setToolTip(statoMapping);
                            image.setImage(statoPD ? "&#xE9F6;" : "&#xE9F5;");
                            de.setImage(image);
                        }
                        e.add(de);
                    }
                    if (!visualizzazioneTabs && (gestioneGruppi || listaParam.size() > 1)) {
                        de = new DataElement();
                        de.setValue(mapping.getDescrizione());
                        if (gestioneGruppi && !mapping.isDefault()) {
                            de.setUrl("porteDelegateConfigurazioneChange.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        }
                        e.add(de);
                    }
                    if (gestioneGruppi || visualizzazioneTabs && (listaParam.size() > 1 || !mapping.isDefault())) {
                        List listaAzioni = null;
                        String nomiAzioni = null;
                        long countAzioni = 0L;
                        if (!mapping.isDefault()) {
                            List list = listaAzioni = listaAzioniPDAssociataMappingNonDefault != null ? listaAzioniPDAssociataMappingNonDefault : new ArrayList();
                            if (!listaAzioni.isEmpty() && azioni.size() > 0) {
                                StringBuilder sb = new StringBuilder();
                                for (String idAzione : azioni.keySet()) {
                                    if (!listaAzioni.contains(idAzione)) continue;
                                    if (sb.length() > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(azioni.get(idAzione));
                                    ++countAzioni;
                                }
                                nomiAzioni = sb.toString();
                            }
                        }
                        DataElement de2 = new DataElement();
                        de2.setSize(200);
                        de2.setIdToRemove(pdAssociata.getNome());
                        if (visualizzazioneTabs) {
                            de2.setLabel("Elenco " + labelAzioni);
                        }
                        if (listaSenzaFiltro.size() > 1) {
                            DataElementImage image3 = new DataElementImage();
                            if (!mapping.isDefault()) {
                                de2.setUrl("porteDelegateAzioneList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                                if (this.isModalitaCompleta()) {
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de2, (Long)countAzioni);
                                } else {
                                    de2.setValue(nomiAzioni);
                                }
                                de2.setToolTip(nomiAzioni);
                                image3.setUrl("porteDelegateAzioneList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                image3.setToolTip(MessageFormat.format("Modifica {0}", "Elenco " + labelAzioni));
                                image3.setImage("&#xE3C9;");
                                de2.setImage(image3);
                            } else if (actionNonRidefinite != null && !actionNonRidefinite.isEmpty() && azioni.size() > 0) {
                                long countAzioniRidefinite = 0L;
                                StringBuilder sb = new StringBuilder();
                                for (String idAzione : azioni.keySet()) {
                                    if (!actionNonRidefinite.contains(idAzione)) continue;
                                    if (sb.length() > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(azioni.get(idAzione));
                                    ++countAzioniRidefinite;
                                }
                                String nomiAzioniNonRidefinite = sb.toString();
                                de2.setUrl("porteDelegateAzioneList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                                if (this.isModalitaCompleta()) {
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de2, (Long)countAzioniRidefinite);
                                } else {
                                    de2.setValue(nomiAzioniNonRidefinite);
                                }
                                de2.setToolTip(nomiAzioniNonRidefinite);
                                image3.setUrl("porteDelegateAzioneList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                image3.setToolTip(MessageFormat.format("Modifica {0}", "Elenco " + labelAzioni));
                                image3.setImage("&#xE3C9;");
                                de2.setImage(image3);
                            } else if (allActionRedefined) {
                                de2.setValue(this.getLabelAllAzioniRidefiniteTooltip(serviceBindingMessage));
                            } else {
                                de2.setValue("-");
                            }
                        } else if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                            de2.setValue("Tutte le azioni dell'API");
                        } else {
                            de2.setValue("Tutte le risorse dell'API");
                        }
                        e.add(de2);
                    }
                    if (!descrizioneEmpty) {
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Descrizione");
                        }
                        de.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneDescrizione, pIdTAb});
                        int length = 150;
                        Object descrizione = pdAssociata.getDescrizione();
                        if (descrizione != null && ((String)descrizione).length() > length) {
                            descrizione = ((String)descrizione).substring(0, length - 4) + " ...";
                        }
                        de.setValue(descrizione != null ? StringEscapeUtils.escapeHtml4((String)descrizione) : null);
                        de.setToolTip(pdAssociata.getDescrizione());
                        de.setCopyToClipboard(pdAssociata.getDescrizione());
                        if (visualizzazioneTabs) {
                            DataElementImage image4 = new DataElementImage();
                            image4.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneDescrizione, pIdTAb});
                            image4.setToolTip(MessageFormat.format("Modifica {0}", "Descrizione"));
                            image4.setImage("&#xE3C9;");
                            de.setImage(image4);
                        }
                        e.add(de);
                    }
                    if (gestioneConfigurazioni) {
                        if (showConnettoreLink && !connettoreStatic) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Connettore");
                            }
                            boolean ridefinito = false;
                            Connettore connettore = null;
                            if (!gestioneFruitori && mapping.isDefault()) {
                                de.setValue("-");
                            } else {
                                Long idSoggettoLong = fru.getIdSoggetto();
                                if (idSoggettoLong == null) {
                                    idSoggettoLong = this.soggettiCore.getIdSoggetto(fru.getNome(), fru.getTipo());
                                }
                                ArrayList<Parameter> listParameter = new ArrayList<Parameter>();
                                String azioneConnettore = null;
                                if (listaAzioniPDAssociataMappingNonDefault != null && !listaAzioniPDAssociataMappingNonDefault.isEmpty()) {
                                    azioneConnettore = (String)listaAzioniPDAssociataMappingNonDefault.get(0);
                                }
                                String servletConnettore = "accordiServizioParteSpecificaFruitoriChange.do";
                                String labelConnettore = this.getLabelConnettore(fru.getConnettore(), true, false);
                                String copyConnettore = this.getClipBoardUrlConnettore(fru.getConnettore());
                                if (mapping.isDefault()) {
                                    if (visualizzazioneTabs) {
                                        de.setValue(labelConnettore);
                                        de.setToolTip(this.getLabelConnettore(fru.getConnettore(), true, true));
                                        de.setCopyToClipboard(copyConnettore);
                                    } else {
                                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                                    }
                                    Parameter pId = new Parameter("id", "" + asps.getId());
                                    Parameter pMyId = new Parameter("myId", "" + fru.getId());
                                    Parameter actionIdPorta = new Parameter("fruitoreViewConnettoreAzioneIdPorta", "" + pdAssociata.getId());
                                    listParameter.add(actionIdPorta);
                                    listParameter.add(pId);
                                    listParameter.add(pMyId);
                                    listParameter.add(pIdSoggettoErogatore);
                                    listParameter.add(new Parameter("providerFruitore", "" + idSoggettoLong));
                                    listParameter.add(pIdTAb);
                                    if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                                        listParameter.add(new Parameter("fruitoreViewConnettoreAzione", azioneConnettore));
                                    }
                                    de.setUrl(servletConnettore, listParameter.toArray(new Parameter[1]));
                                    if (visualizzazioneTabs) {
                                        DataElementImage image5 = new DataElementImage();
                                        image5.setUrl(servletConnettore, listParameter.toArray(new Parameter[1]));
                                        image5.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                                        image5.setImage("&#xE3C9;");
                                        de.setImage(image5);
                                    }
                                    connettore = fru.getConnettore();
                                } else {
                                    if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                                        for (ConfigurazioneServizioAzione check : fru.getConfigurazioneAzioneList()) {
                                            if (!check.getAzioneList().contains(azioneConnettore)) continue;
                                            ridefinito = true;
                                            connettore = check.getConnettore();
                                            break;
                                        }
                                    }
                                    if (ridefinito) {
                                        servletConnettore = "porteDelegateConnettoreRidefinito.do";
                                        if (visualizzazioneTabs) {
                                            de.setValue(this.getLabelConnettore(connettore, true, false));
                                            de.setCopyToClipboard(this.getClipBoardUrlConnettore(connettore));
                                        } else {
                                            de.setValue("Connettore ridefinito per il gruppo");
                                        }
                                        de.setUrl(servletConnettore, new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                                        tooltipConnettore = this.getLabelConnettore(connettore, true, true);
                                        de.setToolTip("Connettore ridefinito per il gruppo&#10;" + tooltipConnettore);
                                    } else {
                                        servletConnettore = "porteDelegateConnettoreDefault.do";
                                        if (visualizzazioneTabs) {
                                            de.setValue("[Predefinito] " + labelConnettore);
                                            de.setCopyToClipboard(copyConnettore);
                                        } else {
                                            de.setValue("Utilizza connettore del gruppo 'Predefinito'");
                                        }
                                        de.setUrl(servletConnettore, new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                                        tooltipConnettore = this.getLabelConnettore(fru.getConnettore(), true, true);
                                        de.setToolTip("Utilizza connettore del gruppo 'Predefinito'&#10;" + tooltipConnettore);
                                        connettore = fru.getConnettore();
                                    }
                                    if (visualizzazioneTabs) {
                                        DataElementImage image6 = new DataElementImage();
                                        image6.setUrl(servletConnettore, new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                        image6.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                                        image6.setImage("&#xE3C9;");
                                        de.setImage(image6);
                                    }
                                }
                            }
                            de.allineaTdAlCentro();
                            e.add(de);
                            if (connettore != null) {
                                long idConnettore = connettore.getId();
                                boolean checkConnettore = ConnettoreCheck.checkSupported(connettore);
                                if (checkConnettore && !mapping.isDefault() && !ridefinito) {
                                    checkConnettore = false;
                                }
                                if (visualizzazioneTabs) {
                                    if (checkConnettore) {
                                        DataElementImage image7 = new DataElementImage();
                                        image7.setUrl("porteDelegateVerificaConnettore.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb, new Parameter("connettoreId", "" + idConnettore), new Parameter("connettoreAccessoDaGruppi", "true"), new Parameter("connettoreRegistro", "true")});
                                        image7.setToolTip(MessageFormat.format("Verifica {0}", "Connettore"));
                                        image7.setImage("&#xE8BE;");
                                        de.addImage(image7);
                                    }
                                } else {
                                    DataElement deVerificaConnettore = new DataElement();
                                    if (checkConnettore) {
                                        deVerificaConnettore.setValue("verifica");
                                        deVerificaConnettore.setUrl("porteDelegateVerificaConnettore.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, new Parameter("connettoreId", "" + idConnettore), new Parameter("connettoreAccessoDaGruppi", "true"), new Parameter("connettoreRegistro", "true")});
                                    } else {
                                        deVerificaConnettore.setValue("-");
                                    }
                                    deVerificaConnettore.allineaTdAlCentro();
                                    e.add(deVerificaConnettore);
                                }
                            }
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Controllo Accessi");
                        }
                        de.setUrl("porteDelegateControlloAccessi.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        if (visualizzazioneTabs) {
                            this.setStatoControlloAccessiPortaDelegata(protocollo, pdAssociata, de);
                        } else {
                            String statoControlloAccessi = this.getStatoControlloAccessiPortaDelegata(protocollo, pdAssociata);
                            de.setValue(statoControlloAccessi);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image8 = new DataElementImage();
                            image8.setUrl("porteDelegateControlloAccessi.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image8.setToolTip(MessageFormat.format("Modifica {0}", "Controllo Accessi"));
                            image8.setImage("&#xE3C9;");
                            de.setImage(image8);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Rate Limiting");
                        }
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do?CTPolicyRuoloPorta=" + RuoloPolicy.DELEGATA.getValue() + "&CTPolicyNomePorta=" + pdAssociata.getNome() + "&CTPolicyServiceBinding=" + serviceBindingMessage.name());
                        List<AttivazionePolicy> listaPolicy = null;
                        if (contaListe || visualizzazioneTabs) {
                            ConsoleSearch searchPolicy = new ConsoleSearch(true);
                            listaPolicy = this.confCore.attivazionePolicyList(searchPolicy, RuoloPolicy.DELEGATA, pdAssociata.getNome());
                        }
                        if (visualizzazioneTabs) {
                            this.setStatoRateLimiting(de, listaPolicy);
                        } else if (contaListe) {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(listaPolicy.size()));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image9 = new DataElementImage();
                            image9.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do", new Parameter[]{new Parameter("CTPolicyRuoloPorta", RuoloPolicy.DELEGATA.getValue()), new Parameter("CTPolicyNomePorta", pdAssociata.getNome()), new Parameter("CTPolicyServiceBinding", serviceBindingMessage.name()), pIdTAb});
                            image9.setToolTip(MessageFormat.format("Modifica {0}", "Rate Limiting"));
                            image9.setImage("&#xE3C9;");
                            de.setImage(image9);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Validazione");
                        }
                        de.setUrl("porteDelegateValidazioneContenuti.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        if (visualizzazioneTabs) {
                            this.setStatoValidazioneContenuti(de, pdAssociata.getValidazioneContenutiApplicativi(), apc.getFormatoSpecifica());
                        } else {
                            String statoValidazione = this.getStatoValidazionePortaDelegata(pdAssociata);
                            de.setValue(statoValidazione);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image10 = new DataElementImage();
                            image10.setUrl("porteDelegateValidazioneContenuti.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image10.setToolTip(MessageFormat.format("Modifica {0}", "Validazione"));
                            image10.setImage("&#xE3C9;");
                            de.setImage(image10);
                        }
                        e.add(de);
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Caching Risposta");
                        }
                        de.setUrl("porteDelegateResponseCaching.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        if (visualizzazioneTabs) {
                            this.setStatoCachingRisposta(de, pdAssociata.getResponseCaching(), configurazioneGenerale);
                        } else {
                            String statoResponseCaching = this.getStatoResponseCachingPortaDelegata(pdAssociata, false);
                            de.setValue(statoResponseCaching);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image11 = new DataElementImage();
                            image11.setUrl("porteDelegateResponseCaching.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image11.setToolTip(MessageFormat.format("Modifica {0}", "Caching Risposta"));
                            image11.setImage("&#xE3C9;");
                            de.setImage(image11);
                        }
                        e.add(de);
                        if (visualizzaSicurezza) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Sicurezza Messaggio");
                            }
                            de.setUrl("porteDelegateWS.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                            if (visualizzazioneTabs) {
                                this.setStatoSicurezzaMessaggio(de, pdAssociata.getMessageSecurity(), configManager, propertiesSourceConfiguration);
                            } else {
                                String statoMessageSecurity = this.getStatoMessageSecurityPortaDelegata(pdAssociata);
                                de.setValue(statoMessageSecurity);
                            }
                            if (visualizzazioneTabs) {
                                DataElementImage image12 = new DataElementImage();
                                image12.setUrl("porteDelegateWS.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                image12.setToolTip(MessageFormat.format("Modifica {0}", "Sicurezza Messaggio"));
                                image12.setImage("&#xE3C9;");
                                de.setImage(image12);
                            }
                            e.add(de);
                        }
                        if (visualizzaMTOM) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("MTOM");
                            }
                            de.setUrl("porteDelegateMTOM.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                            if (visualizzazioneTabs) {
                                this.setStatoMTOM(de, pdAssociata.getMtomProcessor());
                            } else {
                                String statoMTOM = this.getStatoMTOMPortaDelegata(pdAssociata);
                                de.setValue(statoMTOM);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image13 = new DataElementImage();
                                image13.setUrl("porteDelegateMTOM.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                image13.setToolTip(MessageFormat.format("Modifica {0}", "MTOM"));
                                image13.setImage("&#xE3C9;");
                                de.setImage(image13);
                            }
                            e.add(de);
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Trasformazioni");
                        }
                        de.setUrl("porteDelegateTrasformazioniList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        if (visualizzazioneTabs) {
                            this.setStatoTrasformazioni(de, pdAssociata.getTrasformazioni(), serviceBindingMessage);
                        } else if (contaListe) {
                            long size = 0L;
                            if (pdAssociata.getTrasformazioni() != null) {
                                size = pdAssociata.getTrasformazioni().sizeRegolaList();
                            }
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)size);
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image14 = new DataElementImage();
                            image14.setUrl("porteDelegateTrasformazioniList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image14.setToolTip(MessageFormat.format("Modifica {0}", "Trasformazioni"));
                            image14.setImage("&#xE3C9;");
                            de.setImage(image14);
                        }
                        e.add(de);
                        if (visualizzaCorrelazione) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Tracciamento");
                            }
                            de.setUrl("porteDelegateCorrelazioneApplicativa.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                            if (visualizzazioneTabs) {
                                this.setStatoTracciamento(de, pdAssociata.getCorrelazioneApplicativa(), pdAssociata.getCorrelazioneApplicativaRisposta(), pdAssociata.getTracciamento(), configurazioneGenerale != null && configurazioneGenerale.getTracciamento() != null ? configurazioneGenerale.getTracciamento().getPortaDelegata() : null, pdAssociata.getProprieta(), configurazioneGenerale);
                            } else {
                                String statoTracciamento = this.getStatoTracciamentoPortaDelegata(pdAssociata);
                                de.setValue(statoTracciamento);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image15 = new DataElementImage();
                                image15.setUrl("porteDelegateCorrelazioneApplicativa.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                                image15.setToolTip(MessageFormat.format("Modifica {0}", "Tracciamento"));
                                image15.setImage("&#xE3C9;");
                                de.setImage(image15);
                            }
                            e.add(de);
                        }
                        de = new DataElement();
                        if (visualizzazioneTabs) {
                            de.setLabel("Registrazione Messaggi");
                        }
                        de.setUrl("porteDelegateDumpConfigurazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore});
                        if (visualizzazioneTabs) {
                            this.setStatoDump(de, pdAssociata.getDump(), configurazioneGenerale, false);
                        } else {
                            String statoDump = this.getStatoDumpPortaDelegata(pdAssociata, false);
                            de.setValue(statoDump);
                        }
                        de.allineaTdAlCentro();
                        if (visualizzazioneTabs) {
                            DataElementImage image16 = new DataElementImage();
                            image16.setUrl("porteDelegateDumpConfigurazione.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pIdTAb});
                            image16.setToolTip(MessageFormat.format("Modifica {0}", "Registrazione Messaggi"));
                            image16.setImage("&#xE3C9;");
                            de.setImage(image16);
                        }
                        e.add(de);
                        if (visualizzaAllarmi) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Allarmi");
                            }
                            de.setUrl("configurazioneAllarmiList.do?allRuoloPorta=" + RuoloPorta.DELEGATA.getValue() + "&allNomePorta=" + pdAssociata.getNome() + "&allServiceBinding=" + serviceBindingMessage.name());
                            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                            if (contaListe || visualizzazioneTabs) {
                                ConsoleSearch searchPolicy = new ConsoleSearch(true);
                                listaAllarmi = this.confCore.allarmiList(searchPolicy, RuoloPorta.DELEGATA, pdAssociata.getNome());
                            }
                            if (visualizzazioneTabs) {
                                this.setStatoAllarmi(de, listaAllarmi);
                            } else if (contaListe) {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(listaAllarmi.size()));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image17 = new DataElementImage();
                                image17.setUrl("configurazioneAllarmiList.do", new Parameter[]{new Parameter("allRuoloPorta", RuoloPorta.DELEGATA.getValue()), new Parameter("allNomePorta", pdAssociata.getNome()), new Parameter("allServiceBinding", serviceBindingMessage.name()), pIdTAb});
                                image17.setToolTip(MessageFormat.format("Modifica {0}", "Allarmi"));
                                image17.setImage("&#xE3C9;");
                                de.setImage(image17);
                            }
                            e.add(de);
                        }
                        if (this.isModalitaAvanzata() || this.porteDelegateCore.isProprietaFruizioniShowModalitaStandard()) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Propriet&agrave;");
                            }
                            de.setUrl("porteDelegateProprietaProtocolloList.do", new Parameter[]{pIdSoggPD, pIdPD, pIdAsps, pIdFruitore});
                            if (visualizzazioneTabs) {
                                this.setStatoProprieta(de, pdAssociata.sizeProprietaList());
                            } else if (contaListe) {
                                int numProp = pdAssociata.sizeProprietaList();
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numProp));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image18 = new DataElementImage();
                                image18.setUrl("porteDelegateProprietaProtocolloList.do", new Parameter[]{pIdSoggPD, pIdPD, pIdAsps, pIdFruitore, pIdTAb});
                                image18.setToolTip(MessageFormat.format("Modifica {0}", "Propriet&agrave;"));
                                image18.setImage("&#xE3C9;");
                                de.setImage(image18);
                            }
                            e.add(de);
                        }
                        if (this.isModalitaAvanzata()) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel("Opzioni Avanzate");
                            }
                            de.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneAltroPorta});
                            if (visualizzazioneTabs) {
                                this.setStatoOpzioniAvanzate(de, protocollo, serviceBindingMessage, pdAssociata.getAllegaBody(), pdAssociata.getScartaBody(), pdAssociata.getIntegrazione(), null, pdAssociata.getProprietaRateLimitingList(), pdAssociata.getStateless(), pdAssociata.getLocalForward(), pdAssociata.getRicevutaAsincronaSimmetrica(), pdAssociata.getRicevutaAsincronaAsimmetrica(), pdAssociata.getGestioneManifest(), pdAssociata.getConfigurazioneHandler());
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            if (visualizzazioneTabs) {
                                DataElementImage image19 = new DataElementImage();
                                image19.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneAltroPorta, pIdTAb});
                                image19.setToolTip(MessageFormat.format("Modifica {0}", "Opzioni Avanzate"));
                                image19.setImage("&#xE3C9;");
                                de.setImage(image19);
                            }
                            e.add(de);
                        }
                        if (extendedServletList != null && extendedServletList.showExtendedInfo(this, protocollo)) {
                            de = new DataElement();
                            if (visualizzazioneTabs) {
                                de.setLabel(extendedServletList.getListTitle(this));
                            }
                            de.setUrl("porteDelegateExtendedList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneAltroPorta});
                            if (visualizzazioneTabs) {
                                int numExtended = extendedServletList.sizeList(pdAssociata);
                                String stato = extendedServletList.getStatoTab(this, pdAssociata, mapping.isDefault());
                                String statoTooltip = extendedServletList.getStatoTab(this, pdAssociata, mapping.isDefault());
                                this.setStatoExtendedList(de, numExtended, stato, statoTooltip);
                            } else if (contaListe) {
                                int numExtended = extendedServletList.sizeList(pdAssociata);
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numExtended));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                            de.allineaTdAlCentro();
                            if (visualizzazioneTabs) {
                                DataElementImage image20 = new DataElementImage();
                                image20.setUrl("porteDelegateExtendedList.do", new Parameter[]{pIdPD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneAltroPorta, pIdTAb});
                                image20.setToolTip(MessageFormat.format("Modifica {0}", extendedServletList.getListTitle(this)));
                                image20.setImage("&#xE3C9;");
                                de.setImage(image20);
                            }
                            e.add(de);
                        }
                        if (visualizzazioneTabs) {
                            this.addProprietaOggetto(e, pdAssociata.getProprietaOggetto());
                        }
                    }
                    dati.add(e);
                    ++idTab;
                }
            }
            this.pd.setDati(dati);
            if (visualizzazioneTabs) {
                this.pd.setSelect(true);
                if (showBottoneAggiungiNuovaConfigurazione) {
                    this.pd.setAddButton(true);
                } else {
                    this.pd.setAddButton(false);
                }
                if (lista.size() > 1) {
                    this.pd.setRemoveButton(true);
                } else {
                    this.pd.setRemoveButton(false);
                }
            } else if (gestioneGruppi) {
                if (listaSenzaFiltro != null && listaSenzaFiltro.size() > 1) {
                    this.pd.setRemoveButton(true);
                    this.pd.setSelect(true);
                } else {
                    this.pd.setRemoveButton(false);
                    this.pd.setSelect(false);
                }
                this.pd.setAddButton(true);
            } else {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    private boolean addInfoCorrelata(TipoOperazione tipoOp, String portType, boolean modificaAbilitata, String servcorr, String oldStato, String tipoProtocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, List<DataElement> dati) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        boolean infoCorrelataShow = false;
        DataElement de = new DataElement();
        de.setLabel("Correlato");
        if (this.core.isShowCorrelazioneAsincronaInAccordi() && (!isModalitaAvanzata || portType != null && !"".equals(portType) && !"-".equals(portType))) {
            de.setType(DataElementType.HIDDEN);
        } else if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) {
            if (this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(tipoProtocollo, serviceBinding)) {
                de.setType(DataElementType.CHECKBOX);
                infoCorrelataShow = true;
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("servcorr");
        if (this.core.isShowCorrelazioneAsincronaInAccordi() && (!isModalitaAvanzata || portType != null && !"".equals(portType) && !"-".equals(portType))) {
            if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
                de.setValue("yes");
            } else {
                de.setValue("no");
            }
        } else if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
            if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) {
                de.setSelected("yes");
            } else {
                de.setValue("yes");
            }
        } else if (tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato)) {
            de.setValue("no");
        }
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato) || this.core.isShowCorrelazioneAsincronaInAccordi() && (!isModalitaAvanzata || portType != null && !"".equals(portType) && !"-".equals(portType))) {
            DataElement deLabel = new DataElement();
            deLabel.setLabel("Tipologia Servizio");
            deLabel.setName("servcorrLabel");
            if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
                deLabel.setValue("correlato");
            } else {
                deLabel.setValue("normale");
            }
            if (this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(tipoProtocollo, serviceBinding)) {
                deLabel.setType(DataElementType.TEXT);
                infoCorrelataShow = true;
            } else {
                deLabel.setType(DataElementType.HIDDEN);
            }
            dati.add(deLabel);
        }
        return infoCorrelataShow;
    }

    public List<DataElement> addServiziToDati(List<DataElement> dati, String nomeServizio, String tipoServizio, String oldNomeServizio, String oldTipoServizio, String provider, String tipoSoggetto, String nomeSoggetto, String[] soggettiList, String[] soggettiListLabel, String accordo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, InterfaceType interfaceType, String[] accordiList, String[] accordiListLabel, String servcorr, BinaryParameter wsdlimpler, BinaryParameter wsdlimplfru, TipoOperazione tipoOp, String id, List<String> tipi, String profilo, String portType, String[] ptList, boolean privato, String uriAccordo, String descrizione, String descrizioneModificata, long idSoggettoErogatore, String statoPackage, String oldStato, String versione, List<String> versioni, boolean validazioneDocumenti, String[] saSoggetti, String nomeSA, boolean generaPACheckSoggetto, List<AccordoServizioParteComune> asCompatibili, String controlloAccessiStato, String erogazioneRuolo, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, String erogazioneAutorizzazione, boolean erogazioneIsSupportatoAutenticazioneSoggetti, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, List<String> soggettiAutenticati, List<String> soggettiAutenticatiLabel, String soggettoAutenticato, String tipoProtocollo, List<String> listaTipiProtocollo, String[] soggettiFruitoriList, String[] soggettiFruitoriListLabel, String providerSoggettoFruitore, String tipoSoggettoFruitore, String nomeSoggettoFruitore, String fruizioneServizioApplicativo, String fruizioneRuolo, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, List<String> saList, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, boolean moreThenOneImplementation, String canaleStato, String canaleAPI, String canale, List<CanaleConfigurazione> canaleList, boolean gestioneCanaliEnabled, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws Exception {
        boolean showLabelServizio;
        boolean creaDataElementVersione;
        DataElement de;
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        boolean gestioneErogatori = false;
        if (tipologia != null) {
            if ("fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            } else if ("erogazione".equals(tipologia)) {
                gestioneErogatori = true;
            }
        }
        boolean confirmInProgress = false;
        if (moreThenOneImplementation) {
            String tmp;
            de = new DataElement();
            de.setName("backToConfermaModificaDatiServizio");
            de.setValue("true");
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
            if ((this.getPostBackElementName() == null || "".equals(this.getPostBackElementName())) && (tmp = this.getParameter("backToConfermaModificaDatiServizio")) != null && !"".equals(tmp)) {
                confirmInProgress = true;
            }
        }
        if (gestioneFruitori) {
            de = new DataElement();
            de.setName("tipoSoggFru");
            de.setValue(tipoSoggettoFruitore);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
            de = new DataElement();
            de.setName("nomeSoggFru");
            de.setValue(nomeSoggettoFruitore);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        String tmpModificaAPI = this.getParameter("modificaAPI");
        Boolean showModificaAPIErogazioniFruizioniView = null;
        if (tmpModificaAPI != null) {
            showModificaAPIErogazioniFruizioniView = "true".equals(tmpModificaAPI);
            DataElement de2 = new DataElement();
            de2.setName("modificaAPI");
            de2.setValue(tmpModificaAPI);
            de2.setType(DataElementType.HIDDEN);
            dati.add(de2);
        }
        String tmpCambiaAPI = this.getParameter("cambiaAPI");
        boolean cambiaAPI = false;
        if (tmpCambiaAPI != null) {
            cambiaAPI = "true".equals(tmpCambiaAPI);
            DataElement de3 = new DataElement();
            de3.setName("cambiaAPI");
            de3.setValue(tmpCambiaAPI);
            de3.setType(DataElementType.HIDDEN);
            dati.add(de3);
        }
        String tmpModificaDescrizione = this.getParameter("modificaDescrizione");
        boolean modificaDescrizione = false;
        if (tmpModificaDescrizione != null) {
            modificaDescrizione = "true".equals(tmpModificaDescrizione);
            DataElement de4 = new DataElement();
            de4.setName("modificaDescrizione");
            de4.setValue(tmpModificaDescrizione);
            de4.setType(DataElementType.HIDDEN);
            dati.add(de4);
        }
        String tmpCambiaErogatore = this.getParameter("cambiaErogatore");
        boolean cambiaErogatore = false;
        if (tmpCambiaErogatore != null) {
            cambiaErogatore = "true".equals(tmpCambiaErogatore);
            DataElement de5 = new DataElement();
            de5.setName("cambiaErogatore");
            de5.setValue(tmpCambiaErogatore);
            de5.setType(DataElementType.HIDDEN);
            dati.add(de5);
        }
        String tmpModificaProfilo = this.getParameter("modificaProfilo");
        boolean modificaProfilo = false;
        if (tmpModificaProfilo != null) {
            modificaProfilo = "true".equals(tmpModificaProfilo);
            DataElement de6 = new DataElement();
            de6.setName("modificaProfilo");
            de6.setValue(tmpModificaProfilo);
            de6.setType(DataElementType.HIDDEN);
            dati.add(de6);
        }
        Boolean showInformazioniGeneraliErogazioniFruizioniView = null;
        if (gestioneFruitori || gestioneErogatori) {
            if (showModificaAPIErogazioniFruizioniView != null && showModificaAPIErogazioniFruizioniView.booleanValue()) {
                showInformazioniGeneraliErogazioniFruizioniView = false;
            } else if (modificaProfilo || cambiaAPI || cambiaErogatore || modificaDescrizione) {
                showInformazioniGeneraliErogazioniFruizioniView = false;
                showModificaAPIErogazioniFruizioniView = false;
            } else {
                showInformazioniGeneraliErogazioniFruizioniView = true;
            }
        }
        String tipoServizioEffettivo = oldTipoServizio != null ? oldTipoServizio : tipoServizio;
        String nomeServizioEffettivo = oldTipoServizio != null ? oldNomeServizio : nomeServizio;
        String[] tipiLabel = new String[tipi.size()];
        for (int i = 0; i < tipi.size(); ++i) {
            String nomeTipo;
            tipiLabel[i] = nomeTipo = tipi.get(i);
        }
        String[] versioniValues = new String[versioni.size() + 1];
        String[] versioniLabel = new String[versioni.size() + 1];
        versioniLabel[0] = "usa versione erogatore";
        versioniValues[0] = "-";
        for (int i = 0; i < versioni.size(); ++i) {
            String tmp;
            versioniLabel[i + 1] = tmp = versioni.get(i);
            versioniValues[i + 1] = tmp;
        }
        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
        boolean visualizzaSceltaVersioneServizio = creaDataElementVersione = this.apsCore.isSupportatoVersionamentoAccordiServizioParteSpecifica(tipoProtocollo);
        if (this.isModalitaStandard() && TipoOperazione.ADD.equals((Object)tipoOp)) {
            visualizzaSceltaVersioneServizio = false;
        }
        boolean modificaAbilitata = !this.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(oldStato);
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        boolean ripristinoStatoOperativo = this.core.isGestioneWorkflowStatoDocumentiRipristinoStatoOperativoDaFinale();
        Boolean contaListeObject = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        boolean contaListe = contaListeObject != null && contaListeObject != false;
        boolean isAccordiCooperazione = user.getPermessi().isAccordiCooperazione();
        boolean isServizi = user.getPermessi().isServizi();
        String asLabel = "API (ParteComune/Composto)";
        if (isServizi && !isAccordiCooperazione) {
            asLabel = "API";
        }
        if (!isServizi && isAccordiCooperazione) {
            asLabel = "API (Servizio Composto)";
        }
        if (isServizi && isAccordiCooperazione) {
            asLabel = "API (ParteComune/Composto)";
        }
        boolean showReferente = this.apcCore.isSupportatoSoggettoReferente(tipoProtocollo);
        boolean showPortiAccesso = false;
        if (serviceBinding != null) {
            showPortiAccesso = this.apcCore.showPortiAccesso(tipoProtocollo, serviceBinding, interfaceType);
        }
        DataElement de7 = new DataElement();
        if (gestioneFruitori || gestioneErogatori) {
            if (showModificaAPIErogazioniFruizioniView != null && showModificaAPIErogazioniFruizioniView.booleanValue() || cambiaAPI) {
                de7.setLabel(asLabel);
            } else if (modificaDescrizione) {
                de7.setLabel("Descrizione");
            } else {
                de7.setLabel("Informazioni Generali");
            }
        } else {
            de7.setLabel("Informazioni Generali");
        }
        if (modificaProfilo || cambiaErogatore) {
            de7.setType(DataElementType.HIDDEN);
        } else {
            de7.setType(DataElementType.TITLE);
        }
        dati.add(de7);
        de7 = new DataElement();
        if (TipoOperazione.ADD.equals((Object)tipoOp) && listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
            de7.setLabel("Profilo Interoperabilit\u00e0");
            de7.setValues(listaTipiProtocollo);
            de7.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
            de7.setSelected(tipoProtocollo);
            de7.setType(DataElementType.SELECT);
            de7.setName("protocollo");
            de7.setPostBack_viaPOST(true);
        } else {
            de7.setValue(tipoProtocollo);
            de7.setType(DataElementType.HIDDEN);
            de7.setName("protocollo");
        }
        de7.setSize(this.getSize());
        dati.add(de7);
        if (gestioneFruitori) {
            boolean showSoggettoFruitoreInFruizioni = this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
            de7 = new DataElement();
            de7.setLabel("Soggetto Fruitore");
            de7.setName("providerFruitore");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && showSoggettoFruitoreInFruizioni) {
                de7.setType(DataElementType.SELECT);
                de7.setValues(soggettiFruitoriList);
                de7.setLabels(soggettiFruitoriListLabel);
                de7.setPostBack_viaPOST(true);
                de7.setSelected(providerSoggettoFruitore);
                dati.add(de7);
            } else {
                de7.setValue(providerSoggettoFruitore);
                de7.setType(DataElementType.HIDDEN);
                dati.add(de7);
                showSoggettoInChange = false;
                if (showSoggettoFruitoreInFruizioni && showSoggettoInChange) {
                    de7 = new DataElement();
                    de7.setLabel("Soggetto Fruitore");
                    de7.setName("providerFruitoreAsText");
                    de7.setType(DataElementType.TEXT);
                    de7.setValue(this.getLabelNomeSoggetto(tipoProtocollo, tipoSoggettoFruitore, nomeSoggettoFruitore));
                    dati.add(de7);
                }
            }
        } else {
            boolean showSoggettoErogatoreInErogazioni = this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
            de7 = new DataElement();
            de7.setLabel("Soggetto Erogatore");
            de7.setName("providerErogatore");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && showSoggettoErogatoreInErogazioni) {
                de7.setType(DataElementType.SELECT);
                de7.setValues(soggettiList);
                de7.setLabels(soggettiListLabel);
                de7.setPostBack_viaPOST(true);
                de7.setSelected(provider);
                dati.add(de7);
            } else {
                de7.setValue(provider);
                de7.setType(DataElementType.HIDDEN);
                dati.add(de7);
                showSoggettoInChange = false;
                if (!gestioneErogatori || showSoggettoErogatoreInErogazioni && showSoggettoInChange) {
                    de7 = new DataElement();
                    de7.setLabel("Nome");
                    de7.setName("providerText");
                    de7.setType(DataElementType.TEXT);
                    de7.setValue(this.getLabelNomeSoggetto(tipoProtocollo, tipoSoggetto, nomeSoggetto));
                    dati.add(de7);
                }
            }
        }
        if (this.isModalitaCompleta() || tipoOp.equals((Object)TipoOperazione.ADD) || cambiaAPI) {
            de7 = new DataElement();
            de7.setLabel(asLabel);
            de7.setType(DataElementType.SUBTITLE);
            dati.add(de7);
        }
        IDAccordo idAccordoParteComune = null;
        boolean apiChanged = false;
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de7 = new DataElement();
            de7.setLabel("Nome");
            de7.setType(DataElementType.SELECT);
            de7.setName("accordo");
            de7.setValues(accordiList);
            de7.setLabels(accordiListLabel);
            de7.setPostBack_viaPOST(true);
            if (accordo != null) {
                de7.setSelected(accordo);
            }
            if (accordiListLabel.length > 1) {
                de7.setRequired(true);
            }
            dati.add(de7);
        } else if (cambiaAPI && accordiListLabel != null && accordiListLabel.length > 0) {
            de7 = new DataElement();
            de7.setLabel("Attuale");
            de7.setType(DataElementType.TEXT);
            de7.setName("accordo__label");
            de7.setValue(accordiListLabel[0]);
            dati.add(de7);
            if (accordiListLabel.length > 1) {
                String[] newAccordi = new String[accordiListLabel.length];
                String[] newAccordiLabel = new String[accordiListLabel.length];
                for (int i = 0; i < accordiListLabel.length; ++i) {
                    newAccordi[i] = accordiList[i];
                    newAccordiLabel[i] = i > 0 ? accordiListLabel[i] : "-";
                }
                de7 = new DataElement();
                de7.setLabel("Nuovo");
                de7.setType(DataElementType.SELECT);
                de7.setName("accordo");
                de7.setValues(newAccordi);
                de7.setLabels(newAccordiLabel);
                de7.setPostBack(true);
                if (accordo != null) {
                    de7.setSelected(accordo);
                }
                dati.add(de7);
            } else {
                de7 = new DataElement();
                de7.setType(DataElementType.HIDDEN);
                de7.setName("accordo");
                de7.setValue(accordo);
                dati.add(de7);
            }
            if (accordo != null) {
                for (int i = 0; i < accordiList.length; ++i) {
                    if (!accordo.equals(accordiList[i])) continue;
                    apiChanged = i > 0;
                    break;
                }
            }
        } else {
            if (!modificaAbilitata || asCompatibili == null || asCompatibili.size() <= 1 || showModificaAPIErogazioniFruizioniView != null && !showModificaAPIErogazioniFruizioniView.booleanValue()) {
                de7 = new DataElement();
                de7.setLabel("API");
                de7.setType(DataElementType.HIDDEN);
                de7.setName("accordo");
                de7.setValue(accordo);
                dati.add(de7);
            }
            idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
            de7 = new DataElement();
            de7.setLabel("Soggetto Referente");
            if (showReferente && (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue())) {
                de7.setType(DataElementType.TEXT);
            } else {
                de7.setType(DataElementType.HIDDEN);
            }
            de7.setName("param_Soggetto Referente");
            de7.setValue(idAccordoParteComune.getSoggettoReferente().toString());
            dati.add(de7);
            de7 = new DataElement();
            de7.setLabel("Nome");
            if (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue()) {
                de7.setType(DataElementType.TEXT);
            } else {
                de7.setType(DataElementType.HIDDEN);
            }
            de7.setName("param_Nome");
            de7.setValue(idAccordoParteComune.getNome());
            dati.add(de7);
            de7 = new DataElement();
            de7.setLabel("Versione");
            if (!modificaAbilitata || asCompatibili == null || asCompatibili.size() <= 1 || showModificaAPIErogazioniFruizioniView != null && !showModificaAPIErogazioniFruizioniView.booleanValue()) {
                if (showModificaAPIErogazioniFruizioniView != null && !showModificaAPIErogazioniFruizioniView.booleanValue()) {
                    de7.setType(DataElementType.HIDDEN);
                } else {
                    de7.setType(DataElementType.TEXT);
                }
                de7.setName("param_Versione");
                if (idAccordoParteComune.getVersione() != null) {
                    de7.setValue("" + idAccordoParteComune.getVersione());
                }
            } else {
                String[] accordiCompatibiliList = new String[asCompatibili.size()];
                String[] accordiCompatibiliLabelList = new String[asCompatibili.size()];
                for (int i = 0; i < asCompatibili.size(); ++i) {
                    accordiCompatibiliList[i] = "" + asCompatibili.get(i).getId();
                    if (asCompatibili.get(i).getVersione() == null) continue;
                    accordiCompatibiliLabelList[i] = "" + asCompatibili.get(i).getVersione();
                }
                de7.setName("accordo");
                if (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue()) {
                    if (confirmInProgress) {
                        de7.setType(DataElementType.HIDDEN);
                        DataElement deLabel = new DataElement();
                        deLabel.setLabel("Versione");
                        deLabel.setName("accordo__label");
                        deLabel.setType(DataElementType.TEXT);
                        for (int i = 0; i < accordiCompatibiliList.length; ++i) {
                            if (!accordo.equals(accordiCompatibiliList[i])) continue;
                            deLabel.setValue(accordiCompatibiliLabelList[i]);
                            break;
                        }
                        dati.add(deLabel);
                    } else {
                        de7.setType(DataElementType.SELECT);
                        de7.setValues(accordiCompatibiliList);
                        de7.setLabels(accordiCompatibiliLabelList);
                        de7.setPostBack(true);
                        de7.setSelected(accordo);
                    }
                } else {
                    de7.setType(DataElementType.HIDDEN);
                }
                de7.setValue(accordo);
            }
            dati.add(de7);
        }
        if (serviceBinding != null) {
            switch (serviceBinding) {
                case REST: {
                    if (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue()) {
                        de7 = new DataElement();
                        de7.setType(DataElementType.TEXT);
                        de7.setLabel("Tipo");
                        de7.setName("port_type__label");
                        de7.setValue("Rest");
                        dati.add(de7);
                    }
                    de7 = new DataElement();
                    de7.setType(DataElementType.HIDDEN);
                    de7.setName("port_type");
                    de7.setValue(portType);
                    dati.add(de7);
                    break;
                }
                default: {
                    if (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue()) {
                        de7 = new DataElement();
                        de7.setType(DataElementType.TEXT);
                        de7.setLabel("Tipo");
                        de7.setName("port_type__label");
                        de7.setValue("Soap");
                        dati.add(de7);
                    }
                    if (ptList != null) {
                        if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata || apiChanged) {
                            de7 = new DataElement();
                            de7.setLabel("Servizio");
                            de7.setName("port_type");
                            if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue() || apiChanged) {
                                if (showInformazioniGeneraliErogazioniFruizioniView != null) {
                                    de7.setLabel("Servizio (Soap)");
                                }
                                de7.setType(DataElementType.SELECT);
                                de7.setValues(ptList);
                                de7.setLabels(ptList);
                                de7.setSelected(portType);
                                if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                                    de7.setPostBack_viaPOST(true);
                                } else {
                                    de7.setPostBack(true);
                                }
                                if (!isModalitaAvanzata || this.apsCore.isPortTypeObbligatorioImplementazioniSOAP()) {
                                    de7.setRequired(true);
                                }
                            } else {
                                if (showModificaAPIErogazioniFruizioniView != null && showModificaAPIErogazioniFruizioniView.booleanValue()) {
                                    de7.setLabel("Servizio (Soap)");
                                    de7.setType(DataElementType.TEXT);
                                } else {
                                    de7.setType(DataElementType.HIDDEN);
                                }
                                de7.setValue(portType);
                            }
                            dati.add(de7);
                            break;
                        }
                        de7 = new DataElement();
                        de7.setLabel("Servizio");
                        de7.setType(DataElementType.HIDDEN);
                        de7.setName("port_type");
                        de7.setValue(portType);
                        dati.add(de7);
                        de7 = new DataElement();
                        de7.setLabel("Servizio");
                        if (showModificaAPIErogazioniFruizioniView == null || showModificaAPIErogazioniFruizioniView.booleanValue()) {
                            de7.setType(DataElementType.TEXT);
                        } else {
                            de7.setType(DataElementType.HIDDEN);
                        }
                        de7.setName("port_type_label");
                        de7.setValue(portType);
                        dati.add(de7);
                        break;
                    }
                    de7 = new DataElement();
                    de7.setType(DataElementType.HIDDEN);
                    de7.setName("port_type");
                    dati.add(de7);
                }
            }
        }
        ArrayList<DataElement> datiCorrelati = new ArrayList<DataElement>();
        boolean showInfoCorrelata = false;
        if (serviceBinding != null) {
            showInfoCorrelata = this.addInfoCorrelata(tipoOp, portType, modificaAbilitata, servcorr, oldStato, tipoProtocollo, serviceBinding, datiCorrelati);
        }
        boolean modificaAbilitataOrOperazioneAdd = tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata;
        boolean showSceltaNomeServizioDisabilitata = false;
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            if (!isModalitaAvanzata) {
                showSceltaNomeServizioDisabilitata = true;
            }
        } else if (gestioneErogatori || gestioneFruitori) {
            showSceltaNomeServizioDisabilitata = false;
        } else if (!isModalitaAvanzata && (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) && nomeServizio != null && nomeServizio.equals(portType) || org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) && nomeServizio != null && nomeServizio.equals(idAccordoParteComune.getNome()))) {
            showSceltaNomeServizioDisabilitata = true;
        }
        boolean showFlagPrivato = this.core.isShowFlagPrivato() && (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) && isModalitaAvanzata;
        boolean showFlagPrivatoLabel = this.core.isShowFlagPrivato() && tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato) && isModalitaAvanzata;
        boolean showTipoServizio = this.apsCore.getTipiServiziGestitiProtocollo(tipoProtocollo, serviceBinding).size() > 1;
        boolean showVersioneProtocollo = modificaAbilitataOrOperazioneAdd && this.apsCore.getVersioniProtocollo(tipoProtocollo).size() > 1;
        boolean bl = showLabelServizio = this.isModalitaAvanzata() || showTipoServizio || !showSceltaNomeServizioDisabilitata || visualizzaSceltaVersioneServizio || showInfoCorrelata || showFlagPrivato || showFlagPrivatoLabel || showVersioneProtocollo || this.isShowGestioneWorkflowStatoDocumenti() && (TipoOperazione.CHANGE.equals((Object)tipoOp) || this.isModalitaAvanzata());
        if (showLabelServizio && showInformazioniGeneraliErogazioniFruizioniView == null) {
            de7 = new DataElement();
            de7.setLabel("Servizio");
            de7.setType(DataElementType.SUBTITLE);
            dati.add(de7);
        }
        if (this.isModalitaCompleta()) {
            de7 = new DataElement();
            de7.setLabel("Descrizione");
            de7.setType(DataElementType.TEXT_AREA);
            de7.setName("descrizione");
            de7.setSize(this.getSize());
            de7.setValue(descrizione != null ? StringEscapeUtils.escapeHtml4((String)descrizione) : "");
            if (!modificaAbilitata && StringUtils.isBlank((CharSequence)descrizione)) {
                de7.setValue("");
            }
            dati.add(de7);
        } else {
            de7 = new DataElement();
            de7.setLabel("Descrizione");
            de7.setType(DataElementType.HIDDEN);
            de7.setName("descrizione");
            de7.setSize(this.getSize());
            de7.setValue(descrizione != null ? StringEscapeUtils.escapeHtml4((String)descrizione) : "");
            if (!modificaAbilitata && (descrizione == null || "".equals(descrizione))) {
                de7.setValue(" ");
            }
            dati.add(de7);
        }
        if (!this.isModalitaCompleta() && modificaDescrizione) {
            de7 = new DataElement();
            de7.setLabel("Descrizione");
            if (modificaAbilitata) {
                de7.setType(DataElementType.TEXT_AREA);
                de7.setRows(15);
                de7.setLabel("");
            } else {
                de7.setType(DataElementType.TEXT_EDIT);
            }
            de7.setName("descModifica");
            de7.setSize(this.getSize());
            de7.setValue(descrizioneModificata != null ? StringEscapeUtils.escapeHtml4((String)descrizioneModificata) : "");
            if (!modificaAbilitata && StringUtils.isBlank((CharSequence)descrizioneModificata)) {
                de7.setValue("");
            }
            dati.add(de7);
        }
        if (showTipoServizio) {
            if (modificaAbilitataOrOperazioneAdd) {
                de7 = new DataElement();
                de7.setLabel("Tipo");
                de7.setName("tiposervizio");
                if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                    de7.setValues(tipiLabel);
                    de7.setSelected(tipoServizio);
                    de7.setType(DataElementType.SELECT);
                    de7.setSize(this.getSize());
                    if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                        de7.setPostBack_viaPOST(true);
                    }
                } else {
                    de7.setType(DataElementType.HIDDEN);
                    de7.setValue(tipoServizio);
                }
                dati.add(de7);
            } else {
                de7 = new DataElement();
                de7.setLabel("Tipo");
                de7.setName("tiposervizio");
                de7.setValue(tipoServizio);
                if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                    de7.setType(DataElementType.TEXT);
                } else {
                    de7.setType(DataElementType.HIDDEN);
                }
                dati.add(de7);
            }
        } else {
            de7 = new DataElement();
            de7.setValue(tipoServizio);
            de7.setType(DataElementType.HIDDEN);
            de7.setLabel("Tipo");
            de7.setName("tiposervizio");
            dati.add(de7);
        }
        if (!showSceltaNomeServizioDisabilitata && cambiaAPI) {
            de7 = new DataElement();
            if (gestioneErogatori) {
                de7.setLabel("Erogazione");
            }
            if (gestioneFruitori) {
                de7.setLabel("Fruizione");
            }
            de7.setType(DataElementType.SUBTITLE);
            dati.add(de7);
        }
        if (showSceltaNomeServizioDisabilitata) {
            de7 = new DataElement();
            if (nomeServizio == null) {
                de7.setValue("");
            } else {
                de7.setValue(nomeServizio);
            }
            de7.setType(DataElementType.HIDDEN);
            de7.setName("nomeservizio");
            dati.add(de7);
        } else {
            de7 = new DataElement();
            if (tipoOp.equals((Object)TipoOperazione.ADD) && this.isModalitaAvanzata() && (gestioneFruitori || gestioneErogatori)) {
                if (gestioneErogatori) {
                    de7.setLabel("Nome Erogazione");
                } else {
                    de7.setLabel("Nome Fruizione");
                }
            } else {
                de7.setLabel("Nome");
            }
            if (nomeServizio == null) {
                de7.setValue("");
            } else {
                de7.setValue(nomeServizio);
            }
            if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue() || cambiaAPI) {
                if (cambiaAPI && !apiChanged) {
                    de7.setType(DataElementType.TEXT);
                } else if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) {
                    de7.setType(DataElementType.TEXT_EDIT);
                    de7.setRequired(true);
                    if (accordo == null || accordo.equals("")) {
                        de7.setType(DataElementType.HIDDEN);
                        de7.setRequired(false);
                    }
                } else {
                    de7.setType(DataElementType.TEXT);
                }
            } else {
                de7.setType(DataElementType.HIDDEN);
            }
            de7.setName("nomeservizio");
            de7.setSize(this.getSize());
            dati.add(de7);
        }
        if (uriAccordo != null && creaDataElementVersione) {
            Object versioneSelezionata;
            de7 = new DataElement();
            de7.setLabel("Versione");
            de7.setName("versione");
            Object object = versioneSelezionata = versione == null || "".equals(versione) ? "1" : versione;
            if (idAccordoParteComune == null) {
                idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
            }
            if (TipoOperazione.ADD.equals((Object)tipoOp) && this.isModalitaStandard()) {
                versioneSelezionata = "" + idAccordoParteComune.getVersione();
            }
            boolean versioneAllineataAccordoParteComune = false;
            if (TipoOperazione.CHANGE.equals((Object)tipoOp) && !cambiaAPI) {
                versioneAllineataAccordoParteComune = ("" + idAccordoParteComune.getVersione()).equals(versioneSelezionata);
            }
            de7.setValue((String)versioneSelezionata);
            if (visualizzaSceltaVersioneServizio) {
                if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue() || cambiaAPI) {
                    if (cambiaAPI && !apiChanged) {
                        de7.setType(DataElementType.TEXT);
                    } else if (modificaAbilitata) {
                        if (this.isModalitaStandard() && versioneAllineataAccordoParteComune) {
                            de7.setType(DataElementType.HIDDEN);
                        } else {
                            de7 = this.getVersionDataElement("Versione", "versione", (String)versioneSelezionata, false);
                        }
                    } else {
                        de7.setType(DataElementType.TEXT);
                    }
                } else {
                    de7.setType(DataElementType.HIDDEN);
                }
            } else {
                de7.setType(DataElementType.HIDDEN);
            }
            de7.setName("versione");
            dati.add(de7);
        }
        if (showInformazioniGeneraliErogazioniFruizioniView != null && !showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
            for (DataElement dataElement : datiCorrelati) {
                dataElement.setType(DataElementType.HIDDEN);
            }
        }
        dati.addAll(datiCorrelati);
        de7 = new DataElement();
        de7.setLabel("Privato");
        if (showFlagPrivato && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
            de7.setType(DataElementType.CHECKBOX);
            de7.setSelected(privato ? "yes" : "");
        } else {
            de7.setType(DataElementType.HIDDEN);
            de7.setValue(privato ? "yes" : "");
        }
        de7.setName("privato");
        dati.add(de7);
        if (showFlagPrivatoLabel && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
            de7 = new DataElement();
            de7.setLabel("Visibilit&agrave; Servizio");
            de7.setName("privatoLabel");
            if (privato) {
                de7.setValue("privata");
            } else {
                de7.setValue("pubblica");
            }
            dati.add(de7);
        }
        de7 = new DataElement();
        de7.setLabel("Versione Protocollo");
        if (showVersioneProtocollo && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
            if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) {
                de7.setValues(versioniValues);
                de7.setLabels(versioniLabel);
                if (profilo == null) {
                    profilo = "-";
                }
                de7.setSelected(profilo);
                de7.setType(DataElementType.SELECT);
            } else {
                de7.setType(DataElementType.TEXT);
                de7.setValue(profilo);
                if (profilo == null || "".equals(profilo)) {
                    de7.setValue("usa versione erogatore");
                }
            }
        } else {
            de7.setType(DataElementType.HIDDEN);
            if (profilo == null) {
                profilo = "-";
            }
            de7.setValue(profilo);
        }
        de7.setName("profilo");
        de7.setSize(this.getSize());
        dati.add(de7);
        if (gestioneCanaliEnabled) {
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                DataElement dataElement = new DataElement();
                dataElement.setLabel("Canale");
                dataElement.setType(DataElementType.SUBTITLE);
                dati.add(dataElement);
                this.addCanaleToDati(dati, tipoOp, canaleStato, canale, canaleAPI, canaleList, gestioneCanaliEnabled, false);
            } else {
                this.addCanaleToDatiAsHidden(dati, tipoOp, canaleStato, canale, gestioneCanaliEnabled);
            }
        }
        if (isModalitaAvanzata) {
            de7 = new DataElement();
            de7.setLabel("Stato");
            if (this.isShowGestioneWorkflowStatoDocumenti()) {
                if (tipoOp.equals((Object)TipoOperazione.ADD) || !StatiAccordo.finale.toString().equals(oldStato) && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
                    de7.setType(DataElementType.SELECT);
                    de7.setValues(StatiAccordo.toArray());
                    de7.setLabels(StatiAccordo.toLabel());
                    de7.setSelected(statoPackage);
                    de7.setName("stato");
                } else {
                    if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                        deLabel = new DataElement();
                        deLabel.setType(DataElementType.TEXT);
                        deLabel.setLabel("Stato");
                        deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.finale.toString()));
                        deLabel.setName("stato__label");
                        dati.add(deLabel);
                    }
                    de7.setType(DataElementType.HIDDEN);
                    de7.setValue(StatiAccordo.finale.toString());
                    de7.setName("stato");
                    if (ripristinoStatoOperativo) {
                        dati.add(de7);
                        if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                            de7 = new DataElement();
                            de7.setType(DataElementType.LINK);
                            pIdsoggErogatore = new Parameter("idSoggErogatore", "" + idSoggettoErogatore);
                            Parameter pNomeServizio = new Parameter("nomeservizio", nomeServizioEffettivo);
                            pTipoServizio = new Parameter("tiposervizio", tipoServizioEffettivo);
                            de7.setUrl("accordiServizioParteSpecificaChange.do", new Parameter[]{new Parameter("id", id), pNomeServizio, pTipoServizio, pIdsoggErogatore, new Parameter("backToStato", StatiAccordo.operativo.toString()), new Parameter("edit-mode", "in_progress")});
                            de7.setValue("Ripristina Stato Operativo");
                        }
                    }
                }
            } else {
                de7.setType(DataElementType.HIDDEN);
                de7.setValue(StatiAccordo.finale.toString());
                de7.setName("stato");
            }
            dati.add(de7);
        } else {
            de7 = new DataElement();
            de7.setLabel("Stato");
            de7.setName("stato");
            if (this.isShowGestioneWorkflowStatoDocumenti()) {
                if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                    de7.setType(DataElementType.HIDDEN);
                    de7.setValue(statoPackage);
                } else if (!StatiAccordo.finale.toString().equals(oldStato) && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
                    de7.setType(DataElementType.SELECT);
                    de7.setValues(StatiAccordo.toArray());
                    de7.setLabels(StatiAccordo.toLabel());
                    de7.setSelected(statoPackage);
                } else {
                    if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                        deLabel = new DataElement();
                        deLabel.setType(DataElementType.TEXT);
                        deLabel.setLabel("Stato");
                        deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.finale.toString()));
                        deLabel.setName("stato__label");
                        dati.add(deLabel);
                    }
                    de7.setType(DataElementType.HIDDEN);
                    de7.setValue(StatiAccordo.finale.toString());
                    if (ripristinoStatoOperativo) {
                        dati.add(de7);
                        if (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue()) {
                            de7 = new DataElement();
                            de7.setType(DataElementType.LINK);
                            pIdsoggErogatore = new Parameter("idSoggErogatore", "" + idSoggettoErogatore);
                            Parameter pNomeServizio = new Parameter("nomeservizio", nomeServizioEffettivo);
                            pTipoServizio = new Parameter("tiposervizio", tipoServizioEffettivo);
                            de7.setUrl("accordiServizioParteSpecificaChange.do", new Parameter[]{new Parameter("id", id), pNomeServizio, pTipoServizio, pIdsoggErogatore, new Parameter("backToStato", StatiAccordo.operativo.toString()), new Parameter("edit-mode", "in_progress")});
                            de7.setValue("Ripristina Stato Operativo");
                        }
                    }
                }
            } else {
                de7.setType(DataElementType.HIDDEN);
                de7.setValue(StatiAccordo.finale.toString());
            }
            dati.add(de7);
        }
        if (gestioneFruitori) {
            boolean showSoggettoInChange = false;
            if (tipoOp.equals((Object)TipoOperazione.ADD) || showSoggettoInChange) {
                de7 = new DataElement();
                de7.setLabel("Soggetto Erogatore");
                de7.setType(DataElementType.SUBTITLE);
                dati.add(de7);
            }
            de7 = new DataElement();
            de7.setLabel("Nome");
            de7.setName("providerErogatore");
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                de7.setType(DataElementType.SELECT);
                de7.setValues(soggettiList);
                de7.setLabels(soggettiListLabel);
                de7.setPostBack_viaPOST(true);
                de7.setSelected(provider);
                dati.add(de7);
            } else {
                de7.setValue(provider);
                de7.setType(DataElementType.HIDDEN);
                dati.add(de7);
                if (showSoggettoInChange) {
                    de7 = new DataElement();
                    de7.setLabel("Nome");
                    de7.setName("providerText");
                    de7.setType(DataElementType.TEXT);
                    de7.setValue(this.getLabelNomeSoggetto(tipoProtocollo, tipoSoggetto, nomeSoggetto));
                    dati.add(de7);
                }
            }
        }
        if (cambiaErogatore) {
            de7 = new DataElement();
            de7.setLabel("Soggetto Erogatore");
            de7.setType(DataElementType.TITLE);
            dati.add(de7);
            de7 = new DataElement();
            de7.setLabel("Nome");
            de7.setName("providerCambioErogatore");
            if (confirmInProgress) {
                de7.setType(DataElementType.HIDDEN);
                de7.setValue(provider);
            } else {
                de7.setType(DataElementType.SELECT);
                de7.setValues(soggettiList);
                de7.setLabels(soggettiListLabel);
                de7.setSelected(provider);
                de7.setRequired(true);
            }
            dati.add(de7);
            if (confirmInProgress) {
                de7 = new DataElement();
                de7.setLabel("Nome");
                de7.setName("providerCambioErogatore__label");
                de7.setType(DataElementType.TEXT);
                de7.setValue("-");
                if (soggettiList != null && soggettiList.length > 0) {
                    for (int i = 0; i < soggettiList.length; ++i) {
                        String prov = soggettiList[i];
                        if (!prov.equals(provider)) continue;
                        de7.setValue(soggettiListLabel[i]);
                        break;
                    }
                }
                dati.add(de7);
            }
        }
        if (!(tipoOp.equals((Object)TipoOperazione.ADD) || this.isModalitaCompleta() || showInformazioniGeneraliErogazioniFruizioniView != null && !showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
            de7 = new DataElement();
            de7.setType(DataElementType.LINK);
            ArrayList<Parameter> listParametersAllegati = new ArrayList<Parameter>();
            listParametersAllegati.add(new Parameter("id", id));
            if (tmpModificaAPI != null) {
                listParametersAllegati.add(new Parameter("modificaAPI", tmpModificaAPI));
            }
            if (gestioneFruitori) {
                listParametersAllegati.add(new Parameter("tipoSoggFru", tipoSoggettoFruitore));
                listParametersAllegati.add(new Parameter("nomeSoggFru", nomeSoggettoFruitore));
            }
            de7.setUrl("accordiServizioParteSpecificaAllegatiList.do", listParametersAllegati.toArray(new Parameter[1]));
            if (contaListe) {
                try {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.apsCore.serviziAllegatiList(Integer.parseInt(id), (ISearch)searchForCount);
                    int num = searchForCount.getNumEntries(Liste.SERVIZI_ALLEGATI);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Allegati", (Long)Long.valueOf(num));
                }
                catch (Exception e) {
                    this.logError("Calcolo numero Allegati non riuscito", e);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Allegati", (String)"N.D.");
                }
            } else {
                de7.setValue("Allegati");
            }
            dati.add(de7);
        }
        if (serviceBinding != null && serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP) && interfaceType.equals((Object)InterfaceType.WSDL_11) && showPortiAccesso && (showInformazioniGeneraliErogazioniFruizioniView == null || showInformazioniGeneraliErogazioniFruizioniView.booleanValue())) {
            if (isModalitaAvanzata) {
                boolean isRuoloNormale;
                de7 = new DataElement();
                de7.setLabel("Specifica dei Porti di Accesso");
                de7.setType(DataElementType.SUBTITLE);
                dati.add(de7);
                de7 = new DataElement();
                de7.setLabel("Validazione Documenti");
                de7.setValue("" + validazioneDocumenti);
                if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                    de7.setType(DataElementType.CHECKBOX);
                    if (validazioneDocumenti) {
                        de7.setSelected("yes");
                    } else {
                        de7.setSelected("no");
                    }
                } else {
                    de7.setType(DataElementType.HIDDEN);
                }
                de7.setName("validazioneDocumenti");
                de7.setSize(this.getSize());
                dati.add(de7);
                boolean isSupportoAsincrono = this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(tipoProtocollo, serviceBinding);
                boolean bl2 = isRuoloNormale = servcorr == null || !servcorr.equals("yes") && !servcorr.equals("abilitato");
                if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                    if (isSupportoAsincrono) {
                        if (isRuoloNormale) {
                            dati.add(wsdlimpler.getFileDataElement("WSDL Impl. Erogatore", "", this.getSize()));
                            dati.addAll(wsdlimpler.getFileNameDataElement());
                            dati.add(wsdlimpler.getFileIdDataElement());
                        } else {
                            dati.add(wsdlimplfru.getFileDataElement("WSDL Impl. Fruitore", "", this.getSize()));
                            dati.addAll(wsdlimplfru.getFileNameDataElement());
                            dati.add(wsdlimplfru.getFileIdDataElement());
                        }
                    } else {
                        dati.add(wsdlimpler.getFileDataElement("WSDL Implementativo", "", this.getSize()));
                        dati.addAll(wsdlimpler.getFileNameDataElement());
                        dati.add(wsdlimpler.getFileIdDataElement());
                    }
                } else {
                    ArrayList<Parameter> listParametersWSDLChange = new ArrayList<Parameter>();
                    listParametersWSDLChange.add(new Parameter("id", id));
                    if (gestioneFruitori) {
                        listParametersWSDLChange.add(new Parameter("tipoSoggFru", tipoSoggettoFruitore));
                        listParametersWSDLChange.add(new Parameter("nomeSoggFru", nomeSoggettoFruitore));
                    }
                    if (isSupportoAsincrono) {
                        if (isRuoloNormale) {
                            de7 = new DataElement();
                            de7.setType(DataElementType.LINK);
                            listParametersWSDLChange.add(new Parameter("tipo", "wsdlimpler"));
                            de7.setUrl("accordiServizioParteSpecificaWSDLChange.do", listParametersWSDLChange.toArray(new Parameter[1]));
                            de7.setValue("WSDL Implementativo Erogatore");
                            dati.add(de7);
                        } else {
                            de7 = new DataElement();
                            de7.setType(DataElementType.LINK);
                            listParametersWSDLChange.add(new Parameter("tipo", "wsdlimplfru"));
                            de7.setUrl("accordiServizioParteSpecificaWSDLChange.do", listParametersWSDLChange.toArray(new Parameter[1]));
                            de7.setValue("WSDL Implementativo Fruitore");
                            dati.add(de7);
                        }
                    } else {
                        de7 = new DataElement();
                        de7.setType(DataElementType.LINK);
                        listParametersWSDLChange.add(new Parameter("tipo", "wsdlimpler"));
                        de7.setUrl("accordiServizioParteSpecificaWSDLChange.do", listParametersWSDLChange.toArray(new Parameter[1]));
                        de7.setValue("WSDL Implementativo");
                        dati.add(de7);
                    }
                }
            } else if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                de7 = new DataElement();
                String wsdlimplerS = wsdlimpler.getValue() != null ? new String(wsdlimpler.getValue()) : "";
                de7.setValue(wsdlimplerS);
                de7.setType(DataElementType.HIDDEN);
                de7.setName("wsdlimpler");
                dati.add(de7);
                de7 = new DataElement();
                String wsdlimplfruS = wsdlimpler.getValue() != null ? new String(wsdlimpler.getValue()) : "";
                de7.setValue(wsdlimplfruS);
                de7.setType(DataElementType.HIDDEN);
                de7.setName("wsdlimplfru");
                dati.add(de7);
            }
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD) && (accordo == null || accordo.equals(""))) {
            return dati;
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD) && !ServletUtils.isCheckBoxEnabled((String)servcorr) && generaPACheckSoggetto) {
            if (this.isModalitaCompleta()) {
                de7 = new DataElement();
                de7.setLabel("Servizio Applicativo Erogatore");
                de7.setType(DataElementType.TITLE);
                dati.add(de7);
                de7 = new DataElement();
                de7.setLabel("Nome");
                de7.setName("nomeServizioApplicativo");
                de7.setSelected(nomeSA);
                de7.setValues(saSoggetti);
                de7.setType(DataElementType.SELECT);
                dati.add(de7);
            }
            PortaApplicativa pa = new PortaApplicativa();
            pa.setServizio(new PortaApplicativaServizio());
            pa.getServizio().setTipo(tipoServizio);
            boolean forceAutenticato = false;
            boolean forceHttps = false;
            boolean forceDisableOptional = false;
            boolean forceGestioneToken = false;
            boolean forceMostraSezioneToken = false;
            if (this.isProfiloModIPA(tipoProtocollo)) {
                if (idAccordoParteComune == null) {
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
                }
                forceHttps = forceAutenticato = true;
                boolean forcePDND = false;
                boolean forceOAuth = false;
                BooleanNullable forceHttpsClientWrapper = BooleanNullable.NULL();
                BooleanNullable forcePDNDWrapper = BooleanNullable.NULL();
                BooleanNullable forceOAuthWrapper = BooleanNullable.NULL();
                this.readModIConfiguration(forceHttpsClientWrapper, forcePDNDWrapper, forceOAuthWrapper, idAccordoParteComune, portType, null);
                if (forceHttpsClientWrapper.getValue() != null) {
                    forceDisableOptional = forceHttpsClientWrapper.getValue();
                }
                if (forcePDNDWrapper.getValue() != null) {
                    forcePDND = forcePDNDWrapper.getValue();
                }
                if (forceOAuthWrapper.getValue() != null) {
                    forceOAuth = forceOAuthWrapper.getValue();
                }
                if (forcePDND || forceOAuth) {
                    GenericProperties gp;
                    forceGestioneToken = true;
                    forceMostraSezioneToken = true;
                    gestioneToken = StatoFunzionalita.ABILITATO.getValue();
                    if (forcePDND) {
                        tokenPolicies = this.getTokenPolicyGestione(true, false, false, gestioneTokenPolicy, tipoOp);
                        if (tokenPolicies != null && !tokenPolicies.isEmpty()) {
                            if (gestioneTokenPolicy == null || StringUtils.isEmpty((CharSequence)gestioneTokenPolicy) || "-".equals(gestioneTokenPolicy)) {
                                gestioneTokenPolicy = tokenPolicies.get(0);
                            }
                            gestioneTokenPolicyLabels = tokenPolicies.toArray(new String[1]);
                            gestioneTokenPolicyValues = tokenPolicies.toArray(new String[1]);
                        }
                    } else {
                        tokenPolicies = this.getTokenPolicyGestione(false, true, false, gestioneTokenPolicy, tipoOp);
                        if (tokenPolicies != null && !tokenPolicies.isEmpty()) {
                            if (gestioneTokenPolicy == null || StringUtils.isEmpty((CharSequence)gestioneTokenPolicy) || "-".equals(gestioneTokenPolicy)) {
                                gestioneTokenPolicy = tokenPolicies.get(0);
                            }
                            gestioneTokenPolicyLabels = tokenPolicies.toArray(new String[1]);
                            gestioneTokenPolicyValues = tokenPolicies.toArray(new String[1]);
                        }
                    }
                    gestioneTokenOpzionale = StatoFunzionalita.DISABILITATO.getValue();
                    if (gestioneTokenPolicy != null && StringUtils.isNotEmpty((CharSequence)gestioneTokenPolicy) && !"-".equals(gestioneTokenPolicy) && (gp = this.confCore.getGenericProperties(gestioneTokenPolicy, "gestionePolicyToken", false)) != null && gp.sizePropertyList() > 0) {
                        for (Property p : gp.getPropertyList()) {
                            if ("policy.validazioneJWT.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenValidazioneInput = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenValidazioneInput = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if ("policy.introspection.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenIntrospection = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenIntrospection = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if ("policy.userInfo.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenUserInfo = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenUserInfo = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if (!"policy.tokenForward.stato".equals(p.getNome())) continue;
                            if ("true".equalsIgnoreCase(p.getValore())) {
                                gestioneTokenForward = StatoFunzionalita.ABILITATO.getValue();
                                continue;
                            }
                            gestioneTokenForward = StatoFunzionalita.DISABILITATO.getValue();
                        }
                    }
                }
            }
            this.controlloAccessiAdd(dati, tipoOp, controlloAccessiStato, forceAutenticato);
            this.controlloAccessiGestioneToken(dati, tipoOp, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, null, tipoProtocollo, false, forceGestioneToken, forceMostraSezioneToken);
            this.controlloAccessiAutenticazione(dati, tipoOp, "accordiServizioParteSpecificaAdd.do", pa, tipoProtocollo, erogazioneAutenticazione, null, erogazioneAutenticazioneOpzionale, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, false, erogazioneIsSupportatoAutenticazioneSoggetti, false, gestioneToken, gestioneTokenPolicy, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, false, null, 0, forceHttps, forceDisableOptional);
            this.controlloAccessiAutorizzazione(dati, tipoOp, "accordiServizioParteSpecificaAdd.do", pa, tipoProtocollo, erogazioneAutenticazione, null, erogazioneAutorizzazione, null, erogazioneAutorizzazioneAutenticati, null, 0, soggettiAutenticati, soggettiAutenticatiLabel, soggettoAutenticato, erogazioneAutorizzazioneRuoli, null, 0, erogazioneRuolo, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, false, erogazioneIsSupportatoAutenticazioneSoggetti, contaListe, false, false, autorizzazioneScope, null, 0, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazioneToken, autorizzazioneTokenOptions, allegatoXacmlPolicy, null, 0, null, 0, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, null, 0, autorizzazioneRuoliToken, null, 0, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD) && gestioneFruitori) {
            PortaDelegata pd = new PortaDelegata();
            pd.setServizio(new PortaDelegataServizio());
            pd.getServizio().setTipo(tipoServizio);
            this.controlloAccessiAdd(dati, tipoOp, controlloAccessiStato, false);
            this.controlloAccessiGestioneToken(dati, tipoOp, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, null, tipoProtocollo, true, false);
            this.controlloAccessiAutenticazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", pd, tipoProtocollo, fruizioneAutenticazione, null, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, false, true, true, gestioneToken, gestioneTokenPolicy, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, false, null, 0, false, false);
            this.controlloAccessiAutorizzazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", pd, tipoProtocollo, fruizioneAutenticazione, null, fruizioneAutorizzazione, null, fruizioneAutorizzazioneAutenticati, null, 0, saList, fruizioneServizioApplicativo, fruizioneAutorizzazioneRuoli, null, 0, fruizioneRuolo, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, false, true, contaListe, true, false, autorizzazioneScope, null, 0, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazioneToken, autorizzazioneTokenOptions, allegatoXacmlPolicy, null, 0, null, 0, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, null, 0, autorizzazioneRuoliToken, null, 0, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
        }
        if (!tipoOp.equals((Object)TipoOperazione.ADD) && this.isModalitaCompleta()) {
            de7 = new DataElement();
            de7.setLabel("Altre informazioni");
            de7.setType(DataElementType.TITLE);
            dati.add(de7);
            de7 = new DataElement();
            de7.setType(DataElementType.LINK);
            de7.setUrl("accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", id), new Parameter("idSoggErogatore", "" + idSoggettoErogatore), new Parameter("nomeservizio", nomeServizioEffettivo), new Parameter("tiposervizio", tipoServizioEffettivo)});
            if (contaListe) {
                try {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.apsCore.serviziFruitoriList(Integer.parseInt(id), (ISearch)searchForCount);
                    int num = searchForCount.getNumEntries(Liste.SERVIZI_FRUITORI);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Fruizioni", (Long)Long.valueOf(num));
                }
                catch (Exception e) {
                    this.logError("Calcolo numero fruitori non riuscito", e);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Fruizioni", (String)"N.D.");
                }
            } else {
                de7.setValue("Fruizioni");
            }
            dati.add(de7);
            de7 = new DataElement();
            de7.setType(DataElementType.LINK);
            de7.setUrl("accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", id)});
            if (contaListe) {
                try {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.apsCore.serviziAllegatiList(Integer.parseInt(id), (ISearch)searchForCount);
                    int num = searchForCount.getNumEntries(Liste.SERVIZI_ALLEGATI);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Allegati", (Long)Long.valueOf(num));
                }
                catch (Exception e) {
                    this.logError("Calcolo numero Allegati non riuscito", e);
                    ServletUtils.setDataElementCustomLabel((DataElement)de7, (String)"Allegati", (String)"N.D.");
                }
            } else {
                de7.setValue("Allegati");
            }
            dati.add(de7);
        }
        if (cambiaAPI && !apiChanged) {
            this.pd.disableOnlyButton();
        }
        return dati;
    }

    public List<DataElement> addServiziToDatiAsHidden(List<DataElement> dati, String nomeservizio, String tiposervizio, String provider, String tipoSoggetto, String nomeSoggetto, String[] soggettiList, String[] soggettiListLabel, String accordo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String[] accordiList, String[] accordiListLabel, String servcorr, String wsdlimpler, String wsdlimplfru, TipoOperazione tipoOp, String id, List<String> tipi, String profilo, String portType, String[] ptList, boolean privato, String uriAccordo, String descrizione, long idSoggettoErogatore, String statoPackage, String oldStato, String versione, List<String> versioni, boolean validazioneDocumenti, String[] saSoggetti, String nomeSA, String protocollo, boolean generaPACheckSoggetto) throws Exception {
        String[] tipiLabel = new String[tipi.size()];
        for (int i = 0; i < tipi.size(); ++i) {
            String nomeTipo;
            tipiLabel[i] = nomeTipo = tipi.get(i);
        }
        String[] versioniValues = new String[versioni.size() + 1];
        String[] versioniLabel = new String[versioni.size() + 1];
        versioniLabel[0] = "usa versione erogatore";
        versioniValues[0] = "-";
        for (int i = 0; i < versioni.size(); ++i) {
            String tmp;
            versioniLabel[i + 1] = tmp = versioni.get(i);
            versioniValues[i + 1] = tmp;
        }
        boolean modificaAbilitata = !this.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(oldStato);
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        DataElement de = new DataElement();
        de.setLabel("API");
        de.setType(DataElementType.HIDDEN);
        de.setName("accordo");
        de.setValue(accordo);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Servizio");
        de.setType(DataElementType.HIDDEN);
        de.setName("port_type");
        de.setValue(portType);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("providerErogatore");
        de.setValue(provider);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setType(DataElementType.HIDDEN);
        de.setName("descrizione");
        de.setSize(this.getSize());
        de.setValue(descrizione != null ? descrizione : "");
        if (!modificaAbilitata && (descrizione == null || "".equals(descrizione))) {
            de.setValue(" ");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(statoPackage);
        de.setName("stato");
        dati.add(de);
        de = new DataElement();
        de.setValue(tiposervizio);
        de.setType(DataElementType.HIDDEN);
        de.setLabel("Tipo");
        de.setName("tiposervizio");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setType(DataElementType.HIDDEN);
        de.setName("nomeservizio");
        de.setValue(nomeservizio);
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Versione");
        de.setValue(versione);
        de.setType(DataElementType.HIDDEN);
        de.setName("versione");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Correlato");
        de.setType(DataElementType.HIDDEN);
        de.setName("servcorr");
        if (this.core.isShowCorrelazioneAsincronaInAccordi() && (!isModalitaAvanzata || portType != null && !"".equals(portType) && !"-".equals(portType))) {
            if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
                de.setValue("yes");
            } else {
                de.setValue("no");
            }
        } else if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
            if (tipoOp.equals((Object)TipoOperazione.ADD) || modificaAbilitata) {
                de.setSelected("yes");
            } else {
                de.setValue("yes");
            }
        } else if (tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato)) {
            de.setValue("no");
        }
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato) || this.core.isShowCorrelazioneAsincronaInAccordi() && (!isModalitaAvanzata || portType != null && !"".equals(portType) && !"-".equals(portType))) {
            de = new DataElement();
            de.setLabel("Tipologia Servizio");
            de.setName("servcorrLabel");
            if (servcorr != null && (servcorr.equals("yes") || servcorr.equals("abilitato"))) {
                de.setValue("correlato");
            } else {
                de.setValue("normale");
            }
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Privato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(privato ? "yes" : "no");
        de.setName("privato");
        dati.add(de);
        if (this.core.isShowFlagPrivato() && tipoOp.equals((Object)TipoOperazione.CHANGE) && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(oldStato) && isModalitaAvanzata) {
            de = new DataElement();
            de.setLabel("Visibilit&agrave; Servizio");
            de.setName("privatoLabel");
            if (privato) {
                de.setValue("privata");
            } else {
                de.setValue("pubblica");
            }
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Versione Protocollo");
        de.setType(DataElementType.HIDDEN);
        if (profilo == null) {
            profilo = "-";
        }
        de.setValue(profilo);
        de.setName("profilo");
        de.setSize(this.getSize());
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.ADD) && !ServletUtils.isCheckBoxEnabled((String)servcorr) && generaPACheckSoggetto) {
            de = new DataElement();
            de.setLabel("Nome");
            de.setName("nomeServizioApplicativo");
            de.setType(DataElementType.HIDDEN);
            de.setValue(nomeSA);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Validazione Documenti");
        de.setValue("" + validazioneDocumenti);
        de.setType(DataElementType.HIDDEN);
        de.setName("validazioneDocumenti");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(wsdlimpler);
        de.setType(DataElementType.HIDDEN);
        de.setName("wsdlimpler");
        dati.add(de);
        de = new DataElement();
        de.setValue(wsdlimplfru);
        de.setType(DataElementType.HIDDEN);
        de.setName("wsdlimplfru");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addWSDLToDati(TipoOperazione tipoOp, int size, AccordoServizioParteSpecifica asps, String oldwsdl, String tipo, boolean validazioneDocumenti, List<DataElement> dati, String tipologiaDocumentoScaricare, String label) {
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        DataElement de = new DataElement();
        if (label.contains(" di ")) {
            de.setLabel(label.split(" di")[0]);
        } else {
            de.setLabel(tipologiaDocumentoScaricare.toUpperCase().charAt(0) + tipologiaDocumentoScaricare.substring(1));
        }
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo");
        dati.add(de);
        if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(asps.getStatoPackage())) {
            this.pd.setMode("view-noeditbutton");
            if (this.core.isShowInterfacceAPI()) {
                de = new DataElement();
                de.setLabel("");
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setValue(oldwsdl);
                de.setRows(30);
                de.setCols(110);
                dati.add(de);
            }
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", "" + asps.getId()), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "asps")});
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
            } else {
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
        } else {
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                if (this.core.isShowInterfacceAPI()) {
                    de = new DataElement();
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setValue(oldwsdl);
                    de.setRows(30);
                    de.setCols(110);
                    dati.add(de);
                }
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", "" + asps.getId()), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "asps")});
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Aggiornamento WSDL");
                de.setValue("");
                de.setSize(this.getSize());
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("Attuale");
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Validazione");
            de.setValue("" + validazioneDocumenti);
            if (isModalitaAvanzata) {
                de.setType(DataElementType.CHECKBOX);
                if (validazioneDocumenti) {
                    de.setSelected("yes");
                } else {
                    de.setSelected("no");
                }
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("validazioneDocumenti");
            de.setSize(size);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nuovo WSDL");
            de.setValue("");
            de.setType(DataElementType.FILE);
            de.setName("wsdl");
            de.setSize(size);
            dati.add(de);
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                de = new DataElement();
                de.setBold(true);
                de.setLabel("Attenzione");
                de.setValue("Se si desidera eliminare un documento precedentemente caricato cliccare su 'Invi&agrave; senza selezionare alcun file");
                de.setType(DataElementType.NOTE);
                de.setName("wsdlWarn");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
        return dati;
    }

    public List<DataElement> addTipoNomeServizioToDati(TipoOperazione tipoOp, String myId, String tipoServizio, String nomeServizio, Integer versioneServizio, List<DataElement> dati) {
        DataElement de = new DataElement();
        if (nomeServizio != null) {
            de = new DataElement();
            de.setName("nomeservizio");
            de.setType(DataElementType.HIDDEN);
            de.setValue(nomeServizio);
            dati.add(de);
        }
        if (tipoServizio != null) {
            de = new DataElement();
            de.setName("tiposervizio");
            de.setType(DataElementType.HIDDEN);
            de.setValue(tipoServizio);
            dati.add(de);
        }
        if (versioneServizio != null) {
            de = new DataElement();
            de.setName("versione");
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + versioneServizio);
            dati.add(de);
        }
        if (myId != null) {
            de = new DataElement();
            de.setName("myId");
            de.setType(DataElementType.HIDDEN);
            de.setValue(myId);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addFruitoreWSDLToDati(TipoOperazione tipoOp, String tipo, String idSoggettoErogatoreDelServizio, String idSoggettoFruitore, String wsdl, Boolean validazioneDocumenti, Fruitore myFru, List<DataElement> dati, String id, String tipologiaDocumentoScaricare, boolean finished, String label) {
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        DataElement de = new DataElement();
        if (label.contains(" di ")) {
            de.setLabel(label.split(" di")[0]);
        } else {
            de.setLabel(tipologiaDocumentoScaricare.toUpperCase().charAt(0) + tipologiaDocumentoScaricare.substring(1));
        }
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("idErogatore");
        de.setValue(idSoggettoErogatoreDelServizio);
        de.setType(DataElementType.HIDDEN);
        de.setName("idSoggErogatore");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(idSoggettoFruitore);
        de.setType(DataElementType.HIDDEN);
        de.setName("providerFruitore");
        dati.add(de);
        if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(myFru.getStatoPackage())) {
            this.pd.setMode("view-noeditbutton");
            if (wsdl != null && !wsdl.isEmpty()) {
                this.pd.setMode("view-noeditbutton");
                if (this.core.isShowInterfacceAPI()) {
                    de = new DataElement();
                    de.setLabel("");
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setValue(wsdl);
                    de.setRows(30);
                    de.setCols(110);
                    dati.add(de);
                }
                if (wsdl != null && !wsdl.isEmpty()) {
                    DataElement saveAs = new DataElement();
                    saveAs.setValue("Download");
                    saveAs.setType(DataElementType.LINK);
                    saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("wsdlImplementativoTipoSoggettoFruitore", myFru.getTipo()), new Parameter("wsdlImplementativoNomeSoggettoFruitore", myFru.getNome()), new Parameter("tipoDocumento", "asps")});
                    saveAs.setDisabilitaAjaxStatus();
                    dati.add(saveAs);
                }
            } else {
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
        } else {
            if (wsdl != null && !wsdl.isEmpty()) {
                if (this.core.isShowInterfacceAPI()) {
                    de = new DataElement();
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setValue(wsdl);
                    de.setRows(30);
                    de.setCols(110);
                    dati.add(de);
                }
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("wsdlImplementativoTipoSoggettoFruitore", myFru.getTipo()), new Parameter("wsdlImplementativoNomeSoggettoFruitore", myFru.getNome()), new Parameter("tipoDocumento", "asps")});
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
                if (!finished) {
                    de = new DataElement();
                    de.setType(DataElementType.TITLE);
                    de.setLabel("Aggiornamento WSDL");
                    de.setValue("");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel("Attuale");
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Validazione");
            de.setValue("" + validazioneDocumenti);
            if (isModalitaAvanzata && !finished) {
                de.setType(DataElementType.CHECKBOX);
                if (validazioneDocumenti.booleanValue()) {
                    de.setSelected("yes");
                } else {
                    de.setSelected("no");
                }
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("validazioneDocumenti");
            de.setSize(this.getSize());
            dati.add(de);
            if (!finished) {
                de = new DataElement();
                de.setLabel("Nuovo WSDL");
                de.setValue("");
                de.setType(DataElementType.FILE);
                de.setName("wsdl");
                de.setSize(this.getSize());
                dati.add(de);
                if (wsdl != null && !wsdl.isEmpty()) {
                    de = new DataElement();
                    de.setBold(true);
                    de.setLabel("Attenzione");
                    de.setValue("Se si desidera eliminare un documento precedentemente caricato cliccare su 'Invi&agrave; senza selezionare alcun file");
                    de.setType(DataElementType.NOTE);
                    de.setName("wsdlWarn");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            }
        }
        return dati;
    }

    public List<DataElement> addServiziFruitoriToDati(List<DataElement> dati, String idSoggettoFruitore, BinaryParameter wsdlimpler, BinaryParameter wsdlimplfru, String[] soggettiList, String[] soggettiListLabel, String idServ, String id, TipoOperazione tipoOp, String idSoggettoErogatoreDelServizio, String nomeprov, String tipoprov, String nomeservizio, String tiposervizio, Integer versioneservizio, String correlato, String stato, String oldStato, String statoServizio, String tipoAccordo, boolean validazioneDocumenti, String controlloAccessiStato, String fruizioneServizioApplicativo, String fruizioneRuolo, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, List<String> saList, org.openspcoop2.message.constants.ServiceBinding serviceBinding, InterfaceType interfaceType, String azioneConnettore, String azioneConnettoreIdPorta, String accessoDaAPSParametro, Integer parentPD, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws Exception {
        DataElement de;
        boolean isRuoloNormale = correlato == null || !correlato.equals("correlato");
        String protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(tiposervizio);
        boolean isProfiloAsincronoSupportatoDalProtocollo = this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(protocollo, serviceBinding);
        boolean ripristinoStatoOperativo = this.core.isGestioneWorkflowStatoDocumentiRipristinoStatoOperativoDaFinale();
        Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        boolean showPortiAccesso = this.apcCore.showPortiAccesso(protocollo, serviceBinding, interfaceType);
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        String tmpModificaProfilo = this.getParameter("modificaProfilo");
        boolean modificaProfilo = false;
        if (tmpModificaProfilo != null) {
            modificaProfilo = "true".equals(tmpModificaProfilo);
            de = new DataElement();
            de.setName("modificaProfilo");
            de.setValue(tmpModificaProfilo);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (azioneConnettore != null && !"".equals(azioneConnettore)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(azioneConnettore);
            de.setName("fruitoreViewConnettoreAzione");
            dati.add(de);
        }
        if (azioneConnettoreIdPorta != null && !"".equals(azioneConnettoreIdPorta)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(azioneConnettoreIdPorta);
            de.setName("fruitoreViewConnettoreAzioneIdPorta");
            dati.add(de);
        }
        if (accessoDaAPSParametro != null && !"".equals(accessoDaAPSParametro)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(accessoDaAPSParametro);
            de.setName("connettoreDaListaAps");
            dati.add(de);
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Fruizione");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setName("providerFruitore");
            de.setType(DataElementType.SELECT);
            de.setValues(soggettiList);
            de.setLabels(soggettiListLabel);
            de.setSelected(idSoggettoFruitore);
            de.setPostBack(true);
            dati.add(de);
            if (this.isShowGestioneWorkflowStatoDocumenti()) {
                de = new DataElement();
                de.setLabel("Stato");
                if (this.isModalitaStandard()) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(statoServizio);
                } else {
                    de.setType(DataElementType.SELECT);
                    de.setValues(StatiAccordo.toArray());
                    de.setLabels(StatiAccordo.toLabel());
                    de.setSelected(stato);
                }
                de.setName("stato");
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("Stato");
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.finale.toString());
                de.setName("stato");
                dati.add(de);
            }
            boolean isSoggettoGestitoPorta = false;
            String protocolloSoggettoGestitoPorta = null;
            if (soggettiList != null && soggettiList.length > 0) {
                Soggetto sogg;
                String soggettoId = idSoggettoFruitore;
                if (soggettoId == null || "".equals(soggettoId)) {
                    soggettoId = soggettiList[0];
                }
                if (!this.pddCore.isPddEsterna((sogg = this.soggettiCore.getSoggettoRegistro(Long.parseLong(soggettoId))).getPortaDominio())) {
                    isSoggettoGestitoPorta = true;
                    protocolloSoggettoGestitoPorta = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sogg.getTipo());
                }
            }
            if (isSoggettoGestitoPorta) {
                this.controlloAccessiAdd(dati, tipoOp, controlloAccessiStato, false);
                this.controlloAccessiGestioneToken(dati, tipoOp, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, null, protocolloSoggettoGestitoPorta, true, false);
                this.controlloAccessiAutenticazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", null, protocolloSoggettoGestitoPorta, fruizioneAutenticazione, null, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, false, true, true, gestioneToken, gestioneTokenPolicy, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, false, null, 0, false, false);
                this.controlloAccessiAutorizzazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", null, protocolloSoggettoGestitoPorta, fruizioneAutenticazione, null, fruizioneAutorizzazione, null, fruizioneAutorizzazioneAutenticati, null, 0, saList, fruizioneServizioApplicativo, fruizioneAutorizzazioneRuoli, null, 0, fruizioneRuolo, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, false, true, contaListe, true, false, autorizzazioneScope, null, 0, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazioneToken, autorizzazioneTokenOptions, allegatoXacmlPolicy, null, 0, null, 0, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, null, 0, autorizzazioneRuoliToken, null, 0, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
            }
            if (serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP) && interfaceType.equals((Object)InterfaceType.WSDL_11) && showPortiAccesso) {
                if (this.isModalitaAvanzata()) {
                    de = new DataElement();
                    de.setLabel("Specifica dei Porti di Accesso");
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Validazione Documenti");
                de.setValue("" + validazioneDocumenti);
                if (tipoOp.equals((Object)TipoOperazione.ADD) && this.isModalitaAvanzata()) {
                    de.setType(DataElementType.CHECKBOX);
                    if (validazioneDocumenti) {
                        de.setSelected("yes");
                    } else {
                        de.setSelected("no");
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setName("validazioneDocumenti");
                de.setSize(this.getSize());
                dati.add(de);
                if (this.isModalitaAvanzata()) {
                    if (isProfiloAsincronoSupportatoDalProtocollo) {
                        if (isRuoloNormale) {
                            dati.add(wsdlimpler.getFileDataElement("WSDL Impl. Erogatore", "", this.getSize()));
                            dati.addAll(wsdlimpler.getFileNameDataElement());
                            dati.add(wsdlimpler.getFileIdDataElement());
                        } else {
                            dati.add(wsdlimplfru.getFileDataElement("WSDL Impl. Fruitore", "", this.getSize()));
                            dati.addAll(wsdlimplfru.getFileNameDataElement());
                            dati.add(wsdlimplfru.getFileIdDataElement());
                        }
                    } else {
                        dati.add(wsdlimpler.getFileDataElement("WSDL Implementativo", "", this.getSize()));
                        dati.addAll(wsdlimpler.getFileNameDataElement());
                        dati.add(wsdlimpler.getFileIdDataElement());
                    }
                } else {
                    de = new DataElement();
                    de.setValue("");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("wsdlimpler");
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("wsdlimplfru");
                    dati.add(de);
                }
            }
        } else {
            IDSoggetto idSoggetto;
            DataElement de2;
            boolean viewOnlyConnettore;
            boolean bl = viewOnlyConnettore = gestioneFruitori || 2 == parentPD;
            if (!viewOnlyConnettore) {
                de2 = new DataElement();
                de2.setType(DataElementType.TITLE);
                de2.setLabel("Fruizione");
                dati.add(de2);
            }
            de2 = new DataElement();
            de2.setName("providerFruitore");
            de2.setValue(idSoggettoFruitore);
            de2.setType(DataElementType.HIDDEN);
            dati.add(de2);
            String nomeSoggetto = "";
            for (int i = 0; i < soggettiList.length; ++i) {
                if (!soggettiList[i].equals(idSoggettoFruitore)) continue;
                nomeSoggetto = soggettiListLabel[i];
                break;
            }
            if (this.apsCore.isRegistroServiziLocale()) {
                de2 = new DataElement();
                de2.setLabel("Nome");
                String[] split = nomeSoggetto.split("/");
                idSoggetto = new IDSoggetto(split[0], split[1]);
                de2.setValue(this.getLabelNomeSoggetto(protocollo, idSoggetto.getTipo(), idSoggetto.getNome()));
                if (!viewOnlyConnettore) {
                    de2.setType(DataElementType.TEXT);
                } else {
                    de2.setType(DataElementType.HIDDEN);
                }
                dati.add(de2);
            }
            if (this.isModalitaCompleta() && !viewOnlyConnettore) {
                de2 = new DataElement();
                if (this.apsCore.isRegistroServiziLocale()) {
                    de2.setValue("Visualizza Dati Soggetto");
                    String[] split = nomeSoggetto.split("/");
                    idSoggetto = new IDSoggetto(split[0], split[1]);
                    long idSoggettoLong = this.soggettiCore.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo());
                    de2.setType(DataElementType.LINK);
                    de2.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + idSoggettoLong), new Parameter("nomeprov", idSoggetto.getNome()), new Parameter("tipoprov", idSoggetto.getTipo())});
                } else {
                    de2.setName("providerFruitoreAsText");
                    de2.setValue(nomeSoggetto);
                    de2.setType(DataElementType.TEXT);
                }
                dati.add(de2);
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.isModalitaCompleta() && !viewOnlyConnettore) {
                de2 = new DataElement();
                de2.setType(DataElementType.TITLE);
                de2.setLabel("Stato");
                dati.add(de2);
            }
            de2 = new DataElement();
            de2.setLabel("Stato");
            if (this.isShowGestioneWorkflowStatoDocumenti()) {
                if (viewOnlyConnettore) {
                    de2.setType(DataElementType.HIDDEN);
                    de2.setValue(stato);
                    de2.setName("stato");
                } else if (!StatiAccordo.finale.toString().equals(oldStato)) {
                    de2.setType(DataElementType.SELECT);
                    de2.setValues(StatiAccordo.toArray());
                    de2.setLabels(StatiAccordo.toLabel());
                    de2.setSelected(stato);
                    de2.setName("stato");
                } else {
                    DataElement deLabel = new DataElement();
                    deLabel.setType(DataElementType.TEXT);
                    deLabel.setLabel("Stato");
                    deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.finale.toString()));
                    deLabel.setName("stato__label");
                    dati.add(deLabel);
                    de2.setType(DataElementType.HIDDEN);
                    de2.setValue(StatiAccordo.finale.toString());
                    de2.setName("stato");
                    if (ripristinoStatoOperativo) {
                        dati.add(de2);
                        de2 = new DataElement();
                        de2.setType(DataElementType.LINK);
                        Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", idSoggettoErogatoreDelServizio);
                        Parameter pId = new Parameter("id", idServ);
                        Parameter pMyId = new Parameter("myId", id);
                        Parameter pFruitore = new Parameter("providerFruitore", idSoggettoFruitore);
                        de2.setUrl("accordiServizioParteSpecificaFruitoriChange.do", new Parameter[]{pId, pMyId, pIdSoggettoErogatore, pFruitore, new Parameter("backToStato", StatiAccordo.operativo.toString()), new Parameter("edit-mode", "in_progress")});
                        de2.setValue("Ripristina Stato Operativo");
                    }
                }
            } else {
                de2.setType(DataElementType.HIDDEN);
                de2.setValue(StatiAccordo.finale.toString());
                de2.setName("stato");
            }
            dati.add(de2);
            Parameter pCorrelato = null;
            if (correlato != null) {
                pCorrelato = new Parameter("correlato", correlato);
            }
            Parameter pTipoWSDLEr = new Parameter("tipo", "wsdlimpler");
            Parameter pTipoWSDLFru = new Parameter("tipo", "wsdlimplfru");
            Parameter pId = new Parameter("id", id);
            Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", idSoggettoErogatoreDelServizio);
            Parameter pIdSoggettoFruitore = new Parameter("providerFruitore", idSoggettoFruitore);
            Parameter pIdServ = new Parameter("idServ", idServ);
            Parameter pNomeProv = new Parameter("nomeprov", nomeprov);
            Parameter pTipoProv = new Parameter("tipoprov", tipoprov);
            Parameter pNomeServizio = new Parameter("nomeservizio", nomeservizio);
            Parameter pTipoServizio = new Parameter("tiposervizio", tiposervizio);
            Parameter pVersioneServizio = new Parameter("versione", "" + versioneservizio);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            if (!viewOnlyConnettore && serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP) && interfaceType.equals((Object)InterfaceType.WSDL_11) && showPortiAccesso && this.isModalitaAvanzata()) {
                de2 = new DataElement();
                de2.setLabel("Specifica dei Porti di Accesso");
                de2.setType(DataElementType.TITLE);
                dati.add(de2);
                if (isProfiloAsincronoSupportatoDalProtocollo) {
                    ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                    if (isRuoloNormale) {
                        lstParam = new ArrayList();
                        lstParam.add(pId);
                        lstParam.add(pIdSoggettoErogatore);
                        lstParam.add(pIdSoggettoFruitore);
                        lstParam.add(pTipoWSDLEr);
                        if (pCorrelato != null) {
                            lstParam.add(pCorrelato);
                        }
                        de2 = new DataElement();
                        de2.setType(DataElementType.LINK);
                        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                            de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                        } else {
                            lstParam.add(pIdServ);
                            lstParam.add(pNomeProv);
                            lstParam.add(pTipoProv);
                            lstParam.add(pNomeServizio);
                            lstParam.add(pTipoServizio);
                            lstParam.add(pVersioneServizio);
                            lstParam.add(pTipoAccordo);
                            de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                        }
                        de2.setValue("WSDL Implementativo Erogatore");
                        dati.add(de2);
                    } else {
                        lstParam = new ArrayList();
                        lstParam.add(pId);
                        lstParam.add(pIdSoggettoErogatore);
                        lstParam.add(pIdSoggettoFruitore);
                        lstParam.add(pTipoWSDLFru);
                        if (pCorrelato != null) {
                            lstParam.add(pCorrelato);
                        }
                        de2 = new DataElement();
                        de2.setType(DataElementType.LINK);
                        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                            de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                        } else {
                            lstParam.add(pIdServ);
                            lstParam.add(pNomeProv);
                            lstParam.add(pTipoProv);
                            lstParam.add(pNomeServizio);
                            lstParam.add(pTipoServizio);
                            lstParam.add(pVersioneServizio);
                            lstParam.add(pTipoAccordo);
                            de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                        }
                        de2.setValue("WSDL Implementativo Fruitore");
                        dati.add(de2);
                    }
                } else {
                    ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                    lstParam.add(pId);
                    lstParam.add(pIdSoggettoErogatore);
                    lstParam.add(pIdSoggettoFruitore);
                    lstParam.add(pTipoWSDLEr);
                    if (pCorrelato != null) {
                        lstParam.add(pCorrelato);
                    }
                    de2 = new DataElement();
                    de2.setType(DataElementType.LINK);
                    if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                        de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                    } else {
                        lstParam.add(pIdServ);
                        lstParam.add(pNomeProv);
                        lstParam.add(pTipoProv);
                        lstParam.add(pNomeServizio);
                        lstParam.add(pTipoServizio);
                        lstParam.add(pVersioneServizio);
                        lstParam.add(pTipoAccordo);
                        de2.setUrl("accordiServizioParteSpecificaFruitoriWSDLChange.do", lstParam.toArray(new Parameter[lstParam.size()]));
                    }
                    de2.setValue("WSDL Implementativo");
                    dati.add(de2);
                }
            }
        }
        return dati;
    }

    public List<DataElement> addServiziFruitoriToDatiAsHidden(List<DataElement> dati, String idSoggettoFruitore, String wsdlimpler, String wsdlimplfru, String[] soggettiList, String[] soggettiListLabel, String idServ, String id, TipoOperazione tipoOp, String idSoggettoErogatoreDelServizio, String nomeprov, String tipoprov, String nomeservizio, String tiposervizio, String correlato, String stato, String oldStato, String statoServizio, String tipoAccordo, boolean validazioneDocumenti, String azioneConnettore) throws Exception {
        DataElement de;
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        if (azioneConnettore != null && !"".equals(azioneConnettore)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(azioneConnettore);
            de.setName("fruitoreViewConnettoreAzione");
            dati.add(de);
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de = new DataElement();
            de.setLabel("Nome");
            de.setName("providerFruitore");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idSoggettoFruitore);
            dati.add(de);
            if (this.isShowGestioneWorkflowStatoDocumenti()) {
                de = new DataElement();
                de.setLabel("Stato");
                if (!isModalitaAvanzata) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(statoServizio);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(stato);
                }
                de.setName("stato");
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("Stato");
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.finale.toString());
                de.setName("stato");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Validazione Documenti");
            de.setValue("" + validazioneDocumenti);
            de.setType(DataElementType.HIDDEN);
            de.setName("validazioneDocumenti");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setValue("");
            de.setType(DataElementType.HIDDEN);
            de.setName("wsdlimpler");
            dati.add(de);
            de = new DataElement();
            de.setValue("");
            de.setType(DataElementType.HIDDEN);
            de.setName("wsdlimplfru");
            dati.add(de);
        } else {
            String nomeSoggetto = "";
            for (int i = 0; i < soggettiList.length; ++i) {
                if (!soggettiList[i].equals(idSoggettoFruitore)) continue;
                nomeSoggetto = soggettiListLabel[i];
                break;
            }
            DataElement de2 = new DataElement();
            de2.setLabel("Nome");
            de2.setName("providerFruitore");
            de2.setType(DataElementType.HIDDEN);
            de2.setValue(idSoggettoFruitore);
            dati.add(de2);
            de2 = new DataElement();
            de2.setLabel("Stato");
            de2.setType(DataElementType.HIDDEN);
            de2.setValue(stato);
            de2.setName("stato");
            dati.add(de2);
        }
        return dati;
    }

    public static boolean isAddFruitoreToDati_farVedere() {
        return addFruitoreToDati_farVedere;
    }

    public static void setAddFruitoreToDati_farVedere(boolean addFruitoreToDati_farVedere) {
        AccordiServizioParteSpecificaHelper.addFruitoreToDati_farVedere = addFruitoreToDati_farVedere;
    }

    public List<DataElement> addFruitoreToDati(TipoOperazione tipoOp, String[] versioniLabel, String[] versioniValues, List<DataElement> dati, String oldStatoPackage, String idServizio, String idServizioFruitore, String idSoggettoErogatoreDelServizio, String nomeservizio, String tiposervizio, Integer versioneservizio, String idSoggettoFruitore, AccordoServizioParteSpecifica asps, Fruitore fruitore) throws Exception {
        Soggetto fruitoreSogg;
        boolean esterno;
        boolean isModalitaAvanzata = this.isModalitaAvanzata();
        if (addFruitoreToDati_farVedere && tipoOp.equals((Object)TipoOperazione.CHANGE) && !(esterno = this.pddCore.isPddEsterna((fruitoreSogg = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(fruitore.getTipo(), fruitore.getNome()))).getPortaDominio()))) {
            IDPortaDelegata idPD = null;
            IDSoggetto idSoggettoFruitoreObject = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
            if (!isModalitaAvanzata) {
                IDServizio idServizioObject = this.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore(), asps.getVersione().intValue());
                idPD = this.porteDelegateCore.getIDPortaDelegataAssociataDefault(idServizioObject, idSoggettoFruitoreObject);
            }
            DataElement de = new DataElement();
            if (isModalitaAvanzata || idPD == null) {
                de.setLabel("Configurazione");
            } else {
                de.setLabel("Porta Delegata");
            }
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            if (isModalitaAvanzata || idPD == null) {
                Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
                de.setUrl("accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{new Parameter("id", idServizio), new Parameter("idsogg", idSoggettoFruitore), new Parameter("nomeservizio", nomeservizio), new Parameter("tiposervizio", tiposervizio), new Parameter("myId", idServizioFruitore)});
                if (contaListe.booleanValue()) {
                    try {
                        ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                        IDServizio idServizioFromAccordo = this.idServizioFactory.getIDServizioFromAccordo(asps);
                        IDSoggetto idSoggettoFr = new IDSoggetto(fruitore.getNome(), fruitore.getTipo());
                        this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFr, idServizioFromAccordo, (ISearch)searchForCount);
                        int numPD = searchForCount.getNumEntries(Liste.CONFIGURAZIONE_FRUIZIONE);
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Configurazione", (Long)Long.valueOf(numPD));
                    }
                    catch (Exception e) {
                        this.logError("Calcolo numero pa non riuscito", e);
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Configurazione", (String)"N.D.");
                    }
                } else {
                    de.setValue("Configurazione");
                }
            } else {
                ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
                PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(idPD);
                de.setUrl("porteDelegateChange.do", new Parameter[]{new Parameter("idsogg", "" + pd.getIdSoggetto()), new Parameter("nomePorta", pd.getNome()), new Parameter("id", "" + pd.getId())});
                de.setValue("visualizza");
            }
            dati.add(de);
        }
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            DataElement de = new DataElement();
            de.setValue(idServizioFruitore);
            de.setType(DataElementType.HIDDEN);
            de.setName("myId");
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addFruitoreToDatiAsHidden(TipoOperazione tipoOp, String[] versioniLabel, String[] versioniValues, List<DataElement> dati, String oldStatoPackage, String idServizio, String idServizioFruitore, String idSoggettoErogatoreDelServizio, String nomeservizio, String tiposervizio, String idSoggettoFruitore) {
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            DataElement de = new DataElement();
            de.setValue(idServizioFruitore);
            de.setType(DataElementType.HIDDEN);
            de.setName("myId");
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addTipiAllegatiToDati(TipoOperazione tipoOp, String idServizio, String ruolo, String[] ruoli, String[] tipiAmmessi, String[] tipiAmmessiLabel, String tipoFile, List<DataElement> dati, String modificaAPI, List<BinaryParameter> binaryParameterDocumenti) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Allegato");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Ruolo");
        de.setType(DataElementType.SELECT);
        de.setName("ruolo");
        de.setValues(ruoli);
        de.setPostBack(true);
        de.setSelected(ruolo != null ? ruolo : "");
        de.setSize(this.getSize());
        dati.add(de);
        if (tipiAmmessi != null) {
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.SELECT);
            de.setName("tipoFile");
            de.setValues(tipiAmmessi);
            de.setLabels(tipiAmmessiLabel);
            de.setSelected(tipoFile);
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            BinaryParameter allegato0 = binaryParameterDocumenti.get(0);
            DataElement fileDataElement = allegato0.getFileDataElement("Documento", "", this.getSize());
            fileDataElement.setType(DataElementType.MULTI_FILE);
            fileDataElement.setRequired(true);
            dati.add(fileDataElement);
            dati.addAll(BinaryParameter.getFileNameDataElement(binaryParameterDocumenti));
            dati.add(BinaryParameter.getFileIdDataElement(binaryParameterDocumenti));
        } else {
            de = new DataElement();
            de.setValue(idServizio);
            de.setLabel("Documento");
            de.setType(DataElementType.FILE);
            de.setName("theFile");
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (modificaAPI != null) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("modificaAPI");
            de.setValue(modificaAPI);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addInfoAllegatiToDati(TipoOperazione tipoOp, String idAllegato, AccordoServizioParteSpecifica asps, Documento doc, List<DataElement> dati, String modificaAPI) throws Exception {
        boolean stato;
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Allegato");
        dati.add(de);
        de = new DataElement();
        de.setValue(idAllegato);
        de.setType(DataElementType.HIDDEN);
        de.setName("idAllegato");
        dati.add(de);
        boolean bl = stato = this.isEditModeInProgress() && this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(asps.getStatoPackage());
        if (!stato) {
            de = new DataElement();
            de.setLabel("Attuale");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setValue(doc.getRuolo());
        de.setLabel("Ruolo");
        de.setType(DataElementType.TEXT);
        de.setName("ruolo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getFile());
        de.setLabel("Nome");
        de.setType(DataElementType.TEXT);
        de.setName("nomeDoc");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getTipo());
        de.setLabel("Tipo");
        de.setType(DataElementType.TEXT);
        de.setName("tipoFile");
        de.setSize(this.getSize());
        dati.add(de);
        if (stato) {
            this.pd.setMode("view-noeditbutton");
        } else {
            de = new DataElement();
            de.setLabel("Nuovo");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.FILE);
            de.setLabel("Documento");
            de.setName("theFile");
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (modificaAPI != null) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("modificaAPI");
            de.setValue(modificaAPI);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addViewAllegatiToDati(TipoOperazione tipoOp, String idAllegato, String idServizio, Documento doc, StringBuilder contenutoAllegato, String errore, List<DataElement> dati, String modificaAPI) {
        DataElement de = new DataElement();
        de.setValue(idAllegato);
        de.setType(DataElementType.HIDDEN);
        de.setName("idAllegato");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Allegato");
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getRuolo());
        de.setLabel("Ruolo");
        de.setType(DataElementType.TEXT);
        de.setName("ruolo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getFile());
        de.setLabel("Nome");
        de.setType(DataElementType.TEXT);
        de.setName("nomeDoc");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getTipo());
        de.setLabel("Tipo");
        de.setType(DataElementType.TEXT);
        de.setName("tipoFile");
        de.setSize(this.getSize());
        dati.add(de);
        if (this.core.isShowAllegati()) {
            if (errore != null) {
                de = new DataElement();
                de.setValue(errore);
                de.setLabel("Documento");
                de.setType(DataElementType.TEXT);
                de.setName("documento");
                de.setSize(this.getSize());
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("");
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setValue(contenutoAllegato.toString());
                de.setRows(30);
                de.setCols(110);
                dati.add(de);
            }
        }
        DataElement saveAs = new DataElement();
        saveAs.setValue("Download");
        saveAs.setType(DataElementType.LINK);
        Parameter pIdAccordo = new Parameter("idAccordo", idServizio);
        Parameter pIdAllegato = new Parameter("idAllegato", idAllegato);
        Parameter pTipoDoc = new Parameter("tipoDocumento", "asps");
        saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pIdAllegato, pTipoDoc});
        saveAs.setDisabilitaAjaxStatus();
        dati.add(saveAs);
        if (modificaAPI != null) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("modificaAPI");
            de.setValue(modificaAPI);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addConfigurazioneErogazioneToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String nome, String nomeGruppo, String[] azioni, String[] azioniDisponibiliList, String[] azioniDisponibiliLabelList, String idAsps, String idSoggettoErogatoreDelServizio, String identificazione, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String modeCreazione, String modeCreazioneConnettore, String[] listaMappingLabels, String[] listaMappingValues, String mapping, String mappingLabel, boolean paMappingSelezionatoMulti, String nomeSA, String[] saSoggetti, String controlloAccessiStato, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, boolean erogazioneIsSupportatoAutenticazioneSoggetti, String erogazioneAutorizzazione, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneRuolo, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, List<String> soggettiAutenticati, List<String> soggettiAutenticatiLabel, String soggettoAutenticato, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws Exception {
        boolean showModeConnettore;
        Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        DataElement de = new DataElement();
        de.setLabel("Configurazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("idSoggErogatore");
        de.setValue(idSoggettoErogatoreDelServizio);
        dati.add(de);
        de = new DataElement();
        de.setName("nomeGruppo");
        de.setLabel("Nome Gruppo");
        de.setValue(nomeGruppo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        dati.add(de);
        DataElement deAzione = new DataElement();
        deAzione.setLabel(this.getLabelAzioni(serviceBinding));
        deAzione.setValues(azioniDisponibiliList);
        deAzione.setLabels(azioniDisponibiliLabelList);
        deAzione.setSelezionati(azioni);
        deAzione.setType(DataElementType.MULTI_SELECT);
        deAzione.setName("azioni");
        deAzione.setRows(10);
        deAzione.setRequired(true);
        dati.add(deAzione);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setRequired(true);
        de.setName("nome");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Modalit\u00e0");
        String[] modeLabels = new String[]{"Eredita Da", "Nuova"};
        String[] modeValues = new String[]{"eredita", "nuova"};
        de.setLabels(modeLabels);
        de.setValues(modeValues);
        de.setSelected(modeCreazione);
        de.setType(DataElementType.SELECT);
        de.setName("modeCreazione");
        de.setPostBack(true, true);
        dati.add(de);
        boolean bl = showModeConnettore = !this.isModalitaStandard();
        if (modeCreazione.equals("eredita")) {
            de = new DataElement();
            de.setLabel("Gruppo");
            de.setLabels(listaMappingLabels);
            de.setValues(listaMappingValues);
            de.setSelected(mapping);
            de.setToolTip(mappingLabel);
            de.setType(DataElementType.SELECT);
            de.setName("mapping");
            de.setPostBack(true);
            dati.add(de);
            showModeConnettore = showModeConnettore && !paMappingSelezionatoMulti;
        }
        de = new DataElement();
        de.setLabel("Ridefinisci Connettore");
        de.setName("modeCreazioneConnettore");
        if (showModeConnettore) {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore));
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(modeCreazione);
        }
        dati.add(de);
        if (!modeCreazione.equals("eredita")) {
            boolean forceAutenticato = false;
            boolean forceHttps = false;
            boolean forceDisableOptional = false;
            boolean forceGestioneToken = false;
            boolean forceMostraSezioneToken = false;
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
            if (this.isProfiloModIPA(protocollo)) {
                forceHttps = forceAutenticato = true;
                if ("nuova".equals(modeCreazione)) {
                    BooleanNullable forcePDNDWrapper = BooleanNullable.NULL();
                    BooleanNullable forceOAuthWrapper = BooleanNullable.NULL();
                    this.readModIConfiguration(BooleanNullable.NULL(), forcePDNDWrapper, forceOAuthWrapper, this.idAccordoFactory.getIDAccordoFromAccordo(as), asps.getPortType(), azioniDisponibiliList != null && azioniDisponibiliList.length > 0 ? Arrays.asList(azioniDisponibiliList) : null);
                    boolean forcePDND = false;
                    boolean forceOAuth = false;
                    if (forcePDNDWrapper.getValue() != null) {
                        forcePDND = forcePDNDWrapper.getValue();
                    }
                    if (forceOAuthWrapper.getValue() != null) {
                        forceOAuth = forceOAuthWrapper.getValue();
                    }
                    if (forcePDND || forceOAuth) {
                        deAzione.setPostBack(true);
                    }
                }
                boolean forcePDND = false;
                boolean forceOAuth = false;
                BooleanNullable forceHttpsClientWrapper = BooleanNullable.NULL();
                BooleanNullable forcePDNDWrapper = BooleanNullable.NULL();
                BooleanNullable forceOAuthWrapper = BooleanNullable.NULL();
                List<String> azioniList = null;
                if (azioni != null && azioni.length > 0) {
                    azioniList = Arrays.asList(azioni);
                }
                this.readModIConfiguration(forceHttpsClientWrapper, forcePDNDWrapper, forceOAuthWrapper, this.idAccordoFactory.getIDAccordoFromAccordo(as), asps.getPortType(), azioniList);
                if (forceHttpsClientWrapper.getValue() != null) {
                    forceDisableOptional = forceHttpsClientWrapper.getValue();
                }
                if (forcePDNDWrapper.getValue() != null) {
                    forcePDND = forcePDNDWrapper.getValue();
                }
                if (forceOAuthWrapper.getValue() != null) {
                    forceOAuth = forceOAuthWrapper.getValue();
                }
                if (forcePDND || forceOAuth) {
                    GenericProperties gp;
                    forceGestioneToken = true;
                    forceMostraSezioneToken = true;
                    gestioneToken = StatoFunzionalita.ABILITATO.getValue();
                    if (forcePDND) {
                        tokenPolicies = this.getTokenPolicyGestione(true, false, false, gestioneTokenPolicy, tipoOperazione);
                        if (tokenPolicies != null && !tokenPolicies.isEmpty()) {
                            if (gestioneTokenPolicy == null || StringUtils.isEmpty((CharSequence)gestioneTokenPolicy) || "-".equals(gestioneTokenPolicy)) {
                                gestioneTokenPolicy = tokenPolicies.get(0);
                            }
                            gestioneTokenPolicyLabels = tokenPolicies.toArray(new String[1]);
                            gestioneTokenPolicyValues = tokenPolicies.toArray(new String[1]);
                        }
                    } else {
                        tokenPolicies = this.getTokenPolicyGestione(false, true, false, gestioneTokenPolicy, tipoOperazione);
                        if (tokenPolicies != null && !tokenPolicies.isEmpty()) {
                            if (gestioneTokenPolicy == null || StringUtils.isEmpty((CharSequence)gestioneTokenPolicy) || "-".equals(gestioneTokenPolicy)) {
                                gestioneTokenPolicy = tokenPolicies.get(0);
                            }
                            gestioneTokenPolicyLabels = tokenPolicies.toArray(new String[1]);
                            gestioneTokenPolicyValues = tokenPolicies.toArray(new String[1]);
                        }
                    }
                    gestioneTokenOpzionale = StatoFunzionalita.DISABILITATO.getValue();
                    if (gestioneTokenPolicy != null && StringUtils.isNotEmpty((CharSequence)gestioneTokenPolicy) && !"-".equals(gestioneTokenPolicy) && (gp = this.confCore.getGenericProperties(gestioneTokenPolicy, "gestionePolicyToken", false)) != null && gp.sizePropertyList() > 0) {
                        for (Property p : gp.getPropertyList()) {
                            if ("policy.validazioneJWT.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenValidazioneInput = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenValidazioneInput = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if ("policy.introspection.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenIntrospection = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenIntrospection = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if ("policy.userInfo.stato".equals(p.getNome())) {
                                if ("true".equalsIgnoreCase(p.getValore())) {
                                    gestioneTokenUserInfo = StatoFunzionalita.ABILITATO.getValue();
                                    continue;
                                }
                                gestioneTokenUserInfo = StatoFunzionalita.DISABILITATO.getValue();
                                continue;
                            }
                            if (!"policy.tokenForward.stato".equals(p.getNome())) continue;
                            if ("true".equalsIgnoreCase(p.getValore())) {
                                gestioneTokenForward = StatoFunzionalita.ABILITATO.getValue();
                                continue;
                            }
                            gestioneTokenForward = StatoFunzionalita.DISABILITATO.getValue();
                        }
                    }
                }
            }
            this.controlloAccessiAdd(dati, tipoOperazione, controlloAccessiStato, forceAutenticato);
            this.controlloAccessiGestioneToken(dati, tipoOperazione, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, null, protocollo, false, forceGestioneToken, forceMostraSezioneToken);
            this.controlloAccessiAutenticazione(dati, tipoOperazione, "accordiServizioParteSpecificaAdd.do", null, protocollo, erogazioneAutenticazione, null, erogazioneAutenticazioneOpzionale, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, false, erogazioneIsSupportatoAutenticazioneSoggetti, false, gestioneToken, gestioneTokenPolicy, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, false, null, 0, forceHttps, forceDisableOptional);
            this.controlloAccessiAutorizzazione(dati, tipoOperazione, "accordiServizioParteSpecificaAdd.do", null, protocollo, erogazioneAutenticazione, null, erogazioneAutorizzazione, null, erogazioneAutorizzazioneAutenticati, null, 0, soggettiAutenticati, soggettiAutenticatiLabel, soggettoAutenticato, erogazioneAutorizzazioneRuoli, null, 0, erogazioneRuolo, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, false, erogazioneIsSupportatoAutenticazioneSoggetti, contaListe, false, false, autorizzazioneScope, null, 0, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazioneToken, autorizzazioneTokenOptions, allegatoXacmlPolicy, null, 0, null, 0, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, null, 0, autorizzazioneRuoliToken, null, 0, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
        }
        return dati;
    }

    public boolean configurazioneErogazioneCheckData(TipoOperazione tipoOp, String nome, String nomeGruppo, String[] azioni, AccordoServizioParteSpecifica asps, List<String> azioniOccupate, String modeCreazione, String idPorta, boolean isSupportatoAutenticazione, AccordiServizioParteSpecificaPorteApplicativeMappingInfo mappingInfo) throws Exception {
        if (nomeGruppo == null || "".equals(nomeGruppo.trim())) {
            this.pd.setMessage("Deve essere indicato un nome per il gruppo");
            return false;
        }
        if (!this.checkLength255(nomeGruppo, "nomeGruppo")) {
            return false;
        }
        if (AccordiServizioParteSpecificaUtilities.getMappingPAFilterByDescription(mappingInfo.getListaMappingErogazione(), nomeGruppo) != null) {
            this.pd.setMessage("Il nome indicato \u00e8 gi\u00e0 stato assegnato ad un altro gruppo");
            return false;
        }
        if (azioni == null || azioni.length == 0) {
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azioneTmp : azioni) {
            if (azioneTmp != null && !azioneTmp.equals("") && !azioneTmp.equals("-")) continue;
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azioneTmp : azioni) {
            if (!azioniOccupate.contains(azioneTmp)) continue;
            this.pd.setMessage("L'azione scelta &egrave; gi&agrave; presente");
            return false;
        }
        if (!this.checkAzioniUtilizzateErogazione(mappingInfo, azioni)) {
            return false;
        }
        if (!modeCreazione.equals("eredita")) {
            String attributeAuthorityAttributi;
            String[] attributeAuthoritySelezionate;
            String identificazioneAttributiStato;
            String protocollo;
            BinaryParameter allegatoXacmlPolicy;
            String autorizzazioneScopeMatch;
            String autorizzazioneScope;
            String autorizzazione_tokenOptions;
            String autorizzazione_token;
            String autorizzazioneRuoliToken;
            String autorizzazioneAutenticatiToken;
            String gestioneTokenTokenForward;
            String gestioneTokenUserInfo;
            String gestioneTokenIntrospection;
            String gestioneTokenValidazioneInput;
            String gestioneTokenPolicy;
            String gestioneToken;
            String autenticazione = this.getParameter("autenticazione");
            String autenticazioneCustom = this.getParameter("autenticazioneCustom");
            String autenticazioneOpzionale = this.getParameter("autenticazioneOpzionale");
            String autenticazionePrincipalTipo = this.getParameter("autenticazionePrincipalTipo");
            TipoAutenticazionePrincipal autenticazionePrincipal = TipoAutenticazionePrincipal.toEnumConstant((String)autenticazionePrincipalTipo, (boolean)false);
            List<String> autenticazioneParametroList = this.convertFromDataElementValue_parametroAutenticazioneList(autenticazione, autenticazionePrincipal);
            String autorizzazione = this.getParameter("autorizzazione");
            String autorizzazioneCustom = this.getParameter("autorizzazioneCustom");
            String autorizzazioneAutenticati = this.getParameter("autorizzazioneAutenticazione");
            String autorizzazioneRuoli = this.getParameter("autorizzazioneRuoli");
            String autorizzazioneRuoliTipologia = this.getParameter("ruoloTipologia");
            String ruoloMatch = this.getParameter("ruoloMatch");
            String autorizzazioneContenutiStato = this.getParameter("authContenutiStato");
            String autorizzazioneContenuti = this.getParameter("autorizzazioneContenuti");
            String autorizzazioneContenutiProperties = this.getParameter("authContenutiProp");
            if ("custom".equals(autenticazione) && (autenticazioneCustom == null || autenticazioneCustom.equals(""))) {
                this.pd.setMessage(MessageFormat.format("Indicare un nome per l''autenticazione ''{0}''", "custom"));
                return false;
            }
            if ("custom".equals(autorizzazione) && (autorizzazioneCustom == null || autorizzazioneCustom.equals(""))) {
                this.pd.setMessage(MessageFormat.format("Indicare un nome per l''autorizzazione ''{0}''", "custom"));
                return false;
            }
            PortaApplicativa pa = null;
            if (TipoOperazione.CHANGE == tipoOp) {
                pa = this.porteApplicativeCore.getPortaApplicativa(Long.parseLong(idPorta));
            }
            ArrayList<String> ruoli = new ArrayList<String>();
            if (pa != null && pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                for (int i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                    ruoli.add(pa.getRuoli().getRuolo(i).getNome());
                }
            }
            if (!this.controlloAccessiCheck(tipoOp, autenticazione, autenticazioneOpzionale, autenticazionePrincipal, autenticazioneParametroList, autorizzazione, autorizzazioneAutenticati, autorizzazioneRuoli, autorizzazioneRuoliTipologia, ruoloMatch, isSupportatoAutenticazione, false, pa, ruoli, gestioneToken = this.getParameter("gestioneToken"), gestioneTokenPolicy = this.getParameter("gtPolicy"), gestioneTokenValidazioneInput = this.getParameter("gtValidazione"), gestioneTokenIntrospection = this.getParameter("gtIntrospection"), gestioneTokenUserInfo = this.getParameter("gtUserInfo"), gestioneTokenTokenForward = this.getParameter("gtTokenForward"), autorizzazioneAutenticatiToken = this.getParameter("autorizzazioneAutenticazioneToken"), autorizzazioneRuoliToken = this.getParameter("autorizzazioneRuoliToken"), autorizzazione_token = this.getParameter("autorizzazioneToken"), autorizzazione_tokenOptions = this.getParameter("autorizzazioneTokenOptions"), autorizzazioneScope = this.getParameter("autorizzazioneScope"), autorizzazioneScopeMatch = this.getParameter("scopeMatch"), allegatoXacmlPolicy = this.getBinaryParameter("docSicXacmlPol"), autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, protocollo = ProtocolFactoryManager.getInstance().getProtocolByServiceType(asps.getTipo()), identificazioneAttributiStato = this.getParameter("attrStato"), attributeAuthoritySelezionate = this.getParameterValues("attrAuthority"), attributeAuthorityAttributi = this.getParameter("AAttr"))) {
                return false;
            }
        }
        return true;
    }

    public boolean configurazioneFruizioneCheckData(TipoOperazione tipoOp, String nome, String nomeGruppo, String[] azioni, AccordoServizioParteSpecifica asps, List<String> azioniOccupate, String modeCreazione, String idPorta, boolean isSupportatoAutenticazione, AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo mappingInfo) throws Exception {
        if (nomeGruppo == null || "".equals(nomeGruppo.trim())) {
            this.pd.setMessage("Deve essere indicato un nome per il gruppo");
            return false;
        }
        if (!this.checkLength255(nomeGruppo, "Nome Gruppo")) {
            return false;
        }
        if (AccordiServizioParteSpecificaUtilities.getMappingPDFilterByDescription(mappingInfo.getListaMappingFruizione(), nomeGruppo) != null) {
            this.pd.setMessage("Il nome indicato \u00e8 gi\u00e0 stato assegnato ad un altro gruppo");
            return false;
        }
        if (azioni == null || azioni.length == 0) {
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azioneTmp : azioni) {
            if (azioneTmp != null && !azioneTmp.equals("") && !azioneTmp.equals("-")) continue;
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azioneTmp : azioni) {
            if (!azioniOccupate.contains(azioneTmp)) continue;
            this.pd.setMessage("L'azione scelta &egrave; gi&agrave; presente");
            return false;
        }
        if (!this.checkAzioniUtilizzateFruizione(mappingInfo, azioni)) {
            return false;
        }
        if (!modeCreazione.equals("eredita")) {
            String attributeAuthorityAttributi;
            String[] attributeAuthoritySelezionate;
            String identificazioneAttributiStato;
            String protocollo;
            BinaryParameter allegatoXacmlPolicy;
            String autorizzazioneScopeMatch;
            String autorizzazioneScope;
            String autorizzazione_tokenOptions;
            String autorizzazione_token;
            String autorizzazioneRuoliToken;
            String autorizzazioneAutenticatiToken;
            String gestioneTokenTokenForward;
            String gestioneTokenUserInfo;
            String gestioneTokenIntrospection;
            String gestioneTokenValidazioneInput;
            String gestioneTokenPolicy;
            String gestioneToken;
            String autenticazione = this.getParameter("autenticazione");
            String autenticazioneCustom = this.getParameter("autenticazioneCustom");
            String autenticazioneOpzionale = this.getParameter("autenticazioneOpzionale");
            String autenticazionePrincipalTipo = this.getParameter("autenticazionePrincipalTipo");
            TipoAutenticazionePrincipal autenticazionePrincipal = TipoAutenticazionePrincipal.toEnumConstant((String)autenticazionePrincipalTipo, (boolean)false);
            List<String> autenticazioneParametroList = this.convertFromDataElementValue_parametroAutenticazioneList(autenticazione, autenticazionePrincipal);
            String autorizzazione = this.getParameter("autorizzazione");
            String autorizzazioneCustom = this.getParameter("autorizzazioneCustom");
            String autorizzazioneAutenticati = this.getParameter("autorizzazioneAutenticazione");
            String autorizzazioneRuoli = this.getParameter("autorizzazioneRuoli");
            String autorizzazioneRuoliTipologia = this.getParameter("ruoloTipologia");
            String ruoloMatch = this.getParameter("ruoloMatch");
            String autorizzazioneContenutiStato = this.getParameter("authContenutiStato");
            String autorizzazioneContenuti = this.getParameter("autorizzazioneContenuti");
            String autorizzazioneContenutiProperties = this.getParameter("authContenutiProp");
            if ("custom".equals(autenticazione) && (autenticazioneCustom == null || autenticazioneCustom.equals(""))) {
                this.pd.setMessage(MessageFormat.format("Indicare un nome per l''autenticazione ''{0}''", "custom"));
                return false;
            }
            if ("custom".equals(autorizzazione) && (autorizzazioneCustom == null || autorizzazioneCustom.equals(""))) {
                this.pd.setMessage(MessageFormat.format("Indicare un nome per l''autorizzazione ''{0}''", "custom"));
                return false;
            }
            PortaDelegata pd = null;
            if (TipoOperazione.CHANGE == tipoOp) {
                pd = this.porteDelegateCore.getPortaDelegata(Long.parseLong(idPorta));
            }
            ArrayList<String> ruoli = new ArrayList<String>();
            if (pd != null && pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                for (int i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                    ruoli.add(pd.getRuoli().getRuolo(i).getNome());
                }
            }
            if (!this.controlloAccessiCheck(tipoOp, autenticazione, autenticazioneOpzionale, autenticazionePrincipal, autenticazioneParametroList, autorizzazione, autorizzazioneAutenticati, autorizzazioneRuoli, autorizzazioneRuoliTipologia, ruoloMatch, isSupportatoAutenticazione, true, pd, ruoli, gestioneToken = this.getParameter("gestioneToken"), gestioneTokenPolicy = this.getParameter("gtPolicy"), gestioneTokenValidazioneInput = this.getParameter("gtValidazione"), gestioneTokenIntrospection = this.getParameter("gtIntrospection"), gestioneTokenUserInfo = this.getParameter("gtUserInfo"), gestioneTokenTokenForward = this.getParameter("gtTokenForward"), autorizzazioneAutenticatiToken = this.getParameter("autorizzazioneAutenticazioneToken"), autorizzazioneRuoliToken = this.getParameter("autorizzazioneRuoliToken"), autorizzazione_token = this.getParameter("autorizzazioneToken"), autorizzazione_tokenOptions = this.getParameter("autorizzazioneTokenOptions"), autorizzazioneScope = this.getParameter("autorizzazioneScope"), autorizzazioneScopeMatch = this.getParameter("scopeMatch"), allegatoXacmlPolicy = this.getBinaryParameter("docSicXacmlPol"), autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, protocollo = ProtocolFactoryManager.getInstance().getProtocolByServiceType(asps.getTipo()), identificazioneAttributiStato = this.getParameter("attrStato"), attributeAuthoritySelezionate = this.getParameterValues("attrAuthority"), attributeAuthorityAttributi = this.getParameter("AAttr"))) {
                return false;
            }
        }
        return true;
    }

    public List<DataElement> addConfigurazioneFruizioneToDati(TipoOperazione tipoOp, List<DataElement> dati, String nome, String nomeGruppo, String[] azioni, String[] azioniDisponibiliList, String[] azioniDisponibiliLabelList, String idAsps, IDSoggetto idSoggettoFruitore, String identificazione, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String modeCreazione, String modeCreazioneConnettore, String[] listaMappingLabels, String[] listaMappingValues, String mapping, String mappingLabel, List<String> saList, String nomeSA, String controlloAccessiStato, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, boolean erogazioneIsSupportatoAutenticazioneSoggetti, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneRuolo, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, String fruizioneServizioApplicativo, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws Exception {
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        DataElement de = new DataElement();
        de.setLabel("Configurazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("nomeGruppo");
        de.setLabel("Nome Gruppo");
        de.setValue(nomeGruppo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel(this.getLabelAzioni(serviceBinding));
        de.setValues(azioniDisponibiliList);
        de.setLabels(azioniDisponibiliLabelList);
        de.setSelezionati(azioni);
        de.setType(DataElementType.MULTI_SELECT);
        de.setName("azioni");
        de.setRows(10);
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setRequired(true);
        de.setName("nome");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Modalit\u00e0");
        String[] modeLabels = new String[]{"Eredita Da", "Nuova"};
        String[] modeValues = new String[]{"eredita", "nuova"};
        de.setLabels(modeLabels);
        de.setValues(modeValues);
        de.setSelected(modeCreazione);
        de.setType(DataElementType.SELECT);
        de.setName("modeCreazione");
        de.setPostBack(true, true);
        dati.add(de);
        if (modeCreazione.equals("eredita")) {
            de = new DataElement();
            de.setLabel("Gruppo");
            de.setLabels(listaMappingLabels);
            de.setValues(listaMappingValues);
            de.setSelected(mapping);
            de.setToolTip(mappingLabel);
            de.setType(DataElementType.SELECT);
            de.setName("mapping");
            de.setPostBack(true);
            dati.add(de);
        }
        boolean connettoreStatic = false;
        if (gestioneFruitori) {
            connettoreStatic = this.apsCore.isConnettoreStatic(this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore()));
        }
        de = new DataElement();
        de.setLabel("Ridefinisci Connettore");
        de.setName("modeCreazioneConnettore");
        if (this.isModalitaStandard() || connettoreStatic) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(modeCreazione);
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore));
            de.setPostBack(true);
        }
        dati.add(de);
        if (!modeCreazione.equals("eredita")) {
            this.controlloAccessiAdd(dati, tipoOp, controlloAccessiStato, false);
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
            this.controlloAccessiGestioneToken(dati, tipoOp, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, null, protocollo, true, false);
            this.controlloAccessiAutenticazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", null, protocollo, fruizioneAutenticazione, null, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, false, true, true, gestioneToken, gestioneTokenPolicy, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, false, null, 0, false, false);
            this.controlloAccessiAutorizzazione(dati, tipoOp, "accordiServizioParteSpecificaFruitoriAdd.do", null, protocollo, fruizioneAutenticazione, null, fruizioneAutorizzazione, null, fruizioneAutorizzazioneAutenticati, null, 0, saList, fruizioneServizioApplicativo, fruizioneAutorizzazioneRuoli, null, 0, fruizioneRuolo, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, false, erogazioneIsSupportatoAutenticazioneSoggetti, contaListe, true, false, autorizzazioneScope, null, 0, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazioneToken, autorizzazioneTokenOptions, allegatoXacmlPolicy, null, 0, null, 0, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, null, 0, autorizzazioneRuoliToken, null, 0, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
        }
        return dati;
    }

    public List<Parameter> getTitoloAps(TipoOperazione tipoOperazione, AccordoServizioParteSpecifica asps, boolean gestioneFruitori, String labelApsTitle, String servletNameApsChange, boolean addApsChange, String tipoSoggettoFruitore, String nomeSoggettoFruitore) throws Exception {
        if (tipoOperazione != null) {
            // empty if block
        }
        ArrayList<Parameter> listaParams = new ArrayList<Parameter>();
        Parameter pIdServizio = new Parameter("id", "" + asps.getId());
        Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
        String labelApsChange = null;
        ArrayList<Parameter> listParametersErogazioniChange = new ArrayList<Parameter>();
        listParametersErogazioniChange.add(pIdServizio);
        if (gestioneFruitori) {
            Parameter pTipoSoggettoFruitore = new Parameter("tipoSoggFru", tipoSoggettoFruitore);
            Parameter pNomeSoggettoFruitore = new Parameter("nomeSoggFru", nomeSoggettoFruitore);
            listParametersErogazioniChange.add(pTipoSoggettoFruitore);
            listParametersErogazioniChange.add(pNomeSoggettoFruitore);
        }
        if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
            if (gestioneFruitori) {
                listaParams.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
            } else {
                listaParams.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
            }
            listaParams.add(new Parameter(labelApsTitle, "aspsErogazioniChange.do", listParametersErogazioniChange));
            String paramModificaProfilo = this.getParameter("modificaProfilo");
            String paramModificaAPI = this.getParameter("modificaAPI");
            String paramCambiaAPI = this.getParameter("cambiaAPI");
            String paramModificaDescrizione = this.getParameter("modificaDescrizione");
            String paramCambiaErogatore = this.getParameter("cambiaErogatore");
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            boolean isAccordiCooperazione = user.getPermessi().isAccordiCooperazione();
            boolean isServizi = user.getPermessi().isServizi();
            String asLabel = "API (ParteComune/Composto)";
            if (isServizi && !isAccordiCooperazione) {
                asLabel = "API";
            }
            if (!isServizi && isAccordiCooperazione) {
                asLabel = "API (Servizio Composto)";
            }
            labelApsChange = "true".equals(paramModificaAPI) || "true".equals(paramCambiaAPI) ? asLabel : ("true".equals(paramCambiaErogatore) ? "Soggetto Erogatore" : ("true".equals(paramModificaProfilo) ? "Profilo Interoperabilit\u00e0" : ("true".equals(paramModificaDescrizione) ? "Descrizione" : "Informazioni Generali")));
        } else {
            if (gestioneFruitori) {
                listaParams.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
            } else {
                listaParams.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
            }
            labelApsChange = labelApsTitle;
        }
        if (addApsChange) {
            Parameter parameterApcChange = servletNameApsChange != null ? new Parameter(labelApsChange, servletNameApsChange, listParametersErogazioniChange) : new Parameter(labelApsChange, servletNameApsChange);
            listaParams.add(parameterApcChange);
        }
        return listaParams;
    }

    protected ProprietaOggetto creaProprietaOggetto(AccordoServizioParteSpecifica asps, boolean gestioneFruitori, Fruitore fruitore, IDServizio idServizio, IDSoggetto idSoggettoFruitore) {
        ProprietaOggetto pOggetto = null;
        pOggetto = gestioneFruitori ? ProprietaOggettoRegistro.mergeProprietaOggetto(fruitore.getProprietaOggetto(), idServizio, idSoggettoFruitore, this.porteDelegateCore, (ConsoleHelper)this) : ProprietaOggettoRegistro.mergeProprietaOggetto(asps.getProprietaOggetto(), idServizio, this.porteApplicativeCore, this.saCore, (ConsoleHelper)this);
        return pOggetto;
    }
}

