/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneResourcesRisposteChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOp = TipoOperazione.CHANGE;
        try {
            int i;
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            String editMode = apcHelper.getParametroEditMode("edit-mode");
            String id = apcHelper.getParametroLong("id");
            long idAccordoLong = Long.parseLong(id);
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            String nomeAccordo = apcHelper.getParameter("nome");
            String nomeRisorsa = apcHelper.getParameter("nomeRs");
            String descr = apcHelper.getParameter("descrizioneResRisposta");
            if (descr == null) {
                descr = "";
            }
            String statusS = apcHelper.getParametroInteger("statusResRisposta");
            int status = -1;
            if (statusS == null || "".equals(statusS)) {
                status = ApiResponse.getDefaultHttpReturnCode();
            } else {
                try {
                    status = Integer.parseInt(statusS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoLong);
            String labelASTitle = apcHelper.getLabelIdAccordo(as);
            ResourceResponse resourceResponseOLD = null;
            Resource risorsa = null;
            for (i = 0; i < as.sizeResourceList(); ++i) {
                Resource res = as.getResource(i);
                if (!nomeRisorsa.equals(res.getNome())) continue;
                risorsa = res;
                break;
            }
            if (risorsa == null) {
                throw new Exception("Risorsa '" + nomeRisorsa + "' non trovata");
            }
            if (risorsa.getResponseList() != null) {
                for (i = 0; i < risorsa.getResponseList().size(); ++i) {
                    ResourceResponse rr = risorsa.getResponse(i);
                    if (rr.getStatus() != status) continue;
                    resourceResponseOLD = rr;
                    break;
                }
            }
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", id);
            Parameter pIdRisorsa = new Parameter("idRs", "" + risorsa.getId());
            Parameter pNomeRisorsa = new Parameter("nomeRs", nomeRisorsa);
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)session, (HttpServletRequest)request, (Boolean)false).getValue();
            List<Parameter> listaParams = apcHelper.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            String labelRisorse = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            listaParams.add(new Parameter(labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelRisorsa = NamingUtils.getLabelResource((Resource)risorsa);
            listaParams.add(new Parameter(labelRisorsa, "accordiServizioParteComuneResourcesChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pIdRisorsa}));
            String labelResponse = "Risposte";
            listaParams.add(new Parameter(labelResponse, "accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa}));
            String labelRisposta = "HTTP Status " + (ApiResponse.isDefaultHttpReturnCode((int)status) ? "Default" : statusS);
            listaParams.add(new Parameter(labelRisposta, null));
            if (ServletUtils.isEditModeInProgress((String)editMode)) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                if (resourceResponseOLD != null) {
                    descr = resourceResponseOLD.getDescrizione();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apcHelper.addAccordiResourceResponseToDati(tipoOp, dati, id, nomeAccordo, tipoAccordo, as.getStatoPackage(), nomeRisorsa, descr, statusS);
                pd.setDati(dati);
                if (apcHelper.isModalitaStandard() || apcHelper.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                    pd.disableEditMode();
                }
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRisposte", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = apcHelper.accordiResourceResponseCheckData(tipoOp, id, risorsa.getId().intValue(), nomeRisorsa, statusS, descr);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati = apcHelper.addAccordiResourceResponseToDati(tipoOp, dati, id, nomeAccordo, tipoAccordo, as.getStatoPackage(), nomeRisorsa, descr, statusS);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRisposte", (ForwardParams)ForwardParams.CHANGE());
            }
            Resource res = null;
            for (int i2 = 0; i2 < as.sizeResourceList() && !nomeRisorsa.equals((res = as.getResource(i2)).getNome()); ++i2) {
            }
            if (res == null) {
                throw new Exception("Risorsa '" + nomeRisorsa + "' non trovata");
            }
            ResourceResponse resourceResponse = null;
            if (res.getResponseList() != null) {
                for (int i3 = 0; i3 < res.getResponseList().size(); ++i3) {
                    ResourceResponse rr = res.getResponse(i3);
                    if (rr.getStatus() != status) continue;
                    resourceResponse = rr;
                    res.removeResponse(i3);
                    break;
                }
            }
            ResourceResponse newResponse = new ResourceResponse();
            newResponse.setStatus(status);
            newResponse.setDescrizione(descr);
            if (resourceResponse != null) {
                newResponse.setParameterList(resourceResponse.getParameterList());
                newResponse.setRepresentationList(resourceResponse.getRepresentationList());
            }
            res.addResponse(newResponse);
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            as = apcCore.getAccordoServizioFull(idAccordoLong);
            risorsa = null;
            for (int j = 0; j < as.sizeResourceList() && !nomeRisorsa.equals((risorsa = as.getResource(j)).getNome()); ++j) {
            }
            if (risorsa == null) {
                throw new Exception("Risorsa '" + nomeRisorsa + "' non trovata");
            }
            List<ResourceResponse> lista = apcCore.accordiResourceResponseList(risorsa.getId(), (ISearch)ricerca);
            apcHelper.prepareAccordiResourcesResponseList((ISearch)ricerca, lista, id, as, tipoAccordo, risorsa);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRisposte", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRisposte", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

