/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneResourcesRepresentationList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            String id = apcHelper.getParametroLong("id");
            int idAccordo = Integer.parseInt(id);
            String nomeRisorsa = apcHelper.getParameter("nomeRs");
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            String statusResponseS = apcHelper.getParametroInteger("statusResRisposta");
            Integer statusResponse = null;
            try {
                if (StringUtils.isNotEmpty((CharSequence)statusResponseS)) {
                    statusResponse = Integer.parseInt(statusResponseS);
                }
            }
            catch (Exception e) {
                statusResponse = null;
            }
            String isReq = apcHelper.getParametroBoolean("req");
            boolean isRequest = ServletUtils.isCheckBoxEnabled((String)isReq);
            Long idRisorsa = 0L;
            Resource res = null;
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordo);
            for (int i = 0; i < as.sizeResourceList(); ++i) {
                res = as.getResource(i);
                if (!nomeRisorsa.equals(res.getNome())) continue;
                idRisorsa = res.getId();
                break;
            }
            Long idResponse = null;
            ResourceRequest resourceRequest = null;
            ResourceResponse resourceResponse = null;
            if (res != null) {
                if (isRequest) {
                    resourceRequest = res.getRequest();
                } else if (res.getResponseList() != null) {
                    for (int i = 0; i < res.getResponseList().size(); ++i) {
                        resourceResponse = res.getResponse(i);
                        if (statusResponse == null || resourceResponse.getStatus() != statusResponse.intValue()) continue;
                        idResponse = resourceResponse.getId();
                        break;
                    }
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = isRequest ? Liste.ACCORDI_API_RESOURCES_REPRESENTATION_REQUEST : Liste.ACCORDI_API_RESOURCES_REPRESENTATION_RESPONSE;
            ricerca = apcHelper.checkSearchParameters(idLista, ricerca);
            List<ResourceRepresentation> lista = apcCore.accordiResourceRepresentationsList(idRisorsa, isRequest, idResponse, (ISearch)ricerca);
            apcHelper.prepareAccordiResourcesRepresentationsList(id, as, lista, ricerca, tipoAccordo, isRequest, res, resourceRequest, resourceResponse);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.LIST());
        }
    }
}

