/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneAllegatiView
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            String idAllegato = apcHelper.getParametroLong("idAllegato");
            String idAccordo = apcHelper.getParametroLong("idAccordo");
            long idAllegatoLong = Long.parseLong(idAllegato);
            long idAccordoLong = Long.parseLong(idAccordo);
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            ArchiviCore archiviCore = new ArchiviCore(apcCore);
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoLong);
            String labelASTitle = apcHelper.getLabelIdAccordo(as);
            Documento doc = archiviCore.getDocumento(idAllegatoLong, true);
            StringBuilder contenutoAllegato = new StringBuilder();
            String errore = Utilities.getTestoVisualizzabile(doc.getByteContenuto(), contenutoAllegato);
            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
            String uri = idAccordoFactory.getUriFromAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idAccordo);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)session, (HttpServletRequest)request, (Boolean)false).getValue();
            List<Parameter> listaParams = apcHelper.getTitoloApc(TipoOperazione.ADD, as, tipoAccordo, labelASTitle, null, false);
            String labelAllegati = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? "Allegati" : "Allegati di " + labelASTitle;
            listaParams.add(new Parameter(labelAllegati, "accordiServizioParteComuneAllegatiList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo}));
            listaParams.add(new Parameter(doc.getFile(), null));
            ServletUtils.setPageDataTitle((PageData)pd, listaParams);
            ArrayList<Object> dati = new ArrayList<Object>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            apcHelper.addAccordiAllegatiToDati(dati, TipoOperazione.OTHER, idAccordo, null, null, null, null, tipoAccordo, null, idAllegato, doc, as, errore, contenutoAllegato, null);
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)AccordiServizioParteComuneCostanti.TIPO_OPERAZIONE_VIEW);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)AccordiServizioParteComuneCostanti.TIPO_OPERAZIONE_VIEW);
        }
    }
}

