/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ac;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.govway.struts.upload.FormFile;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.FileUploadForm;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiCooperazioneAllegatiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            FileUploadForm fileUpload = (FileUploadForm)form;
            AccordiCooperazioneHelper acHelper = new AccordiCooperazioneHelper(request, pd, session);
            acHelper.makeMenu();
            ArchiviHelper archiviHelper = new ArchiviHelper(request, pd, session);
            String idAccordo = acHelper.getParametroLong("id");
            long idAccordoLong = Long.parseLong(idAccordo);
            String ruolo = acHelper.getParameter("ruolo");
            String tipoFile = acHelper.getParameter("tipoFile");
            FormFile ff = fileUpload.getTheFile();
            AccordiCooperazioneCore acCore = new AccordiCooperazioneCore();
            AccordoCooperazione ac = acCore.getAccordoCooperazione(idAccordoLong);
            String titleAS = acHelper.getLabelIdAccordoCooperazione(ac);
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(ac.getSoggettoReferente().getTipo());
            String[] ruoli = new String[]{RuoliDocumento.allegato.toString(), RuoliDocumento.specificaSemiformale.toString()};
            String[] tipiAmmessi = null;
            String[] tipiAmmessiLabel = null;
            if (ruolo != null && !"".equals(ruolo)) {
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        break;
                    }
                    case specificaSemiformale: {
                        tipiAmmessi = TipiDocumentoSemiformale.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoSemiformale.toStringArray();
                        break;
                    }
                }
            }
            if (acHelper.isEditModeInProgress()) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                lstParam.add(new Parameter("Allegati di " + titleAS, "accordiCooperazioneAllegatiList.do", new Parameter[]{new Parameter("id", idAccordo), new Parameter("nome", ac.getNome())}));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = acHelper.addAllegatoToDati(TipoOperazione.ADD, idAccordo, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiCooperazioneAllegati", (ForwardParams)ForwardParams.ADD());
            }
            Documento documento = new Documento();
            documento.setRuolo(RuoliDocumento.valueOf((String)ruolo).toString());
            documento.setByteContenuto(ff.getFileData());
            documento.setFile(ff.getFileName());
            switch (RuoliDocumento.valueOf((String)ruolo)) {
                case allegato: {
                    documento.setTipo(ff.getFileName().substring(ff.getFileName().lastIndexOf(46) + 1, ff.getFileName().length()));
                    break;
                }
                case specificaSemiformale: {
                    documento.setTipo(TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome());
                    break;
                }
            }
            documento.setIdProprietarioDocumento(ac.getId());
            boolean isOk = archiviHelper.accordiAllegatiCheckData(TipoOperazione.ADD, ff, documento, ProprietariDocumento.accordoCooperazione, pf);
            if (!isOk) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                lstParam.add(new Parameter("Allegati di " + titleAS, "accordiCooperazioneAllegatiList.do", new Parameter[]{new Parameter("id", idAccordo), new Parameter("nome", ac.getNome())}));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = acHelper.addAllegatoToDati(TipoOperazione.ADD, idAccordo, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazioneAllegati", (ForwardParams)ForwardParams.ADD());
            }
            switch (RuoliDocumento.valueOf((String)ruolo)) {
                case allegato: {
                    ac.addAllegato(documento);
                    break;
                }
                case specificaSemiformale: {
                    ac.addSpecificaSemiformale(documento);
                    break;
                }
            }
            acCore.performUpdateOperation(userLogin, acHelper.smista(), ac);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Documento> lista = acCore.accordiCoopAllegatiList(idAccordoLong, (ISearch)ricerca);
            acHelper.prepareAccordiCoopAllegatiList(ac, (ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiCooperazioneAllegati", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiCooperazioneAllegati", (ForwardParams)ForwardParams.ADD());
        }
    }
}

