/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.registro;

import java.util.Properties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.web.ctrlstat.config.RegistroServiziRemotoProperties;
import org.slf4j.Logger;

public class GestoreRegistroServiziRemoto {
    private static GestoreRegistroServiziRemoto gestore = null;
    private String tipoRegistro;
    private IDriverRegistroServiziGet driverRegistroServizi = null;

    public static IDriverRegistroServiziGet getDriverRegistroServizi(Logger log) throws Exception {
        if (gestore == null) {
            GestoreRegistroServiziRemoto.init(log);
        }
        return GestoreRegistroServiziRemoto.gestore.driverRegistroServizi;
    }

    public static String getTipoRegistroServizi(Logger log) throws Exception {
        if (gestore == null) {
            GestoreRegistroServiziRemoto.init(log);
        }
        return GestoreRegistroServiziRemoto.gestore.tipoRegistro;
    }

    private static synchronized void init(Logger log) throws Exception {
        if (gestore == null) {
            gestore = new GestoreRegistroServiziRemoto(log);
        }
    }

    public GestoreRegistroServiziRemoto(Logger log) throws Exception {
        RegistroServiziRemotoProperties registroServiziRemotoProperties = RegistroServiziRemotoProperties.getInstance();
        this.tipoRegistro = registroServiziRemotoProperties.getTipoRegistroServiziRemoto();
        if (CostantiConfigurazione.REGISTRO_XML.equals(this.tipoRegistro)) {
            String location = registroServiziRemotoProperties.getRegistroServiziXML_Location();
            this.driverRegistroServizi = new DriverRegistroServiziXML(location, log);
            if (!((DriverRegistroServiziXML)this.driverRegistroServizi).create) {
                throw new Exception("[RegistroServiziRemoto] DriverRegistroServiziXML non correttamente inizializzato");
            }
        } else if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoRegistro)) {
            String tipoDatabase = registroServiziRemotoProperties.getRegistroServiziDB_TipoDatabase();
            String datasource = registroServiziRemotoProperties.getRegistroServiziDB_DataSource();
            Properties ctxProperties = registroServiziRemotoProperties.getRegistroServiziDB_DataSourceContext();
            this.driverRegistroServizi = new DriverRegistroServiziDB(datasource, ctxProperties, log, tipoDatabase);
            if (!((DriverRegistroServiziDB)this.driverRegistroServizi).create) {
                throw new Exception("[RegistroServiziRemoto] DriverRegistroServiziDB non correttamente inizializzato");
            }
        } else {
            throw new Exception("Tipo di registro non gestito: " + this.tipoRegistro);
        }
        log.info("Accesso al registro dei servizi remoto di tipo [" + this.tipoRegistro + "] correttamente effettuato.");
    }
}

