/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCore;
import org.slf4j.Logger;

public class Connettori {
    private static final List<String> lista = new ArrayList<String>();

    public static void initialize(Logger log) throws Exception {
        Connettori.initialize(log, false, null, null);
    }

    public static void initialize(Logger log, boolean initForApi, String confDir, String protocolloDefault) throws Exception {
        for (TipiConnettore t : TipiConnettore.values()) {
            if (TipiConnettore.CUSTOM.equals((Object)t)) continue;
            lista.add(t.getNome());
        }
        try {
            Connettori.readConnettoriFromDB(initForApi, confDir, protocolloDefault);
        }
        catch (Exception e) {
            log.error("Caricamento connettori non riuscito", (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public static boolean contains(String nome) {
        return lista.contains(nome);
    }

    private static boolean readConnettoriFromDB(boolean initForApi, String confDir, String protocolloDefault) throws Exception {
        try {
            ConnettoriCore core = null;
            core = initForApi ? new ConnettoriCore(initForApi, confDir, protocolloDefault) : new ConnettoriCore();
            List<String> tmpConnettori = core.connettoriList();
            Iterator<String> it = tmpConnettori.iterator();
            while (it.hasNext()) {
                lista.add(it.next());
            }
            ControlStationLogger.getPddConsoleCoreLogger().info("Connettori: caricati " + lista.size() + " connettori.");
        }
        catch (Exception e) {
            ControlStationLogger.getPddConsoleCoreLogger().error("Connettori: " + e.getMessage());
        }
        return true;
    }

    public static List<String> getList() {
        return new ArrayList<String>(lista);
    }
}

