/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.template_scan.cli;

import java.io.InputStream;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ScanResult {
    private TreeMap<Position, String> matches = new TreeMap((p1, p2) -> {
        int cmp = Integer.compare(p1.line, p2.line);
        if (cmp == 0) {
            return Integer.compare(p1.column, p2.column);
        }
        return cmp;
    });

    private ScanResult() {
    }

    public static Optional<ScanResult> parse(InputStream is, Pattern regex) {
        ScanResult res = new ScanResult();
        try (Scanner sc = new Scanner(is);){
            String content = sc.useDelimiter("\\A").hasNext() ? sc.next() : "";
            Matcher matcher = regex.matcher(content);
            while (matcher.find()) {
                int position = matcher.start();
                Position pos = ScanResult.calculateLineAndColumn(content, position);
                res.matches.put(pos, matcher.group());
            }
        }
        if (res.matches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(res);
    }

    private static Position calculateLineAndColumn(String content, int offset) {
        int line = 1;
        int column = 1;
        for (int i = 0; i < offset && i < content.length(); ++i) {
            if (content.charAt(i) == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return new Position(line, column);
    }

    public String toString() {
        return this.matches.entrySet().stream().map(e -> ((Position)e.getKey()).toString()).collect(Collectors.joining(", "));
    }

    private static class Position {
        int line;
        int column;

        Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public String toString() {
            return "linea " + this.line + " colonna " + this.column;
        }
    }
}

