/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.generic_project.exception.NotAuthorizedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServerPropertiesBase;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.slf4j.Logger;

public class AuthorizationManagerBase {
    private boolean basic = false;
    private boolean ssl = false;
    private boolean principal = false;
    private boolean authorizedRequired;
    private boolean identifiedMethodOrRelation = true;
    private Properties basicAuthorizedIdentitiesSearch = null;
    private Properties basicAuthorizedIdentitiesCRUD = null;
    private Properties sslAuthorizedIdentitiesSearch = null;
    private Properties sslAuthorizedIdentitiesCRUD = null;
    private Properties principalAuthorizedIdentitiesSearch = null;
    private Properties principalAuthorizedIdentitiesCRUD = null;

    public AuthorizationManagerBase(Properties serverProperties) throws ServiceException {
        this(new ServerPropertiesBase(serverProperties));
    }

    public AuthorizationManagerBase(ServerPropertiesBase serverProperties) throws ServiceException {
        String authorizationMethodEnabled;
        String identifiedMethodOrRelationTmp = serverProperties.getProperty("identifiedMethod.orRelation", false);
        if (identifiedMethodOrRelationTmp != null) {
            this.identifiedMethodOrRelation = Boolean.parseBoolean(identifiedMethodOrRelationTmp);
        }
        if ((authorizationMethodEnabled = serverProperties.getProperty("identifiedMethod", false)) != null) {
            String[] split = authorizationMethodEnabled.split(",");
            for (int i = 0; i < split.length; ++i) {
                String key;
                Enumeration<Object> en;
                String key2;
                Enumeration<Object> en2;
                String method = split[i].trim();
                if ("basic".equalsIgnoreCase(method)) {
                    Properties authBasicCRUD;
                    this.basic = true;
                    Properties authBasicAll = serverProperties.readProperties("authorized.basic.");
                    this.basicAuthorizedIdentitiesSearch = new Properties();
                    this.basicAuthorizedIdentitiesSearch.putAll((Map<?, ?>)authBasicAll);
                    this.basicAuthorizedIdentitiesCRUD = new Properties();
                    this.basicAuthorizedIdentitiesCRUD.putAll((Map<?, ?>)authBasicAll);
                    Properties authBasicSearch = serverProperties.readProperties("authorized.search.basic.");
                    if (authBasicSearch.size() > 0) {
                        en2 = authBasicSearch.keys();
                        while (en2.hasMoreElements()) {
                            key2 = (String)en2.nextElement();
                            if (this.basicAuthorizedIdentitiesSearch.containsKey(key2)) {
                                throw new ServiceException("Property [" + key2 + "] already defined for basic authentication of search method (see authorized.basic.* and authorized.search.basic.*)");
                            }
                            this.basicAuthorizedIdentitiesSearch.put(key2, authBasicSearch.get(key2));
                        }
                    }
                    if ((authBasicCRUD = serverProperties.readProperties("authorized.crud.basic.")).size() > 0) {
                        en = authBasicCRUD.keys();
                        while (en.hasMoreElements()) {
                            key = (String)en.nextElement();
                            if (this.basicAuthorizedIdentitiesCRUD.containsKey(key)) {
                                throw new ServiceException("Property [" + key + "] already defined for basic authentication of crud method (see authorized.basic.* and authorized.crud.basic.*)");
                            }
                            this.basicAuthorizedIdentitiesCRUD.put(key, authBasicCRUD.get(key));
                        }
                    }
                    if (this.basicAuthorizedIdentitiesCRUD.size() > 0 || this.basicAuthorizedIdentitiesSearch.size() > 0) continue;
                    throw new ServiceException("Required authorizedMethod [" + method + "] without a list of authorized users");
                }
                if ("ssl".equalsIgnoreCase(method)) {
                    Properties authSslCRUD;
                    this.ssl = true;
                    Properties authSslAll = serverProperties.readProperties("authorized.ssl.");
                    this.sslAuthorizedIdentitiesSearch = new Properties();
                    this.sslAuthorizedIdentitiesSearch.putAll((Map<?, ?>)authSslAll);
                    this.sslAuthorizedIdentitiesCRUD = new Properties();
                    this.sslAuthorizedIdentitiesCRUD.putAll((Map<?, ?>)authSslAll);
                    Properties authSslSearch = serverProperties.readProperties("authorized.search.ssl.");
                    if (authSslSearch.size() > 0) {
                        en2 = authSslSearch.keys();
                        while (en2.hasMoreElements()) {
                            key2 = (String)en2.nextElement();
                            if (this.sslAuthorizedIdentitiesSearch.containsKey(key2)) {
                                throw new ServiceException("Property [" + key2 + "] already defined for ssl authentication of search method (see authorized.ssl.* and authorized.search.ssl.*)");
                            }
                            this.sslAuthorizedIdentitiesSearch.put(key2, authSslSearch.get(key2));
                        }
                    }
                    if ((authSslCRUD = serverProperties.readProperties("authorized.crud.ssl.")).size() > 0) {
                        en = authSslCRUD.keys();
                        while (en.hasMoreElements()) {
                            key = (String)en.nextElement();
                            if (this.sslAuthorizedIdentitiesCRUD.containsKey(key)) {
                                throw new ServiceException("Property [" + key + "] already defined for ssl authentication of crud method (see authorized.ssl.* and authorized.crud.ssl.*)");
                            }
                            this.sslAuthorizedIdentitiesCRUD.put(key, authSslCRUD.get(key));
                        }
                    }
                    if (this.sslAuthorizedIdentitiesCRUD.size() > 0 || this.sslAuthorizedIdentitiesSearch.size() > 0) continue;
                    throw new ServiceException("Required authorizedMethod [" + method + "] without a list of authorized users");
                }
                if ("principal".equalsIgnoreCase(method)) {
                    Properties authPrincipalCRUD;
                    this.principal = true;
                    Properties authPrincipalAll = serverProperties.readProperties("authorized.principal.");
                    this.principalAuthorizedIdentitiesSearch = new Properties();
                    this.principalAuthorizedIdentitiesSearch.putAll((Map<?, ?>)authPrincipalAll);
                    this.principalAuthorizedIdentitiesCRUD = new Properties();
                    this.principalAuthorizedIdentitiesCRUD.putAll((Map<?, ?>)authPrincipalAll);
                    Properties authPrincipalSearch = serverProperties.readProperties("authorized.search.principal.");
                    if (authPrincipalSearch.size() > 0) {
                        en2 = authPrincipalSearch.keys();
                        while (en2.hasMoreElements()) {
                            key2 = (String)en2.nextElement();
                            if (this.principalAuthorizedIdentitiesSearch.containsKey(key2)) {
                                throw new ServiceException("Property [" + key2 + "] already defined for principal authentication of search method (see authorized.principal.* and authorized.search.principal.*)");
                            }
                            this.principalAuthorizedIdentitiesSearch.put(key2, authPrincipalSearch.get(key2));
                        }
                    }
                    if ((authPrincipalCRUD = serverProperties.readProperties("authorized.crud.principal.")).size() > 0) {
                        en = authPrincipalCRUD.keys();
                        while (en.hasMoreElements()) {
                            key = (String)en.nextElement();
                            if (this.principalAuthorizedIdentitiesCRUD.containsKey(key)) {
                                throw new ServiceException("Property [" + key + "] already defined for principal authentication of crud method (see authorized.principal.* and authorized.crud.principal.*)");
                            }
                            this.principalAuthorizedIdentitiesCRUD.put(key, authPrincipalCRUD.get(key));
                        }
                    }
                    if (this.principalAuthorizedIdentitiesCRUD.size() > 0 || this.principalAuthorizedIdentitiesSearch.size() > 0) continue;
                    throw new ServiceException("Required authorizedMethod [" + method + "] without a list of authorized users");
                }
                throw new ServiceException("AuthorizedMethod [" + method + "] unknow");
            }
        }
        this.authorizedRequired = this.basic || this.ssl || this.principal;
    }

    private void logError(Logger log, String message, StringBuilder bf) {
        if (bf.length() > 0) {
            bf.append("\n");
        }
        bf.append(message);
        log.error(message);
    }

    public void authorize(HttpServletRequest httpServletRequest, Logger log, boolean searchMethod) throws NotAuthorizedException {
        String principalId;
        String subject;
        boolean isRegistered;
        if (!this.authorizedRequired) {
            return;
        }
        HttpServletCredential identity = new HttpServletCredential(httpServletRequest, log, true);
        StringBuilder bf = new StringBuilder();
        boolean basicOk = false;
        if (this.basic) {
            String username = identity.getUsername();
            String password = identity.getPassword();
            if (username != null) {
                if (password != null) {
                    isRegistered = false;
                    String passwordRegistrata = null;
                    if (searchMethod) {
                        isRegistered = this.basicAuthorizedIdentitiesSearch.containsKey(username);
                        if (isRegistered) {
                            passwordRegistrata = this.basicAuthorizedIdentitiesSearch.getProperty(username);
                        }
                    } else {
                        isRegistered = this.basicAuthorizedIdentitiesCRUD.containsKey(username);
                        if (isRegistered) {
                            passwordRegistrata = this.basicAuthorizedIdentitiesCRUD.getProperty(username);
                        }
                    }
                    if (isRegistered) {
                        if (password.equals(passwordRegistrata)) {
                            log.debug("Detected in the http request a credential basic (username:" + username + ") that identifies an authorized user");
                            basicOk = true;
                        } else {
                            this.logError(log, "Detected in the http request a credential basic (username:" + username + ") that contains a wrong password [" + password + "]", bf);
                        }
                    } else {
                        this.logError(log, "Detected in the http request a credential basic (username:" + username + " password" + password + ") not authorized", bf);
                    }
                } else {
                    this.logError(log, "Detected in the http request a credential basic not usable (username:" + username + "), password not defined???", bf);
                }
            }
        }
        boolean sslOk = false;
        if (this.ssl && (subject = identity.getSubject()) != null) {
            isRegistered = false;
            isRegistered = searchMethod ? this.sslAuthorizedIdentitiesSearch.containsValue(subject) : this.sslAuthorizedIdentitiesCRUD.containsValue(subject);
            if (isRegistered) {
                log.debug("Detected in the http request a credential ssl (subject:" + subject + ") that identifies an authorized user");
                sslOk = true;
            } else {
                this.logError(log, "Detected in the http request a credential ssl (subject:" + subject + ") not authorized", bf);
            }
        }
        boolean principalOk = false;
        if (this.principal && (principalId = identity.getPrincipal()) != null) {
            boolean isRegistered2 = false;
            isRegistered2 = searchMethod ? this.principalAuthorizedIdentitiesSearch.containsValue(principalId) : this.principalAuthorizedIdentitiesCRUD.containsValue(principalId);
            if (isRegistered2) {
                log.debug("Detected in the http request a credential principal (id:" + principalId + ") that identifies an authorized user");
                principalOk = true;
            } else {
                this.logError(log, "Detected in the http request a credential principal (id:" + principalId + ") not authorized", bf);
            }
        }
        if (this.identifiedMethodOrRelation) {
            if (!(basicOk || sslOk || principalOk)) {
                if (bf.length() > 0) {
                    throw new NotAuthorizedException(bf.toString());
                }
                throw new NotAuthorizedException("No credentials found in the request");
            }
        } else {
            if (this.basic && !basicOk) {
                if (bf.length() > 0) {
                    throw new NotAuthorizedException(bf.toString());
                }
                throw new NotAuthorizedException("No basic credentials found in the request");
            }
            if (this.ssl && !sslOk) {
                if (bf.length() > 0) {
                    throw new NotAuthorizedException(bf.toString());
                }
                throw new NotAuthorizedException("No ssl credentials found in the request");
            }
            if (this.principal && !principalOk) {
                if (bf.length() > 0) {
                    throw new NotAuthorizedException(bf.toString());
                }
                throw new NotAuthorizedException("No principal credentials found in the request");
            }
        }
    }
}

