/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class TimestampTypeFormatter
implements ITypeFormatter<Timestamp> {
    private SimpleDateFormat dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String toString(Timestamp o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return this.dateformat.format(o);
    }

    @Override
    public String toSQLString(Timestamp o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Timestamp o, TipiDatabase databaseType) throws ExpressionException {
        return TimestampTypeFormatter.toSQLString(o, o, databaseType, this);
    }

    public static <T> String toSQLString(T rawDate, Date date, TipiDatabase databaseType, ITypeFormatter<T> formatter) throws ExpressionException {
        if (databaseType != null) {
            switch (databaseType) {
                case POSTGRESQL: 
                case ORACLE: 
                case MYSQL: 
                case HSQL: 
                case SQLSERVER: 
                case DB2: 
                case DERBY: {
                    try {
                        ISQLQueryObject sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((TipiDatabase)databaseType);
                        return sqlQueryObjectCore.getSelectTimestampConstantField(date);
                    }
                    catch (Exception e) {
                        throw new ExpressionException(e.getMessage(), e);
                    }
                }
                case DEFAULT: {
                    return "'" + formatter.toString(rawDate) + "'";
                }
            }
        }
        return "'" + formatter.toString(rawDate) + "'";
    }

    @Override
    public Timestamp toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return new Timestamp(this.dateformat.parse(o).getTime());
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Timestamp> getTypeSupported() {
        return Timestamp.class;
    }
}

