/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class FloatTypeFormatter
implements ITypeFormatter<Float> {
    @Override
    public String toString(Float o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return "" + o.floatValue();
    }

    @Override
    public String toSQLString(Float o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Float o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case ORACLE: {
                return "to_binary_float(" + this.toString(o) + ")";
            }
        }
        return this.toString(o);
    }

    @Override
    public Float toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return Float.valueOf(Float.parseFloat(o));
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Float> getTypeSupported() {
        return Float.class;
    }
}

