/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.List;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.impl.AbstractCommonFieldBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;

public class InExpressionImpl
extends AbstractCommonFieldBaseExpressionImpl {
    private List<Object> objects;

    public InExpressionImpl(IObjectFormatter objectFormatter, IField field, List<Object> objects) {
        super(objectFormatter, field);
        this.objects = objects;
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        bf.append(" IN (");
        for (int i = 0; i < this.objects.size(); ++i) {
            bf.append(" ");
            if (i > 0) {
                bf.append(", ");
            }
            try {
                bf.append(super.getObjectFormatter().toString(this.objects.get(i)));
                continue;
            }
            catch (Exception e) {
                return "ERROR[" + i + "]: " + e.getMessage();
            }
        }
        bf.append(" )");
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        List<Object> l = null;
        if (this.field == null) {
            return l;
        }
        if (this.field.equals(field)) {
            return this.objects;
        }
        return l;
    }
}

