/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.expression.impl.AbstractCommonFieldValueBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.DayFormatEnum;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;

public class DayFormatExpressionImpl
extends AbstractCommonFieldValueBaseExpressionImpl {
    protected DayFormatEnum dayFormatEnum;

    public DayFormatExpressionImpl(IObjectFormatter objectFormatter, IField field, String value, DayFormatEnum dayFormatEnum) {
        super(objectFormatter, field, value);
        this.dayFormatEnum = dayFormatEnum;
    }

    public String toString() {
        try {
            StringBuilder bf = new StringBuilder();
            if (this.isNot()) {
                bf.append("( NOT ");
            }
            bf.append("( ");
            SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject((TipiDatabase)TipiDatabase.POSTGRESQL);
            String prefix = sqlQueryObject.getExtractDayFormatFromTimestampFieldPrefix(this.dayFormatEnum);
            bf.append(prefix);
            if (this.field instanceof ComplexField) {
                ComplexField cf = (ComplexField)this.field;
                if (cf.getFather() != null) {
                    bf.append(cf.getFather().getFieldName());
                } else {
                    bf.append(this.field.getClassName());
                }
            } else {
                bf.append(this.field.getClassName());
            }
            bf.append(".");
            bf.append(this.field.getFieldName());
            String suffix = sqlQueryObject.getExtractDayFormatFromTimestampFieldSuffix(this.dayFormatEnum);
            bf.append(" ");
            bf.append(suffix);
            bf.append(" = '");
            bf.append(this.value);
            bf.append("'");
            bf.append(" )");
            if (this.isNot()) {
                bf.append(" )");
            }
            return bf.toString();
        }
        catch (Exception e) {
            LoggerWrapperFactory.getLogger(DayFormatExpressionImpl.class).error(e.getMessage(), (Throwable)e);
            return " Errore DateTimePart: " + e.getMessage();
        }
    }
}

