/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import org.openspcoop2.generic_project.beans.Field;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.BooleanTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ByteTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.CalendarTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.CharacterTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.DateTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.DoubleTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.FloatTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.IntegerTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.LongTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.NullTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ShortTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.StringTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.TimestampTypeFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.URITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class ConstantField
extends Field {
    private Object fieldValue;
    private ObjectFormatter objectFormatter = null;

    public ConstantField(String fieldName, Object fieldValue, Class<?> fieldType) throws ExpressionException {
        super(fieldName, fieldType, ConstantField.class.getSimpleName(), ConstantField.class);
        this.fieldValue = fieldValue;
        this.objectFormatter = new ObjectFormatter(new BooleanTypeFormatter(), new CalendarTypeFormatter(), new DateTypeFormatter(), new TimestampTypeFormatter(), new CharacterTypeFormatter(), new StringTypeFormatter(), new ByteTypeFormatter(), new ShortTypeFormatter(), new IntegerTypeFormatter(), new LongTypeFormatter(), new DoubleTypeFormatter(), new FloatTypeFormatter(), new URITypeFormatter(), new NullTypeFormatter());
        this.objectFormatter.isSupported(this.fieldValue);
    }

    public String getConstantValue(TipiDatabase databaseType) throws ExpressionException {
        return this.objectFormatter.toSQLString(this.fieldValue, databaseType);
    }

    public String getAlias() {
        return this.getFieldName();
    }

    @Override
    public String toString(int indent) {
        StringBuilder indentBuffer = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentBuffer.append("\t");
        }
        StringBuilder bf = new StringBuilder(super.toString(indent));
        bf.append(indentBuffer.toString());
        bf.append("- fieldValue: " + String.valueOf(this.fieldValue));
        bf.append("\n");
        return bf.toString();
    }
}

