/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.pdd.config.DigestServiceParams;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.digest.DigestType;
import org.openspcoop2.utils.random.RandomUtilities;

public class SignalHubUtils {
    private SignalHubUtils() {
    }

    public static DigestServiceParams generateDigestServiceParams(IDServizio idServizio, List<ProtocolProperty> eServiceProperties, Long serial) throws ProtocolException {
        Long durata = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenSignalHubSeedLifetime", (boolean)true);
        String algorithm = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenSignalHubAlg");
        Long seedSize = ProtocolPropertiesUtils.getRequiredNumberValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenSignalHubSeedSize", (boolean)true);
        DigestServiceParams param = new DigestServiceParams();
        param.setIdServizio(idServizio);
        param.setDataRegistrazione(Instant.now());
        param.setDurata(Integer.valueOf(durata.intValue()));
        param.setDigestAlgorithm(DigestType.fromAlgorithmName((String)algorithm));
        param.setSeed(Base64.getEncoder().encode(RandomUtilities.getSecureRandom().generateSeed(seedSize.intValue())));
        param.setSerialNumber(serial);
        return param;
    }

    public static List<ProtocolProperty> obtainSignalHubProtocolProperty(Context context) {
        return ((List)context.get(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_PROPERTIES)).stream().map(e -> (ProtocolProperty)e).collect(Collectors.toList());
    }
}

