/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationKeystoreUtilities;
import org.openspcoop2.protocol.modipa.utils.SOAPHeader;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.ModISecurityUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class ModIDynamicConfigurationAccordiParteSpecificaUtilities {
    private static final String PREFIX_VERIFICATO_QUANTO_INDICATO_IN = "Verificare quanto indicato in ";

    private ModIDynamicConfigurationAccordiParteSpecificaUtilities() {
    }

    private static String getErrorLetturaAPIFallita(Exception e) {
        return "Lettura API fallita: " + e.getMessage();
    }

    static ConsoleConfiguration getDynamicConfigParteSpecifica(Logger log, ModIProperties modiProperties, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id, IDSoggetto idFruitore, boolean fruizioni) throws ProtocolException {
        boolean sicurezzaMessaggioNonPresente;
        boolean tokenSignedJWT;
        boolean pdnd;
        if (consoleHelper.isModalitaCompleta()) {
            return null;
        }
        if (ConsoleOperationType.DEL.equals((Object)consoleOperationType)) {
            return null;
        }
        if (!ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizioneOrErogazione(consoleHelper)) {
            return null;
        }
        boolean casoSpecialeModificaNomeFruizione = !fruizioni && ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizione(consoleHelper);
        AccordoServizioParteComune api = null;
        IDAccordo idAccordo = null;
        String portType = null;
        try {
            if (id != null && id.getUriAccordoServizioParteComune() != null) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(id.getUriAccordoServizioParteComune());
                api = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
            }
            if (((portType = consoleHelper.getParameter("port_type")) == null || "".equals(portType)) && id != null) {
                portType = id.getPortType();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(ModIDynamicConfigurationAccordiParteSpecificaUtilities.getErrorLetturaAPIFallita(e), (Throwable)e);
        }
        if (api == null) {
            return null;
        }
        boolean rest = ServiceBinding.REST.equals((Object)api.getServiceBinding());
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        boolean corniceSicurezza = ModISecurityUtils.isProfiloSicurezzaMessaggioCorniceSicurezza((AccordoServizioParteComune)api, (String)portType);
        String patternDatiCorniceSicurezza = null;
        String schemaDatiCorniceSicurezza = null;
        if (corniceSicurezza) {
            patternDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaPattern((AccordoServizioParteComune)api, (String)portType);
            if (patternDatiCorniceSicurezza == null) {
                patternDatiCorniceSicurezza = "old";
            }
            if (!"old".equals(patternDatiCorniceSicurezza)) {
                schemaDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema((AccordoServizioParteComune)api, (String)portType);
            }
        }
        boolean addSignalHub = false;
        if (fruizioni && idAccordo != null && ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(idAccordo, registryReader, modiProperties, log)) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignaHubFruizioneConfig(modiProperties, configuration, rest);
            addSignalHub = true;
        }
        if ((pdnd = ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthPDND((AccordoServizioParteComune)api, (String)portType)) && !fruizioni) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addPdndInfo(modiProperties, configuration, rest);
        }
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)api, (String)portType)) {
            boolean digest = ModISecurityUtils.isProfiloSicurezzaMessaggioConIntegrita((AccordoServizioParteComune)api, (String)portType);
            boolean headerDuplicati = false;
            boolean riferimentoX509 = false;
            boolean kidMode = false;
            if (rest) {
                headerDuplicati = ModISecurityUtils.isProfiloSicurezzaMessaggioConHeaderDuplicati((AccordoServizioParteComune)api, (String)portType);
                riferimentoX509 = ModISecurityUtils.isSicurezzaMessaggioRiferimentoX509Required((AccordoServizioParteComune)api, (String)portType);
                kidMode = ModISecurityUtils.isSicurezzaMessaggioKidModeSupported((AccordoServizioParteComune)api, (String)portType);
            }
            boolean tokenNonLocale = true;
            if (rest || fruizioni) {
                tokenNonLocale = ModISecurityUtils.isProfiloSicurezzaMessaggioConSorgenteTokenNonLocale((AccordoServizioParteComune)api, (String)portType, (boolean)rest);
            }
            if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRichiesta((AccordoServizioParteComune)api, (String)portType, (boolean)true)) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaMessaggio(modiProperties, configuration, rest, fruizioni, true, casoSpecialeModificaNomeFruizione, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, idFruitore, riferimentoX509, kidMode, false, tokenNonLocale);
            }
            if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRisposta((AccordoServizioParteComune)api, (String)portType, (boolean)true)) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaMessaggio(modiProperties, configuration, rest, fruizioni, false, casoSpecialeModificaNomeFruizione, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, idFruitore, riferimentoX509, kidMode, false, tokenNonLocale);
            }
            return configuration;
        }
        if (corniceSicurezza && !"old".equals(patternDatiCorniceSicurezza) && schemaDatiCorniceSicurezza != null) {
            boolean forceRest = true;
            boolean tokenNonLocale = false;
            if (fruizioni) {
                tokenNonLocale = ModISecurityUtils.isProfiloSicurezzaMessaggioConSorgenteTokenNonLocale((AccordoServizioParteComune)api, (String)portType, (boolean)rest);
            }
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaMessaggio(modiProperties, configuration, forceRest, fruizioni, true, casoSpecialeModificaNomeFruizione, false, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, false, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, idFruitore, false, false, true, tokenNonLocale);
            return configuration;
        }
        if (fruizioni && (tokenSignedJWT = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaTokenSignedJWT(rest, configuration, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, idFruitore, sicurezzaMessaggioNonPresente = false))) {
            ModIDynamicConfigurationKeystoreUtilities.addTrustStoreKeystoreFruizioneOAuthConfigChoice(configuration);
            boolean requiredValue = true;
            ModIDynamicConfigurationKeystoreUtilities.addKeystoreConfig(configuration, true, false, requiredValue);
            return configuration;
        }
        if (pdnd || addSignalHub) {
            return configuration;
        }
        return null;
    }

    static boolean updateDynamicConfigParteSpecifica(Logger log, ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IDServizio id, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean fruizioni) throws ProtocolException {
        boolean pdnd;
        if (consoleHelper.isModalitaCompleta()) {
            return false;
        }
        if (ConsoleOperationType.DEL.equals((Object)consoleOperationType)) {
            return false;
        }
        if (!ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizioneOrErogazione(consoleHelper)) {
            return false;
        }
        boolean casoSpecialeModificaNomeFruizione = !fruizioni && ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizione(consoleHelper);
        AccordoServizioParteComune api = null;
        IDAccordo idAccordo = null;
        String portType = null;
        try {
            if (id != null && id.getUriAccordoServizioParteComune() != null) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(id.getUriAccordoServizioParteComune());
                api = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
            }
            if (((portType = consoleHelper.getParameter("port_type")) == null || "".equals(portType)) && id != null) {
                portType = id.getPortType();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(ModIDynamicConfigurationAccordiParteSpecificaUtilities.getErrorLetturaAPIFallita(e), (Throwable)e);
        }
        if (api == null) {
            return false;
        }
        boolean rest = ServiceBinding.REST.equals((Object)api.getServiceBinding());
        boolean corniceSicurezza = ModISecurityUtils.isProfiloSicurezzaMessaggioCorniceSicurezza((AccordoServizioParteComune)api, (String)portType);
        String patternDatiCorniceSicurezza = null;
        String schemaDatiCorniceSicurezza = null;
        if (corniceSicurezza) {
            patternDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaPattern((AccordoServizioParteComune)api, (String)portType);
            if (patternDatiCorniceSicurezza == null) {
                patternDatiCorniceSicurezza = "old";
            }
            if (!"old".equals(patternDatiCorniceSicurezza)) {
                schemaDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema((AccordoServizioParteComune)api, (String)portType);
            }
        }
        if (fruizioni && idAccordo != null && ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(idAccordo, registryReader, modiProperties, log)) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSignaHubFruizioneConfig(modiProperties, consoleConfiguration, properties);
        }
        if ((pdnd = ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthPDND((AccordoServizioParteComune)api, (String)portType)) && !fruizioni) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfo(consoleConfiguration, properties, api, portType, id, registryReader, configIntegrationReader, log);
        }
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)api, (String)portType)) {
            boolean headerDuplicati = false;
            if (rest) {
                headerDuplicati = ModISecurityUtils.isProfiloSicurezzaMessaggioConHeaderDuplicati((AccordoServizioParteComune)api, (String)portType);
            }
            boolean kidMode = ModISecurityUtils.isSicurezzaMessaggioKidModeSupported((AccordoServizioParteComune)api, (String)portType);
            boolean tokenNonLocale = ModISecurityUtils.isProfiloSicurezzaMessaggioConSorgenteTokenNonLocale((AccordoServizioParteComune)api, (String)portType, (boolean)rest);
            if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRichiesta((AccordoServizioParteComune)api, (String)portType, (boolean)true)) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSicurezzaMessaggio(modiProperties, consoleConfiguration, properties, rest, fruizioni, true, casoSpecialeModificaNomeFruizione, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, consoleHelper, kidMode, tokenNonLocale);
            }
            if (ModISecurityUtils.isProfiloSicurezzaMessaggioApplicabileRisposta((AccordoServizioParteComune)api, (String)portType, (boolean)true)) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSicurezzaMessaggio(modiProperties, consoleConfiguration, properties, rest, fruizioni, false, casoSpecialeModificaNomeFruizione, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, consoleHelper, kidMode, tokenNonLocale);
            }
        } else {
            if (corniceSicurezza && !"old".equals(patternDatiCorniceSicurezza) && schemaDatiCorniceSicurezza != null) {
                boolean forceRest = true;
                boolean kidMode = true;
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSicurezzaMessaggio(modiProperties, consoleConfiguration, properties, forceRest, fruizioni, true, casoSpecialeModificaNomeFruizione, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, false, consoleHelper, kidMode, false);
            }
            if (fruizioni) {
                boolean requiredValue = true;
                boolean hideSceltaArchivioFilePath = false;
                boolean addHiddenSubjectIssuer = false;
                boolean checkRidefinisciOauth = false;
                rest = true;
                ModIDynamicConfigurationKeystoreUtilities.updateKeystoreConfig(consoleConfiguration, properties, true, checkRidefinisciOauth, hideSceltaArchivioFilePath, addHiddenSubjectIssuer, requiredValue, null, rest);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean validateDynamicConfigParteSpecifica(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, IConsoleHelper consoleHelper, ProtocolProperties properties, IDServizio id, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean fruizioni) throws ProtocolException {
        StringProperty tokenKidItemValue;
        StringProperty tokenIdentificativoClientItemValue;
        boolean pdnd;
        boolean casoSpecialeModificaNomeFruizione;
        if (!ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizioneOrErogazione(consoleHelper)) {
            return false;
        }
        if (!fruizioni && ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizione(consoleHelper)) {
            return false;
        }
        boolean bl = casoSpecialeModificaNomeFruizione = false;
        if (casoSpecialeModificaNomeFruizione) {
            return false;
        }
        AccordoServizioParteComune api = null;
        String portType = null;
        try {
            if (id != null && id.getUriAccordoServizioParteComune() != null) {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(id.getUriAccordoServizioParteComune());
                api = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
            }
            if (((portType = consoleHelper.getParameter("port_type")) == null || "".equals(portType)) && id != null) {
                portType = id.getPortType();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(ModIDynamicConfigurationAccordiParteSpecificaUtilities.getErrorLetturaAPIFallita(e), (Throwable)e);
        }
        if (api == null) {
            return false;
        }
        boolean corniceSicurezza = ModISecurityUtils.isProfiloSicurezzaMessaggioCorniceSicurezza((AccordoServizioParteComune)api, (String)portType);
        String patternDatiCorniceSicurezza = null;
        String schemaDatiCorniceSicurezza = null;
        if (corniceSicurezza) {
            patternDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaPattern((AccordoServizioParteComune)api, (String)portType);
            if (patternDatiCorniceSicurezza == null) {
                patternDatiCorniceSicurezza = "old";
            }
            if (!"old".equals(patternDatiCorniceSicurezza)) {
                schemaDatiCorniceSicurezza = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema((AccordoServizioParteComune)api, (String)portType);
            }
        }
        if ((pdnd = ModISecurityUtils.isSicurezzaMessaggioGenerazioneTokenIdAuthPDND((AccordoServizioParteComune)api, (String)portType)) && !fruizioni) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfo(registryReader, configIntegrationReader, api, id, portType, consoleConfiguration, properties);
        }
        boolean sicurezzaAudit = false;
        if (fruizioni && corniceSicurezza && !"old".equals(patternDatiCorniceSicurezza) && schemaDatiCorniceSicurezza != null) {
            sicurezzaAudit = true;
        }
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)api, (String)portType) || sicurezzaAudit) {
            StringProperty truststorePathItemValue;
            StringProperty truststoreCRLPathItemValue;
            AbstractConsoleItem truststoreCRLPathItem;
            StringProperty truststoreItemValue;
            AbstractConsoleItem truststorePasswordItem;
            StringProperty truststorePathItemValue2;
            AbstractConsoleItem truststorePathItem;
            StringProperty keystoreItemValue;
            AbstractConsoleItem keyAliasItem;
            StringProperty keystoreItemValue2;
            AbstractConsoleItem keyPasswordItem;
            StringProperty keystoreItemValue3;
            AbstractConsoleItem keystorePasswordItem;
            StringProperty keystorePathItemValue;
            AbstractConsoleItem keystorePathItem;
            StringProperty profiloSicurezzaMessaggioAudienceIntegrityItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioAudienceIntegrityItem;
            StringProperty profiloSicurezzaMessaggioCorniceSicurezzaIPUserItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaIPUserItem;
            StringProperty profiloSicurezzaMessaggioCorniceSicurezzaUserIdItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaUserIdItem;
            StringProperty profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItem;
            StringProperty profiloSicurezzaMessaggioAudienceItemValue;
            Properties claims;
            String idProperty;
            StringProperty profiloSicurezzaMessaggioRestJwtClaimsItemValue;
            StringProperty profiloSicurezzaMessaggioSoapHeadersItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioSoapHeadersItem;
            AbstractConsoleItem profiloSicurezzaMessaggioHttpHeadersItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageHttpHeaders");
            if (profiloSicurezzaMessaggioHttpHeadersItem != null) {
                StringProperty profiloSicurezzaMessaggioHttpHeadersItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHttpHeaders");
                if (profiloSicurezzaMessaggioHttpHeadersItemValue == null) throw new ProtocolException("Verificare quanto indicato in HTTP Headers da firmare: nessun header indicato");
                if (profiloSicurezzaMessaggioHttpHeadersItemValue.getValue() == null) throw new ProtocolException("Verificare quanto indicato in HTTP Headers da firmare: nessun header indicato");
                if ("".equals(profiloSicurezzaMessaggioHttpHeadersItemValue.getValue())) throw new ProtocolException("Verificare quanto indicato in HTTP Headers da firmare: nessun header indicato");
                try {
                    String[] hdrObbligatori = modiProperties.getRestSecurityTokenSignedHeaders();
                    if (hdrObbligatori != null && hdrObbligatori.length > 0) {
                        String[] hdrImpostati = ((String)profiloSicurezzaMessaggioHttpHeadersItemValue.getValue()).split(",");
                        if (hdrImpostati == null) throw new ProtocolException("Nessun header indicato");
                        if (hdrImpostati.length <= 0) {
                            throw new ProtocolException("Nessun header indicato");
                        }
                        for (String hdrObbligatorio : hdrObbligatori) {
                            boolean found = false;
                            for (String hdrImpostato : hdrImpostati) {
                                if (!hdrImpostato.equalsIgnoreCase(hdrObbligatorio)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            throw new ProtocolException("Header obbligatorio '" + hdrObbligatorio + "' non indicato");
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("Verificare quanto indicato in HTTP Headers da firmare: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((profiloSicurezzaMessaggioSoapHeadersItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageSoapHeaders")) != null && (profiloSicurezzaMessaggioSoapHeadersItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageSoapHeaders")) != null && profiloSicurezzaMessaggioSoapHeadersItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioSoapHeadersItemValue.getValue())) {
                try {
                    String sValue = (String)profiloSicurezzaMessaggioSoapHeadersItemValue.getValue();
                    SOAPHeader.parse(sValue);
                }
                catch (Exception e) {
                    throw new ProtocolException("Verificare quanto indicato in SOAP Headers da firmare: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!fruizioni) {
                try {
                    ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig(properties, false);
                }
                catch (Exception e) {
                    throw new ProtocolException("Verificare i parametri indicati per il keystore in Sicurezza Messaggio: " + e.getMessage(), (Throwable)e);
                }
            }
            boolean rest = ServiceBinding.REST.equals((Object)api.getServiceBinding());
            boolean digest = ModISecurityUtils.isProfiloSicurezzaMessaggioConIntegrita((AccordoServizioParteComune)api, (String)portType);
            boolean corniceSicurezzaLegacy = false;
            if (corniceSicurezza) {
                corniceSicurezzaLegacy = "old".equals(patternDatiCorniceSicurezza);
            }
            boolean headerDuplicati = false;
            if (rest) {
                headerDuplicati = ModISecurityUtils.isProfiloSicurezzaMessaggioConHeaderDuplicati((AccordoServizioParteComune)api, (String)portType);
            }
            boolean requestCalcolatoSuInfoFruizioni = fruizioni;
            if (rest && (profiloSicurezzaMessaggioRestJwtClaimsItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(idProperty = fruizioni ? "modipaSecurityMessageRequestClaims" : "modipaSecurityMessageResponseClaims"))) != null && profiloSicurezzaMessaggioRestJwtClaimsItemValue.getValue() != null) {
                claims = PropertiesUtilities.convertTextToProperties((String)((String)profiloSicurezzaMessaggioRestJwtClaimsItemValue.getValue()));
                ModIDynamicConfigurationAccordiParteSpecificaUtilities.checkClaims(modiProperties, claims, "Claims", requestCalcolatoSuInfoFruizioni, digest, corniceSicurezzaLegacy);
            }
            if (rest && headerDuplicati) {
                StringProperty profiloSicurezzaMessaggioRestJwtModiClaimsItemValue;
                idProperty = fruizioni ? "modipaSecurityMessageRequestClaimsAuth" : "modipaSecurityMessageResponseClaimsAuth";
                StringProperty profiloSicurezzaMessaggioRestJwtAuthorizationClaimsItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idProperty);
                if (profiloSicurezzaMessaggioRestJwtAuthorizationClaimsItemValue != null && profiloSicurezzaMessaggioRestJwtAuthorizationClaimsItemValue.getValue() != null) {
                    claims = PropertiesUtilities.convertTextToProperties((String)((String)profiloSicurezzaMessaggioRestJwtAuthorizationClaimsItemValue.getValue()));
                    ModIDynamicConfigurationAccordiParteSpecificaUtilities.checkClaims(modiProperties, claims, "Claims 'Authorization'", requestCalcolatoSuInfoFruizioni, digest, corniceSicurezzaLegacy);
                }
                if ((profiloSicurezzaMessaggioRestJwtModiClaimsItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(idProperty = fruizioni ? "modipaSecurityMessageRequestClaimsModi" : "modipaSecurityMessageResponseClaimsModi"))) != null && profiloSicurezzaMessaggioRestJwtModiClaimsItemValue.getValue() != null) {
                    Properties claims2 = PropertiesUtilities.convertTextToProperties((String)((String)profiloSicurezzaMessaggioRestJwtModiClaimsItemValue.getValue()));
                    ModIDynamicConfigurationAccordiParteSpecificaUtilities.checkClaims(modiProperties, claims2, "Claims 'TEMPLATE'".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()), requestCalcolatoSuInfoFruizioni, digest, corniceSicurezzaLegacy);
                }
            }
            if (rest) {
                StringProperty profiloSicurezzaMessaggioRestUrlItemValue;
                AbstractConsoleItem profiloSicurezzaMessaggioRestUrlItem;
                String idUrl = null;
                if (fruizioni) {
                    idUrl = "modipaSecurityMessageRestRequestX509Url";
                } else if (!fruizioni) {
                    idUrl = "modipaSecurityMessageRestResponseX509Url";
                }
                if (idUrl != null && (profiloSicurezzaMessaggioRestUrlItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idUrl)) != null && (profiloSicurezzaMessaggioRestUrlItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idUrl)) != null && profiloSicurezzaMessaggioRestUrlItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioRestUrlItemValue.getValue())) {
                    try {
                        InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioRestUrlItemValue.getValue()), (String)"URL (x5u)");
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            String idAudit = "modipaSecurityMessageRequestAud";
            String labelAudit = rest ? "Audience" : "WSAddressing To";
            AbstractConsoleItem profiloSicurezzaMessaggioAudienceItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idAudit);
            if (profiloSicurezzaMessaggioAudienceItem != null && (profiloSicurezzaMessaggioAudienceItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idAudit)) != null && profiloSicurezzaMessaggioAudienceItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioAudienceItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioAudienceItemValue.getValue()), (String)labelAudit);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (fruizioni) {
                StringProperty profiloSicurezzaMessaggioAudienceItemValue2;
                idAudit = "modipaSecurityMessageResponseAudExpected";
                labelAudit = rest ? "Verifica Audience" : "Verifica WSAddressing To";
                profiloSicurezzaMessaggioAudienceItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idAudit);
                if (profiloSicurezzaMessaggioAudienceItem != null && (profiloSicurezzaMessaggioAudienceItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idAudit)) != null && profiloSicurezzaMessaggioAudienceItemValue2.getValue() != null && !"".equals(profiloSicurezzaMessaggioAudienceItemValue2.getValue())) {
                    try {
                        InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioAudienceItemValue2.getValue()), (String)labelAudit);
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if ((profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte")) != null && (profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte")) != null && profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioCorniceSicurezzaCodiceEnteItemValue.getValue()), (String)"Codice Ente", (boolean)true);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((profiloSicurezzaMessaggioCorniceSicurezzaUserIdItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaUser")) != null && (profiloSicurezzaMessaggioCorniceSicurezzaUserIdItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaUser")) != null && profiloSicurezzaMessaggioCorniceSicurezzaUserIdItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioCorniceSicurezzaUserIdItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioCorniceSicurezzaUserIdItemValue.getValue()), (String)"UserID Utente", (boolean)true);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((profiloSicurezzaMessaggioCorniceSicurezzaIPUserItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaIPUser")) != null && (profiloSicurezzaMessaggioCorniceSicurezzaIPUserItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaIPUser")) != null && profiloSicurezzaMessaggioCorniceSicurezzaIPUserItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioCorniceSicurezzaIPUserItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioCorniceSicurezzaIPUserItemValue.getValue()), (String)"Indirizzo IP Utente", (boolean)true);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (fruizioni && (profiloSicurezzaMessaggioAudienceIntegrityItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageRequestIntegrityAud")) != null && (profiloSicurezzaMessaggioAudienceIntegrityItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRequestIntegrityAud")) != null && profiloSicurezzaMessaggioAudienceIntegrityItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioAudienceIntegrityItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioAudienceIntegrityItemValue.getValue()), (String)("Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()) + " - Audience"));
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (rest && headerDuplicati) {
                StringProperty profiloSicurezzaMessaggioAudienceIntegrityItemValue2;
                String idAud = "modipaSecurityMessageRequestIntegrityAud";
                AbstractConsoleItem profiloSicurezzaMessaggioAudienceIntegrityItem2 = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idAud);
                if (profiloSicurezzaMessaggioAudienceIntegrityItem2 != null && (profiloSicurezzaMessaggioAudienceIntegrityItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idAud)) != null && profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue() != null && !"".equals(profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue())) {
                    try {
                        InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue()), (String)("Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()) + " - Audience"));
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                idAud = "modipaSecurityMessageResponseIntegrityAud";
                profiloSicurezzaMessaggioAudienceIntegrityItem2 = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idAud);
                if (profiloSicurezzaMessaggioAudienceIntegrityItem2 != null && (profiloSicurezzaMessaggioAudienceIntegrityItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idAud)) != null && profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue() != null && !"".equals(profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue())) {
                    try {
                        InputValidationUtils.validateTextAreaInput((String)((String)profiloSicurezzaMessaggioAudienceIntegrityItemValue2.getValue()), (String)("Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()) + " - Audience"));
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if ((keystorePathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePath")) != null && (keystorePathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath")) != null && keystorePathItemValue.getValue() != null && !"".equals(keystorePathItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)keystorePathItemValue.getValue()), (String)"KeyStore - Path");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keystorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePassword")) != null && (keystoreItemValue3 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword")) != null && keystoreItemValue3.getValue() != null && !"".equals(keystoreItemValue3.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue3.getValue()), (String)"KeyStore - Password");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keyPasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyPassword")) != null && (keystoreItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword")) != null && keystoreItemValue2.getValue() != null && !"".equals(keystoreItemValue2.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue2.getValue()), (String)"KeyStore - Password Chiave Privata");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keyAliasItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyAlias")) != null && (keystoreItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyAlias")) != null && keystoreItemValue.getValue() != null && !"".equals(keystoreItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue.getValue()), (String)"KeyStore - Alias Chiave Privata");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((truststorePathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaTruststorePath")) != null && (truststorePathItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaTruststorePath")) != null && truststorePathItemValue2.getValue() != null && !"".equals(truststorePathItemValue2.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)truststorePathItemValue2.getValue()), (String)"TrustStore Certificati - Path");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((truststorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaTruststorePassword")) != null && (truststoreItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaTruststorePassword")) != null && truststoreItemValue.getValue() != null && !"".equals(truststoreItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)truststoreItemValue.getValue()), (String)"TrustStore Certificati - Password");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((truststoreCRLPathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaTruststoreCRLs")) != null && (truststoreCRLPathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaTruststoreCRLs")) != null && truststoreCRLPathItemValue.getValue() != null && !"".equals(truststoreCRLPathItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)truststoreCRLPathItemValue.getValue()), (String)"TrustStore Certificati - CRL File(s)");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((truststorePathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSslTruststorePath")) != null && (truststorePathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSslTruststorePath")) != null && truststorePathItemValue.getValue() != null && !"".equals(truststorePathItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)truststorePathItemValue.getValue()), (String)"TrustStore SSL - Path");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((truststoreCRLPathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSslTruststoreCRLs")) != null && (truststoreCRLPathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSslTruststoreCRLs")) != null && truststoreCRLPathItemValue.getValue() != null && !"".equals(truststoreCRLPathItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)truststoreCRLPathItemValue.getValue()), (String)"TrustStore SSL - CRL File(s)");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((tokenIdentificativoClientItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthId")) != null && tokenIdentificativoClientItemValue.getValue() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)tokenIdentificativoClientItemValue.getValue()))) {
            try {
                InputValidationUtils.validateTextAreaInput((String)((String)tokenIdentificativoClientItemValue.getValue()), (String)"Identificativo");
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        if ((tokenKidItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthKid")) == null) return true;
        if (tokenKidItemValue.getValue() == null) return true;
        if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)tokenKidItemValue.getValue()))) return true;
        try {
            InputValidationUtils.validateTextAreaInput((String)((String)tokenKidItemValue.getValue()), (String)"Key Id (kid) del Certificato");
            return true;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static void checkClaims(ModIProperties modiProperties, Properties claims, String elemento, boolean request, boolean digest, boolean corniceSicurezzaLegacy) throws ProtocolException {
        List<String> denyClaims = null;
        String claimNameClientId = null;
        try {
            denyClaims = modiProperties.getUsedRestSecurityClaims(request, digest);
            claimNameClientId = modiProperties.getRestSecurityTokenClaimsClientIdHeader();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (claims != null && !claims.isEmpty()) {
            for (Object oClaim : claims.keySet()) {
                if (!(oClaim instanceof String)) continue;
                String claim = (String)oClaim;
                String value = claims.getProperty(claim);
                String debugS = "'" + claim + "', indicato nel campo " + elemento;
                if (value != null && "${notGenerate}".equalsIgnoreCase(value.trim())) {
                    if (claim.equalsIgnoreCase(claimNameClientId) || claim.equalsIgnoreCase("iss") && !corniceSicurezzaLegacy || claim.equalsIgnoreCase("sub") && !corniceSicurezzaLegacy) continue;
                    throw new ProtocolException("Keyword '${notGenerate}' non utilizzabile nel claim " + debugS);
                }
                if (denyClaims.contains(claim) || denyClaims.contains(claim.toLowerCase())) {
                    throw new ProtocolException("Il claim " + debugS + ", non pu\u00f2 essere configurato");
                }
                if (value != null && !StringUtils.isEmpty((CharSequence)value)) continue;
                throw new ProtocolException("Claim " + debugS + ", non valorizzato");
            }
        }
    }

    private static boolean isMascheraGestioneFruizioneOrErogazione(IConsoleHelper consoleHelper) {
        boolean gestioneFruitori = ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneFruizione(consoleHelper);
        boolean gestioneErogatori = ModIDynamicConfigurationAccordiParteSpecificaUtilities.isMascheraGestioneErogazione(consoleHelper);
        return gestioneErogatori || gestioneFruitori;
    }

    private static boolean isMascheraGestioneErogazione(IConsoleHelper consoleHelper) {
        String tipologia = (String)consoleHelper.getAttributeFromSession("_tabKey_tipologiaErogazione", String.class);
        if (tipologia == null) {
            try {
                String p = consoleHelper.getParameter("_tabKey_tipologiaErogazione_VIA_PARAM");
                if (p != null) {
                    tipologia = p;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tipologia != null && "erogazione".equals(tipologia);
    }

    private static boolean isMascheraGestioneFruizione(IConsoleHelper consoleHelper) {
        String tipologia = (String)consoleHelper.getAttributeFromSession("_tabKey_tipologiaErogazione", String.class);
        if (tipologia == null) {
            try {
                String p = consoleHelper.getParameter("_tabKey_tipologiaErogazione_VIA_PARAM");
                if (p != null) {
                    tipologia = p;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tipologia != null && "fruizione".equals(tipologia);
    }
}

