/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class ModIAuditClaimConfig {
    public static final String PROPERTY_NOME = "nome";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_REQUIRED = "required";
    public static final String PROPERTY_CACHEABLE = "cacheable";
    public static final String PROPERTY_STRING_TYPE = "stringType";
    public static final String PROPERTY_REGEXP = "regexp";
    public static final String PROPERTY_ENUM = "enum";
    public static final String PROPERTY_MIN_LENGTH = "minLength";
    public static final String PROPERTY_MAX_LENGTH = "maxLength";
    public static final String PROPERTY_INFO = "info";
    public static final String PROPERTY_DEFAULT_RULE = "rule";
    public static final String PROPERTY_DEFAULT_RULE_INFO = "rule.info";
    public static final String PROPERTY_FORWARD_BACKEND = "forwardBackend";
    public static final String PROPERTY_TRACE = "trace";
    private String propertyId;
    private String nome;
    private String label;
    private boolean required;
    private boolean cacheable;
    private boolean stringType;
    private String regexp;
    private List<String> values;
    private int minLength;
    private int maxLength;
    private String info;
    private List<String> rules;
    private List<String> rulesInfo;
    private String forwardBackend;
    private boolean trace;

    private ModIAuditClaimConfig() {
    }

    ModIAuditClaimConfig(String prefix, String propertyId, Properties p) throws ProtocolException {
        this.propertyId = propertyId;
        this.nome = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".nome", true);
        this.label = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".label", true);
        this.required = ModIAuditConfig.getBooleanProperty(prefix, p, "claims." + propertyId + ".required", true, true);
        this.cacheable = ModIAuditConfig.getBooleanProperty(prefix, p, "claims." + propertyId + ".cacheable", false, true);
        this.stringType = ModIAuditConfig.getBooleanProperty(prefix, p, "claims." + propertyId + ".stringType", true, true);
        this.regexp = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".regexp", false);
        String tmp = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".enum", false);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            this.values = new ArrayList<String>();
            ModIAuditClaimConfig.setList(tmp, this.values);
        }
        this.minLength = ModIAuditConfig.getIntProperty(prefix, p, "claims." + propertyId + ".minLength", false, -1);
        this.maxLength = ModIAuditConfig.getIntProperty(prefix, p, "claims." + propertyId + ".maxLength", false, -1);
        this.info = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".info", true);
        tmp = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".rule", true);
        this.rules = new ArrayList<String>();
        ModIAuditClaimConfig.setList(tmp, this.rules);
        tmp = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".rule.info", true);
        this.rulesInfo = new ArrayList<String>();
        ModIAuditClaimConfig.setList(tmp, this.rulesInfo);
        this.forwardBackend = ModIAuditConfig.getProperty(prefix, p, "claims." + propertyId + ".forwardBackend", false);
        this.trace = ModIAuditConfig.getBooleanProperty(prefix, p, "claims." + propertyId + ".trace", true, true);
    }

    private static void setList(String v, List<String> list) {
        String[] split = v.split(",");
        if (split != null && split.length > 0) {
            for (String s : split) {
                if (s == null || !StringUtils.isNotEmpty((CharSequence)(s = s.trim()))) continue;
                list.add(s);
            }
        }
    }

    public ModIAuditClaimConfig copyNewInstance() {
        ModIAuditClaimConfig newInstance = new ModIAuditClaimConfig();
        newInstance.propertyId = this.propertyId;
        newInstance.nome = this.nome;
        newInstance.label = this.label;
        newInstance.required = this.required;
        newInstance.cacheable = this.cacheable;
        newInstance.stringType = this.stringType;
        newInstance.regexp = this.regexp;
        newInstance.values = new ArrayList<String>();
        if (this.values != null && !this.values.isEmpty()) {
            newInstance.values.addAll(this.values);
        }
        newInstance.minLength = this.minLength;
        newInstance.maxLength = this.maxLength;
        newInstance.info = this.info;
        newInstance.rules = new ArrayList<String>();
        if (this.rules != null && !this.rules.isEmpty()) {
            newInstance.rules.addAll(this.rules);
        }
        newInstance.rulesInfo = new ArrayList<String>();
        if (this.rulesInfo != null && !this.rulesInfo.isEmpty()) {
            newInstance.rulesInfo.addAll(this.rulesInfo);
        }
        newInstance.forwardBackend = this.forwardBackend;
        newInstance.trace = this.trace;
        return newInstance;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isStringType() {
        return this.stringType;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public List<String> getValues() {
        return this.values;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getInfo() {
        return this.info;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public void setRules(List<String> rules) {
        this.rules = rules;
    }

    public List<String> getRulesInfo() {
        return this.rulesInfo;
    }

    public void setRulesInfo(List<String> rulesInfo) {
        this.rulesInfo = rulesInfo;
    }

    public String getForwardBackend() {
        return this.forwardBackend;
    }

    public void setForwardBackend(String forwardBackend) {
        this.forwardBackend = forwardBackend;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

