/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.utils;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.message.utils.DumpMessaggioMultipartInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.transport.TransportUtils;

public class DumpMessaggio
implements Serializable {
    private static final long serialVersionUID = 4718160136521047108L;
    private MessageType messageType;
    private String contentType;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private transient ByteArrayOutputStream body;
    private DumpMessaggioMultipartInfo multipartInfoBody;
    private List<DumpAttachment> attachments;

    public long getBodyLength() {
        if (this.body != null) {
            return this.body.size();
        }
        return 0L;
    }

    public byte[] getBody() {
        if (this.body != null) {
            return this.body.toByteArray();
        }
        return null;
    }

    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public void setBody(ByteArrayOutputStream body) {
        this.body = body;
    }

    public String getBodyBase64Digest(String algorithm) throws UtilsException {
        return this.getBodyDigest(algorithm, DigestEncoding.BASE64, false);
    }

    public String getBodyBase64Digest(String algorithm, String rfc3230) throws UtilsException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new UtilsException("Uncorrect boolean value '" + rfc3230 + "': " + e.getMessage(), (Throwable)e);
        }
        return this.getBodyBase64Digest(algorithm, v);
    }

    public String getBodyBase64Digest(String algorithm, boolean rfc3230) throws UtilsException {
        return this.getBodyDigest(algorithm, DigestEncoding.BASE64, rfc3230);
    }

    public String getBodyHexDigest(String algorithm) throws UtilsException {
        return this.getBodyDigest(algorithm, DigestEncoding.HEX, false);
    }

    public String getBodyHexDigest(String algorithm, String rfc3230) throws UtilsException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new UtilsException("Uncorrect boolean value '" + rfc3230 + "': " + e.getMessage(), (Throwable)e);
        }
        return this.getBodyHexDigest(algorithm, v);
    }

    public String getBodyHexDigest(String algorithm, boolean rfc3230) throws UtilsException {
        return this.getBodyDigest(algorithm, DigestEncoding.HEX, rfc3230);
    }

    public String getBodyDigest(String algorithm, String digestEncodingParam) throws UtilsException {
        return this.getBodyDigest(algorithm, digestEncodingParam, false);
    }

    public String getBodyDigest(String algorithm, DigestEncoding digestEncoding) throws UtilsException {
        return this.getBodyDigest(algorithm, digestEncoding, false);
    }

    public String getBodyDigest(String algorithm, String digestEncodingParam, String rfc3230) throws UtilsException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new UtilsException("Uncorrect boolean value '" + rfc3230 + "': " + e.getMessage(), (Throwable)e);
        }
        return this.getBodyDigest(algorithm, digestEncodingParam, v);
    }

    public String getBodyDigest(String algorithm, String digestEncodingParam, boolean rfc3230) throws UtilsException {
        DigestEncoding digestEncoding = null;
        try {
            digestEncoding = DigestEncoding.valueOf((String)digestEncodingParam);
        }
        catch (Throwable t) {
            throw new UtilsException("DigestEncoding '" + digestEncodingParam + "' unsupported");
        }
        return this.getBodyDigest(algorithm, digestEncoding, rfc3230);
    }

    public String getBodyDigest(String algorithm, DigestEncoding digestEncoding, String rfc3230) throws UtilsException {
        boolean v = false;
        try {
            v = Boolean.valueOf(rfc3230);
        }
        catch (Exception e) {
            throw new UtilsException("Uncorrect boolean value '" + rfc3230 + "': " + e.getMessage(), (Throwable)e);
        }
        return this.getBodyDigest(algorithm, digestEncoding, v);
    }

    public String getBodyDigest(String algorithm, DigestEncoding digestEncoding, boolean rfc3230) throws UtilsException {
        byte[] content = this.getBody();
        if (content == null) {
            throw new UtilsException("Content null");
        }
        return DigestUtils.getDigestValue((byte[])content, (String)algorithm, (DigestEncoding)digestEncoding, (boolean)rfc3230);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<DumpAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<DumpAttachment> attachments) {
        this.attachments = attachments;
    }

    public DumpAttachment getAttachmentByIndex(String index) throws UtilsException {
        int pos = -1;
        try {
            pos = Integer.valueOf(index);
            if (pos < 0) {
                throw new Exception("negative index");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Uncorrect position '" + pos + "': " + e.getMessage(), (Throwable)e);
        }
        return this.getAttachment(pos);
    }

    public DumpAttachment getAttachment(int index) {
        if (this.attachments == null || this.attachments.isEmpty()) {
            return null;
        }
        if (index >= this.attachments.size()) {
            return null;
        }
        return this.attachments.get(index);
    }

    public DumpAttachment getAttachmentById(String id) {
        return this.getAttachment(id);
    }

    public DumpAttachment getAttachmentByContentId(String id) {
        return this.getAttachment(id);
    }

    public DumpAttachment getAttachment(String id) {
        if (this.attachments == null || this.attachments.isEmpty()) {
            return null;
        }
        for (DumpAttachment dumpAttachment : this.attachments) {
            if (!id.equals(dumpAttachment.getContentId())) continue;
            return dumpAttachment;
        }
        return null;
    }

    public DumpMessaggioMultipartInfo getMultipartInfoBody() {
        return this.multipartInfoBody;
    }

    public void setMultipartInfoBody(DumpMessaggioMultipartInfo multipartInfoBody) {
        this.multipartInfoBody = multipartInfoBody;
    }

    @Deprecated
    public Map<String, String> getHeaders() {
        return TransportUtils.convertToMapSingleValue(this.headers);
    }

    public Map<String, List<String>> getHeadersValues() {
        return this.headers;
    }

    @Deprecated
    public void setHeaders(Map<String, String> headers) {
        this.headers = TransportUtils.convertToMapListValues(headers);
    }

    public void setHeadersValues(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String toString(DumpMessaggioConfig config, boolean dumpAllAttachments) throws MessageException {
        try {
            StringBuilder out = new StringBuilder();
            if (config.isDumpHeaders()) {
                out.append("------ Header di trasporto ------\n");
                if (this.getHeadersValues() != null && this.getHeadersValues().size() > 0) {
                    for (String key : this.getHeadersValues().keySet()) {
                        List<String> values;
                        if (key == null || (values = this.getHeadersValues().get(key)) == null || values.isEmpty()) continue;
                        for (String value : values) {
                            out.append("- " + key + ": " + value + "\n");
                        }
                    }
                } else {
                    out.append("Non presenti\n");
                }
            }
            boolean hasContent = this.getBodyLength() > 0L;
            String contentString = "Body";
            Object contentType = "";
            String attachString = "BodyPart";
            if (!hasContent) {
                contentString = "Empty Body";
            }
            if (MessageType.SOAP_11.equals(this.getMessageType()) || MessageType.SOAP_12.equals(this.getMessageType())) {
                contentString = "SOAPEnvelope";
                attachString = "Attachment";
            }
            if (hasContent && this.getContentType() != null) {
                contentType = " (ContentType: " + this.getContentType() + ")";
            }
            if (config.isDumpBody()) {
                out.append("------ " + contentString + (String)contentType + " (MessageType: " + String.valueOf(this.getMessageType()) + ") ------\n");
                if (this.getMultipartInfoBody() != null) {
                    out.append("\n*** MimePart Header ***\n");
                    if (this.getMultipartInfoBody().getContentId() != null) {
                        out.append("- Content-ID: " + this.getMultipartInfoBody().getContentId() + "\n");
                    }
                    if (this.getMultipartInfoBody().getContentLocation() != null) {
                        out.append("- Content-Location: " + this.getMultipartInfoBody().getContentLocation() + "\n");
                    }
                    if (this.getMultipartInfoBody().getContentType() != null) {
                        out.append("- Content-Type: " + this.getMultipartInfoBody().getContentType() + "\n");
                    }
                    if (config.isDumpMultipartHeaders() && this.getMultipartInfoBody().getHeadersValues() != null && this.getMultipartInfoBody().getHeadersValues().size() > 0) {
                        for (String keyO : this.getMultipartInfoBody().getHeadersValues().keySet()) {
                            List<String> values;
                            String key;
                            if (!(keyO instanceof String) || "Content-ID".equalsIgnoreCase(key = keyO) || "Content-Location".equalsIgnoreCase(key) || "Content-Type".equalsIgnoreCase(key) || (values = this.getMultipartInfoBody().getHeadersValues().get(key)) == null || values.isEmpty()) continue;
                            for (String value : values) {
                                out.append("- " + key + ": " + value + "\n");
                            }
                        }
                    }
                }
                out.append("\n");
                if (this.getBodyLength() > 0L) {
                    out.append(this.getBodyAsString());
                }
            }
            if (config.isDumpAttachments() && this.getAttachments() != null && this.getAttachments().size() > 0) {
                Iterator<DumpAttachment> it = this.getAttachments().iterator();
                int index = 1;
                while (it.hasNext()) {
                    DumpAttachment ap = it.next();
                    out.append("\n------ " + attachString + "-" + index + " ------\n");
                    out.append("\n*** MimePart Header ***\n");
                    if (ap.getContentId() != null) {
                        out.append("- Content-ID: " + ap.getContentId() + "\n");
                    }
                    if (ap.getContentLocation() != null) {
                        out.append("- Content-Location: " + ap.getContentLocation() + "\n");
                    }
                    if (ap.getContentType() != null) {
                        out.append("- Content-Type: " + ap.getContentType() + "\n");
                    }
                    if (config.isDumpMultipartHeaders() && ap.getHeadersValues() != null && ap.getHeadersValues().size() > 0) {
                        for (String keyO : ap.getHeadersValues().keySet()) {
                            List<String> values;
                            String key;
                            if (!(keyO instanceof String) || "Content-ID".equalsIgnoreCase(key = keyO) || "Content-Location".equalsIgnoreCase(key) || "Content-Type".equalsIgnoreCase(key) || (values = ap.getHeadersValues().get(key)) == null || values.isEmpty()) continue;
                            for (String value : values) {
                                out.append("- " + key + ": " + value + "\n");
                            }
                        }
                    }
                    out.append("\n");
                    if (ap.getErrorContentNotSerializable() != null) {
                        out.append(ap.getErrorContentNotSerializable());
                    } else {
                        out.append(ap.getContentAsString(!dumpAllAttachments));
                    }
                    ++index;
                }
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

