/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.mtom.test;

import jakarta.xml.soap.AttachmentPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.mtom.MtomXomPackageInfo;
import org.openspcoop2.message.soap.mtom.MtomXomReference;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MTOMTest {
    public static void main(String[] args) throws Exception {
        MTOMTest.test();
    }

    public static void test() throws Exception {
        System.out.println("============ SOAP 11 ============");
        new MTOMTest(MessageType.SOAP_11, null, false);
        System.out.println("============ SOAP 12 ============");
        new MTOMTest(MessageType.SOAP_12, null, false);
        System.out.println("============ SOAP 11 (attach) ============");
        new MTOMTest(MessageType.SOAP_11, null, true);
        System.out.println("============ SOAP 12 (attach) ============");
        new MTOMTest(MessageType.SOAP_12, null, true);
        System.out.println("Testsuite terminata");
    }

    public MTOMTest(MessageType messageType, String messageFactoryClass, boolean addAttachInMsgOriginale) throws Exception {
        if (messageFactoryClass != null) {
            OpenSPCoop2MessageFactory.setMessageFactoryImpl(messageFactoryClass);
        }
        OpenSPCoop2MessageFactory.initDefaultMessageFactory();
        OpenSPCoop2MessageFactory messageFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        Document d = MessageXMLUtils.getInstance(messageFactory).newDocument("<prova xmlns=\"www.openspcoop.org\"><esempio>Esempio di Utilizzo</esempio></prova>".getBytes());
        Element contenuto1 = d.createElementNS("www.openspcoop.org", "contenuto1");
        contenuto1.setTextContent(Base64Utilities.encodeAsString((byte[])"<esempioXml xmlns=\"www.openspcoop.org/example1\">PROVA</esempioXml>".getBytes()));
        d.getFirstChild().appendChild(contenuto1);
        Element contenuto2 = d.createElementNS("www.openspcoop.org", "contenuto2");
        contenuto2.setTextContent(Base64Utilities.encodeAsString((byte[])"<esempioXml2 xmlns=\"www.openspcoop.org/example2\"><nodoInterno>PROVA</nodoInterno></esempioXml2>".getBytes()));
        d.getLastChild().appendChild(contenuto2);
        byte[] xmlOriginale = MessageXMLUtils.getInstance(messageFactory).toByteArray(d, true);
        String soap11Prefix = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n\t<soapenv:Body>\n";
        String soap11Suffix = "\n\t</soapenv:Body>\n</soapenv:Envelope>";
        String soap12Prefix = "<soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\">\n\t<soapenv:Body>\n";
        String soap12Suffix = "\n\t</soapenv:Body>\n</soapenv:Envelope>";
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (MessageType.SOAP_11.equals(messageType)) {
            bout.write(soap11Prefix.getBytes());
            bout.write(xmlOriginale);
            bout.write(soap11Suffix.getBytes());
        } else {
            bout.write(soap12Prefix.getBytes());
            bout.write(xmlOriginale);
            bout.write(soap12Suffix.getBytes());
        }
        OpenSPCoop2MessageParseResult pr = messageFactory.createMessage(messageType, MessageRole.REQUEST, MessageUtilities.getDefaultContentType(messageType), bout.toByteArray());
        OpenSPCoop2Message omsg = pr.getMessage_throwParseException();
        OpenSPCoop2SoapMessage msg = omsg.castAsSoap();
        if (addAttachInMsgOriginale) {
            AttachmentPart ap = msg.createAttachmentPart();
            String contentType = "application/octet-stream";
            ap.setContentId(msg.createContentID("www.openspcoop2.org/example"));
            ap.setBase64Content((InputStream)new ByteArrayInputStream(Base64Utilities.encode((byte[])"PROVA".getBytes())), contentType);
            msg.addAttachmentPart(ap);
        }
        msg.updateContentType();
        System.out.println("SOAP [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        ArrayList<MtomXomPackageInfo> packageInfos = new ArrayList<MtomXomPackageInfo>();
        MtomXomPackageInfo fileInfo = new MtomXomPackageInfo();
        fileInfo.setName("Contenuto1");
        fileInfo.setXpathExpression("//{www.openspcoop.org}contenuto1");
        packageInfos.add(fileInfo);
        MtomXomPackageInfo fileMetaInfo = new MtomXomPackageInfo();
        fileMetaInfo.setName("Contenuto2");
        fileMetaInfo.setXpathExpression("//{www.openspcoop.org}contenuto2");
        fileMetaInfo.setContentType("text/xml");
        fileMetaInfo.setRequired(true);
        packageInfos.add(fileMetaInfo);
        msg.mtomPackaging(packageInfos);
        msg.updateContentType();
        System.out.println("PACKAGING [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        System.out.println("VERIFICA ...");
        msg.mtomVerify(packageInfos);
        System.out.println("VERIFICA OK");
        System.out.println("\n\n\n");
        List<MtomXomReference> mtomReferences = msg.mtomFastUnpackagingForXSDConformance();
        System.out.println("PRE-VERIFICA XSD");
        for (MtomXomReference mtomXomReference : mtomReferences) {
            System.out.println("\t- " + mtomXomReference.toString());
        }
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        msg.mtomRestoreAfterXSDConformance(mtomReferences);
        System.out.println("POST-VERIFICA XSD");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        mtomReferences = msg.mtomUnpackaging();
        msg.updateContentType();
        System.out.println("UNPACKAGING [" + msg.getContentType() + "]");
        for (MtomXomReference mtomXomReference : mtomReferences) {
            System.out.println("\t- " + mtomXomReference.toString());
        }
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        msg.mtomPackaging(packageInfos);
        msg.updateContentType();
        System.out.println("PACKAGING [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
    }
}

