/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.rest.AbstractLazyContent;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.mime.MimeMultipart;

public class MultipartContent
extends AbstractLazyContent<MimeMultipart> {
    public MultipartContent(InputStream is, String contentType) throws MessageException {
        try {
            if (BUILD_LAZY) {
                this.init(is, contentType);
            } else {
                this.init(new MimeMultipart(is, contentType));
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public MultipartContent(DumpByteArrayOutputStream contentBuffer, String contentType) throws MessageException {
        block14: {
            try {
                if (BUILD_LAZY) {
                    this.init(contentBuffer, contentType);
                    break block14;
                }
                if (contentBuffer.isSerializedOnFileSystem()) {
                    try (FileInputStream is = new FileInputStream(contentBuffer.getSerializedFile());){
                        this.init(new MimeMultipart((InputStream)is, contentType));
                        break block14;
                    }
                }
                try (ByteArrayInputStream is = new ByteArrayInputStream(contentBuffer.toByteArray());){
                    this.init(new MimeMultipart((InputStream)is, contentType));
                }
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        }
    }

    @Override
    public MimeMultipart buildContent(InputStream is) throws MessageException {
        try {
            return new MimeMultipart(is, this.contentType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public MimeMultipart buildContent(byte[] c) throws MessageException {
        MimeMultipart mimeMultipart;
        ByteArrayInputStream is = new ByteArrayInputStream(c);
        try {
            mimeMultipart = new MimeMultipart((InputStream)is, this.contentType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        }
        ((InputStream)is).close();
        return mimeMultipart;
    }

    @Override
    public void writeContentTo(OutputStream os, boolean consume) throws MessageException {
        try {
            ((MimeMultipart)this.content).writeTo(os);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public MimeMultipart getMimeMultipart() throws MessageException {
        return (MimeMultipart)this.getContent();
    }
}

