/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;

public abstract class AbstractLazyContent<T> {
    public static boolean BUILD_LAZY = true;
    protected T content;
    protected DumpByteArrayOutputStream contentBuffer;
    protected byte[] contentByteArray;
    protected String contentType;

    protected AbstractLazyContent() {
    }

    public void init(InputStream is, String contentType) throws MessageException {
        try {
            this.contentType = contentType;
            this.contentByteArray = Utilities.getAsByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public void init(DumpByteArrayOutputStream contentBuffer, String contentType) throws MessageException {
        try {
            this.contentType = contentType;
            this.contentBuffer = contentBuffer;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public void init(T content) {
        this.content = content;
    }

    public abstract T buildContent(InputStream var1) throws MessageException;

    public abstract T buildContent(byte[] var1) throws MessageException;

    public abstract void writeContentTo(OutputStream var1, boolean var2) throws MessageException;

    public void buildContent() throws MessageException {
        if (this.content == null) {
            if (this.contentBuffer != null) {
                try {
                    if (this.contentBuffer.isSerializedOnFileSystem()) {
                        try (FileInputStream is = new FileInputStream(this.contentBuffer.getSerializedFile());){
                            this.content = this.buildContent(is);
                        }
                    } else {
                        this.content = this.buildContent(this.contentBuffer.toByteArray());
                    }
                    this.contentBuffer = null;
                }
                catch (Exception e) {
                    throw new MessageException(e.getMessage(), e);
                }
            }
            if (this.contentByteArray != null) {
                try {
                    this.content = this.buildContent(this.contentByteArray);
                    this.contentByteArray = null;
                }
                catch (Exception e) {
                    throw new MessageException(e.getMessage(), e);
                }
            }
        }
    }

    public T getContent() throws MessageException {
        if (this.content == null) {
            this.buildContent();
        }
        return this.content;
    }

    public void writeTo(OutputStream os, boolean consume) throws MessageException {
        this.writeTo(true, os, consume);
    }

    protected void writeTo(boolean checkContent, OutputStream os, boolean consume) throws MessageException {
        try {
            if (checkContent && this.content != null) {
                this.writeContentTo(os, consume);
                if (consume) {
                    this.content = null;
                }
            } else if (this.contentBuffer != null) {
                this.contentBuffer.writeTo(os);
                if (consume) {
                    this.contentBuffer = null;
                }
            } else if (this.contentByteArray != null) {
                os.write(this.contentByteArray);
                if (consume) {
                    this.contentByteArray = null;
                }
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

