/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.constants;

import java.io.Serializable;

public enum MessageType implements Serializable
{
    SOAP_11,
    SOAP_12,
    XML,
    JSON,
    BINARY,
    MIME_MULTIPART;

    private static final String LABEL_SOAP_11 = "Soap-1.1";
    private static final String LABEL_SOAP_12 = "Soap-1.2";
    private static final String LABEL_XML = "Xml";
    private static final String LABEL_JSON = "Json";
    private static final String LABEL_BINARY = "Binary";
    private static final String LABEL_MIME_MULTIPART = "MIME-Multipart";

    public String getMessageVersionAsString() {
        switch (this.ordinal()) {
            case 0: {
                return LABEL_SOAP_11;
            }
            case 1: {
                return LABEL_SOAP_12;
            }
            case 2: {
                return LABEL_XML;
            }
            case 3: {
                return LABEL_JSON;
            }
            case 4: {
                return LABEL_BINARY;
            }
            case 5: {
                return LABEL_MIME_MULTIPART;
            }
        }
        throw new RuntimeException("Unsupported-Type");
    }

    public String getLabelMessageVersion() {
        return this.getMessageVersionAsString();
    }

    public static MessageType getMessageTypeFromLabel(String v) {
        if (v == null) {
            return null;
        }
        if (LABEL_SOAP_11.equals(v)) {
            return SOAP_11;
        }
        if (LABEL_SOAP_12.equals(v)) {
            return SOAP_12;
        }
        if (LABEL_XML.equals(v)) {
            return XML;
        }
        if (LABEL_JSON.equals(v)) {
            return JSON;
        }
        if (LABEL_BINARY.equals(v)) {
            return BINARY;
        }
        if (LABEL_MIME_MULTIPART.equals(v)) {
            return MIME_MULTIPART;
        }
        return null;
    }
}

