/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.List;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.constants.IntegrationErrorMessageType;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;

public class IntegrationErrorConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntegrationErrorMessageType errorType;
    private IntegrationErrorMessageType defaultErrorType;
    private ConfigurationRFC7807 rfc7807;
    private IntegrationErrorReturnConfiguration errorReturnConfig;
    private boolean useInternalFault;

    public IntegrationErrorConfiguration(ConfigurationRFC7807 rfc7807, IntegrationErrorMessageType errorType, IntegrationErrorReturnConfiguration errorReturnConfig, boolean useInternalFault) {
        this.rfc7807 = rfc7807;
        this.errorType = errorType;
        this.errorReturnConfig = errorReturnConfig;
        this.useInternalFault = useInternalFault;
    }

    void setDefaultErrorType(IntegrationErrorMessageType defaultErrorType) {
        this.defaultErrorType = defaultErrorType;
    }

    public ConfigurationRFC7807 getRfc7807() {
        return this.rfc7807;
    }

    public IntegrationErrorReturnConfiguration getErrorReturnConfig() {
        return this.errorReturnConfig;
    }

    public boolean isUseInternalFault() {
        return this.useInternalFault;
    }

    public MessageType getMessageType(HttpServletTransportRequestContext request, ServiceBinding serviceBinding, MessageType requestMsgType) {
        if (ServiceBinding.REST.equals(serviceBinding) && this.rfc7807 != null && this.rfc7807.isUseAcceptHeader() && request != null && request.getHeaderValues("Accept") != null && !request.getHeaderValues("Accept").isEmpty()) {
            boolean readQparameter;
            List values = request.getHeaderValues("Accept");
            MessageType mt = this.readMessageTypeFromAccept(values, !(readQparameter = true));
            if (mt != null) {
                return mt;
            }
            mt = this.readMessageTypeFromAccept(values, readQparameter);
            if (mt != null) {
                return mt;
            }
        }
        switch (this.errorType) {
            case SOAP_AS_REQUEST: {
                if (MessageType.SOAP_11.equals(requestMsgType) || MessageType.SOAP_12.equals(requestMsgType)) {
                    return requestMsgType;
                }
                return this.getDefaultMessageType(requestMsgType);
            }
            case SOAP_11: {
                return MessageType.SOAP_11;
            }
            case SOAP_12: {
                return MessageType.SOAP_12;
            }
            case XML: {
                return MessageType.XML;
            }
            case JSON: {
                return MessageType.JSON;
            }
            case SAME_AS_REQUEST: {
                if (MessageType.SOAP_11.equals(requestMsgType) || MessageType.SOAP_12.equals(requestMsgType)) {
                    return requestMsgType;
                }
                if (MessageType.XML.equals(requestMsgType) || MessageType.JSON.equals(requestMsgType)) {
                    return requestMsgType;
                }
                return this.getDefaultMessageType(requestMsgType);
            }
        }
        return MessageType.BINARY;
    }

    public MessageType getDefaultMessageType(MessageType requestMsgType) {
        switch (this.defaultErrorType) {
            case SOAP_11: {
                return MessageType.SOAP_11;
            }
            case SOAP_12: {
                return MessageType.SOAP_12;
            }
            case XML: {
                return MessageType.XML;
            }
            case JSON: {
                return MessageType.JSON;
            }
        }
        return MessageType.BINARY;
    }

    private MessageType readMessageTypeFromAccept(List<String> values, boolean readQparameter) {
        boolean asJson = false;
        boolean asXml = false;
        for (String value : values) {
            String[] acceptHeaders = null;
            if (value.contains(",")) {
                acceptHeaders = value.split(",");
                for (int i = 0; i < acceptHeaders.length; ++i) {
                    acceptHeaders[i] = acceptHeaders[i].trim();
                }
            } else {
                acceptHeaders = new String[]{value.trim()};
            }
            double asJsonParamterQ = 0.0;
            double asXmlParamterQ = 0.0;
            for (String hdr : acceptHeaders) {
                if (readQparameter) {
                    String[] tmpQ;
                    String[] tmp;
                    if (!hdr.contains(";") || (tmp = hdr.split(";")) == null || tmp.length != 2) continue;
                    String mediaType = tmp[0];
                    String q = tmp[1];
                    if (mediaType == null || q == null) continue;
                    q = q.trim();
                    mediaType = mediaType.trim();
                    if (!q.contains("=") || (tmpQ = q.split("=")) == null || tmpQ.length != 2) continue;
                    String qParam = tmpQ[0];
                    String qParamValue = tmpQ[1];
                    if (qParam == null || !"q".equalsIgnoreCase(qParam.trim()) || qParamValue == null) continue;
                    double d = 0.0;
                    try {
                        d = Double.valueOf(qParamValue.trim());
                        if (!(d > 0.0)) continue;
                        if (this.isJsonMediaType(mediaType)) {
                            if (!(d > asJsonParamterQ)) continue;
                            asJsonParamterQ = d;
                            asJson = true;
                            continue;
                        }
                        if (!this.isXmlMediaType(mediaType) || !(d > asXmlParamterQ)) continue;
                        asXmlParamterQ = d;
                        asXml = true;
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (this.isJsonMediaType(hdr)) {
                    asJson = true;
                    break;
                }
                if (!this.isXmlMediaType(hdr)) continue;
                asXml = true;
                break;
            }
            if (asJson && asXml && readQparameter) {
                if (asJsonParamterQ > asXmlParamterQ) {
                    return MessageType.JSON;
                }
                return MessageType.XML;
            }
            if (asJson) {
                return MessageType.JSON;
            }
            if (!asXml) continue;
            return MessageType.XML;
        }
        return null;
    }

    private boolean isJsonMediaType(String hdrValue) {
        return hdrValue.toLowerCase().endsWith("/x-json") || hdrValue.toLowerCase().endsWith("/json") || hdrValue.toLowerCase().endsWith("+json");
    }

    private boolean isXmlMediaType(String hdrValue) {
        return hdrValue.toLowerCase().endsWith("/x-xml") || hdrValue.toLowerCase().endsWith("/xml") || hdrValue.toLowerCase().endsWith("+xml");
    }
}

