/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.IntegrationErrorConfiguration;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.constants.IntegrationError;
import org.openspcoop2.message.constants.IntegrationErrorMessageType;

public class IntegrationErrorCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, IntegrationErrorConfiguration> map = new HashMap<String, IntegrationErrorConfiguration>();
    private IntegrationErrorMessageType defaultError;

    public void addIntegrationError(ConfigurationRFC7807 rfc7807, IntegrationError errorType, IntegrationErrorMessageType integrationErrorMessageType, IntegrationErrorReturnConfiguration errorReturnConfig, boolean useInternalFault) {
        if (this.map.containsKey(errorType.name())) {
            this.map.remove(errorType.name());
        }
        IntegrationErrorConfiguration error = new IntegrationErrorConfiguration(rfc7807, integrationErrorMessageType, errorReturnConfig, useInternalFault);
        this.map.put(errorType.name(), error);
        if (IntegrationError.DEFAULT.equals(errorType)) {
            this.defaultError = integrationErrorMessageType;
        }
    }

    public IntegrationErrorConfiguration getIntegrationError(IntegrationError errorType) {
        if (this.map.containsKey(errorType.name())) {
            IntegrationErrorConfiguration error = this.map.get(errorType.name());
            error.setDefaultErrorType(this.defaultError);
            return error;
        }
        return null;
    }
}

