/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.config.AbstractConfigurationServiceBinding;
import org.openspcoop2.message.config.IntegrationErrorCollection;
import org.openspcoop2.message.config.SoapBinding;
import org.openspcoop2.message.config.SoapMediaTypeCollection;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;

public class ConfigurationServiceBindingSoap
extends AbstractConfigurationServiceBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SoapBinding binding;

    public ConfigurationServiceBindingSoap(boolean enabled, SoapBinding binding, IntegrationErrorCollection internalIntegrationErrorConfiguration, IntegrationErrorCollection externalIntegrationErrorConfiguration) throws MessageException {
        super(ServiceBinding.SOAP, enabled, internalIntegrationErrorConfiguration, externalIntegrationErrorConfiguration);
        if (this.enabled) {
            if (binding == null) {
                throw new MessageException("SoapBinding not defined");
            }
            this.binding = binding;
        }
    }

    @Override
    public void init() {
        if (this.enabled) {
            this.request = new SoapMediaTypeCollection(this.binding);
            this.response = new SoapMediaTypeCollection(this.binding);
        }
    }

    public SoapBinding getBinding() {
        return this.binding;
    }

    @Override
    public List<MessageType> getMessageTypeSupported() {
        ArrayList<MessageType> list = new ArrayList<MessageType>();
        if (this.binding != null) {
            if (this.binding.isBinding_soap11()) {
                list.add(MessageType.SOAP_11);
            }
            if (this.binding.isBinding_soap12()) {
                list.add(MessageType.SOAP_12);
            }
        }
        return list;
    }
}

