/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.openspcoop2.message.AbstractBaseOpenSPCoop2Message;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2InputStreamDynamicContent;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public abstract class AbstractBaseOpenSPCoop2MessageDynamicContent<T>
extends AbstractBaseOpenSPCoop2Message {
    protected BoundedInputStream _countingInputStream;
    protected String contentType;
    protected String contentTypeCharsetName = Charset.UTF_8.getValue();
    protected boolean supportSSE = true;
    protected boolean supportReadOnly = true;
    protected boolean contentUpdatable = false;
    protected T content;
    protected boolean hasContent = false;
    protected OpenSPCoop2MessageSoapStreamReader soapStreamReader;
    protected DumpByteArrayOutputStream contentBuffer;
    private static int soglia;
    private static File repositoryFile;
    private static boolean soapReader;
    private static int soapReaderBufferThresholdKb;

    public static void setSoglia(int soglia) {
        AbstractBaseOpenSPCoop2MessageDynamicContent.soglia = soglia;
    }

    public static void setRepositoryFile(File repositoryFile) {
        AbstractBaseOpenSPCoop2MessageDynamicContent.repositoryFile = repositoryFile;
    }

    public static void setSoapReader(boolean soapReader) {
        AbstractBaseOpenSPCoop2MessageDynamicContent.soapReader = soapReader;
    }

    public static void setSoapReaderBufferThresholdKb(int bufferThresholdKb) {
        soapReaderBufferThresholdKb = bufferThresholdKb;
    }

    public boolean isSupportSSE() {
        return this.supportSSE;
    }

    public void setSupportSSE(boolean supportSSE) {
        this.supportSSE = supportSSE;
    }

    protected AbstractBaseOpenSPCoop2MessageDynamicContent(OpenSPCoop2MessageFactory messageFactory) {
        super(messageFactory);
        this.hasContent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBaseOpenSPCoop2MessageDynamicContent(OpenSPCoop2MessageFactory messageFactory, InputStream isParam, String contentType, boolean soap, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        super(messageFactory);
        try {
            String ch;
            this.contentType = contentType;
            if (contentType != null && (ch = ContentTypeUtilities.readCharsetFromContentType((String)contentType)) != null) {
                this.contentTypeCharsetName = ch;
            }
            if (isParam != null) {
                InputStream normalizedIs;
                if (soap && soapStreamReader != null) {
                    soapStreamReader.checkException();
                }
                if ((normalizedIs = Utilities.normalizeStream((InputStream)isParam, (boolean)false)) == null) {
                    this.hasContent = false;
                } else {
                    if (soap) {
                        if (soapStreamReader == null) {
                            if (soapReader) {
                                this.soapStreamReader = new OpenSPCoop2MessageSoapStreamReader(messageFactory, this.contentType, normalizedIs, soapReaderBufferThresholdKb);
                                try {
                                    this.soapStreamReader.read();
                                }
                                finally {
                                    normalizedIs = this.soapStreamReader.getBufferedInputStream();
                                }
                            }
                        } else {
                            this.soapStreamReader = soapStreamReader;
                            if (this.soapStreamReader != null) {
                                this.soapStreamReader.checkException();
                            }
                        }
                    }
                    this._countingInputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(normalizedIs)).get();
                    this.hasContent = true;
                }
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected abstract T buildContent() throws MessageException;

    protected abstract T buildContent(DumpByteArrayOutputStream var1) throws MessageException;

    protected abstract String buildContentAsString() throws MessageException;

    protected abstract byte[] buildContentAsByteArray() throws MessageException;

    protected abstract void serializeContent(OutputStream var1, boolean var2) throws MessageException;

    protected void setUpdatableContent() throws MessageException {
    }

    public OpenSPCoop2MessageSoapStreamReader getSoapReader() {
        return this.soapStreamReader;
    }

    public void releaseSoapReader() {
        if (this.soapStreamReader != null) {
            this.soapStreamReader.releaseBufferedInputStream();
            this.soapStreamReader.clearHeader();
            this.soapStreamReader = null;
        }
    }

    public boolean setInputStreamLazyBuffer(String idTransazione) throws MessageException {
        if (this._countingInputStream == null) {
            return false;
        }
        if (this.content != null || this.contentBuffer != null) {
            return false;
        }
        if (!(this._countingInputStream instanceof OpenSPCoop2InputStreamDynamicContent)) {
            DumpByteArrayOutputStream contentBuffer = new DumpByteArrayOutputStream(soglia, repositoryFile, idTransazione, this.getMessageRole().name());
            this._countingInputStream = new OpenSPCoop2InputStreamDynamicContent(this._countingInputStream, contentBuffer);
        }
        return true;
    }

    private synchronized void initializeContent(boolean readOnly, String idTransazione) throws MessageException {
        if (this.hasContent && this.content == null) {
            if (readOnly && this.supportReadOnly) {
                if (this._countingInputStream instanceof OpenSPCoop2InputStreamDynamicContent) {
                    this._countingInputStream = ((OpenSPCoop2InputStreamDynamicContent)this._countingInputStream).getWrappedInputStream();
                    this.contentBuffer = ((OpenSPCoop2InputStreamDynamicContent)this._countingInputStream).getBuffer();
                } else {
                    this.contentBuffer = new DumpByteArrayOutputStream(soglia, repositoryFile, idTransazione, this.getMessageRole().name());
                }
                try {
                    CopyStream.copy((InputStream)this._countingInputStream, (OutputStream)this.contentBuffer);
                    this.content = this.buildContent(this.contentBuffer);
                }
                catch (Throwable t) {
                    MessageUtils.registerParseException(this, t, true);
                    throw new MessageException(t.getMessage(), t);
                }
                finally {
                    try {
                        this._countingInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                this.content = this.buildContent();
            }
            catch (Throwable t) {
                MessageUtils.registerParseException(this, t, true);
                throw new MessageException(t.getMessage(), t);
            }
        }
    }

    @Override
    public boolean isContentBuilded() {
        return this.content != null;
    }

    public InputStream getInputStreamFromContentBuffer() throws MessageException {
        if (this.contentBuffer == null) {
            return null;
        }
        try {
            if (this.contentBuffer.isSerializedOnFileSystem()) {
                return new FileInputStream(this.contentBuffer.getSerializedFile());
            }
            return new ByteArrayInputStream(this.contentBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public InputStream getInputStream() {
        return this._countingInputStream;
    }

    protected InputStream _getInputStream() throws MessageException {
        if (this._countingInputStream instanceof OpenSPCoop2InputStreamDynamicContent) {
            OpenSPCoop2InputStreamDynamicContent di = (OpenSPCoop2InputStreamDynamicContent)this._countingInputStream;
            DumpByteArrayOutputStream bf = di.getBuffer();
            if (bf != null && bf.size() > 0) {
                this._countingInputStream = di.getWrappedInputStream();
                InputStream isBuffered = bf.getInputStream();
                try {
                    InputStream isRemained = Utilities.normalizeStream((InputStream)this._countingInputStream, (boolean)false);
                    if (di.isInputStreamConsumed() || isRemained == null) {
                        return isBuffered;
                    }
                    return new SequenceInputStream(isBuffered, isRemained);
                }
                catch (Exception e) {
                    throw new MessageException(e.getMessage(), e);
                }
            }
            return this._countingInputStream;
        }
        return this._countingInputStream;
    }

    public boolean hasContent() throws MessageException, MessageNotSupportedException {
        return this.hasContent;
    }

    public void initContent() throws MessageException, MessageNotSupportedException {
        this.getContent();
    }

    public void initContent(boolean readOnly, String idTransazione) throws MessageException, MessageNotSupportedException {
        this.getContent(readOnly, idTransazione);
    }

    public T getContent() throws MessageException, MessageNotSupportedException {
        return this.getContent(false, null);
    }

    public T getContent(boolean readOnly, String idTransazione) throws MessageException, MessageNotSupportedException {
        if (this.hasContent) {
            if (!readOnly) {
                boolean aggiornaContenuto = false;
                if (this.content != null && !this.contentUpdatable) {
                    aggiornaContenuto = true;
                }
                this.contentUpdatable = true;
                if (aggiornaContenuto) {
                    this.setUpdatableContent();
                }
            }
            if (this.content == null) {
                this.initializeContent(readOnly, idTransazione);
            }
        }
        return this.content;
    }

    public String getContentAsString() throws MessageException, MessageNotSupportedException {
        return this.getContentAsString(false, null);
    }

    public String getContentAsString(boolean readOnly, String idTransazione) throws MessageException, MessageNotSupportedException {
        try {
            if (this.hasContent) {
                if (this.content == null) {
                    this.initializeContent(readOnly, idTransazione);
                }
                if (!readOnly) {
                    this.contentUpdatable = true;
                }
                return this.buildContentAsString();
            }
            return null;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public byte[] getContentAsByteArray() throws MessageException, MessageNotSupportedException {
        return this.getContentAsByteArray(false, null);
    }

    public byte[] getContentAsByteArray(boolean readOnly, String idTransazione) throws MessageException, MessageNotSupportedException {
        try {
            if (this.hasContent) {
                if (this.content == null) {
                    this.initializeContent(readOnly, idTransazione);
                }
                if (!readOnly) {
                    this.contentUpdatable = true;
                }
                return this.buildContentAsByteArray();
            }
            return null;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public void updateContent(T content) throws MessageException, MessageNotSupportedException {
        this.content = content;
        this.contentUpdatable = true;
        if (this.contentBuffer != null) {
            this.contentBuffer.clearResources();
            this.contentBuffer = null;
        }
        if (this.content != null) {
            this.hasContent = true;
        } else {
            this.hasContent = false;
            this.contentType = null;
        }
    }

    public void setContentUpdatable() {
        this.contentUpdatable = true;
    }

    @Override
    public void updateContentType() throws MessageException {
    }

    @Override
    public void setContentType(String type) {
        this.contentType = type;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void writeTo(OutputStream os, boolean consume) throws MessageException {
        this.writeTo(os, consume, false, null);
    }

    public void writeTo(OutputStream os, boolean consume, boolean readOnly, String idTransazione) throws MessageException {
        this.writeTo(os, consume, readOnly, idTransazione, null);
    }

    public void writeTo(OutputStream os, boolean consume, boolean readOnly, String idTransazione, StringBuilder debug) throws MessageException {
        try {
            if (this.hasContent) {
                if (!consume && this.content == null) {
                    if (!readOnly) {
                        this.contentUpdatable = true;
                    }
                    this.initializeContent(readOnly, idTransazione);
                }
                CountingOutputStream cos = new CountingOutputStream(os);
                if (this.contentBuffer != null && !this.contentUpdatable) {
                    if (this.soapStreamReader != null && this.soapStreamReader.isSoapHeaderModified() && this.contentType != null) {
                        if (debug != null) {
                            debug.append("SERIALIZE-BUFFER-WITH-HEADER");
                        }
                        this.soapStreamReader.writeOptimizedHeaderTo(this.contentBuffer.getInputStream(), (OutputStream)cos, true);
                    } else {
                        if (debug != null) {
                            debug.append("SERIALIZE-BUFFER");
                        }
                        this.contentBuffer.writeTo((OutputStream)cos);
                    }
                } else if (this.content != null) {
                    if (debug != null) {
                        debug.append("SERIALIZE-CONTENT");
                    }
                    this.serializeContent((OutputStream)cos, consume);
                } else if (this.soapStreamReader != null && this.soapStreamReader.isSoapHeaderModified()) {
                    if (debug != null) {
                        debug.append("SERIALIZE-STREAM-WITH-HEADER");
                    }
                    this.soapStreamReader.writeOptimizedHeaderTo(this._getInputStream(), (OutputStream)cos, true);
                } else {
                    if (debug != null) {
                        debug.append("SERIALIZE-STREAM");
                    }
                    if (this.supportSSE && MessageRole.RESPONSE.equals(this.messageRole) && this.contentType != null && "text/event-stream".equals(ContentTypeUtilities.readBaseTypeFromContentType((String)this.contentType))) {
                        Utilities.copyServerSentEvents((InputStream)this._getInputStream(), (OutputStream)cos);
                    } else {
                        Utilities.copy((InputStream)this._getInputStream(), (OutputStream)cos);
                    }
                    this._getInputStream().close();
                }
                this.outgoingsize = cos.getByteCount();
            }
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable eInner = Utilities.getInnerNotEmptyMessageException((Throwable)e);
            throw new MessageException(eInner != null ? eInner.getMessage() : e.getMessage(), e);
        }
        finally {
            if (consume) {
                try {
                    if (this.contentBuffer != null) {
                        this.contentBuffer.unlock();
                        this.contentBuffer.clearResources();
                        this.contentBuffer = null;
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void saveChanges() throws MessageException {
    }

    @Override
    public boolean saveRequired() {
        return false;
    }

    @Override
    public long getIncomingMessageContentLength() {
        if (this._countingInputStream != null) {
            return this._countingInputStream.getCount();
        }
        return super.getIncomingMessageContentLength();
    }

    static {
        soapReader = false;
        soapReaderBufferThresholdKb = 10;
    }
}

