/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class MethodExpressionValidator
implements Validator,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean transientValue = false;

    public MethodExpressionValidator() {
    }

    public MethodExpressionValidator(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    @Override
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            try {
                ELContext elContext = context.getELContext();
                this.methodExpression.invoke(elContext, new Object[]{context, component, value});
            }
            catch (ELException ee) {
                Throwable e = ee.getCause();
                if (e instanceof ValidatorException) {
                    throw (ValidatorException)e;
                }
                String errInfo = ee.getMessage();
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errInfo, errInfo);
                throw new ValidatorException(message, ee.getCause());
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.methodExpression};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.methodExpression = (MethodExpression)values[0];
    }

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

