/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.vendor.WebContainerInjectionProvider;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

public class InjectionProviderFactory {
    private static final InjectionProvider NOOP_PROVIDER = new NoopInjectionProvider();
    private static final InjectionProvider GENERIC_WEB_PROVIDER = new WebContainerInjectionProvider();
    private static final String INJECTION_PROVIDER_PROPERTY = "com.sun.faces.InjectionProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String[] EMPTY_ARRAY = new String[0];

    public static InjectionProvider createInstance(ExternalContext extContext) {
        String providerClass = InjectionProviderFactory.findProviderClass(extContext);
        InjectionProvider provider = InjectionProviderFactory.getProviderInstance(providerClass, extContext);
        if (!NoopInjectionProvider.class.equals(provider.getClass()) && !WebContainerInjectionProvider.class.equals(provider.getClass())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.spi.injection.provider_configured", new Object[]{provider.getClass().getName()});
            }
            return provider;
        }
        if (WebContainerInjectionProvider.class.equals(provider.getClass())) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("jsf.core.injection.provider_generic_web_configured");
            }
            return provider;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "jsf.spi.injection.no_injection");
        }
        return provider;
    }

    private static InjectionProvider getProviderInstance(String className, ExternalContext extContext) {
        InjectionProvider provider;
        block18: {
            provider = NOOP_PROVIDER;
            if (className != null) {
                try {
                    Class clazz = Util.loadClass(className, InjectionProviderFactory.class);
                    if (InjectionProviderFactory.implementsInjectionProvider(clazz)) {
                        try {
                            Constructor ctor = clazz.getConstructor(ServletContext.class);
                            return (InjectionProvider)ctor.newInstance((ServletContext)extContext.getContext());
                        }
                        catch (NoSuchMethodException nsme) {
                            return (InjectionProvider)clazz.newInstance();
                        }
                        catch (InvocationTargetException ite) {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{className});
                                LOGGER.log(Level.SEVERE, "", ite);
                            }
                        }
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_implemented", new Object[]{className});
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_found", new Object[]{className});
                    }
                }
                catch (InstantiationException ie) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{className});
                        LOGGER.log(Level.SEVERE, "", ie);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block18;
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{className});
                    LOGGER.log(Level.SEVERE, "", iae);
                }
            }
        }
        if (NOOP_PROVIDER.equals(provider)) {
            try {
                if (Util.loadClass("jakarta.annotation.PostConstruct", null) != null && Util.loadClass("jakarta.annotation.PreDestroy", null) != null) {
                    provider = GENERIC_WEB_PROVIDER;
                }
            }
            catch (Exception e) {
                provider = NOOP_PROVIDER;
            }
        }
        return provider;
    }

    private static boolean implementsInjectionProvider(Class<?> clazz) {
        return InjectionProvider.class.isAssignableFrom(clazz);
    }

    private static boolean extendsDiscoverableInjectionProvider(Class<?> clazz) {
        return DiscoverableInjectionProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext extContext) {
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);
        String provider = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.InjectionProviderClass);
        if (provider != null) {
            return provider;
        }
        provider = System.getProperty(INJECTION_PROVIDER_PROPERTY);
        if (provider != null) {
            return provider;
        }
        String[] serviceEntries = InjectionProviderFactory.getServiceEntries();
        if (serviceEntries.length > 0) {
            for (int i = 0; i < serviceEntries.length && (provider = InjectionProviderFactory.getProviderFromEntry(serviceEntries[i])) == null; ++i) {
            }
        } else {
            return provider;
        }
        return provider;
    }

    private static String getProviderFromEntry(String entry) {
        block9: {
            if (entry == null) {
                return null;
            }
            String[] parts = Util.split(entry, ":");
            if (parts.length != 2) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.invalid_service_entry", new Object[]{entry});
                }
                return null;
            }
            try {
                Class clazz = Util.loadClass(parts[0], null);
                if (InjectionProviderFactory.extendsDiscoverableInjectionProvider(clazz)) {
                    if (DiscoverableInjectionProvider.isInjectionFeatureAvailable(parts[1])) {
                        return parts[0];
                    }
                    break block9;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider.entry_not_discoverable", new Object[]{parts[0]});
                }
                return null;
            }
            catch (ClassNotFoundException cnfe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_found", new Object[]{parts[0]});
                }
                return null;
            }
        }
        return null;
    }

    private static String[] getServiceEntries() {
        return EMPTY_ARRAY;
    }

    private static final class NoopInjectionProvider
    implements InjectionProvider {
        private NoopInjectionProvider() {
        }

        @Override
        public void inject(Object managedBean) {
        }

        @Override
        public void invokePreDestroy(Object managedBean) {
        }

        @Override
        public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        }
    }
}

