/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.faces.context.FacesContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanFacesELResolver
extends ELResolver {
    @Nullable
    public Object getValue(ELContext elContext, @Nullable Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            WebApplicationContext wac = this.getWebApplicationContext(elContext);
            if (wac.containsBean(beanName)) {
                elContext.setPropertyResolved(true);
                return wac.getBean(beanName);
            }
        }
        return null;
    }

    @Nullable
    public Class<?> getType(ELContext elContext, @Nullable Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            WebApplicationContext wac = this.getWebApplicationContext(elContext);
            if (wac.containsBean(beanName)) {
                elContext.setPropertyResolved(true);
                return wac.getType(beanName);
            }
        }
        return null;
    }

    public void setValue(ELContext elContext, @Nullable Object base, Object property, Object value) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            WebApplicationContext wac = this.getWebApplicationContext(elContext);
            if (wac.containsBean(beanName)) {
                if (value == wac.getBean(beanName)) {
                    elContext.setPropertyResolved(true);
                } else {
                    throw new PropertyNotWritableException("Variable '" + beanName + "' refers to a Spring bean which by definition is not writable");
                }
            }
        }
    }

    public boolean isReadOnly(ELContext elContext, @Nullable Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            WebApplicationContext wac = this.getWebApplicationContext(elContext);
            if (wac.containsBean(beanName)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, @Nullable Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, @Nullable Object base) {
        return Object.class;
    }

    protected WebApplicationContext getWebApplicationContext(ELContext elContext) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull((Object)facesContext, (String)"FacesContext must not be null");
        Object attr = facesContext.getExternalContext().getApplicationMap().get(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof WebApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (WebApplicationContext)attr;
    }
}

