/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.ui;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.TemplateClient;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.ui.DefineHandler;
import com.sun.facelets.tag.ui.ParamHandler;
import jakarta.el.ELException;
import jakarta.el.VariableMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

public final class DecorateHandler
extends TagHandler
implements TemplateClient {
    private static final Logger log = Logger.getLogger("facelets.tag.ui.decorate");
    private final TagAttribute template = this.getRequiredAttribute("template");
    private final Map handlers = new HashMap();
    private final ParamHandler[] params;

    public DecorateHandler(TagConfig config) {
        super(config);
        Iterator itr = this.findNextByType(DefineHandler.class);
        DefineHandler d = null;
        while (itr.hasNext()) {
            d = (DefineHandler)itr.next();
            this.handlers.put(d.getName(), d);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(this.tag + " found Define[" + d.getName() + "]");
        }
        ArrayList paramC = new ArrayList();
        itr = this.findNextByType(ParamHandler.class);
        while (itr.hasNext()) {
            paramC.add(itr.next());
        }
        if (paramC.size() > 0) {
            this.params = new ParamHandler[paramC.size()];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = (ParamHandler)paramC.get(i);
            }
        } else {
            this.params = null;
        }
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        VariableMapper orig = ctx.getVariableMapper();
        if (this.params != null) {
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            ctx.setVariableMapper(vm);
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].apply(ctx, parent);
            }
        }
        String path = null;
        ctx.pushClient(this);
        try {
            path = this.template.getValue(ctx);
            ctx.includeFacelet(parent, path);
        }
        catch (IOException e) {
            throw new TagAttributeException(this.tag, this.template, "Invalid path : " + path);
        }
        finally {
            ctx.setVariableMapper(orig);
            ctx.popClient(this);
        }
    }

    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            DefineHandler handler = (DefineHandler)this.handlers.get(name);
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

