/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyMethodBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.util.FacesAPI;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.validator.MethodExpressionValidator;

public final class EditableValueHolderRule
extends MetaRule {
    private static final Class[] VALIDATOR_SIG = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] VALUECHANGE_SIG = new Class[]{ValueChangeEvent.class};
    public static final EditableValueHolderRule Instance = new EditableValueHolderRule();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(EditableValueHolder.class)) {
            boolean elSupport;
            boolean bl = elSupport = FacesAPI.getComponentVersion(meta.getTargetClass()) >= 12;
            if ("validator".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValidatorMetadata(attribute.getValue());
                }
                if (elSupport) {
                    return new ValidatorExpressionMetadata(attribute);
                }
                return new ValidatorBindingMetadata(attribute);
            }
            if ("valueChangeListener".equals(name)) {
                if (elSupport) {
                    return new ValueChangedExpressionMetadata(attribute);
                }
                return new ValueChangedBindingMetadata(attribute);
            }
        }
        return null;
    }

    static final class LiteralValidatorMetadata
    extends Metadata {
        private final String validatorId;

        public LiteralValidatorMetadata(String validatorId) {
            this.validatorId = validatorId;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValidator(ctx.getFacesContext().getApplication().createValidator(this.validatorId));
        }
    }

    static final class ValidatorExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValidatorExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValidator(new MethodExpressionValidator(this.attr.getMethodExpression(ctx, null, VALIDATOR_SIG)));
        }
    }

    static final class ValidatorBindingMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValidatorBindingMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).setValidator(new LegacyMethodBinding(this.attr.getMethodExpression(ctx, null, VALIDATOR_SIG)));
        }
    }

    static final class ValueChangedExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValueChangedExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValueChangeListener(new MethodExpressionValueChangeListener(this.attr.getMethodExpression(ctx, null, VALUECHANGE_SIG)));
        }
    }

    static final class ValueChangedBindingMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValueChangedBindingMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).setValueChangeListener(new LegacyMethodBinding(this.attr.getMethodExpression(ctx, null, VALUECHANGE_SIG)));
        }
    }
}

